/*
 *      Created 1993  IBM Corp.                                            *
 *                                                                         *
 *      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is        *
 *      sample code created by IBM Corporation. This sample code is not    *
 *      part of any standard or IBM product and is provided to you solely  *
 *      for  the purpose of assisting you in the development of your       *
 *      applications.  The code is provided "AS IS", without               *
 *      warranty of any kind.  IBM shall not be liable for any damages     *
 *      arising out of your use of the sample code, even if they have been *
 *      advised of the possibility of such damages.                        *
 */
/*****************************************************************************
 * encode/decode sample program for P22 protocol (test1.asn).
 * It uses:
 * 1.contents-array
 * 2.decoding user-exit
 * 3.content user-exit
 * 4.definite length form
 *
 * The data stream is passed in pieces to the GDSdecber routine.
 * Arguments:
 *            .DAT file,
 *            input buffer length,
 *            output buffer length,
 *            only decoding (ENC or NOENC)
 *****************************************************************************
 */

/*
 * The following are needed to compile this program.  Note that the
 * order of the header files is important.
 */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "gdstypes.h"
#include "gdsrcods.h"
#include "gdsproto.h"
#include "test1ndx.h"
#include "sample.h"


main(int argc, char **argv)
{
   int                   rc, onlydec;
   long                  l;
   static char          *dummy = "dummy";
   char                  savmodname[50], *ModName, modname[50];
   void                 *Mod, *env;
   unsigned short        Typ;
   unsigned long         EncBytes, inbuflen, outbuflen, DecBytes;
   enum TypOfEnc         enctype;
   struct gds           *p1;
   FILE                 *trace_enc;
   FILE                 *trace_dec;
   FILE                 *EncStream;    /* input-output file */
   FILE                 *usrdecfile;   /* file written by decoding user-exit */

   if (argc < 5) {
      exit(0);
   }   /* endif */

  /*
   * only decoding?
   */
   if (!strcmp(argv[4],"ENC")) {
    onlydec = 0;
   } else {
     if (!strcmp(argv[4],"NOENC")) {
       onlydec = 1;
     } else {
       printf("invalid encoding YES/NO parameter\n");
       return -1;
     } /* endif */
   } /* endif */

/*
 * set the type of encoding indicator
 */
   enctype = ber;

   inbuflen = atol(argv[2]);           /* set the length of the input buffer */
   outbuflen = atol(argv[3]);          /* set the length of output buffer */


/*
 * open the trace file for encoding gds tree
 */
   trace_enc = fopen("enctrace1.out","w");
   if (trace_enc == NULL) {            /* open file failed */
     printf("open enc trace file failed\n");
     exit(-1);
   } /* endif */

/*
 * open the trace file for decoding gds tree
 */
   trace_dec = fopen("dectrace1.out","w");
   if (trace_dec == NULL) {            /* open file failed */
     printf("open dec trace file failed\n");
     exit(-1);
   } /* endif */


/*
 * open the decoding user-exit output file
 */
   usrdecfile = fopen("usrdec1.out","w");
   if (usrdecfile == NULL) {           /* open file failed */
     printf("open decoding user-exit output file failed\n");
     exit(-1);
   } /* endif */

/***************************
 * INITIALIZATION
 ***************************
 */

/*
 * Call the library routine, GDSinitEnvironment, to initialize the environment.
 * Each User Application Program should do this before calling any routine to
 * read .dat files, encode or decode GDSs.
 */
   GDSinitEnvironment(&env);           /* initialize environment for modules */

/*
 * Call the library routine, GDSreaddatfile, to read a .dat file containing
 * the metatables and symbol tables for one or more ASN.1 module.  Note that
 * references between ASN.1 modules (imported and exported symbols) are *not*
 * resolved by GDSreaddatfile.
 */
   rc = GDSreaddatfile(argv[1], env);  /* first parm should be a readable data
                                        * file */
   if (rc != READ_DAT_OK) {
     printf("GDSreaddatfile return code: %i\n", rc);
     return rc;
   }

/*
 * Call the library routine, GDSresolveallimports, to resolve imports and
 * exports in the .dat file.  Note that if more than one .dat file had
 * been read in with multiple calls to GDSreaddatfile, this call should be
 * deferred as late as possible to maximize performance.  Multiple calls
 * to GDSresolveallimports are allowed, however.
 */
   rc = GDSresolveallimports(env);
   if (rc != RESOLVE_IMPORTS_OK) {
      printf("GDSresolveallimports return code: %i\n", rc);

      /* Call the library routine, GDSPrintUnresolvedImports, to print the
       * unresolved imports */
      GDSPrintUnresolvedImports(stdout, env);
      return rc;
   }

/*
 * Call the library routine, GDSsetUsrWrite, to set the user exit routine for
 * writing buffer.
 */
   GDSsetUsrWrite(mywrite, env);

/*
 * Call the library routine, GDSsetUsrRead, to set the user exit routine for
 * writing buffer.
 */
   GDSsetUsrRead(myread, env);

/*
 * Call the library routine, GDSsetUsrDec, to set the user exit routine
 * for decoding. In this program, it is set to mydec once.  However,
 * it may be called any time the User Application Program wants to change the
 * encoding routine.
 */
   GDSsetUsrDec(mydec, env);

/***************************
 * ENCODING
 ***************************
 */
/*
 * Call the library routine, GDSfirstmodule, to get pointers to the first
 * moddef structure and the module name string in the current chain of modules.
 */
   GDSfirstmodule(&Mod,               /* return ptr to a moddef structure */
                  &ModName,           /* return ptr to the module name string */
                  env                 /* environment */
                 );                   /* init module vars */

   strcpy(savmodname, ModName);

/*
 * This loop repeatedly asks the user to enter a module and type name.
 * It terminates upon user request or when an error is detected.
 */
   for (;;) {

      char                  *readmod, readbuf[100];
      unsigned char         *cont, *out_buff, *in_buff, alldata;
      long                   lencont, loc;
      struct contents_str   *ContArrayPtr;
      struct content_str    *cont_list;
      struct gds           **gds_tree_ptr = NULL;
      struct errdata         errinfo;

      if (!onlydec) {
        printf("\n[%s.]Module (or stop): ", savmodname);
        fflush(NULL);

     /*
      * ask user for module name
      */
        strcpy(modname, savmodname);
        readmodtype(readbuf, sizeof(readbuf), &readmod);
        if (readmod != NULL) {         /* if user typed in a module name */
          if (!strcmp(readmod, "stop")) {
            break;
          } /* endif */
          strcpy(modname, readmod);    /* use the module name the user typed
                                        * in */
        } /* endif */

/*
 * Call the library routine, GDSfindmodule, to find the moddef structure
 * corresponding to the name in the modname string.
 */
        Mod = GDSfindmodule(modname, env);
        if (Mod == NULL) {             /* if module not found */
          printf("\nModule not found\n");
          continue;                    /* allow more attempts */
        }

/*
 * Call the library routine, GDSfindtype, to find the metatable index in
 * the Mod module corresponding to the type name in readtype.  Note that
 * the .H files created by the ASN.1 compiler contain symbol names for
 * the type and value metatable indices.  When the type or value name
 * is known at application compile-time, these symbolic names can be
 * used directly instead of searching through the metatables at
 * runtime. In this case we call GDSfindtype as example.
 */
        rc = GDSfindtype(Mod,          /* module where type is to be found */
                         "IPM",        /* type name string */
                         &Typ          /* returned metatable index */
                         );
        if (rc != FIND_TYPE_OK) {            /* if type not found */
           printf("\nType not found; rc = %i\n", rc);
           continue;                   /* allow more attempts */
        }

/*
 * Call the library routine GDSallocateContentsArray to allocate
 * the array of contents pointers for the specified module.
 * This function returns a pointer to the first location of the array
 */
        rc = GDSallocateContentsArray(Mod, &ContArrayPtr);
        if (rc == ALLOCATECONT_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents pointers array\n");
          return(-1);
        } /* endif */

/*
 * Load the Contents Array
 */
/* IPM */
(ContArrayPtr[IPMSInformationObjects_IPM_SEQUENCE]).content = dummy;

/* HEADING */
(ContArrayPtr[IPMSInformationObjects_HEADING_SET]).content = dummy;

/* BODY */
(ContArrayPtr[IPMSInformationObjects_BODY_SEQUENCE_OF]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_BODY_SEQUENCE_OF]).len = 1;

/* IPMIdentifier */
(ContArrayPtr[IPMSInformationObjects_IPMIdentifier_SET]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_LocalIPMIdentifier_PrintableString_CharacterString]).content = "mio_messaggio";
(ContArrayPtr[IPMSInformationObjects_LocalIPMIdentifier_PrintableString_CharacterString]).len = 13;
(ContArrayPtr[IPMSInformationObjects_LocalIPMIdentifier_PrintableString_CharacterString]).contstg = allocd;

/* Originator */
(ContArrayPtr[IPMSInformationObjects_ORDescriptor_SET]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_ORName_SEQUENCE]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_StandardAttributes_SEQUENCE]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_CountryName_EXPLICIT]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_CountryName_CHOICE_iso_3166_alpha2_code_CharacterString]).content = "IT";
(ContArrayPtr[IPMSInformationObjects_CountryName_CHOICE_iso_3166_alpha2_code_CharacterString]).len = 2;
(ContArrayPtr[IPMSInformationObjects_CountryName_CHOICE_iso_3166_alpha2_code_CharacterString]).contstg = allocd;

(ContArrayPtr[IPMSInformationObjects_PersonalName_SET]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_PersonalName_SET_surname_CharacterString]).content = "Starinieri";
(ContArrayPtr[IPMSInformationObjects_PersonalName_SET_surname_CharacterString]).len = 10;
(ContArrayPtr[IPMSInformationObjects_PersonalName_SET_surname_CharacterString]).contstg = allocd;


(ContArrayPtr[IPMSInformationObjects_PersonalName_SET_given_name_CharacterString]).content = "Mauro";
(ContArrayPtr[IPMSInformationObjects_PersonalName_SET_given_name_CharacterString]).len = 5;
(ContArrayPtr[IPMSInformationObjects_PersonalName_SET_given_name_CharacterString]).contstg = allocd;

/* Subject */
(ContArrayPtr[IPMSInformationObjects_HEADING_SET_subject_EXPLICIT]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_SubjectField_TeletexString_CharacterString]).content =
             "prova-prova";
(ContArrayPtr[IPMSInformationObjects_SubjectField_TeletexString_CharacterString]).len = 11;
(ContArrayPtr[IPMSInformationObjects_SubjectField_TeletexString_CharacterString]).contstg = allocd;

/* IA5 body */
(ContArrayPtr[IPMSInformationObjects_IA5TextBodyPart_SEQUENCE]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_IA5TextParameters_SET]).content = dummy;
(ContArrayPtr[IPMSInformationObjects_IA5TextData_IA5String_CharacterString]).usrcontent = mycontent;
(ContArrayPtr[IPMSInformationObjects_IA5TextData_IA5String_CharacterString]).len = 330;
(ContArrayPtr[IPMSInformationObjects_IA5TextData_IA5String_CharacterString]).contstg = allocd;

/*
 * Call the library routine, GDSencode, to create one or more GDS structures
 * that represent a value for Mod.Typ.
 * Note that the GDSencode function does *not* create the BER encoded
 * data.  The GDS structures contain the information needed to
 * encode the data, but the actual encoding is a secondary step.  This
 * allows other encoding techniques besides BER to be used.  The
 * log component of the GDS structure is computed by encode assuming
 * BER rules (this is a slight optimization that prevents traversing
 * the GDS structure tree another time); if encber is not used to encode
 * the data, the log component should not be used.
 */
        /* encode ThisIPMField */
        Typ = IPMSInformationObjects_IPM;
        rc = GDSencode(Mod,            /* moddef module where type occurs */
                       &Typ,           /* metatable index where type occurs */
                       ContArrayPtr,   /* pointer to Contents Array */
                       &p1,            /* returned GDS structure */
                       enctype,        /* type of encoding */
                       env,            /* environment */
                       NULL            /* parms to pass to the user encode
                                        * routine, not used in this case */
                      );


        if (rc != ENCODE_MATCH) {      /* if the encoding failed */
           printf("\nGDSencode return code: %i\n", rc);
           printf("\nmetatable type index where error occurred: %i\n", Typ);
        }    /* endif */

        l = p1->loc;                   /* get the length of encoded data */
        printf("\nlength of encoded data: %ld\n", l);

/*
 * open the input-output file that will contain the encoded data stream
 */
        EncStream = fopen("stream1.out","wb");
        if (EncStream == NULL) {            /* open file failed */
          printf("open input/output file failed\n");
          exit(-1);
        } /* endif */

/*
 * Call the library routine, GDSencber, to encode the GDS using BER rules.
 */
        rc = GDSencber(&p1,            /* the GDS structure to be encoded */
                       outbuflen,      /* the length of the output buffer */
                       &out_buff,      /* output buffer pointer */
                       &EncBytes,      /* the number of encoded bytes */
                       0,              /* use definite length form */
                       env,            /* environment */
                       (void *) EncStream); /* output file pointer */

        if (rc != ENCBER_OK) {         /* if encoding was unsuccessful */
           printf("\nGDSencber return code: %i\n", rc);
           printf("module name: %s\n", p1->modname);
           printf("type name: %s\n", p1->name);
        }  /* endif */

        printf("\nnumber of encoded bytes: %lu\n", EncBytes);

/*
 * Call the library routine, GDSprintgds, to print the structure and
 * content of the encoded GDS.
 */
        rc = GDSprintgds(p1,           /* ptr to root GDS structure */
                         0,            /* number of spaces to indent */
                         400,          /* max content length */
                         79,           /* number of characters for row */
                         trace_enc,    /* gds tree trace file */
                         enctype       /* type of encoding */
                        );

        if (rc != PRINT_GDS_OK) {      /* if the printing failed */
           printf("\nGDSprintgds return code: %i\n", rc);
           GDSfreegds(p1, env);        /* reclaim space for encoded GDS tree */
           continue;
        }    /* endif */

        fclose(trace_enc);

        fclose(EncStream);

/*
 * Call the library routine, GDSfreegds, to reclaim the storage occupied by
 * the GDS structures headed by p1 which are marked as allocated.  Note
 * that some GDSs may be marked as static, which prevents them from
 * being freed.
 */
        GDSfreegds(p1, env);           /* reclaim space for encoded GDS tree */

        printf("GDSfreegds OK\n");

/*
 * Call the library routine, GDSfreeContentsArray, to reclaim the storage
 * allocated for the contents-array.
 */
        GDSfreeContentsArray(Mod, ContArrayPtr);

      } /* endif */

/***************************
 * DECODING
 ***************************
 */
/*
 * ask to the user the name of the decoding module
 */

      printf("\n[%s.]Module for decoding (or stop): ", savmodname);
      fflush(NULL);


   /*
    * ask user for module name
    */
      strcpy(modname, savmodname);
      readmodtype(readbuf, sizeof(readbuf), &readmod);
      if (readmod != NULL) {           /* if user typed in a module name */
        if (!strcmp(readmod, "stop")) {
           break;
        } /* endif */
         strcpy(modname, readmod);     /* use the module name the user
                                        * typed in */
      } /* endif */

/*
 * Call the library routine, GDSfindmodule, to find the moddef structure
 * corresponding to the name in the modname string.
 */
      Mod = GDSfindmodule(modname, env);
      if (Mod == NULL) {               /* if module not found */
         printf("\nModule not found\n");
         continue;                     /* allow more attempts */
      }

/*
 * Call the library routine, GDSfindtype, to find the metatable index in
 * the Mod module corresponding to the type name in readtype.  Note that
 * the .H files created by the ASN.1 compiler contain symbol names for
 * the type and value metatable indices.  When the type or value name
 * is known at application compile-time, these symbolic names can be
 * used directly instead of searching through the metatables at
 * runtime.
 */
      rc = GDSfindtype(Mod,            /* module where type is to be found */
                       "IPM",          /* type name string */
                       &Typ            /* returned metatable index */
                      );
      if (rc != FIND_TYPE_OK) {            /* if type not found */
         printf("\nType not found; rc = %i\n", rc);
         continue;                     /* allow more attempts */
      }

/*
 * open the input file that will contain the encoded data stream
 */
      EncStream = fopen("stream1.out","rb");
      if (EncStream == NULL) {            /* open file failed */
        printf("open input/output file failed\n");
        exit(-1);
      } /* endif */

/*
 * Call the library routine, GDSdecber, to decode encoded data in the
 * buffer we just built.  The result should be a tree of GDS structures
 * topped by p1 which matches the original structure created by the
 * encode library routine.
 */
      alldata = 0;
      in_buff = &alldata;
      rc = GDSdecber(&p1,              /* GDS structure which will be the root
                                        * of the GDS tree */
                     inbuflen,         /* the length of the input buffer */
                     &DecBytes,        /* number of decoded bytes */
                     &in_buff,         /* data buffered indicator */
                     env,              /* environment */
                     (void *) EncStream); /* input file pointer */

      if (rc != DECBER_OK) {           /* if decoding failed */
         printf("\nGDSdecber return code: %i\n", rc);
         printf("\nnumber of decoded bytes: %u\n", DecBytes);
      }    /* endif */

      printf("\nnumber of decoded bytes: %u\n", DecBytes);

/*
 * Call the library routine, GDSprintgds, to print the structure and
 * content of the decoded GDS.
 */
      rc = GDSprintgds(p1,             /* ptr to root GDS structure */
                       0,              /* number of spaces to indent */
                       400,            /* max content length */
                       79,             /* number of characters for row */
                       trace_dec,      /* gds tree trace file */
                       enctype         /* type of encoding */
                      );

      if (rc != PRINT_GDS_OK) { /* if the printing failed */
         printf("\nGDSprintgds return code: %i\n", rc);
         GDSfreegds(p1, env);
         continue;
      }    /* endif */

/*
 * Call the library routine, GDSdecode, to match the GDS structure tree
 * created by GDSdecber with an ASN.1 type referenced by Mod and Typ.
 * If successful, the GDS structures will have name information set.
 */

      rc = GDSdecode(Mod,              /* moddef module where type occurs */
                     &Typ,             /* metatable index where type occurs */
                     &p1,              /* root of GDS structure tree */
                     gds_tree_ptr,     /* gds-tree-array ptr */
                     env,              /* environment */
                     (void *) usrdecfile); /* file used by dec user-exit */

      if (rc != DECODE_MATCH) {        /* if decoding didn't go ok */
        printf("\nGDSdecode return code: %i\n", rc);
        printf("metatable type index where error occurred: %i\n", Typ);
        printf("module name: %s\n", p1->modname);
        printf("type name: %s\n", p1->name);
      }   /* endif */

      printf("\nGDSdecode OK\n");

/*
 * Call the library routine, GDSprintgds, to print the structure and
 * content of the decoded GDS.
 */
      rc = GDSprintgds(p1,             /* ptr to root GDS structure */
                       0,              /* number of spaces to indent */
                       400,            /* max content length */
                       79,             /* number of characters for row */
                       trace_dec,      /* gds tree trace file */
                       enctype         /* type of encoding */
                      );

      if (rc != PRINT_GDS_OK) { /* if the printing failed */
         printf("\nGDSprintgds return code: %i\n", rc);
         GDSfreegds(p1, env);
         continue;
      }    /* endif */

      fclose(trace_dec);

      fclose(EncStream);

/*
 * Call the library routine to free the GDS structures in the tree rooted
 * by *p1.
 */
      GDSfreegds(p1, env);

   }        /* endfor */

   printf("\nout of loop\n");

/***************************
 * TERMINATION
 ***************************
 */

/*
 * Clean up the environment by unloading all modules by calling
 * GDSunloadmodule for each module in the environment.  NOTE:
 * the GDSunloadmodule function should only be called for modules which
 * were loaded by the GDSreaddatfile function or which have allocated
 * storage in the heap like the GDSreaddatfile function.
 */

   for (GDSfirstmodule(&Mod, &ModName, env); Mod != NULL;
        GDSfirstmodule(&Mod, &ModName, env)) {
      GDSunloadmodule(Mod, env);
   } /* endfor */
   printf("\nGDSunloadmodule loop OK\n");

 /*
  * Call the library routine GDSfreeEnvironment to free the
  * environment storage
  */
   GDSfreeEnvironment(env);

   return 0;
}  /* end main */

static
char *readline(char *buf)
{
   char *r;

   *buf = '\0';                 /* init */
   r = gets(buf);
   if (r == NULL) {
      return(0);
   } /* endif */
   return r;
}

static
void readmodtype(char *readbuf, int buflen, char **readmod)
{

   /*  Read from standard input to get a modulename.typename or
    *  just typename.  Skip over white space before name strings and
    *  consider newline the end of the string.
    */

   char *cp, *cp2;
   int len;
   char foo[200];

   readline(foo);
   cp2 = strtok(foo, " ");

   if (cp2 == NULL) {
      *readmod = NULL;
      return;
   } /* endif */
   /* Now read characters up to a newline or the end of the buffer */
   for (cp = readbuf, len = 0; len < buflen-1; cp++, cp2++, len++) {
      *cp = *cp2;
      if (*cp == '\0') {
         break;
      } /* endif */
   } /* endfor */
   *cp = '\0';               /* terminate the string with a null */
   *readmod = readbuf;       /* the module name starts at 1st char in str */
}

/*
 * Writing user-exit
 */
unsigned long mywrite(char *buf, unsigned long buflen, void *usrparms)
{
  FILE *EncStream;

  EncStream = (FILE *) usrparms;
  return (unsigned long) (fwrite(buf,sizeof(unsigned char),buflen,EncStream));
}

/*
 * Reading user-exit
 */
unsigned long myread(char *buf, unsigned long buflen, void *usrparms)
{
  FILE *EncStream;

  EncStream = (FILE *) usrparms;
  return (unsigned long) (fread(buf,sizeof(unsigned char),buflen,EncStream));
}

/*
 * Content user-exit
 */
int mycontent (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data0 = "caro amico";                     /* 10 */
  char *data1 = " ti scrivo,";                    /* 11 */
  char *data2 = " cosi' mi distraggo un po',";    /* 27 */
  char *data3 = " e siccome sei molto lontano,";  /* 29 */
  char *data4 = " piu' forte ti scrivero',";   /* 25 */
  char *data5 = " da quando sei partito c'e' una grossa novita',"; /* 47 */
  char *data6 = " l'anno vecchio e' finito ormai ma qualcosa ancora qui non va,";  /* 62 */
  char *data7 = " si esce poco la sera, compreso quando e' festa,"; /* 48 */
  char *data8 = " e c'e' qualcuno cha ha messo dei sacchi di sabbia";  /* 50 */
  char *data9 = " vicino alla finestra";   /* 21 */
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    *buff = data0;
    *buflen = strlen(data0);
    *lastf = NO;
    break;
  case 1:
    *buff = data1;
    *buflen = strlen(data1);
    *lastf = NO;
    break;
  case 2:
    *buff = data2;
    *buflen = strlen(data2);
    *lastf = NO;
    break;
  case 3:
    *buff = data3;
    *buflen = strlen(data3);
    *lastf = NO;
    break;
  case 4:
    *buff = data4;
    *buflen = strlen(data4);
    *lastf = NO;
    break;
  case 5:
    *buff = data5;
    *buflen = strlen(data5);
    *lastf = NO;
    break;
  case 6:
    *buff = data6;
    *buflen = strlen(data6);
    *lastf = NO;
    break;
  case 7:
    *buff = data7;
    *buflen = strlen(data7);
    *lastf = NO;
    break;
  case 8:
    *buff = data8;
    *buflen = strlen(data8);
    *lastf = NO;
    break;
  case 9:
    *buff = data9;
    *buflen = strlen(data9);
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * Decoding user-exit
 */
int mydec(unsigned short ndx, struct gds *p, char *content,
          unsigned long contlen, void *usrparms)
{
  long   foolong;
  char   foo[500];
  FILE  *usrdecfile;

  usrdecfile = (FILE *) usrparms;
  if (content != NULL) {
    switch (ndx) {
    case IPMSInformationObjects_LocalIPMIdentifier_PrintableString_CharacterString:
      fprintf(usrdecfile,"IPMSInformationObjects_LocalIPMIdentifier_PrintableString_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case IPMSInformationObjects_CountryName_CHOICE_iso_3166_alpha2_code_CharacterString:
      fprintf(usrdecfile,"IPMSInformationObjects_CountryName_CHOICE_iso_3166_alpha2_code_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case IPMSInformationObjects_PersonalName_SET_surname_CharacterString:
      fprintf(usrdecfile,"IPMSInformationObjects_PersonalName_SET_surname_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case IPMSInformationObjects_PersonalName_SET_given_name_CharacterString:
      fprintf(usrdecfile,"IPMSInformationObjects_PersonalName_SET_given_name_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case IPMSInformationObjects_SubjectField_TeletexString_CharacterString:
      fprintf(usrdecfile,"IPMSInformationObjects_SubjectField_TeletexString_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case IPMSInformationObjects_IA5TextData_IA5String_CharacterString:
      fprintf(usrdecfile,"IPMSInformationObjects_IA5TextData_IA5String_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    default:
     break;
    } /* endswitch */
  } /* endif */
  return 0;
}
