/*
 *      Created 1993  IBM Corp.                                            *
 *                                                                         *
 *      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is        *
 *      sample code created by IBM Corporation. This sample code is not    *
 *      part of any standard or IBM product and is provided to you solely  *
 *      for  the purpose of assisting you in the development of your       *
 *      applications.  The code is provided "AS IS", without               *
 *      warranty of any kind.  IBM shall not be liable for any damages     *
 *      arising out of your use of the sample code, even if they have been *
 *      advised of the possibility of such damages.                        *
 */
/**************************************************************************
 * encode/decode sample program for the ASN.1 specification of TEST0.asn.
 * This sample uses:
 * 1.GDSD encoding
 * 2.contents user-exit
 * 3.contents-array
 * 4.decoding user-exit
 *
 * It tests also an error situation in decoding: the SIZE constraint of
 * cmd2 of Req3 of DDM0 is not matched.
 * Arguments:
 *            .DAT file,
 *            input buffer length,
 *            output buffer length,
 *            only decoding (ENC or NOENC)
 *****************************************************************************
 */

/*
 * The following are needed to compile this program. Note that the
 * order of the header files is important.
 */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "gdstypes.h"
#include "gdsrcods.h"
#include "gdsproto.h"
#include "test0ndx.h"
#include "sample0.h"


main(int argc, char **argv)
{
   int                   rc, onlydec;
   void                 *Mod, *env;
   unsigned short        Typ;
   long                  l;
   char                  savmodname[50], *ModName, modname[50];
   unsigned long         EncBytes, inbuflen, outbuflen, DecBytes;
   enum TypOfEnc         enctype;
   struct gds           *p1;
   FILE                 *trace_enc;
   FILE                 *trace_dec;
   FILE                 *EncStream;    /* input-output file */
   FILE                 *usrdecfile;   /* file written by decoding user-exit */
   static char          *dummy = "dummy";

   if (argc < 5) {
      exit(0);
   }   /* endif */

 /*
  * only decoding?
  */
   if (!strcmp(argv[4],"ENC")) {
    onlydec = 0;
   } else {
     if (!strcmp(argv[4],"NOENC")) {
       onlydec = 1;
     } else {
       printf("invalid encoding YES/NO parameter\n");
       exit(-1);
     } /* endif */
   } /* endif */

/*
 * set the type of encoding indicator
 */
   enctype = gdsd;


   inbuflen = atol(argv[2]);     /* set the length of the input buffer */
   outbuflen = atol(argv[3]);    /* set the length of output buffer */


/*
 * open the trace file for encoded gds tree
 */
   trace_enc = fopen("enctrace0.out","w");
   if (trace_enc == NULL) { /* open file failed */
     printf("open enc trace file failed\n");
     exit(-1);
   } /* endif */

/*
 * open the trace file for decoded gds tree
 */
   trace_dec = fopen("dectrace0.out","w");
   if (trace_dec == NULL) { /* open file failed */
     printf("open dec trace file failed\n");
     exit(-1);
   } /* endif */

/*
 * open the decoding user-exit output file
 */
   usrdecfile = fopen("usrdec0.out","w");
   if (usrdecfile == NULL) { /* open file failed */
     printf("open decoding user-exit output file failed\n");
     exit(-1);
   } /* endif */

/*****************************
 * INITIALIZATION
 *****************************
 */

/*
 * Call the library routine, GDSinitEnvironment, to initialize the environment.
 * Each application program has to do this before calling any routine to
 * read .dat files, encode or decode GDSs.
 */
   rc = GDSinitEnvironment(&env);

   if (rc != INIT_ENV_OK) {
     printf("GDSinitEnvironment return code: %i\n", rc);
     exit(rc);
   }

/*
 * Call the library routine, GDSsetUsrWrite, to set the user exit routine for
 * writing buffer.
 */
   GDSsetUsrWrite(mywrite, env);

/*
 * Call the library routine, GDSsetUsrRead, to set the user exit routine for
 * reading buffer.
 */
   GDSsetUsrRead(myread, env);

/*
 * Call the library routine, GDSsetUsrDec, to set the decoding user exit
 */
   GDSsetUsrDec(mydec, env);


/*
 * Call the library routine, GDSreaddatfile, to read a .dat file containing
 * the metatables and symbol tables for one or more ASN.1 module.  Note that
 * references between ASN.1 modules (imported and exported symbols) are *not*
 * resolved by GDSreaddatfile.
 */
   rc = GDSreaddatfile(argv[1], env); /* first parm should be a readable data file */

   if (rc != READ_DAT_OK) {
     printf("GDSreaddatfile return code: %i\n", rc);
     exit(rc);
   }

/*
 * Call the library routine, GDSresolveallimports, to resolve imports and
 * exports in the .dat file.  Note that if more than one .dat file had
 * been read in with multiple calls to GDSreaddatfile, this call should be
 * deferred as late as possible to maximize performance.  Multiple calls
 * to GDSresolveallimports are allowed, however.
 */
   rc = GDSresolveallimports(env);

   if (rc != RESOLVE_IMPORTS_OK) {
     printf("GDSresolveallimports return code: %i\n", rc);

    /* Call the library routine, GDSPrintUnresolvedImports, to print the
     * unresolved imports */
     GDSPrintUnresolvedImports(stdout, env);
     exit(rc);
   }

/*
 * Call the library routine, fGDSirstmodule, to get pointers to the first
 * module structure and the module name string in the current chain of modules.
 * This is done in this program to obtain the default module name for
 * querying the user for module to encode and decode.
 */
   GDSfirstmodule(&Mod,         /* return ptr to a moddef structure */
                  &ModName,     /* return ptr to the module name string */
                  env
                 );

   strcpy(savmodname, ModName);
   ModName = savmodname;

/*
 * This loop repeatedly asks the user to enter a module and type name.
 * It terminates upon user request or when an error is detected.
 */

   for (;;) {

      char                  *readmod, readbuf[100], cont1[2], cont2[2];
      unsigned char         *cont;
      long                   lencont;
      struct contents_str   *ContArrayPtr;
      struct content_str    *cont_list;
      struct errdata         errinfo;

      if (!onlydec) {
        printf("\n[%s.]Module (or stop): ", savmodname);
        fflush(NULL);

     /*
      * ask user for module name
      */
        strcpy(modname, savmodname);
        readmodtype(readbuf, sizeof(readbuf), &readmod);
        if (readmod != NULL) {         /* if user typed in a module name */
          if (!strcmp(readmod, "stop")) {
            break;
          } /* endif */
          strcpy(modname, readmod);    /* use the module name the user typed
                                        * in */
        } /* endif */

/*
 * Call the library routine, GDSfindmodule, to find the moddef structure
 * corresponding to the name in the modname string.
 */
        Mod = GDSfindmodule(modname, env);
        if (Mod == NULL) {        /* if module not found */
          printf("\nModule not found\n");
          continue;               /* allow more attempts */
        }                         /* endif */

/*
 * Call the library routine, GDSfindtype, to find the metatable index in
 * the Mod module corresponding to the type name "Req".  Note that
 * the .H files created by the ASN.1 compiler contain symbol names for
 * the type and value metatable indices.  When the type or value name
 * is known at application compile-time, these symbolic names can be
 * used directly instead of searching through the metatables at
 * runtime.
 */
        rc = GDSfindtype(Mod,     /* module where type is to be found */
                         "Req",   /* type name string */
                         &Typ     /* returned metatable index */
                      );
        if (rc != FIND_TYPE_OK) {        /* if type not found */
          printf("\nType not found; rc = %i\n", rc);
          continue;                      /* allow more attempts */
        }                      /* endif */

/********************************
 * ENCODING
 ********************************
 */

/*
 * Call the library routine GDSallocateContentsArray to allocate
 * the array of contents pointers for the specified module.
 * This function returns a pointer to the first location of the array
 */

        rc = GDSallocateContentsArray(Mod, &ContArrayPtr);
        if (rc == ALLOCATECONT_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents pointers array\n");
          return(-1);
        } /* endif */

/*
 * Load the Contents Array
 */


       (ContArrayPtr[DDM1_Req0_SET_OF]).len = 2; /* number of items of SET OF */

/*
 * Call the library routine GDSallocateContListArray to allocate
 * the array of contents pointers for SET OF type.
 * This function returns a pointer to the first location of the array
 */

        (ContArrayPtr[DDM1_Req1_SET]).content = dummy;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(1L, cont, &lencont);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = lencont;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(0L, cont, &lencont);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = lencont;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req1_SET_cmd1_ENUMERATED]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req1_SET_cmd1_ENUMERATED]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(5L, cont, &lencont);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = lencont;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(10L, cont, &lencont);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = lencont;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req1_SET_cmd2_INTEGER]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req1_SET_cmd2_INTEGER]).len = 2;


        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(10,unsigned char);
        GDSstr2hex(cont, 10, "00112233445566778899", 20);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 10;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(5,unsigned char);
        GDSstr2hex(cont, 5, "0011223344", 10);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 5;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd1_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd1_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(20,unsigned char);
        memcpy(cont, "Caro amico ti scrivo",20);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 20;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(25,unsigned char);
        memcpy(cont, "cosi' mi distraggo un po'",25);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 25;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd2_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd2_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(4,unsigned char);
        GDSstr2hex(cont, 4, "00112233", 8);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 4;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(4,unsigned char);
        GDSstr2hex(cont, 4, "44556677", 8);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 4;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd5_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd5_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(27,unsigned char);
        memcpy(cont, "e siccome sei molto lontano",27);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 27;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(22,unsigned char);
        memcpy(cont, "piu' forte ti scrivero",22);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 22;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd6_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd6_CharacterString]).len = 2;


        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "0011", 4);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 2;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "4455", 4);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 2;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd7_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd7_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(1,unsigned char);
        memcpy(cont, "d",1);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 1;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(1,unsigned char);
        memcpy(cont, "a",1);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 1;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd8_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd8_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(4,unsigned char);
        memcpy(cont, "ciao",4);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 4;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(4,unsigned char);
        memcpy(cont, "ciao",4);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 4;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd9_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd9_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(6,unsigned char);
        GDSstr2hex(cont, 6, "001122334455", 12);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 6;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(6,unsigned char);
        GDSstr2hex(cont, 6, "001122334455", 12);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 6;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd10_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd10_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(55L, cont, &lencont);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = lencont;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(100L, cont, &lencont);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = lencont;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd11_INTEGER]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd11_INTEGER]).len = 2;


        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(355L, cont, &lencont);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = lencont;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW(long);
        GDSlongtoINTEGER(310L, cont, &lencont);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = lencont;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd12_INTEGER]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req3_SEQUENCE_cmd12_INTEGER]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = dummy;                        /* dummy pointer */
        (cont_list[0]).content = cont;       /* encode the first */
        (cont_list[1]).content = cont;       /* encode the second */
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd1_NULL]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd1_NULL]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 1;
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 1;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 0;
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 1;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd2_BOOLEAN]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd2_BOOLEAN]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = dummy;                        /* dummy pointer */
        (cont_list[0]).content = cont;       /* encode the first */
        (cont_list[1]).content = NULL;       /* skip the second */
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd4_NULL]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd4_NULL]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 1;
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 1;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 0;
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 1;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd7_BOOLEAN]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd7_BOOLEAN]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = dummy;                        /* dummy pointer */
        (cont_list[0]).content = cont;       /* encode the first */
        (cont_list[1]).content = cont;       /* encode the second */
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd8_NULL]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd8_NULL]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 1;
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 1;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 0;
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 1;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd9_BOOLEAN]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd9_BOOLEAN]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = dummy;                        /* dummy pointer */
        (cont_list[0]).content = NULL;       /* skip the first */
        (cont_list[1]).content = cont;       /* encode the second */
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd10_NULL]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd10_NULL]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 1;
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 1;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(1,unsigned char);
        *cont = 0;
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 1;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd11_BOOLEAN]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req5_SEQUENCE_cmd11_BOOLEAN]).len = 2;

        (ContArrayPtr[DDM1_Req6_SET_cmd1_SEQUENCE]).content = dummy;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "6677", 4);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 2;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "8899", 4);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 2;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req6_SET_cmd1_SEQUENCE_cmd1_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req6_SET_cmd1_SEQUENCE_cmd1_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(9,unsigned char);
        memcpy(cont, "quando se",9);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 9;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(8,unsigned char);
        memcpy(cont, "partito ",8);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 8;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req6_SET_cmd1_SEQUENCE_cmd2_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req6_SET_cmd1_SEQUENCE_cmd2_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(8,unsigned char);
        memcpy(cont, "c'e' una",8);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 8;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(9,unsigned char);
        memcpy(cont, "grossa no",9);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 9;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req8_CHOICE_cmd1_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req8_CHOICE_cmd1_CharacterString]).len = 2;

        (ContArrayPtr[DDM1_Req7_SEQUENCE]).content = dummy;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        (cont_list[0]).usrcontent = mycontent;
        (cont_list[0]).len = 88;
        (cont_list[0]).contstg = stat;
        cont = (unsigned char *) NEW2(24,unsigned char);
        memcpy(cont, "compreso quando e' festa",24);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 24;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req7_SEQUENCE_cmd1_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req7_SEQUENCE_cmd1_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "AABB", 4);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 2;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "CCDD", 4);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 2;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req7_SEQUENCE_cmd3_SEQUENCE_cmd1_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req7_SEQUENCE_cmd3_SEQUENCE_cmd1_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(20,unsigned char);
        memcpy(cont, "si esce poco la sera",20);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 20;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(24,unsigned char);
        memcpy(cont, "compreso quando e' festa",24);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 24;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req7_SEQUENCE_cmd3_SEQUENCE_cmd2_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req7_SEQUENCE_cmd3_SEQUENCE_cmd2_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(3,unsigned char);
        memcpy(cont, "ole",3);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 3;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(3,unsigned char);
        memcpy(cont, "ole",3);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 3;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM0_Req10_SEQUENCE_cmd1_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM0_Req10_SEQUENCE_cmd1_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "0011", 4);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 2;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "2233", 4);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 2;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM0_Req10_SEQUENCE_cmd2_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM0_Req10_SEQUENCE_cmd2_OCTET_STRING]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(3,unsigned char);
        memcpy(cont, "ole",3);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 3;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(3,unsigned char);
        memcpy(cont, "ole",3);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 3;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req11_SEQUENCE_cmd1_CharacterString]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req11_SEQUENCE_cmd1_CharacterString]).len = 2;

        rc = GDSallocateContListArray(2, &cont_list);
        if (rc == ALLOCATECONTLIST_NO_ENOUGH_STORAGE) {
          printf("no enough storage for contents list pointers array\n");
          return(-1);
        } /* endif */

        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "0011", 4);
        (cont_list[0]).content = cont;
        (cont_list[0]).len = 2;
        (cont_list[0]).contstg = allocd;
        cont = (unsigned char *) NEW2(2,unsigned char);
        GDSstr2hex(cont, 2, "2233", 4);
        (cont_list[1]).content = cont;
        (cont_list[1]).len = 2;
        (cont_list[1]).contstg = allocd;
        (ContArrayPtr[DDM1_Req11_SEQUENCE_cmd2_OCTET_STRING]).contlist = cont_list;
        (ContArrayPtr[DDM1_Req11_SEQUENCE_cmd2_OCTET_STRING]).len = 2;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd2_CharacterString]).usrcontent = mycontent2;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd2_CharacterString]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd2_CharacterString]).contstg = stat;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd3_CharacterString]).usrcontent = mycontent3;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd3_CharacterString]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd3_CharacterString]).contstg = stat;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd4_CharacterString]).usrcontent = mycontent4;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd4_CharacterString]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd4_CharacterString]).contstg = stat;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd5_CharacterString]).usrcontent = mycontent5;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd5_CharacterString]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd5_CharacterString]).contstg = stat;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd6_OCTET_STRING]).usrcontent = mycontent6;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd6_OCTET_STRING]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd6_OCTET_STRING]).contstg = stat;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd7_OCTET_STRING]).usrcontent = mycontent7;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd7_OCTET_STRING]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd7_OCTET_STRING]).contstg = stat;

        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd8_OCTET_STRING]).usrcontent = mycontent8;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd8_OCTET_STRING]).len = UNDEFLENGTH;
        (ContArrayPtr[DDM1_Req_SEQUENCE_cmd8_OCTET_STRING]).contstg = stat;


/*
 * Call the library routine, GDSencode, to create one or more GDS structures
 * that represent a value for Mod and Typ. The user encode exit is called
 * during this process to provide the necessary values for the
 * ASN.1 type. The last parm is the addr of a structure with data
 * to be passed to the user encode exit. Applications
 * use this to pass local parameters to the user encode routine.  This is
 * useful when the the user appl (this routine) and the exit routine
 * must share data. The alternative is to make the
 * shared data global -- usually an undesirable programming practice.
 *
 * Note that the GDSencode function does *not* create the GDSD encoded
 * data. The GDS structures contain the information needed to
 * encode the data, but the actual encoding is a secondary step.
 */

        rc = GDSencode(Mod,      /* moddef module where type occurs */
                       &Typ,     /* metatable index where type occurs */
                       ContArrayPtr, /* pointer to Contents Array */
                       &p1,      /* returned GDS structure */
                       enctype,  /* type of encoding */
                       env,      /* environment */
                       NULL      /* parms to pass to the user encode routine
                                  * not used in this case */
                      );


        if (rc != ENCODE_MATCH) { /* if the encoding failed */
          printf("\nGDSencode return code: %i\n", rc);
          printf("\nmetatable type index where error occurred: %i\n", Typ);
        }    /* endif */

        l = p1->loc;           /* get the length of enctype-encoded data */
        printf("\nlength of encoded data: %ld\n", l);

/*
 * Call the library routine, GDSprintgds, to print the structure and
 * content of the encoded GDS.
 */
        rc = GDSprintgds(p1,           /* ptr to root GDS structure */
                         0,            /* number of spaces to indent */
                         300,          /* max content length */
                         79,           /* number of characters for row */
                         trace_enc,    /* gds tree trace file */
                         enctype       /* type of encoding */
                        );

        if (rc != PRINT_GDS_OK) { /* if the printing failed */
          printf("\nGDSprintgds return code: %i\n", rc);
          GDSfreegds(p1, env);   /* reclaim space for encoded GDS struct */
          continue;              /* terminate the query loop */
        }    /* endif */

        fclose(trace_enc);

/*
 * open the output file that will contain the encoded data stream
 */
        EncStream = fopen("stream0.out","wb");
        if (EncStream == NULL) { /* open file failed */
          printf("open output file failed\n");
          exit(-1);
        } /* endif */
/*
 * Call the library routine, GDSencgdsd, to encode the GDS using GDSD rules.
 */
        rc = GDSencgdsd(&p1,          /* the GDS structure to be encoded */
                        outbuflen,    /* the length of the output buffer */
                        &EncBytes,    /* the number of encoded bytes */
                        use,          /* use LLIDFISS segmentation */
                        env,          /* environment */
                        (void *) EncStream /* output file pointer */
                        );

        if (rc != ENCGDSD_OK) {       /* if encoding was unsuccessful */
          printf("\nGDSencgdsd return code: %i\n", rc);
        }  /* endif */

        printf("\nnumber of encoded bytes: %lu\n", EncBytes);


/*
 * Call the library routine, GDSfreegds, to reclaim the storage occupied by
 * the GDS structures headed by p1 which are marked as allocated.  Note
 * that some GDSs may be marked as static, which prevents them from
 * being freed.
 */

        GDSfreegds(p1, env);

        printf("GDSfreegds OK\n");

/*
 * Call the library routine, GDSfreeContentsArray, to reclaim the storage
 * allocated for the contents-array.
 */
        GDSfreeContentsArray(Mod, ContArrayPtr);

      } /* endif */

/********************************
 * DECODING
 ********************************
 */

      fclose(EncStream);

/*
 * open the inputput file that will contain the encoded data stream
 */
      EncStream = fopen("stream0.out","rb");
      if (EncStream == NULL) { /* open file failed */
        printf("open output file failed\n");
        exit(-1);
      } /* endif */

/*
 * ask to the user the name of the decoding module
 */

      printf("\n[%s.]Module for decoding (or stop): ", savmodname);
      fflush(NULL);

   /*
    * ask user for module name
    */
      strcpy(modname, savmodname);
      readmodtype(readbuf, sizeof(readbuf), &readmod);
      if (readmod != NULL) {    /* if user typed in a module name */
        if (!strcmp(readmod, "stop")) {
           break;
        } /* endif */
        strcpy(modname, readmod); /* use the module name the user typed in */
      } /* endif */

/*
 * Call the library routine, GDSfindmodule, to find the moddef structure
 * corresponding to the name in the modname string.
 */
      Mod = GDSfindmodule(modname, env);
      if (Mod == NULL) {        /* if module not found */
        printf("\nModule not found\n");
        continue;              /* allow more attempts */
      }                         /* endif */

/*
 * Call the library routine, GDSfindtype, to find the metatable index in
 * the Mod module corresponding to the type name in readtype.  Note that
 * the .H files created by the ASN.1 compiler contain symbol names for
 * the type and value metatable indices.  When the type or value name
 * is known at application compile-time, these symbolic names can be
 * used directly instead of searching through the metatables at
 * runtime.  Since this application does not know the type
 * definitions beforehand, we have to use findtype to locate them.
 */
      rc = GDSfindtype(Mod,     /* module where type is to be found */
                       "Req",   /* type name string */
                       &Typ     /* returned metatable index */
                      );
      if (rc != FIND_TYPE_OK) {            /* if type not found */
         printf("\nType not found; rc = %i\n", rc);
         continue;           /* allow more attempts */
      }                      /* endif */


/*
 * Call the library routine, GDSdecgdsd, to decode encoded data in the
 * buffer we just built. The result should be a tree of GDS structures
 * topped by p1 which matches the original structure created by the
 * encode library routine.
 */
      rc = GDSdecgdsd(&p1,       /* GDS structure which will be the root
                                  * of the GDS tree */
                      inbuflen,  /* the length of the input buffer */
                      &DecBytes, /* number of decoded bytes */
                      Mod,       /* moddef module where type occurs */
                      &Typ,      /* metatable index where type occurs */
                      NULL,      /* pointer to array of pointers to GDS tree */
                      &errinfo,  /* error information */
                      env,       /* environment */
                      (void *) usrdecfile, /* dec user-exit file pointer */
                      (void *) EncStream   /* input file pointer */
                     );

      if (rc != DECGDSD_MATCH) {    /* if decoding didn't go ok */
        printf("\nGDSdecgdsd return code: %i\n", rc);
        printf("metatable type index where error occurred: %i\n", Typ);
        switch (rc) {
        case DECGDSD_INVALID_ID:
        case DECGDSD_INVALID_UNIQUE_ITEM:
        case DECGDSD_INVALID_SEG_IDF_PREFIX:
        case DECGDSD_INVALID_SEG_ID_PREFIX:
        {
          char errval[8];

          GDShex2str(errval, sizeof(errval),(char *) errinfo.err_item,
                     errinfo.err_item_len);
          printf("item in error: %s\n", errval);
          break;
        }
        case DECGDSD_INVALID_LENGTH:
        case DECGDSD_INVALID_SEG_SEQ_NUM:
          printf("item in error: %lu\n", *((long *) (errinfo.err_item)));
         break;
        default:
         break;
        } /* endswitch */
      }   /* endif */

      printf("\nnumber of decoded bytes: %u\n", DecBytes);

/*
 * Call the library routine, GDSprintgds, to print the structure and
 * content of the decoded GDS.
 */
      rc = GDSprintgds(p1,           /* ptr to root GDS structure */
                       0,            /* number of spaces to indent */
                       300,          /* max content length */
                       79,           /* number of characters for row */
                       trace_dec,    /* gds tree trace file */
                       enctype       /* type of encoding */
                      );

      if (rc != PRINT_GDS_OK) { /* if the printing failed */
        printf("\nGDSprintgds return code: %i\n", rc);
        GDSfreegds(p1, env);
        continue;              /* terminate the query loop */
      }    /* endif */

      fclose(trace_dec);

      fclose(EncStream);

/*
 * Call the library routine to free the GDS structures in the tree rooted
 * by *p1.
 */
      GDSfreegds(p1, env);

      freopen("","rb",EncStream); /* flush the output file buffer
                                   * and reopen the file for reading */
      if (EncStream == NULL) {    /* open file failed */
        printf("\nopen file failed\n");
        exit(-1);
      } /* endif */
   }        /* endfor */

   printf("\nout of loop\n");
/*******************************************
 * TERMINATION
 *******************************************
 */

/*
 * Clean up the environment by unloading all modules by calling
 * GDSunloadmodule for each module in the environment.  NOTE:
 * the GDSunloadmodule function should only be called for modules which
 * were loaded by the GDSreaddatfile function or which have allocated
 * storage in the heap like the GDSreaddatfile function.
 */

   for (GDSfirstmodule(&Mod, &ModName, env); Mod != NULL;
        GDSfirstmodule(&Mod, &ModName, env)) {
      GDSunloadmodule(Mod, env);
   } /* endfor */

   printf("\nGDSunloadmodule loop OK\n");

 /*
  * call the library routine GDSfreeEnvironment to free the
  * environment storage
  */
   GDSfreeEnvironment(env);

   return 0;
}  /* end main */

static
char *readline(char *buf)
{
   char *r;

   *buf = '\0';                 /* init */
   r = gets(buf);
   if (r == NULL) {
      return(0);
   } /* endif */
   return r;
}

static
void readmodtype(char *readbuf, int buflen, char **readmod)
{

   /*  Read from standard input to get a modulename.
    *  Skip over white space before name strings and
    *  consider newline the end of the string.
    */

   char *cp, *cp2;
   int len;
   char foo[200];

   readline(foo);
   cp2 = strtok(foo, " ");

   if (cp2 == NULL) {
     *readmod = NULL;
     return;
   } /* endif */
   /* Now read characters up to a newline or the end of the buffer */
   for (cp = readbuf, len = 0; len < buflen-1; cp++, cp2++, len++) {
      *cp = *cp2;
      if (*cp == '\0') {
         break;
      } /* endif */
   } /* endfor */
   *cp = '\0';               /* terminate the string with a null */
   *readmod = readbuf;       /* the module name starts at 1st char in str */
}

/*
 * writing user-exit
 */
unsigned long mywrite(char *buf, unsigned long buflen, void *usrparms)
{
  FILE *EncStream;

  EncStream = (FILE *) usrparms;
  return (unsigned long) (fwrite(buf,sizeof(unsigned char),buflen,EncStream));
}

/*
 * reading user-exit
 */
unsigned long myread(char *buf, unsigned long buflen, void *usrparms)
{
  FILE *EncStream;

  EncStream = (FILE *) usrparms;
  return (unsigned long) (fread(buf,sizeof(unsigned char),buflen,EncStream));
}

/*
 * content user-exit
 */
int mycontent (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data1 = "vita', l'anno vecchio e' finito ormai ma qualcosa";
  char *data2 = " ancora qui non va,";
  char *data3 = " si esce poco la ser";
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    *buff = data1;
    *buflen = strlen(data1);
    *lastf = NO;
    break;
  case 1:
    *buff = data2;
    *buflen = strlen(data2);
    *lastf = NO;
    break;
  case 2:
    *buff = data3;
    *buflen = strlen(data3);
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent2 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data1 = "BEGIN-cmd2:2222222222222222222";
  char *data2 = "222222222222222222222222222222";
  char *data3 = "2222222222222222222222END-cmd2";
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    *buff = data1;
    *buflen = strlen(data1);
    *lastf = NO;
    break;
  case 1:
    *buff = data2;
    *buflen = strlen(data2);
    *lastf = NO;
    break;
  case 2:
    *buff = data3;
    *buflen = strlen(data3);
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent3 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data1 = "BEGIN-cmd3:3333333333333333333";
  char *data2 = "333333333333333333333333333333";
  char *data3 = "3333333333333333333333END-cmd3";
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    *buff = data1;
    *buflen = strlen(data1);
    *lastf = NO;
    break;
  case 1:
    *buff = data2;
    *buflen = strlen(data2);
    *lastf = NO;
    break;
  case 2:
    *buff = data3;
    *buflen = strlen(data3);
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent4 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data1 = "BEGIN-cmd4:4444444444444444444";
  char *data2 = "444444444444444444444444444444";
  char *data3 = "4444444444444444444444END-cmd4";
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    *buff = data1;
    *buflen = strlen(data1);
    *lastf = NO;
    break;
  case 1:
    *buff = data2;
    *buflen = strlen(data2);
    *lastf = NO;
    break;
  case 2:
    *buff = data3;
    *buflen = strlen(data3);
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent5 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data1 = "BEGIN-cmd5:5555555555555555555";
  char *data2 = "555555555555555555555555555555";
  char *data3 = "5555555555555555555555END-cmd5";
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    *buff = data1;
    *buflen = strlen(data1);
    *lastf = NO;
    break;
  case 1:
    *buff = data2;
    *buflen = strlen(data2);
    *lastf = NO;
    break;
  case 2:
    *buff = data3;
    *buflen = strlen(data3);
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent6 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data;
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "666666666666666666666666666666", 30);
    *buff = data;
    *buflen = 15;
    *lastf = NO;
    break;
  case 1:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "777777777777777777777777777777", 30);
    *buff = data;
    *buflen = 15;
    *lastf = NO;
    break;
  case 2:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "888888888888888888888888888888", 30);
    *buff = data;
    *buflen = 15;
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent7 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data;
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "777777777777777777777777777777", 30);
    *buff = data;
    *buflen = 15;
    *lastf = NO;
    break;
  case 1:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "888888888888888888888888888888", 30);
    *buff = data;
    *buflen = 15;
    *lastf = NO;
    break;
  case 2:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "999999999999999999999999999999", 30);
    *buff = data;
    *buflen = 15;
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}

/*
 * content user-exit
 */
int mycontent8 (char **buff, unsigned long *buflen, enum lastflag *lastf)
{
  char *data;
  static int pass = 0;
  int rc = 0;

  switch (pass) {
  case 0:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "888888888888888888888888888888", 30);
    *buff = data;
    *buflen = 15;
    *lastf = NO;
    break;
  case 1:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "999999999999999999999999999999", 30);
    *buff = data;
    *buflen = 15;
    *lastf = NO;
    break;
  case 2:
    data = (unsigned char *) NEW2(15,unsigned char);
    GDSstr2hex(data, 15, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 30);
    *buff = data;
    *buflen = 15;
    *lastf = YES;
    break;
  } /* endswitch */
  pass++;
  return rc;
}


/*
 * decoding user-exit
 */
int mydec(unsigned short ndx, struct gds *p, char *content,
          unsigned long contlen, void *usrparms)
{
  long   foolong;
  char   foo[300];
  FILE  *usrdecfile;

  usrdecfile = (FILE *) usrparms;
  if (content != NULL) {
    switch (ndx) {
    case DDM0_Req1_SET_cmd1_ENUMERATED:
      fprintf(usrdecfile,"DDM0_Req1_SET_cmd1_ENUMERATED\n");
      GDSINTEGERtolong(content, contlen, &foolong);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"%ld (\'%s\'H)\n", foolong, foo);
      break;
    case DDM0_Req1_SET_cmd2_INTEGER:
      fprintf(usrdecfile,"DDM0_Req1_SET_cmd2_INTEGER\n");
      GDSINTEGERtolong(content, contlen, &foolong);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"%ld (\'%s\'H)\n", foolong, foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd1_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd1_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd2_CharacterString:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd2_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd3_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd3_OCTET_STRING\n");
      break;
    case DDM0_Req3_SEQUENCE_cmd4_CharacterString:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd4_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd5_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd5_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd6_CharacterString:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd6_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd7_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd7_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd8_CharacterString:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd8_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd9_CharacterString:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd9_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd10_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd10_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd11_INTEGER:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd11_INTEGER\n");
      GDSINTEGERtolong(content, contlen, &foolong);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"%ld (\'%s\'H)\n", foolong, foo);
      break;
    case DDM0_Req3_SEQUENCE_cmd12_INTEGER:
      fprintf(usrdecfile,"DDM0_Req3_SEQUENCE_cmd12_INTEGER\n");
      GDSINTEGERtolong(content, contlen, &foolong);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"%ld (\'%s\'H)\n", foolong, foo);
      break;
    case DDM0_Req5_SEQUENCE_cmd1_NULL:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd1_NULL\n");
      break;
    case DDM0_Req5_SEQUENCE_cmd2_BOOLEAN:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd2_BOOLEAN\n");
      GDShex2str(foo, 300, content, contlen);
      if (*content) {
         fprintf(usrdecfile,"TRUE ('%s'H)\n", foo);
      } else {
         fprintf(usrdecfile,"FALSE ('%s'H)\n", foo);
      }                   /* endif */
      break;
    case DDM0_Req5_SEQUENCE_cmd3_BOOLEAN:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd3_BOOLEAN\n");
      break;
    case DDM0_Req5_SEQUENCE_cmd4_NULL:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd4_NULL\n");
      break;
    case DDM0_Req5_SEQUENCE_cmd7_BOOLEAN:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd7_BOOLEAN\n");
      GDShex2str(foo, 300, content, contlen);
      if (*content) {
         fprintf(usrdecfile,"TRUE ('%s'H)\n", foo);
      } else {
         fprintf(usrdecfile,"FALSE ('%s'H)\n", foo);
      }                   /* endif */
      break;
    case DDM0_Req5_SEQUENCE_cmd8_NULL:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd8_NULL\n");
      break;
    case DDM0_Req5_SEQUENCE_cmd9_BOOLEAN:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd9_BOOLEAN\n");
      GDShex2str(foo, 300, content, contlen);
      if (*content) {
         fprintf(usrdecfile,"TRUE ('%s'H)\n", foo);
      } else {
         fprintf(usrdecfile,"FALSE ('%s'H)\n", foo);
      }                   /* endif */
      break;
    case DDM0_Req5_SEQUENCE_cmd10_NULL:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd10_NULL\n");
      break;
    case DDM0_Req5_SEQUENCE_cmd11_BOOLEAN:
      fprintf(usrdecfile,"DDM0_Req5_SEQUENCE_cmd11_BOOLEAN\n");
      GDShex2str(foo, 300, content, contlen);
      if (*content) {
         fprintf(usrdecfile,"TRUE ('%s'H)\n", foo);
      } else {
         fprintf(usrdecfile,"FALSE ('%s'H)\n", foo);
      }                   /* endif */
      break;
    case DDM0_Req6_SET_cmd1_SEQUENCE_cmd1_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req6_SET_cmd1_SEQUENCE_cmd1_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req6_SET_cmd1_SEQUENCE_cmd2_CharacterString:
      fprintf(usrdecfile,"DDM0_Req6_SET_cmd1_SEQUENCE_cmd2_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req7_SEQUENCE_cmd1_CharacterString:
      fprintf(usrdecfile,"DDM0_Req7_SEQUENCE_cmd1_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req7_SEQUENCE_cmd2_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req7_SEQUENCE_cmd2_OCTET_STRING\n");
      break;
    case DDM0_Req7_SEQUENCE_cmd3_SEQUENCE_cmd1_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req7_SEQUENCE_cmd3_SEQUENCE_cmd1_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req7_SEQUENCE_cmd3_SEQUENCE_cmd2_CharacterString:
      fprintf(usrdecfile,"DDM0_Req7_SEQUENCE_cmd3_SEQUENCE_cmd2_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req8_CHOICE_cmd1_CharacterString:
      fprintf(usrdecfile,"DDM0_Req8_CHOICE_cmd1_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req8_CHOICE_cmd2_NULL:
      fprintf(usrdecfile,"DDM0_Req8_CHOICE_cmd2_NULL\n");
      break;
    case DDM1_Req9_SEQUENCE_cmd1_CharacterString:
      fprintf(usrdecfile,"DDM1_Req9_SEQUENCE_cmd1_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM1_Req9_SEQUENCE_cmd2_OCTET_STRING:
      fprintf(usrdecfile,"DDM1_Req9_SEQUENCE_cmd2_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req11_SEQUENCE_cmd1_CharacterString:
      fprintf(usrdecfile,"DDM0_Req11_SEQUENCE_cmd1_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      break;
    case DDM0_Req11_SEQUENCE_cmd2_OCTET_STRING:
      fprintf(usrdecfile,"DDM0_Req11_SEQUENCE_cmd2_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      break;
    case DDM0_Req_SEQUENCE_cmd2_CharacterString: {
      static char pass = 0;

      if (!pass)
        fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd2_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      pass++;
      break;
      }
    case DDM0_Req_SEQUENCE_cmd3_CharacterString: {
      static char pass = 0;

      if (!pass)
        fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd3_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      pass++;
      break;
      }
    case DDM0_Req_SEQUENCE_cmd4_CharacterString: {
      static char pass = 0;

      if (!pass)
        fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd4_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      pass++;
      break;
      }
    case DDM0_Req_SEQUENCE_cmd5_CharacterString: {
      static char pass = 0;

      if (!pass)
        fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd5_CharacterString\n");
      strncpy(foo, content, contlen);
      foo[contlen] = '\0';
      fprintf(usrdecfile,"\"%s\" ", foo);
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"(\'%s\'H)\n", foo);
      pass++;
      break;
      }
    case DDM0_Req_SEQUENCE_cmd6_OCTET_STRING: {
      static char pass = 0;

      if (!pass)
        fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd6_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      pass++;
      break;
      }
    case DDM0_Req_SEQUENCE_cmd7_OCTET_STRING: {
      static char pass = 0;

      if (!pass)
        fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd7_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      pass++;
      break;
      }
    case DDM0_Req_SEQUENCE_cmd8_OCTET_STRING: {
      static char pass = 0;

      if (!pass)
      fprintf(usrdecfile,"DDM0_Req_SEQUENCE_cmd8_OCTET_STRING\n");
      GDShex2str(foo, 300, content, contlen);
      fprintf(usrdecfile,"'%s'H\n", foo);
      pass++;
      break;
      }
    default:
     break;
    } /* endswitch */
  } /* endif */
  return 0;
}

static char *
mallocate(unsigned n)
{
   register char  *block = NULL;

   block = calloc(n, 1);
   return (block);
}
