/*** $PROLOG(C,INCLUDE) **********************************************/
/*                                                                   */
/*  INCLUDE NAME : GDSTYPES                                          */
/*                                                                   */
/*  DESCRIPTIVE NAME : GDSED types                                   */
/*                                                                   */
/*  STATUS :                                                         */
/*                                                                   */
/*    RELEASE : 1.0.0                                                */
/*    MODIFICATION : 0                                               */
/*    DATE : 930930                                                  */
/*                                                                   */
/*  DESCRIPTION :  GDSED types declarations. This must be included   */
/*                 by User Application Program.                      */
/*                                                                   */
/*  MODULE TYPE : INCLUDE FILE                                       */
/*                                                                   */
/*      SIZE :                                                       */
/*                                                                   */
/*  CHANGE ACTIVITY :                                                */
/*                                                                   */
/*  $INC(GDSTYPES),COMP(GDS),    PROD(GDS)    : MODULE DESCRIPTOR    */
/*                                                                   */
/*  FLAG REASON   RLSE     DATE   ORIGIN  FLAG DESCRIPTOR            */
/*  ---- -------- -------- ------ ------  -------------------------  */
/*  $X0= GDSED    100      930930   RNSL: IMPLICIT FLAG, ORIGINAL    */
/*  $Y1= xxxxxxxx nnn      yymmdd _logo_: _____Description_______    */
/*                                                                   */
/*                                                                   */
/*** $EPROLOG(C,INCLUDE) *********************************************/
/*********************************************************************/
/*  Licensed Materials - Property of IBM                             */
/*                                                                   */
/*  GenE/D version 1.00 - 5648-075                                   */
/*  Copyright (C) International Business Machines Corp., 1993        */
/*  All rights reserved                                              */
/*********************************************************************/

/*********************************************************************
 * The following identifies the ASN.1 base types
 *********************************************************************
 */
enum basetypes {
   bas_unknown,                 /*  0 unknown */
   bas_integer,                 /*  1 integer */
   bas_choice,                  /*  2 choice */
   bas_boolean,                 /*  3 boolean */
   bas_null,                    /*  4 null */
   bas_bitstr,                  /*  5 bit string */
   bas_octstr,                  /*  6 octet string */
   bas_seqenum,                 /*  7 sequence{...} */
   bas_seqof,                   /*  8 sequence of ... */
   bas_setenum,                 /*  9 set{...} */
   bas_setof,                   /* 10 set of ... */
   bas_any,                     /* 11 any */
   bas_objid,                   /* 12 object identifier */
   bas_real,                    /* 13 real */
   bas_enum,                    /* 14 enumerated */
   bas_charstr,                 /* 15 character string type */
   bas_anytbl,                  /* 16 any defined by table */
   bas_expltag                  /* 17 explicit encoded type */
};  /* basetypes */

/************************************************************************
 * Tag classes. The ones beginning with "GDS" are not ASN.1 standard,
 * they can be used if IBM GDS Definition encoding is used.
 ************************************************************************
 */
enum tagclass {
   cont,                        /* CONTEXT SPECIFIC - only BER */
   univ,                        /* UNIVERSAL - BER and GDSD */
   appl,                        /* APPLICATION - only BER */
   priv,                        /* PRIVATE - only BER */
   gdstl,                       /* GDSTL - only GDSD */
   gdslt,                       /* GDSLT - only GDSD */
   gdssegiss,                   /* GDSSEGISS - only GDSD */
   gdssegll,                    /* GDSSEGLL - only GDSD */
   gdslen,                      /* GDSLENGTH - only GDSD */
   gdsuniq,                     /* GDSUNIQUE - only GDSD */
   gdsflen,                     /* GDSFLEN - only GDSD */
   gdsuntil,                    /* GDSOccursUntilLKAHD - only GDSD */
   gdswhen,                     /* GDSOccursWhenLKAHD - only GDSD */
   gdswhile,                    /* GDSOccursWhileLKAHD - only GDSD */
   gdsunkn,                     /* GDSUNKNLT - only GDSD */
   noclass                      /* class not specified, error situations */
};   /* tagclass */


/************************************************************************
 * Type of encoding. Used by GDSencode routine, in order to do correctly
 * some encoding decision, and by GDSprintgds routine in order to print
 * correctly the GDS structure tree.
 ************************************************************************
 */
enum TypOfEnc {
   ber,                         /* Basic Encoding Rules */
   gdsd,                        /* IBM General Data Stream Definitions */
   none                         /* the lengths are not calculated by encode,
                                 * useful if other encoding rules are used */
};

/************************************************************************
 * Storage class: dynamic or static
 ************************************************************************
 */
enum stg {
   stat,                        /* static - not subject to reclaimation */
   allocd                       /* allocated - subject to reclaimation */
};

/************************************************************************
 * Status of GDS, used during BER decoding of SET type
 ************************************************************************
 */
enum setstat {                  /* set element status */
   matched,                     /* GDS is matched in the set element */
   unmatched                    /* GDS is unmatched */
};

/************************************************************************
 * Form of type: primitive or constructor
 ************************************************************************
 */
enum frm {
   prim,                        /* primitive form */
   constr                       /* constructor form */
};

/************************************************************************
 * Last piece of data indicator, used if the content data is passed
 * using an user exit.
 ************************************************************************
 */
enum lastflag {
   NO,                          /* this is not last piece of data */
   YES                          /* this is last piece of data */
};

/************************************************************************
 * User exit for passing the content data
 ************************************************************************
 */
#define usr_cont_exit\
 int (*usrcontent) (char **buff, unsigned long *buflen, enum lastflag *lastf)

/************************************************************************
 * Segment structure, used in case of IBM GDSD segmentation
 ************************************************************************
 */
struct segment {
  unsigned long   seg_len;      /* length of the segment */
  char           *seg_content;  /* segment content data */
  struct segment *next_seg;     /* pointer to the next segment.
                                 * NULL if it is the last */
};

/************************************************************************
 * GDS structure
 ************************************************************************
 */
struct gds {
   enum tagclass   cls;         /* class */
   unsigned long   id;          /* identifier number */
   enum frm        form;        /* primitive or constructed */
   long            loc;         /* length of CONTENTS field */
   long            log;         /* length of GDS */
   int             basetype;    /* base type of GDS */
   char           *modname;     /* module name pointer */
   char           *name;        /* type/value name pointer */
   char           *sop;         /* address of start of GDS */
   char           *contents;    /* address of contents */
   struct gds     *next;        /* sibling ptr */
   struct gds     *contains;    /* contained GDSs */
   struct gds     *parent;      /* parent (containing) GDS */
   enum stg        gdsstg;      /* storage class for GDS structure */
   enum stg        contstg;     /* storage class for GDS contents
                                   field */
   enum setstat    sstat;       /* set element matching status */
   unsigned long   id_seg_len;  /* the maximum length of the segment
                                 * or the IDENTIFIER length */
   usr_cont_exit;               /* the pointer to the user exit called by */
                                /* GDSencgdsd and GDSencber routines to get */
                                /* the data that must be encoded. It could be */
                                /* used in case of GDSD segmentation */
   struct segment *seg_list;    /* pointer to a list of segments. It is set
                                 * by GDSdecgdsd function if decoding user-exit
                                 * is not used and content data are segmentated
                                 */
};

/************************************************************************
 * The following are structures to pass during the GDS tree walking
 * process for encoding.
 ************************************************************************
 */
struct encinh {                 /* inherited attributes */
   struct ietag   *it;          /* points to the structure containing
                                 * the information of implicit tagging if
                                 * the type is implicit tagged */
   char           *symname;     /* name of the current item to encode */
   char           *modname;     /* current module name */
   void           *module_ptr;  /* module for type to encode */
   void           *usrparms;    /* user parms */
   char            opt;         /* TRUE if item is optional or defaulted,
                                   FALSE if mandatory */
};

struct encinhsyn {              /* inherited and synthesized attributes */
   struct gds     *p;           /* the GDS structure allocated fo the type */
   unsigned short ndx;          /* Metatable index of the type encoded */
   enum basetypes base;         /* base type of GDS */
   long   ssof_items_num;       /* num of items inside a SET OF or SEQ OF */
};

/************************************************************************
 * This indicates if LLIDFISS segmentation is used. The UAP can decide,
 * calling GDSencgdsd function, if it wants to use LLIDFISS segmention
 * or not.
 ************************************************************************
 */
typedef enum {
    nouse,                      /* segmentation is not used */
    use                         /* the LLIDFISS segmentation is used */
} useLLIDFISS;


/************************************************************************
 * Used by GDSdecgdsd function to return to the UAP information
 * about decoding errors.
 ************************************************************************
 */
struct errdata {
  void *err_item;               /* item in error */
  int   err_item_len;           /* length of item in error */
};

/************************************************************************
 * Contents structures, used by UAP to pass content data to GDSencode
 * function instead of encoding user-exit mechanism.
 ************************************************************************
 */
 struct contents_str {
   char *content;               /* content data */
   usr_cont_exit;               /* content user exit */
   struct content_str *contlist; /* list of contents, used for SET OF and
                                  * SEQUENCE OF */
   enum stg contstg;            /* storage class */
   long                len;     /* content length (number of bytes), or
                                 * number of contents in contlist */
 };

 struct content_str {
   char *content;               /* content data */
   usr_cont_exit;               /* content user exit */
   enum stg contstg;            /* storage class */
   long                len;     /* content length (number of bytes) */
 };

