/*** $PROLOG(C,INCLUDE) **********************************************/
/*                                                                   */
/*  INCLUDE NAME : GDSTYPEC                                          */
/*                                                                   */
/*  DESCRIPTIVE NAME : GDSED types                                   */
/*                                                                   */
/*  STATUS :                                                         */
/*                                                                   */
/*    RELEASE : 1.0.0                                                */
/*    MODIFICATION : 0                                               */
/*    DATE : 930930                                                  */
/*                                                                   */
/*  DESCRIPTION :  GDSED types declarations. This must be included   */
/*                 by User Application Program if the .C file is used*/
/*                 instead of the .DAT file.                         */
/*                                                                   */
/*  MODULE TYPE : INCLUDE FILE                                       */
/*                                                                   */
/*      SIZE :                                                       */
/*                                                                   */
/*  CHANGE ACTIVITY :                                                */
/*                                                                   */
/*  $INC(GDSTYPEC),COMP(GDS),    PROD(GDS)    : MODULE DESCRIPTOR    */
/*                                                                   */
/*  FLAG REASON   RLSE     DATE   ORIGIN  FLAG DESCRIPTOR            */
/*  ---- -------- -------- ------ ------  -------------------------  */
/*  $X0= GDSED    100      930930   RNSL: IMPLICIT FLAG, ORIGINAL    */
/*  $Y1= xxxxxxxx nnn      yymmdd _logo_: _____Description_______    */
/*                                                                   */
/*                                                                   */
/*** $EPROLOG(C,INCLUDE) *********************************************/
/*********************************************************************/
/*  Licensed Materials - Property of IBM                             */
/*                                                                   */
/*  GenE/D version 1.00 - 5648-075                                   */
/*  Copyright (C) International Business Machines Corp., 1993        */
/*  All rights reserved                                              */
/*********************************************************************/


/*************************************************************************
 * The following types declarations are needed if the .C file is used,
 * instead of .DAT file.
 *************************************************************************
 */

/**********************************************************************
 * Metatable and Symbol Table index
 **********************************************************************
 */
typedef unsigned short symdex;  /* symbol table index */

typedef unsigned short tbldex;  /* metatable index */

/**********************************************************************
 * Metatoken
 **********************************************************************
 */
typedef unsigned char mtok;     /* type for a single metatable token */

/**********************************************************************
 * Type of tagging
 **********************************************************************
 */
enum tagging {
   implicit, explicit
};

/**********************************************************************
 * Imported Symbol
 **********************************************************************
 */
struct berimp {                 /* imported symbol */
   symdex          modname;     /* index of module name in the */
                                /* symbol table */
   symdex          symname;     /* index of symbol name in the */
                                /* symbol table */
   struct moddef  *module;      /* addr of resolved module defn */
   tbldex          def;         /* index of resolved defn of symbol */
};

/**********************************************************************
 * Exported Symbol
 **********************************************************************
 */
struct berexp {                 /* exported symbol */
   symdex          symname;     /* index of symbol in symbol table */
   tbldex          symdef;      /* index of symbol defn in metatable */
};

/**********************************************************************
 * Module Structure
 **********************************************************************
 */
struct moddef {
   char           *name;        /* address of module name in the */
                                /* symbol table */
   char           *oid;         /* module object identifier */
   char           *symtab;      /* symbols for module */
   enum tagging    tagdefault;  /* implicit or explicit tagging */
                                /* default */
   mtok           *toks;        /* metatable for module */
   unsigned short  size;        /* metatable size */
   int             numtypvals;  /* number of type defns */
   tbldex         *typvals;     /* addr of array of references to */
                                /* type definitions */
   int             numimps;     /* number of imported symbols */
   struct berimp  *imps;        /* addr of array of imported symbols */
   int             numexps;     /* number of exported symbols */
   struct berexp  *exps;        /* addr of array of exported symbols */
   struct moddef  *next;        /* next module */
};
