/*** $PROLOG(C,INCLUDE) **********************************************/
/*                                                                   */
/*  INCLUDE NAME : GDSRCODS                                          */
/*                                                                   */
/*  DESCRIPTIVE NAME : return codes                                  */
/*                                                                   */
/*  STATUS :                                                         */
/*                                                                   */
/*    RELEASE : 1.0.0                                                */
/*    MODIFICATION : 0                                               */
/*    DATE : 930930                                                  */
/*                                                                   */
/*  DESCRIPTION :  return codes of functions of GDSEDLIB library     */
/*                                                                   */
/*  MODULE TYPE : INCLUDE FILE                                       */
/*                                                                   */
/*      SIZE :                                                       */
/*                                                                   */
/*  CHANGE ACTIVITY :                                                */
/*                                                                   */
/*  $INC(GDSRCODS),COMP(GDS),    PROD(GDS)    : MODULE DESCRIPTOR    */
/*                                                                   */
/*  FLAG REASON   RLSE     DATE   ORIGIN  FLAG DESCRIPTOR            */
/*  ---- -------- -------- ------ ------  -------------------------  */
/*  $X0= GDSED    100      930930   RNSL: IMPLICIT FLAG, ORIGINAL    */
/*  $Y1= xxxxxxxx nnn      yymmdd _logo_: _____Description_______    */
/*                                                                   */
/*                                                                   */
/*** $EPROLOG(C,INCLUDE) *********************************************/
/*********************************************************************/
/*  Licensed Materials - Property of IBM                             */
/*                                                                   */
/*  GenE/D version 1.00 - 5648-075                                   */
/*  Copyright (C) International Business Machines Corp., 1993        */
/*  All rights reserved                                              */
/*********************************************************************/

/* return codes from GDSaddmodule */
#define ADDMODULE_DUP_MODULE -1
#define ADDMODULE_OK 0

/* return codes from GDSallocateContentsArray */
#define ALLOCATECONT_OK 0
#define ALLOCATECONT_NO_ENOUGH_STORAGE -1
#define ALLOCATECONT_INVALID_MODULE -2

/* return codes from GDSallocateContListArray */
#define ALLOCATECONTLIST_OK 0
#define ALLOCATECONTLIST_NO_ENOUGH_STORAGE -1

/* return codes from GDSallocateGdsTreeArray */
#define ALLOCATEGDSTREE_OK 0
#define ALLOCATEGDSTREE_NO_ENOUGH_STORAGE -1
#define ALLOCATEGDSTREE_INVALID_MODULE -2

/* return codes from GDSbasetype */
#define BASETYPE_OK 0
#define BASETYPE_WRONG_TOKEN 1
#define BASETYPE_UNRESOLVED_EXTERN_REF 2

/* return codes from GDSdecber */
#define DECBER_OK 0
#define DECBER_SYNTAX_ERROR -1
#define DECBER_NO_ENOUGH_STORAGE -2
#define DECBER_BUFFER_EMPTY -3
#define DECBER_BUFFER_TOO_SMALL -4

/* return codes from GDSdecgdsd */
#define DECGDSD_NO_MATCH 1
#define DECGDSD_MATCH 0
#define DECGDSD_SYNTAX_ERROR -1
#define DECGDSD_INTERNAL_ERROR -2
#define DECGDSD_UNRESOLVED_REFERENCE -3
#define DECGDSD_BUFFER_EMPTY -4
#define DECGDSD_INVALID_ID -5
#define DECGDSD_INVALID_UNIQUE_ITEM -6
#define DECGDSD_INVALID_LENGTH -7
#define DECGDSD_NO_ENOUGH_STORAGE -8
#define DECGDSD_INVALID_SEG_ID_PREFIX -9
#define DECGDSD_INVALID_SEG_SEQ_NUM -10
#define DECGDSD_INVALID_SEG_IDF_PREFIX -11
#define DECGDSD_LAST_SEG_BEFORE_EOD -12
#define DECGDSD_MISSING_MANDATORY_ELEMENT -13
#define DECGDSD_BUFFER_TOO_SMALL -14
#define DECGDSD_USR_DEC_FUN_FAILED -15
#define DECGDSD_SUBTYPE_CONSTRNTS_NO_MATCH -16

/* return codes from GDSdecode */
#define DECODE_MATCH 0
#define DECODE_NO_MATCH 1
#define DECODE_SYNTAX_ERROR -1
#define DECODE_INTERNAL_ERROR -2
#define DECODE_UNRESOLVED_REFERENCE -3
#define DECODE_USR_DEC_FUN_FAILED -4
#define DECODE_SUBTYPE_CONSTRNTS_NO_MATCH -5

/* return codes from GDSencber */
#define ENCBER_OK 0
#define ENCBER_NO_ENOUGH_STORAGE -1
#define ENCBER_GDSUSRWRT_FAILED -2
#define ENCBER_USER_EXIT_FAILED -3
#define ENCBER_PRIM_TYPE_CONTENT_MISSING -4
#define ENCBER_INTERNAL_ERROR -5
#define ENCBER_UNDEFLEN_NOT_PERMITTED -6
#define ENCBER_BUFFER_TOO_SMALL -7

/* return codes from GDSencgdsd */
#define ENCGDSD_OK 0
#define ENCGDSD_INTERNAL_ERROR -1
#define ENCGDSD_BUFFER_TOO_SMALL -2
#define ENCGDSD_GDSUSRWRT_FAILED -3
#define ENCGDSD_INVALID_CLASS -4
#define ENCGDSD_INVALID_FIXED_ITEM_LENGTH -5
#define ENCGDSD_NO_ENOUGH_STORAGE -6
#define ENCGDSD_INVALID_LENGTH -7
#define ENCGDSD_INVALID_LL_LENGTH -8
#define ENCGDSD_UNDEFLEN_NOT_PERMITTED -9
#define ENCGDSD_SEGMENT_TOO_SHORT -10
#define ENCGDSD_PRIM_TYPE_CONTENT_MISSING -11
#define ENCGDSD_USER_EXIT_FAILED -12
#define ENCGDSD_NESTED_SEGMENT -13

/* return codes from GDSencode */
#define ENCODE_MATCH 0
#define ENCODE_NO_MATCH 1
#define ENCODE_SYNTAX_ERROR -1
#define ENCODE_INTERNAL_ERROR -2
#define ENCODE_UNRESOLVED_REFERENCE -3
#define ENCODE_INVALID_GDSD_FIXED_LENGTH -4
#define ENCODE_INVALID_ENCODING_TYPE -5
#define ENCODE_UNDEFLENGTH_NOT_PERMITTED -6
#define ENCODE_INVALID_LL_LENGTH -7
#define ENCODE_INVALID_LENGTH -8
#define ENCODE_INVALID_UNIQUE_ITEM_LENGTH -9
#define ENCODE_INVALID_SEGMENT_LENGTH -10
#define ENCODE_INVALID_NUMBER_OF_SSOF_ITEMS -11
#define ENCODE_DEFAULT_FUNCTION -12
#define ENCODE_MISSING_MANDATORY_ELEMENT -13
#define ENCODE_NO_ENOUGH_STORAGE -14
#define ENCODE_USER_EXIT_FAILED -15

/* return codes from GDSfindtbl */
#define FIND_TABLE_FAIL -1
#define FIND_TABLE_OK 0

/* return codes from GDSfindtype */
#define FIND_TYPE_FAIL -1
#define FIND_TYPE_OK 0

/* return codes from GDSfindval */
#define FIND_VALUE_FAIL -1
#define FIND_VALUE_OK 0

/* return codes from GDSfirstmodule */
#define FIRST_MOD_OK 0
#define FIRST_MOD_FAIL -5

/* return codes from GDSinitEnvironment */
#define INIT_ENV_OK 0
#define INIT_ENV_FAILED -1

/* return codes from GDSINTEGERtolong */
#define INTG2LNG_ERROR -1
#define INTG2LNG_OK    0

/* return codes from GDSlongs2OID */
#define LNGS2OID_OK 0
#define LNGS2OID_ERROR -1

/* return codes from GDSlongtoINTEGER */
#define LONG2INTEGER_OK 0

/* return codes from GDSnewgds */
#define NEWGDS_OK 0
#define NEWGDS_NO_ENOUGH_STORAGE -1

/* return codes from GDSOIDtolngs */
#define OID2LNGS_ERROR -1
#define OID2LNGS_OK 0

/* return codes from GDSprintgds */
#define PRINT_GDS_OK 0
#define PRINT_GDS_ERROR -1
#define PRINT_GDS_NO_ENOUGH_STORAGE -2

/* return codes from GDSPrintUresolvedImports */
#define PRTUNRES_BAD_FILE -1
#define PRTUNRES_OK 0

/* return codes from GDSreaddatfile */
#define READ_DAT_OK 0
#define READ_DAT_OPEN -3
#define READ_DAT_VERSION -4

/* return codes from GDSresolveimports */
#define RESOLVE_IMPORTS_OK 0
#define UNRESOLVED_REFERENCE -2

/* return codes from GDSunloadmodule */
#define UNLOAD_MOD_OK 0
#define UNLOAD_MOD_NOT_FOUND -6
