/*** $PROLOG(C,INCLUDE) **********************************************/
/*                                                                   */
/*  INCLUDE NAME : GDSPROTO                                          */
/*                                                                   */
/*  DESCRIPTIVE NAME : GDSED library functions prototypes            */
/*                                                                   */
/*  STATUS :                                                         */
/*                                                                   */
/*    RELEASE : 1.0.0                                                */
/*    MODIFICATION : 0                                               */
/*    DATE : 930930                                                  */
/*                                                                   */
/*  DESCRIPTION :  prototypes of the functions of the GDSED runtime  */
/*                 library                                           */
/*                                                                   */
/*  MODULE TYPE : INCLUDE FILE                                       */
/*                                                                   */
/*      SIZE :                                                       */
/*                                                                   */
/*  CHANGE ACTIVITY :                                                */
/*                                                                   */
/*  $INC(GDSPROTO),COMP(GDS),    PROD(GDS)    : MODULE DESCRIPTOR    */
/*                                                                   */
/*  FLAG REASON   RLSE     DATE   ORIGIN  FLAG DESCRIPTOR            */
/*  ---- -------- -------- ------ ------  -------------------------  */
/*  $X0= GDSED    100      930930   RNSL: IMPLICIT FLAG, ORIGINAL    */
/*  $Y1= xxxxxxxx nnn      yymmdd _logo_: _____Description_______    */
/*                                                                   */
/*                                                                   */
/*** $EPROLOG(C,INCLUDE) *********************************************/
/*********************************************************************/
/*  Licensed Materials - Property of IBM                             */
/*                                                                   */
/*  GenE/D version 1.00 - 5648-075                                   */
/*  Copyright (C) International Business Machines Corp., 1993        */
/*  All rights reserved                                              */
/*********************************************************************/

extern int
GDSaddmodule(void *module_ptr,    /* pointer to the current module */
             void *environmnt);   /* environment pointer */

extern int
GDSallocateContentsArray(void *module_ptr,   /* pointer to the current module */
                struct contents_str **cont); /* pointer to contents array */


extern int
GDSallocateContListArray(long numitems,     /* number of items */
                struct content_str **cont); /* array of allocated structures */


extern int
GDSallocateGdsTreeArray(void *module_ptr,   /* pointer to the current module */
                     struct gds ***gdsptr); /* array of pointers inside the GDS
                                             * structure tree */

extern int
GDSbasetype(void **module_ptr,    /* pointer to the current module */
            unsigned short *t,    /* metatable index */
            enum basetypes *bt);  /* base type */

extern int
GDSdecber(struct gds **p,            /* pointer to GDS structure tree */
          unsigned long buflen,      /* input buffer length */
          unsigned long *bytesnum,   /* number of decoded bytes */
          char **alldata,            /* input: flag indicating if the input
                                      *        buffer contains all the data
                                      * output: pointer to the input buffer if
                                      *         alldata is 1 */
          void *environmnt,          /* environment pointer */
          void *usrparms);           /* user parms for reading user-exit */

extern int
GDSdecgdsd(struct gds **p,           /* pointer to GDS structure tree */
           unsigned long buflen,     /* input buffer length */
           unsigned long *bytesnum,  /* number of decoded bytes */
           void *module_ptr,         /* pointer to the current module */
           unsigned short *metandx,  /* metatable index */
           struct gds **gdsptr,      /* array of pointers inside the GDS
                                      * structure tree */
           struct errdata *err_data, /* error information */
           void *environmnt,         /* environment pointer */
           void *decusrparms,        /* user parameters for dec user-exit */
           void *usrparms);          /* user parms for reading user-exit */

extern int
GDSdecode(void *module_ptr,        /* pointer to the current module */
          unsigned short *t,       /* metatable index */
          struct gds **p,          /* pointer to the GDS structure tree */
          struct gds **gds_ptr,    /* array of pointers inside the GDS
                                    * structure tree */
          void *environmnt,        /* environment pointer */
          void *usrparms);         /* user parameters */

extern int
GDSencber(struct gds **p,             /* pointer to GDS structure tree */
          unsigned long buflen,       /* output buffer length */
          unsigned char **out_buffer, /* output buffer pointer */
          unsigned long *bytesnum,    /* number of encoded bytes */
          int indef_length,           /* definite or indefinite length form */
          void *environmnt,           /* environment pointer */
          void *usrparms);            /* user parms for writing user-exit */

extern int
GDSencgdsd(struct gds **p,            /* pointer to GDS structure tree */
           unsigned long buflen,      /* output buffer length */
           unsigned long *bytesnum,   /* number of encoded bytes */
           useLLIDFISS useseg,        /* flag indicating if LLIDFISS
                                       * segmentation is used or not */
           void *environmnt,          /* environment pointer */
           void *usrparms);           /* user parms for writing user-exit */

extern int
GDSencode(void *module_ptr,    /* pointer to current module */
          unsigned short *t,   /* metatable index of type */
          struct contents_str
             *cont_array_ptr,  /* pointer to contents array */
          struct gds **p,      /* pointer to GDS structure tree */
          enum TypOfEnc tenc,  /* type of encoding: BER or GDSD */
          void *environmnt,    /* environment pointer */
          void *usrparms);     /* user parameters, passed to enc user-exit */

extern void *
GDSfindmodule(const char *mname,  /* module name */
              void *environmnt);  /* environment pointer */

extern int
GDSfindtbl(const void *module_ptr,  /* pointer to current module */
           const char *symname,     /* table name */
           unsigned short *fdex);   /* metatable index of table */

extern int
GDSfindtype(const void *module_ptr, /* pointer to current module */
            const char *symname,    /* type name */
            unsigned short *fdex);  /* metatable index of type */

extern int
GDSfindval(const void *module_ptr,  /* pointer to current module */
           const char *symname,     /* value name */
           unsigned short *fdex);   /* metatable index of value */

extern int
GDSfirstmodule(void **module_ptr,   /* pointer to current module */
               char **modname,      /* module name */
               void *environmnt);   /* environment pointer */

extern void
GDSfreeContentsArray(void *module_ptr,           /* pointer to current module */
                     struct contents_str *cont); /* pointer to contents array */

extern void
GDSfreeEnvironment(void *environmnt);   /* environment pointer */

extern void
GDSfreegds(struct gds * p,              /* pointer to GDS structure tree */
           void *environmnt);           /* environment pointer */

extern void
GDSfreeGdsTreeArray(struct gds **gdsptr);   /* array of pointers inside the GDS
                                             * structure tree */

extern void
GDShex2str(char *outbuf,
           long outlen,
           char *inbuf,
           long inlen);

extern
int GDSinitEnvironment(void **environmnt);

extern
int GDSINTEGERtolong(char *buf,
                     long loc,
                     long *l);

extern int
GDSlngs2OID(long a[],
            unsigned char *buf,
            int buflen,
            int *loc,
            int compress);

extern int
GDSlongtoINTEGER(long l,
                 unsigned char *buf,
                 long *loc);

extern int
GDSnewgds(struct gds **gds,
          char *modname,
          char *symname,
          struct ietag * it,
          enum tagclass cls,
          unsigned long id,
          enum frm form,
          char *contents,
          long loc,
          enum stg contstg,
          int (*usrcontent) (char **, unsigned long *, enum lastflag *),
          void *environmnt);

extern int
GDSOIDtolngs(char *buf,
             int loc,
             long *a,
             int asize);

extern int
GDSprintgds(struct gds * p,
            int indentcol,
            long maxcontlen,
            long rowlen,
            FILE *tracefile,
            enum TypOfEnc tenc);

extern int
GDSPrintUnresolvedImports(FILE *outfile,
                          void *environmnt);

extern int
GDSreaddatfile(char *fn,
               void *environmnt);

extern int
GDSresolveallimports(void *environmnt);

extern int
GDSresolveimports(void *module_ptr,
                  void *environmnt);

extern void
GDSsetUsrDec(int (*gdsusdec) (unsigned short ndx, struct gds *p,
                              char *content, unsigned long contlen,
                              void *usrparms),
             void *environmnt);

extern void
GDSsetUsrEnc(int (*gdsusenc) (struct encinh ia,
                              struct encinhsyn *sa,
                              enum tagclass cls, long id, enum frm form,
                              char *encsubs),
             void *environmnt);

extern void
GDSsetUsrRead(unsigned long (*usrred) (char *buff, unsigned long buflen,
                                       void *usrparms),
              void *environmnt);

extern void
GDSsetUsrWrite(unsigned long (*usrwrt) (char *buff, unsigned long buflen,
                                        void *usrparms),
               void *environmnt);

extern void
GDSstr2hex(char *outbuf, long outlen, char *inbuf, long inlen);

extern
char *GDStypestr(enum basetypes base);

extern int
GDSunloadmodule(void *module_ptr,
                void *environmnt);
