/*
** Module   :VARPOOL.CPP
** Abstract :
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  29/09/1999 Created
**
*/

#include <varpool.h>
#include <string.h>

char *str_dup(char*, int = -1);

//VarPoolItem implementation

VarPoolItem::VarPoolItem(char * pName, char *pValue)
{
    cName  = str_dup(pName);
    cValue = str_dup(pValue);
};

VarPoolItem::~VarPoolItem()
{
    delete cName;
    delete cValue;
}

void VarPoolItem::set(char * pValue)
{
    delete cValue;
    cValue = str_dup(pValue);
}

//VarPool implementation

int VarPool::Compare(Ptr p1, Ptr p2)
{
    return stricmp(((VarPoolItem*)p1)->name(), ((VarPoolItem*)p2)->name());
}

VarPoolItem* VarPool::LocateVar(char *name, int iCreate)
{
    VarPoolItem i = name;

    unsigned dPos = Look(&i);

    if(dPos < Count() && !Compare(&i, Get(dPos)))
        return (VarPoolItem*) Get(dPos);

    if(iCreate)
    {
        VarPoolItem *p = new VarPoolItem(name);
        Add(p);
        return p;
    }

    return 0;
}

void VarPool::del(char *name)
{
    VarPoolItem i = name;

    unsigned dPos = Look(&i);

    if(dPos < Count() && !Compare(&i, Get(dPos)))
        Free(Remove(dPos));
}

void VarPool::drop(char *namestart)
{
    unsigned len = strlen(namestart);
    unsigned dPos;
    {
        VarPoolItem i = namestart;
        dPos = Look(&i);
    }

    while(dPos < Count() &&
          !strnicmp(namestart, ((VarPoolItem *)Get(dPos))->name(), len))
    {
        Free(Remove(dPos));
    }
}

void VarPool::set(char *name, char *value)
{
    VarPoolItem* pItem = LocateVar(name, 1);

    if(pItem)
        pItem->set(value);
}

char* VarPool::get(char *name)
{
    VarPoolItem* pItem = LocateVar(name, 0);

    if(pItem)
        return pItem->get();
    return 0;
}

VarPool::VarPool():SortedCollection()
{
    bDuplicates = 0;
}

VarPool::~VarPool()
{
    RemoveAll();
}

