/*
** Module   :STDDLG.CPP
** Abstract :Standard dialogs
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  12/11/1997   	Derived from DIALOG.CPP
*/

#include <string.h>

#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <stddlg.h>
#include <keynames.h>
#include <version.h>

extern EditBoxCollection Editor;

//----------------------------------------------------------------------
//
//----------------------------------------------------------------------

int AChoice(int r, int c, char **itemlist, char* Hdr)
{
    Dialog dlg(r, c, 1, 1);
    Menu* menu = new Menu(1, 1, itemlist);
    dlg.Ins(menu);
    dlg.rows = menu->rows+2;
    dlg.cols = menu->cols+2;

    if(Hdr)
        dlg.Ins(new StaticText(0, 1, 1, dlg.cols - 2, Hdr));

    KeyInfo k;
    do
    {
        dlg.draw();
        vio_read_key(&k);

        if((k.skey & 0x00FF) == kbEnter || (k.skey & 0x00FF) == kbGrEnter)
            return menu->first_selected();

        dlg.do_key(k);

        if(menu->selected_by_key())
            return menu->first_selected();
    }
    while(k.skey != (kbEsc | shIsCtrl));
    return -1;
}

//----------------------------------------------------------------------
//
//----------------------------------------------------------------------

int SearchReplace(int r, int c, char *searchstr, char *replacestr, char* flags)
{
    int _rows = 7;
    int _cols = 68;

    if(_rows + r >= Rows)
        _rows = Rows - r - 2;

    if(_cols - c >= Cols)
        _cols = Cols - c - 2;

    Dialog dlg(r, c, _rows, _cols);

    dlg.Ins(new StaticText(1,1,1, 7,"Search  "));
    dlg.Ins(new StaticText(2,1,1, 7,"Replace "));
    dlg.Ins(new StaticText(3,1,1,66,"~R~eplace ~B~ackward ~G~lobal ~I~gnore ~N~o-ask r~E~gexp"));
    EditLine* lsearch  = new EditLine(1,  9, 1, 58);
    EditLine* lreplace = new EditLine(2,  9, 1, 58);
    EditLine* lflags   = new EditLine(3, 52, 1, 15);

    lsearch ->set_text(searchstr );
    lreplace->set_text(replacestr);
    lflags  ->set_text(flags     );

    dlg.Ins(lsearch );
    dlg.Ins(lreplace);
    dlg.Ins(lflags  );

    KeyInfo k;
    do
    {
        dlg.draw();
        vio_read_key(&k);

        if(((k.skey & 0x00FF) == kbEnter || (k.skey & 0x00FF) == kbGrEnter) &&
           dlg.in_focus() == lflags)
        {
            lsearch ->get_text(searchstr , 1024);
            lreplace->get_text(replacestr, 1024);
            lflags  ->get_text(flags     ,   32);
            return 0;
        }
        dlg.do_key(k);
    }
    while(k.skey != (kbEsc | shIsCtrl));
    return -1;
}

//----------------------------------------------------------------------
//
//----------------------------------------------------------------------

static void FillFileList(ListBox* list, char *mask)
{
    HDIR hdirFindHandle     = HDIR_SYSTEM;
    FILEFINDBUF3 FindBuffer = {0};
    ULONG ulResultBufLen    = sizeof(FILEFINDBUF3);
    ULONG ulFindCount       = 1;
    ULONG ulDriveNum        = 0;
    ULONG ulDriveMap        = 1;
    int i;

    APIRET rc = NO_ERROR;

    list->go_item(0);
    list->RemoveAll();

//--------------------------------
// Fill directory list

    rc = DosFindFirst((PCH)"*",
                      &hdirFindHandle,
                      MUST_HAVE_DIRECTORY,
                      &FindBuffer,
                      ulResultBufLen,
                      &ulFindCount,
                      FIL_STANDARD);

    while(rc == NO_ERROR)
	{
        if(!(  FindBuffer.achName[0]=='.'
          && FindBuffer.achName[1]=='\x00'))
        {
            int pos = list->Count();
            strcpy(cName, "\x10");
            strcat(cName, FindBuffer.achName);
            list->add_at_end(cName);
            list->set_item_key(pos, 1);
        }
        ulFindCount = 1;

        rc = DosFindNext(hdirFindHandle,
                         &FindBuffer,
                         ulResultBufLen,
                         &ulFindCount);

    }

    DosFindClose(hdirFindHandle);

//--------------------------------
// Fill filename list

    ulFindCount    = 1;
    hdirFindHandle = HDIR_SYSTEM;

    rc = DosFindFirst((PCH)mask,
                      &hdirFindHandle,
                      0
                      | FILE_ARCHIVED
                      | FILE_READONLY,
                      &FindBuffer,
                      ulResultBufLen,
                      &ulFindCount,
                      FIL_STANDARD);
    while(rc == NO_ERROR)
	{
        if(!(FindBuffer.attrFile & FILE_DIRECTORY))
        {
            int pos = list->Count();
            strcpy(cName, " ");
            strcat(cName, FindBuffer.achName);
            list->add_at_end(cName);
            list->set_item_key(pos, 0);
        }

        ulFindCount = 1;

        rc = DosFindNext(hdirFindHandle,
                         &FindBuffer,
                         ulResultBufLen,
                         &ulFindCount);

    }

    DosFindClose(hdirFindHandle);

//--------------------------------
// Fill drives list

    rc = DosQueryCurrentDisk(&ulDriveNum, &ulDriveMap);

    for(i = 0; i < 26; i++)
    {
        if(ulDriveMap & (1 << i))
        {
            int pos = list->Count();
            cName[0] = '[';
            cName[1] = char('A' + i);
            cName[2] = ']';
            cName[3] = 0;
            list->add_at_end(cName);
            list->set_item_key(pos, 2);
        }
    }
}

int FileDialog(int r, int c, char *name, int flags)
{
    int _rows = 20;
    int _cols = 60;

    if(_rows + r >= Rows)
        _rows = Rows - r - 2;

    if(_cols - c >= Cols)
        _cols = Cols - c - 2;

    Dialog dlg(r, c, _rows, _cols);

    char *hdr = FileDialogNames[flags & 3];

    ListBox *dir_list = new ListBox(4,
                                    1,
                                    dlg.rows - 5,
                                    dlg.cols - 2,
                                    0
                                    //| ListBox::lbMultiSel
                                    | ListBox::lbCanScroll);

    EditLine* filename  = new EditLine(2,
                                       1,
                                       1,
                                       dlg.cols - 2);

    filename->set_text("*");

    StaticText* stTxt1 = new StaticText(filename->row - 1,
                                        filename->col,
                                        1,
                                        filename->cols,
                                        "File Name");

    StaticText* stTxt2 = new StaticText(dir_list->row - 1,
                                        dir_list->col,
                                        1,
                                        dir_list->cols,
                                        "Directory list");

    StaticText* stTxt3 = new StaticText(0,
                                        (dlg.cols-strlen(hdr)) / 2,
                                        1,
                                        strlen(hdr),
                                        hdr);
    dlg.Ins(stTxt1);
    dlg.Ins(stTxt2);
    dlg.Ins(stTxt3);
    dlg.Ins(filename);
    dlg.Ins(dir_list);

    FillFileList(dir_list, filename->line(0)->str);

    KeyInfo k;
    do
    {
        dlg.draw();
        vio_read_key(&k);

        if((k.skey & 0x00FF) == kbEnter ||
           (k.skey & 0x00FF) == kbGrEnter)
        {
            if(dlg.in_focus() == dir_list)
            {
                switch(dir_list->get_item_key(dir_list->abs_row()))
                {
                    case 1:

    	                //Change directory
                        DosSetCurrentDir((PCH)dir_list->get_item_text(dir_list->abs_row()) + 1);

            	        //Refill directory list

                	    filename->set_text("*");
                    	FillFileList(dir_list, filename->line(0)->str);
	                    continue;

                    case 0:
                        {
                        	char *s = dir_list->get_item_text(dir_list->abs_row())+1;
                        	if(name)
                            	strncpy(name, s, FED_MAXPATH);
                        	return 0;
                        }

                    case 2:

                        //Change current drive
                        {
                            char *dsk_name = (dir_list->get_item_text(dir_list->abs_row()) + 1);
                            DosSetDefaultDisk(*dsk_name - 'A' + 1);
                        }
                        //Refill directory list
                        filename->set_text("*");
                    	FillFileList(dir_list, filename->line(0)->str);
	                    continue;
                }
            }
            if(dlg.in_focus() == filename)
            {
                char *s = filename->line(0)->str;

                while(*s && *s == ' ')
                    s++;

                if(strchr(s, ':'))
                {
                    //Change current drive
                    {
                        char *dsk_name = s;
                        DosSetDefaultDisk((*dsk_name | 0x20) - 'a' + 1);
                    }
                    //Refill directory list
                    filename->set_text("*");
                    FillFileList(dir_list, filename->line(0)->str);
                    continue;
                }

                if(strchr(s, '*') || strchr(s, '?'))
                {
                    //Refresh list
                    FillFileList(dir_list, s);
                }
                else
                {
                    if(name)
                    {
                        strncpy(name, s, FED_MAXPATH);
                        s = name;
                        s += strlen(name);

                        while(s > name)
                        {
                            if(*s == ' ')
                            {
                                *s-- = 0;
                                continue;
                            }
                            if(!*s)
                            {
                                s--;
                                continue;
                            }
                            break;
                        }
                        if(s > name && *name)
                            return 0;
                    }
                    else
                    	return 0;
                }
            }
        }

        dlg.do_key(k);

        if(dlg.in_focus() == dir_list)
        {
            if(dir_list->get_item_key(dir_list->abs_row()) == 0)
            	filename->set_text(dir_list->get_item_text(dir_list->abs_row())+1);
        }
        if(dlg.in_focus() == filename)
        {
            if(!(k.skey & shIsCtrl) ||
                k.skey == (kbBksp | shIsCtrl) ||
                k.skey == (kbDel | shIsCtrl))
            {
                int candidate = -1;
                int candidate_len = 0;
                char *s = filename->line(0)->str;
                int s_len = strlen(s);

                for(int i = 0; i < dir_list->Count(); i++)
                {
                    if(dir_list->get_item_key(i) == 2)
                        break; //skip drive names

                    char * cstr = dir_list->get_item_text(i)+1;

                    int j;

                    for(j = 0; j < s_len; j++)
                    {
                        if(__to_lower(s[j]) != __to_lower(cstr[j]))
                            break;
                    }
                    if(j > candidate_len)
                    {
                        candidate_len = j;
                        candidate     = i;
                    }
                }
                if(candidate >= 0 && candidate != dir_list->abs_row())
                    dir_list->go_item(candidate);
            }
        }
    }
    while(k.skey != (kbEsc | shIsCtrl));
    return -1;
}

//----------------------------------------------------------------------
//
//----------------------------------------------------------------------

#define MK_CLR(clr)     (app_pal[CL_APPLICATION_START+(clr)])

//----------------------------------------------------------------------
//
//----------------------------------------------------------------------

int AskNumber(int r, int c, int *number, char *hdr)
{
    int _rows = 3;
    int _cols = 30;

    if(_rows + r >= Rows)
        _rows = Rows - r - 2;

    if(_cols - c >= Cols)
        _cols = Cols - c - 2;

    Dialog dlg(r, c, _rows, _cols);
    EditLine* in = new EditLine(1,
                                    1,
                                    1,
                                    dlg.cols - 2);
    dlg.Ins(in);

    if(hdr)
        dlg.Ins(new StaticText(0, (dlg.cols - strlen(hdr)) / 2, 1, strlen(hdr), hdr));

    KeyInfo k;
    do
    {
        dlg.draw();
        vio_read_key(&k);
        if((k.skey & 0x00FF) == kbEnter ||
           (k.skey & 0x00FF) == kbGrEnter)
        {
            char *s = in->line(0)->str;

            while(__issp(*s))
                s++;
            if(!*s)
                return -1;
            *number = 0;

            while(__isdd(*s))
            {
                *number *= 10;
                *number += *s - '0';
                s++;
            }

            if(!*number)
                return -1;

            return 0;
        }
        dlg.do_key(k);
    }
    while(k.skey != (kbEsc | shIsCtrl));

    return -1;
}

int AskString(int r, int c, char** res, char *hdr)
{
    int _rows = 3;
    int _cols = 65;

    if(!res)
        return -1;

    if(_rows + r >= Rows)
        _rows = Rows - r - 2;

    if(_cols - c >= Cols)
        _cols = Cols - c - 2;

    if(_rows < 3 || _cols < 65)
        return -1;

    Dialog dlg(r, c, _rows, _cols);

    EditLine* in = new EditLine(1, 1, 1, dlg.cols - 2);
    dlg.Ins(in);

    if(hdr)
        dlg.Ins(new StaticText(0, (dlg.cols - strlen(hdr)) / 2, 1, strlen(hdr), hdr));

    KeyInfo k;
    do
    {
        dlg.draw();
        vio_read_key(&k);
        if((k.skey & 0x00FF) == kbEnter ||
           (k.skey & 0x00FF) == kbGrEnter)
        {
            *res = str_dup(in->line(0)->str);

            return 0;
        }
        dlg.do_key(k);
    }
    while(k.skey != (kbEsc | shIsCtrl));

    return -1;
}

int MessageBox(char *text, KeyInfo* lastkey, int timeout)
{
    Dialog dlg(0, 0, 2, 2);

    int r = 0;
    int c = 0;
    int len;
    char *ptr;
    char *str;

    for(ptr = str = text; *str;)
    {
        while(*str && *str != '\n')
            str++;

        if(*str)
        {
            if(*(str - 1) == '\r')
                *(str - 1) = 0;
            *str++ = 0;
            if(*str == '\r' || *str == '\n')
                *str++ = 0;
        }
        //
        len = strlen(ptr);

        if(len >(Cols - 4))
            len = Cols - 4;

        if(len > c)
            c = len;
        dlg.Ins(new StaticText(r + 1, 1, 1, len, ptr));
        //
        ptr = str;
        r++;
    }

    if(dlg.rows + r >= Rows)
        r = Rows - dlg.rows - 2;

    if(dlg.cols + c >= Cols)
        c = Cols - dlg.cols - 2;

    dlg.size(dlg.rows + r, dlg.cols + c);
    dlg.move((Rows - dlg.rows)/2, (Cols - dlg.cols)/2);

    if(dlg.row < 0 || dlg.col < 0)
        dlg.move(0, 0);


    KeyInfo k;
    dlg.draw();

    if(!timeout)
    {
        do
        {
            vio_read_key(&k);
        }
        while(!(k.skey & 0x00FF));

        if(lastkey)
        {
            *lastkey = k;
        }
    }
    else
    {
        DosSleep(timeout);
        k.skey = 0;
    }
    return k.skey;
}

int JumpListBox(PJumpList pList, int r, int c, int nr, int nc)
{
    if(!pList || !pList->Count())
        return -1;

    if(r < 2 || r > (Rows - 7))
        r = 2;
    if(c < 2 || c > (Cols - 7))
        c = 2;

    if(nr <= 4)
        nr = Rows - 4;

    if(nc <= 4)
        nc = Cols - 4;

    if((nr + r) > (Rows - 2))
        nr = (Rows - 2) - r;

    if((nc + c) > (Cols - 2))
        nc = (Cols - 2) - c;

    int iFollow = 0;

    Dialog dlg(r, c, nr, nc);

    ListBox *list = new ListBox(1, 1, dlg.rows - 2, dlg.cols - 2,
                                ListBox::lbCanScroll |
                                ListBox::lbXScroll );

    dlg.Ins(list);

    for(int i = 0; i < pList->Count(); i++)
    {
        PJumpEntry pEntry = pList->get_entry(i);
        list->add_at_end(pEntry->get_name());
        list->set_item_key(i, (unsigned int)pEntry);
    }

    list->go_item(pList->get_last_pos());

    KeyInfo k;

    int last_pos = list->first_selected();

    do
    {
        dlg.draw();
        vio_read_key(&k);

        if((k.skey & 0x00FF) == kbEnter ||
           (k.skey & 0x00FF) == kbGrEnter)
        {
        	int pos = list->first_selected();

            PJumpEntry pEntry = (PJumpEntry)list->get_item_key(pos);

            if(!pEntry)
                return -1;

            // Select file if opened or open it

            Editor.doOpenFile(pEntry->get_file());

            if(pEntry->get_row())
                Editor.current()->goto_line(*Editor.current(),
                                             pEntry->get_row() - 1);

            if(pEntry->get_col())
                Editor.current()->goto_col(*Editor.current(),
                                            pEntry->get_col() - 1);

            pList->set_last_pos(pos);
            return pos;
        }

        dlg.do_key(k);

        int pos = list->first_selected();

        if(iFollow && (last_pos != pos))
        {
            PJumpEntry pEntry = (PJumpEntry)list->get_item_key(pos);

            if(!pEntry)
                continue;

            // Select file if opened or open it

            Editor.doOpenFile(pEntry->get_file());

            if(pEntry->get_row())
                Editor.current()->goto_line(*Editor.current(),
                                             pEntry->get_row() - 1);

            if(pEntry->get_col())
                Editor.current()->goto_col(*Editor.current(),
                                            pEntry->get_col() - 1);
            //Editor.draw();
        }
    }
    while(k.skey != (kbEsc | shIsCtrl));

    return -1;
}

