/*
** Module   :PARSER.CPP
** Abstract :Sintax hiliting language-specific parsers
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Tue  11/03/1997   	Created
**      Sat  12/04/1997   	Added REXX parser
*/

#include <string.h>

#include <fio.h>
#include <parser.h>
#include <version.h>

RegParser<Parser     > reg_NONE("none"  ," ~N~o hiliting ", 0);
RegParser<Parser_CPP > reg_CPP ("C++"   ," ~C~++"         , HI_CPP );
RegParser<Parser_REXX> reg_REXX("REXX"  ," ~R~EXX"        , HI_REXX);
RegParser<Parser_MAKE> reg_MAKE("MAKE"  ," ~M~AKE"        , HI_MAKE);
RegParser<Parser_ASM > reg_ASM ("ASM"   ," ~A~SM"         , HI_ASM );
RegParser<Parser_HTML> reg_HTML("HTML"  ," ~H~TML"        , HI_HTML);
RegParser<Parser_MAIL> reg_MAIL("MAIL"  ," MA~I~L"        , HI_MAIL);
RegParser<Parser_PAS > reg_PAS ("PASCAL"," ~P~ASCAL"      , HI_PAS );
RegParser<Parser_PL  > reg_PL  ("PERL"  ," P~E~RL"        , HI_PL  );

//-----------------------------------------
// Class Parser
//-----------------------------------------

Dictionary *Parser::pKeywords = 0;
Dictionary *Parser::pParsers  = 0;

char Parser::def_tbl[256];
int Parser::tbl_ready = 0;

Parser::Parser()
{
    if(!pKeywords)
    {
        pKeywords = new Dictionary(1,0,0);
        for(int i = 0; keywords[i].key; i++)
            pKeywords->Add(&keywords[i]);
    }

    reset(0, ST_INITIAL);
    preserve_case = 0;
    mask = 0;

    if(!tbl_ready)
    {
        for(int j = 0; j < 256; j++)
            def_tbl[j] = j;

        tbl_ready = 1;
    }

    cvt_tbl = def_tbl;
}

//-----------------------------------------
// Static methods for Parser dictionary
//-----------------------------------------

void Parser::RegParser(RegRecord* pReg)
{
    if(!pParsers)
        pParsers = new Dictionary(1, 0, 0);

    pParsers->Add(pReg);
}

Parser* Parser::GenParser(int key)
{
    if(!pParsers)
        return 0;

    for(int i = 0; i < pParsers->Count(); i++)
    {
        RegRecord* pReg = (RegRecord*)pParsers->Get(i);

        if(pReg->iType == key)
            return pReg->pGen();
    }

    return 0;
}

Parser* Parser::GenParser(char* key)
{
    if(!pParsers)
        return 0;

    RegRecord* pReg = (RegRecord*)pParsers->IsIn(key, 0);

    if(pReg)
        return pReg->pGen();

    return 0;
}

int Parser::Count()
{
    if(!pParsers)
        return 0;

    return pParsers->Count();
}

char* Parser::Name(int iNdx, int iHint)
{
    if(!pParsers)
        return 0;

    RegRecord* pReg = (RegRecord*)pParsers->Get(iNdx);

    if(pReg)
        return (iHint) ? pReg->cHName:pReg->cName;

    return 0;
}

int Parser::Type(int iNdx)
{
    if(!pParsers)
        return 0;

    RegRecord* pReg = (RegRecord*)pParsers->Get(iNdx);

    if(pReg)
        return pReg->iType;

    return 0;
}

char* Parser::NameByKey(int key, int iHint)
{
    if(!pParsers)
        return 0;

    for(int i = 0; i < pParsers->Count(); i++)
    {
        RegRecord* pReg = (RegRecord*)pParsers->Get(i);

        if(pReg->iType == key)
            return (iHint) ? pReg->cHName:pReg->cName;
    }

    return "";
}

int Parser::Index(char* key)
{
    if(!pParsers)
        return 0;

    RegRecord* pReg = (RegRecord*)pParsers->IsIn(key, 0);

    if(pReg)
        return pReg->iType;

    return 0;
}

int Parser::GuessType(char *name)
{
    char *str;
    char *ptr;
    int mode = 0;
    char mapname[FED_MAXPATH];

    for(ptr = str = hi_map; *str;)
    {
        char chr;

        while(*str && *str != '\n')
            str++;

        chr = *str;
        *str = 0;

        //String ready, parse it
        char *dots = strchr(ptr, ':');

        if(dots)
        {
            *dots = 0;

            while(__issp(*ptr))
                ptr++;

            mode = Index(ptr);

            *dots = ':';

            if(mode)
            {
                ptr = dots + 1;
                while(*ptr)
                {
                    int i = 0;

                    while(__issp(*ptr))
                        ptr++;

                    for(; *ptr && *ptr != ';' && i < FED_MAXPATH; i++, ptr++)
                    {
                        mapname[i] = *ptr;
                    }
                    mapname[i] = 0;

                    if(match_name(name, mapname))
                    {
                        *str = chr;
                        return mode;
                    }

                    if(*ptr)
                        ptr++;
                }
            }
        }

        *str = chr;

        if(*str)
            str++;

        ptr = str;
        mode = 0;
    }

    return mode;
}

//-----------------------------------------
// Regular methods
//-----------------------------------------

void Parser::reset(char *token, int initial_state)
{
    tok_len = 0;
    color   = 0;
    state   = initial_state;
    tok     = token;
    old_tok = token;
}

int Parser::next_token()
{
    old_tok = tok;
    tok_len = 0;
    color = CL_DEFAULT;
    char *tmp = tok;
    while(*tmp)
    {
        tmp++;
        tok_len++;
    }
    return tok_len;
}

int Parser::is_kwd()
{
    Pkwd pKwd = (Pkwd) pKeywords->IsIn(tok, tok_len, preserve_case);
    if(pKwd && (pKwd->mask & mask))
        return 1;
    return 0;
}

