/*
** Module   :PALETTE.CPP
** Abstract :Color palette for all visible elements of editor
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Sun  09/11/1997   	Updated to V0.1
*/

#include <editbox.h>
#include <version.h>

Buffer* Clipboard = 0;

char *untitled=".";
char *statusline="L%3r:C%2c %h [%u%f]";
char StartupDir[FED_MAXPATH];
char cPipe[] = "\\PIPE\\FED";
char Search[1025];
char Replace[1025];
char Flags[33];
char cName[1025];
char toupper_cvt_table[256];
char tolower_cvt_table[256];
char collate_cvt_table[256];
char _cFedPATH[FED_MAXPATH];

char *Screen;
char *AlignedBuffer;
int Rows;
int Cols;
int iTabWidth = 4;
int iWWDef    = WW_MERGE;
int iDefWidth = 78;
int BufLen;
int iShape[2] = { 90, 0};
int iForce;
int iDefType = 0;
int iCtrlBrk = 0;
int iUpperStatus = 0;
int iNoEA = 0;
int iFileName = 1;
int iSaveSyntax = 1;

char app_pal[]=
{
    //CL_APPLICATION_START
    0x07,   //CL_DEFAULT
    0x70,   //CL_STATUSLINE

    //CL_DIALOG_START
    0x70,   //CL_DEFAULT
    0x70,   //CL_BORDER

    //CL_STEXT_START
    0x70,   //CL_DEFAULT
    0x7C,   //CL_HILITE

    //CL_EDITBOX_START
    0x08,   //CL_DEFAULT
    0x70,   //CL_SELECTION
    0x1B,   //CL_EOF
    0x06,   //CL_COMMENT
    0x07,   //CL_IDENT
    0x0E,   //CL_CONST
    0x0A,   //CL_PREPROC
    0x0C,   //CL_NUMBER
    0x0F,   //CL_STDWORD
    0x09,   //CL_SEMICOL
    0x0F,   //CL_FUNCTION
    0x0D,   //CL_XNUMBER

    //CL_EDITLINE_ACTIVE
    0x0F,   //CL_DEFAULT
    0x30,   //CL_SELECTION
    0x07,   //CL_EOF
    0x07,   //CL_COMMENT
    0x07,   //CL_IDENT
    0x07,   //CL_CONST
    0x07,   //CL_PREPROC
    0x07,   //CL_NUMBER
    0x07,   //CL_STDWORD
    0x07,   //CL_SEMICOL
    0x07,   //CL_FUNCTION
    0x07,   //CL_XNUMBER

    //CL_EDITLINE_INACTIVE
    0x1B,   //CL_DEFAULT
    0x3B,   //CL_SELECTION
    0x07,   //CL_EOF
    0x07,   //CL_COMMENT
    0x07,   //CL_IDENT
    0x07,   //CL_CONST
    0x07,   //CL_PREPROC
    0x07,   //CL_NUMBER
    0x07,   //CL_STDWORD
    0x07,   //CL_SEMICOL
    0x07,   //CL_FUNCTION
    0x07,   //CL_XNUMBER

    //CL_LISTBOX_START_ACTIVE
    0x30,   //CL_DEFAULT
    0x3B,   //CL_SELECTION
    0x07,   //CL_CURRENT
    0x0B,   //CL_CURRSEL

    //CL_LISTBOX_START_INACTIVE
    0x30,   //CL_DEFAULT
    0x3B,   //CL_SELECTION
    0x1B,   //CL_CURRENT
    0x1B,   //CL_CURRSEL

    //CL_MENU
    0x70,   //CL_DEFAULT
    0x7C,   //CL_SELECTION
    0x07,   //CL_CURRENT
    0x0C,   //CL_CURRSEL

    //CL_END_OF_PALETTE
    0
};

char ProgressBar[]="";

char _cZero[]="";

char* FileDialogNames[]=
{
    " File Open ",
    " File Save ",
    " File Save As ",
    _cZero
};

char *Yes_No[]=
{
    " ~Y~es",
    " ~N~o",
    " ~C~ancel ",
    0
};

char *help_text="No Help available";

stKeyMap AltKey[] =
{
    { 0x00, _cZero },
    { 0x1A, "Esc" },
    { 0x02, "1" },
    { 0x03, "2" },
    { 0x04, "3" },
    { 0x05, "4" },
    { 0x06, "5" },
    { 0x07, "6" },
    { 0x08, "7" },
    { 0x09, "8" },
    { 0x0A, "9" },
    { 0x01, "0" },
    { 0x38, "Minus" },
    { 0x19, "Equal" },
    { 0x0E, "Bksp" },
    { 0x48, "Tab" },
    { 0x3F, "Q" },
    { 0x4D, "W" },
    { 0x16, "E" },
    { 0x41, "R" },
    { 0x47, "T" },
    { 0x4F, "Y" },
    { 0x4A, "U" },
    { 0x30, "I" },
    { 0x3A, "O" },
    { 0x3B, "P" },
    { 0x35, "Lbracket" },
    { 0x42, "Rbracket" },
    { 0x18, "Enter" },
    { 0x00, _cZero },
    { 0x0B, "A" },
    { 0x44, "S" },
    { 0x12, "D" },
    { 0x1B, "F" },
    { 0x28, "G" },
    { 0x2E, "H" },
    { 0x32, "J" },
    { 0x33, "K" },
    { 0x34, "L" },
    { 0x45, "Semicolon" },
    { 0x40, "Quote" },
    { 0x49, "Tilde" },
    { 0x00, _cZero },
    { 0x0D, "BackSlash" },
    { 0x50, "Z" },
    { 0x4E, "X" },
    { 0x0F, "C" },
    { 0x4C, "V" },
    { 0x0C, "B" },
    { 0x39, "N" },
    { 0x37, "M" },
    { 0x11, "Comma" },
    { 0x3E, "Point" },
    { 0x14, "Div" },
    { 0x00, _cZero },
    { 0x2C, "GrMul" },
    { 0x00, _cZero },
    { 0x46, "Space" },
    { 0x00, _cZero },
    { 0x1C, "F1" },
    { 0x20, "F2" },
    { 0x21, "F3" },
    { 0x22, "F4" },
    { 0x23, "F5" },
    { 0x24, "F6" },
    { 0x25, "F7" },
    { 0x26, "F8" },
    { 0x27, "F9" },
    { 0x1D, "F10" },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x2F, "Home" },
    { 0x4B, "Up" },
    { 0x3D, "PgUp" },
    { 0x2B, "GrMinus" },
    { 0x36, "Left" },
    { 0x10, "Center" },
    { 0x43, "Right" },
    { 0x2D, "GrPlus" },
    { 0x17, "End" },
    { 0x15, "Down" },
    { 0x3C, "PgDown" },
    { 0x31, "Ins" },
    { 0x13, "Del" },
    { 0x1C, "F1" },
    { 0x20, "F2" },
    { 0x21, "F3" },
    { 0x22, "F4" },
    { 0x23, "F5" },
    { 0x24, "F6" },
    { 0x25, "F7" },
    { 0x26, "F8" },
    { 0x27, "F9" },
    { 0x1D, "F10" },
    { 0x1C, "F1" },
    { 0x20, "F2" },
    { 0x21, "F3" },
    { 0x22, "F4" },
    { 0x23, "F5" },
    { 0x24, "F6" },
    { 0x25, "F7" },
    { 0x26, "F8" },
    { 0x27, "F9" },
    { 0x1D, "F10" },
    { 0x1C, "F1" },
    { 0x20, "F2" },
    { 0x21, "F3" },
    { 0x22, "F4" },
    { 0x23, "F5" },
    { 0x24, "F6" },
    { 0x25, "F7" },
    { 0x26, "F8" },
    { 0x27, "F9" },
    { 0x1D, "F10" },
    { 0x00, _cZero },
    { 0x36, "Left" },
    { 0x43, "Right" },
    { 0x17, "End" },
    { 0x3C, "PgDown" },
    { 0x2F, "Home" },
    { 0x02, "1" },
    { 0x03, "2" },
    { 0x04, "3" },
    { 0x05, "4" },
    { 0x06, "5" },
    { 0x07, "6" },
    { 0x08, "7" },
    { 0x09, "8" },
    { 0x0A, "9" },
    { 0x01, "0" },
    { 0x38, "Minus" },
    { 0x19, "Equal" },
    { 0x3D, "PgUp" },
    { 0x1E, "F11" }, //Norm
    { 0x1F, "F12" },
    { 0x1E, "F11" }, //Shift
    { 0x1F, "F12" },
    { 0x1E, "F11" }, //Ctrl
    { 0x1F, "F12" },
    { 0x1E, "F11" }, //Alt
    { 0x1F, "F12" },
    { 0x4B, "Up" },
    { 0x2B, "GrMinus" },
    { 0x10, "Center" },
    { 0x2D, "GrPlus" },
    { 0x15, "Down" },
    { 0x31, "Ins" },
    { 0x13, "Del" },
    { 0x48, "Tab" },
    { 0x29, "GrDiv" },
    { 0x2C, "GrMul" },
    { 0x2F, "Home" },
    { 0x4B, "Up" },
    { 0x3D, "PgUp" },
    { 0x00, _cZero },
    { 0x36, "Left" },
    { 0x00, _cZero },
    { 0x43, "Right" },
    { 0x00, _cZero },
    { 0x17, "End" },
    { 0x15, "Down" },
    { 0x3C, "PgDown" },
    { 0x31, "Ins" },
    { 0x13, "Del" },
    { 0x29, "GrDiv" },
    { 0x00, _cZero },
    { 0x2A, "GrEnter" },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x2A, "GrEnter" },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero },
    { 0x00, _cZero }
};

int __r_ctype[]=
{
     0, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP,
 IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP,
 IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP,
 IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP, IS_SP,
 IS_SP                          /*' ' - 0x20*/,
 IS_PU                          /*'!' - 0x21*/,
 IS_PU | IS_QU                  /*'"' - 0x22*/,
 IS_PU | IS_IS                  /*'#' - 0x23*/,
 IS_PU                          /*'$' - 0x24*/,
 IS_PU                          /*'%' - 0x25*/,
 IS_PU                          /*'&' - 0x26*/,
 IS_PU | IS_QU                  /*''' - 0x27*/,
 IS_PU                          /*'(' - 0x28*/,
 IS_PU                          /*')' - 0x29*/,
 IS_PU                          /*'*' - 0x2A*/,
 IS_PU                          /*'+' - 0x2B*/,
 IS_PU                          /*',' - 0x2C*/,
 IS_PU                          /*'-' - 0x2D*/,
 IS_PU                          /*'.' - 0x2E*/,
 IS_PU                          /*'/' - 0x2F*/,
 IS_DI | IS_XD | IS_HD          /*'0' - 0x30*/,
 IS_DI | IS_XD | IS_HD          /*'1' - 0x31*/,
 IS_DI | IS_XD | IS_HD          /*'2' - 0x32*/,
 IS_DI | IS_XD | IS_HD          /*'3' - 0x33*/,
 IS_DI | IS_XD | IS_HD          /*'4' - 0x34*/,
 IS_DI | IS_XD | IS_HD          /*'5' - 0x35*/,
 IS_DI | IS_XD | IS_HD          /*'6' - 0x36*/,
 IS_DI | IS_XD | IS_HD          /*'7' - 0x37*/,
 IS_DI | IS_XD | IS_HD          /*'8' - 0x38*/,
 IS_DI | IS_XD | IS_HD          /*'9' - 0x39*/,
 IS_PU                          /*':' - 0x3A*/,
 IS_PU | IS_SE                  /*';' - 0x3B*/,
 IS_PU                          /*'<' - 0x3C*/,
 IS_PU                          /*'=' - 0x3D*/,
 IS_PU                          /*'>' - 0x3E*/,
 IS_PU                          /*'?' - 0x3F*/,
 IS_PU                          /*'@' - 0x40*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'A' - 0x41*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'B' - 0x42*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'C' - 0x43*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'D' - 0x44*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'E' - 0x45*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'F' - 0x46*/,
 IS_AL                 | IS_IS  /*'G' - 0x47*/,
 IS_AL                 | IS_IS  /*'H' - 0x48*/,
 IS_AL                 | IS_IS  /*'I' - 0x49*/,
 IS_AL                 | IS_IS  /*'J' - 0x4A*/,
 IS_AL                 | IS_IS  /*'K' - 0x4B*/,
 IS_AL                 | IS_IS  /*'L' - 0x4C*/,
 IS_AL                 | IS_IS  /*'M' - 0x4D*/,
 IS_AL                 | IS_IS  /*'N' - 0x4E*/,
 IS_AL                 | IS_IS  /*'O' - 0x4F*/,
 IS_AL                 | IS_IS  /*'P' - 0x50*/,
 IS_AL                 | IS_IS  /*'Q' - 0x51*/,
 IS_AL                 | IS_IS  /*'R' - 0x52*/,
 IS_AL                 | IS_IS  /*'S' - 0x53*/,
 IS_AL                 | IS_IS  /*'T' - 0x54*/,
 IS_AL                 | IS_IS  /*'U' - 0x55*/,
 IS_AL                 | IS_IS  /*'V' - 0x56*/,
 IS_AL                 | IS_IS  /*'W' - 0x57*/,
 IS_AL                 | IS_IS  /*'X' - 0x58*/,
 IS_AL                 | IS_IS  /*'Y' - 0x59*/,
 IS_AL                 | IS_IS  /*'Z' - 0x5A*/,
 IS_PU                          /*'[' - 0x5B*/,
 IS_PU                          /*'\' - 0x5C*/,
 IS_PU                          /*']' - 0x5D*/,
 IS_PU                          /*'^' - 0x5E*/,
 IS_PU                 | IS_IS  /*'_' - 0x5F*/,
 IS_PU                          /*'`' - 0x60*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'a' - 0x61*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'b' - 0x62*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'c' - 0x63*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'d' - 0x64*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'e' - 0x65*/,
 IS_AL | IS_XD | IS_HD | IS_IS  /*'f' - 0x66*/,
 IS_AL                 | IS_IS  /*'g' - 0x67*/,
 IS_AL                 | IS_IS  /*'h' - 0x68*/,
 IS_AL                 | IS_IS  /*'i' - 0x69*/,
 IS_AL                 | IS_IS  /*'j' - 0x6A*/,
 IS_AL                 | IS_IS  /*'k' - 0x6B*/,
 IS_AL                 | IS_IS  /*'l' - 0x6C*/,
 IS_AL                 | IS_IS  /*'m' - 0x6D*/,
 IS_AL                 | IS_IS  /*'n' - 0x6E*/,
 IS_AL                 | IS_IS  /*'o' - 0x6F*/,
 IS_AL                 | IS_IS  /*'p' - 0x70*/,
 IS_AL                 | IS_IS  /*'q' - 0x71*/,
 IS_AL                 | IS_IS  /*'r' - 0x72*/,
 IS_AL                 | IS_IS  /*'s' - 0x73*/,
 IS_AL                 | IS_IS  /*'t' - 0x74*/,
 IS_AL                 | IS_IS  /*'u' - 0x75*/,
 IS_AL                 | IS_IS  /*'v' - 0x76*/,
 IS_AL                 | IS_IS  /*'w' - 0x77*/,
 IS_AL                 | IS_IS  /*'x' - 0x78*/,
 IS_AL                 | IS_IS  /*'y' - 0x79*/,
 IS_AL                 | IS_IS  /*'z' - 0x7A*/,
 IS_PU                          /*'{' - 0x7B*/,
 IS_PU                          /*'|' - 0x7C*/,
 IS_PU                          /*'}' - 0x7D*/,
 IS_PU                          /*'~' - 0x7E*/,
 IS_SP | IS_PU                  /*' ' - 0x7F*/,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0
};

char *hi_map = _cZero;
int iDateFmt = 0;
int cDateSep = '/';
int iVSearch = 0;
int iMouseMask = 0x06;
int iSenseShift = 1;

//-----------------------------------------
// Static initializer for dictionary of keywords
//-----------------------------------------

kwdPair keywords [] =
{

    { "AUTOLOAD"        , MASK_PL},
    { "BEGIN"           , MASK_PL},
    { "CHECK"           , MASK_PL},
    { "CORE"            , MASK_PL},
    { "DESTROY"         , MASK_PL},
    { "END"             , MASK_PL},
    { "EQ"              , MASK_PL},
    { "GE"              , MASK_PL},
    { "GT"              , MASK_PL},
    { "INIT"            , MASK_PL},
    { "LE"              , MASK_PL},
    { "LT"              , MASK_PL},
    { "NE"              , MASK_PL},
    { "NULL"            , MASK_PL},
    { "__DATA__"        , MASK_PL},
    { "__END__"         , MASK_PL},
    { "__FILE__"        , MASK_PL},
    { "__LINE__"        , MASK_PL},
    { "__PACKAGE__"     , MASK_PL},

    { "::method"    	, MASK_REXX},
    { "::class"     	, MASK_REXX},
    { "::requires"      , MASK_REXX},

    { "abs"             , MASK_PL},
    { "absolute"        , MASK_PAS },
    { "abstract"        , MASK_JAVA},
    { "accept"          , MASK_PL},
    { "address"         , MASK_REXX},
    { "alarm"           , MASK_PL},
    { "all"             , MASK_REXX},
    { "and"             , MASK_PAS | MASK_PL},
    { "arg"             , MASK_REXX},
    { "array"           , MASK_PAS },
    { "asm"             , MASK_PAS },
    { "assembler"       , MASK_PAS },
    { "atan2"           , MASK_PL},
    { "auto"            , MASK_CPP },
    { "begin"           , MASK_PAS },
    { "bind"            , MASK_PL},
    { "binmode"         , MASK_PL},
    { "bless"           , MASK_PL},
    { "bool"            , MASK_CPP },
    { "boolean"         , MASK_JAVA},
    { "break"           , MASK_CPP | MASK_JAVA},
    { "by"              , MASK_REXX},
    { "byte"            , MASK_ASM | MASK_JAVA},
    { "call"            , MASK_ASM | MASK_REXX},
    { "caller"          , MASK_PL},
    { "case"            , MASK_CPP | MASK_PAS | MASK_JAVA},
    { "catch"           , MASK_CPP | MASK_JAVA},
    { "char"            , MASK_CPP },
    { "chdir"           , MASK_PL},
    { "chmod"           , MASK_PL},
    { "chomp"           , MASK_PL},
    { "chop"            , MASK_PL},
    { "chown"           , MASK_PL},
    { "chr"             , MASK_PL},
    { "chroot"          , MASK_PL},
    { "class"           , MASK_CPP | MASK_JAVA},
    { "close"           , MASK_PL},
    { "closedir"        , MASK_PL},
    { "cmp"             , MASK_PL},
    { "commands"        , MASK_REXX},
    { "connect"         , MASK_PL},
    { "const"           , MASK_CPP | MASK_PAS | MASK_JAVA},
    { "constructor"     , MASK_PAS },
    { "continue"        , MASK_CPP | MASK_JAVA | MASK_PL},
    { "cos"             , MASK_PL},
    { "crypt"           , MASK_PL},
    { "dbmclose"        , MASK_PL},
    { "dbmopen"         , MASK_PL},
    { "default"         , MASK_CPP | MASK_JAVA},
    { "define"          , MASK_CPP },
    { "defined"         , MASK_PL},
    { "delete"          , MASK_CPP | MASK_PL},
    { "destructor"      , MASK_PAS },
    { "die"             , MASK_PL},
    { "digits"          , MASK_REXX},
    { "div"             , MASK_PAS },
    { "do"              , MASK_REXX | MASK_CPP | MASK_PAS | MASK_JAVA | MASK_PL},
    { "double"          , MASK_CPP | MASK_JAVA},
    { "downto"          , MASK_PAS },
    { "drop"            , MASK_REXX},
    { "dump"            , MASK_PL},
    { "dword"           , MASK_ASM },
    { "each"            , MASK_PL},
    { "else"            , MASK_REXX | MASK_CPP | MASK_PAS | MASK_JAVA | MASK_PL},
    { "elsif"           , MASK_PL},
    { "end"             , MASK_REXX | MASK_ASM | MASK_PAS},
    { "endgrent"        , MASK_PL},
    { "endhostent"      , MASK_PL},
    { "endif"           , MASK_CPP },
    { "endnetent"       , MASK_PL},
    { "endp"            , MASK_ASM },
    { "endprotoent"     , MASK_PL},
    { "endpwent"        , MASK_PL},
    { "ends"            , MASK_ASM },
    { "endservent"      , MASK_PL},
    { "engineering"     , MASK_REXX},
    { "entry"           , MASK_CPP },
    { "enum"            , MASK_CPP },
    { "eof"             , MASK_PL},
    { "eq"              , MASK_PL},
    { "error"           , MASK_REXX},
    { "errors"          , MASK_REXX},
    { "eval"            , MASK_PL},
    { "exec"            , MASK_PL},
    { "exists"          , MASK_PL},
    { "exit"            , MASK_REXX | MASK_PL},
    { "exp"             , MASK_PL},
    { "expose"          , MASK_REXX},
    { "extends"         , MASK_JAVA},
    { "extern"          , MASK_CPP },
    { "external"        , MASK_PAS },
    { "false"           , MASK_CPP | MASK_JAVA},
    { "far"             , MASK_PAS },
    { "fcntl"           , MASK_PL},
    { "file"            , MASK_PAS },
    { "fileno"          , MASK_PL},
    { "final"           , MASK_JAVA},
    { "finally"         , MASK_JAVA},
    { "float"           , MASK_CPP | MASK_JAVA},
    { "flock"           , MASK_PL},
    { "for"             , MASK_REXX | MASK_CPP | MASK_PAS | MASK_JAVA | MASK_PL},
    { "foreach"         , MASK_PL},
    { "forever"         , MASK_REXX},
    { "fork"            , MASK_PL},
    { "form"            , MASK_REXX},
    { "format"          , MASK_PL},
    { "formline"        , MASK_PL},
    { "forward"         , MASK_PAS },
    { "friend"          , MASK_CPP },
    { "function"        , MASK_PAS },
    { "fuzz"            , MASK_REXX},
    { "ge"              , MASK_PL},
    { "getc"            , MASK_PL},
    { "getgrent"        , MASK_PL},
    { "getgrgid"        , MASK_PL},
    { "getgrnam"        , MASK_PL},
    { "gethostbyaddr"   , MASK_PL},
    { "gethostbyname"   , MASK_PL},
    { "gethostent"      , MASK_PL},
    { "getlogin"        , MASK_PL},
    { "getnetbyaddr"    , MASK_PL},
    { "getnetbyname"    , MASK_PL},
    { "getnetent"       , MASK_PL},
    { "getpeername"     , MASK_PL},
    { "getpgrp"         , MASK_PL},
    { "getppid"         , MASK_PL},
    { "getpriority"     , MASK_PL},
    { "getprotobyname"  , MASK_PL},
    { "getprotobynumber", MASK_PL},
    { "getprotoent"     , MASK_PL},
    { "getpwent"        , MASK_PL},
    { "getpwnam"        , MASK_PL},
    { "getpwuid"        , MASK_PL},
    { "getservbyname"   , MASK_PL},
    { "getservbyport"   , MASK_PL},
    { "getservent"      , MASK_PL},
    { "getsockname"     , MASK_PL},
    { "getsockopt"      , MASK_PL},
    { "glob"            , MASK_PL},
    { "gmtime"          , MASK_PL},
    { "goto"            , MASK_CPP | MASK_PAS | MASK_JAVA | MASK_PL},
    { "grep"            , MASK_PL},
    { "gt"              , MASK_PL},
    { "halt"            , MASK_REXX},
    { "hex"             , MASK_PL},
    { "if"              , MASK_REXX | MASK_CPP | MASK_PAS | MASK_JAVA | MASK_PL},
    { "ifdef"           , MASK_CPP },
    { "ifndef"          , MASK_CPP },
    { "implementation"  , MASK_PAS },
    { "implements"      , MASK_JAVA},
    { "import"          , MASK_JAVA},
    { "in"              , MASK_PAS },
    { "include"         , MASK_CPP },
    { "index"           , MASK_PL},
    { "inherited"       , MASK_PAS },
    { "inline"          , MASK_CPP | MASK_PAS},
    { "instanceof"      , MASK_JAVA},
    { "int"             , MASK_CPP | MASK_JAVA | MASK_PL},
    { "interface"       , MASK_PAS | MASK_JAVA},
    { "intermediates"   , MASK_REXX},
    { "interpret"       , MASK_REXX},
    { "interrupt"       , MASK_PAS },
    { "ioctl"           , MASK_PL},
    { "iterate"         , MASK_REXX},
    { "join"            , MASK_PL},
    { "keys"            , MASK_PL},
    { "kill"            , MASK_PL},
    { "label"           , MASK_ASM | MASK_PAS},
    { "labels"          , MASK_REXX},
    { "last"            , MASK_PL},
    { "lc"              , MASK_PL},
    { "lcfirst"         , MASK_PL},
    { "le"              , MASK_PL},
    { "leave"           , MASK_REXX},
    { "length"          , MASK_PL},
    { "link"            , MASK_PL},
    { "listen"          , MASK_PL},
    { "local"           , MASK_PL},
    { "localtime"       , MASK_PL},
    { "lock"            , MASK_PL},
    { "log"             , MASK_PL},
    { "long"            , MASK_CPP | MASK_JAVA},
    { "lstat"           , MASK_PL},
    { "lt"              , MASK_PL},
    { "m"               , MASK_PL},
    { "map"             , MASK_PL},
    { "mkdir"           , MASK_PL},
    { "mod"             , MASK_PAS },
    { "msgctl"          , MASK_PL},
    { "msgget"          , MASK_PL},
    { "msgrcv"          , MASK_PL},
    { "msgsnd"          , MASK_PL},
    { "my"              , MASK_PL},
    { "native"          , MASK_JAVA},
    { "ne"              , MASK_PL},
    { "near"            , MASK_ASM | MASK_PAS},
    { "negative"        , MASK_REXX},
    { "new"             , MASK_CPP | MASK_JAVA},
    { "next"            , MASK_PL},
    { "nil"             , MASK_REXX | MASK_PAS },
    { "no"              , MASK_PL},
    { "nop"             , MASK_REXX},
    { "normal"          , MASK_REXX},
    { "not"             , MASK_PAS | MASK_PL},
    { "novalue"         , MASK_REXX},
    { "null"            , MASK_JAVA},
    { "numeric"         , MASK_REXX},
    { "object"          , MASK_PAS },
    { "oct"             , MASK_PL},
    { "of"              , MASK_PAS },
    { "off"             , MASK_REXX},
    { "offset"          , MASK_ASM },
    { "on"              , MASK_REXX},
    { "open"            , MASK_PL},
    { "opendir"         , MASK_PL},
    { "or"              , MASK_PAS | MASK_PL},
    { "ord"             , MASK_PL},
    { "otherwise"       , MASK_REXX},
    { "our"             , MASK_PL},
    { "pack"            , MASK_PL},
    { "package"         , MASK_JAVA | MASK_PL},
    { "packed"          , MASK_PAS },
    { "parse"           , MASK_REXX},
    { "pipe"            , MASK_PL},
    { "pop"             , MASK_PL},
    { "pos"             , MASK_PL},
    { "print"           , MASK_PL},
    { "printf"          , MASK_PL},
    { "private"         , MASK_CPP | MASK_PAS | MASK_JAVA},
    { "proc"            , MASK_ASM },
    { "procedure"       , MASK_REXX | MASK_PAS},
    { "program"         , MASK_PAS },
    { "protected"       , MASK_CPP | MASK_JAVA},
    { "prototype"       , MASK_PL},
    { "ptr"             , MASK_ASM },
    { "public"          , MASK_CPP | MASK_PAS | MASK_JAVA},
    { "pull"            , MASK_REXX},
    { "push"            , MASK_REXX | MASK_PL},
    { "q"               , MASK_PL},
    { "qq"              , MASK_PL},
    { "qr"              , MASK_PL},
    { "queue"           , MASK_REXX},
    { "quotemeta"       , MASK_PL},
    { "qw"              , MASK_PL},
    { "qword"           , MASK_ASM },
    { "qx"              , MASK_PL},
    { "rand"            , MASK_PL},
    { "read"            , MASK_PL},
    { "readdir"         , MASK_PL},
    { "readline"        , MASK_PL},
    { "readlink"        , MASK_PL},
    { "readpipe"        , MASK_PL},
    { "record"          , MASK_PAS },
    { "recv"            , MASK_PL},
    { "redo"            , MASK_PL},
    { "ref"             , MASK_PL},
    { "register"        , MASK_CPP },
    { "rename"          , MASK_PL},
    { "repeat"          , MASK_PAS },
    { "require"         , MASK_PL},
    { "reset"           , MASK_PL},
    { "results"         , MASK_REXX},
    { "return"          , MASK_REXX | MASK_CPP | MASK_JAVA | MASK_PL},
    { "reverse"         , MASK_PL},
    { "rewinddir"       , MASK_PL},
    { "rindex"          , MASK_PL},
    { "rmdir"           , MASK_PL},
    { "s"               , MASK_PL},
    { "say"             , MASK_REXX},
    { "scalar"          , MASK_PL},
    { "scan"            , MASK_REXX},
    { "scientific"      , MASK_REXX},
    { "seek"            , MASK_PL},
    { "seekdir"         , MASK_PL},
    { "segment"         , MASK_ASM },
    { "select"          , MASK_REXX | MASK_PL},
    { "self"            , MASK_REXX | MASK_PAS},
    { "semctl"          , MASK_PL},
    { "semget"          , MASK_PL},
    { "semop"           , MASK_PL},
    { "send"            , MASK_PL},
    { "set"             , MASK_PAS },
    { "setgrent"        , MASK_PL},
    { "sethostent"      , MASK_PL},
    { "setnetent"       , MASK_PL},
    { "setpgrp"         , MASK_PL},
    { "setpriority"     , MASK_PL},
    { "setprotoent"     , MASK_PL},
    { "setpwent"        , MASK_PL},
    { "setservent"      , MASK_PL},
    { "setsockopt"      , MASK_PL},
    { "shift"           , MASK_PL},
    { "shl"             , MASK_PAS },
    { "shmctl"          , MASK_PL},
    { "shmget"          , MASK_PL},
    { "shmread"         , MASK_PL},
    { "shmwrite"        , MASK_PL},
    { "short"           , MASK_CPP | MASK_JAVA},
    { "shr"             , MASK_PAS },
    { "shutdown"        , MASK_PL},
    { "sigl"            , MASK_REXX},
    { "signal"          , MASK_REXX},
    { "signed"          , MASK_CPP },
    { "sin"             , MASK_PL},
    { "sizeof"          , MASK_CPP },
    { "sleep"           , MASK_PL},
    { "socket"          , MASK_PL},
    { "socketpair"      , MASK_PL},
    { "sort"            , MASK_PL},
    { "splice"          , MASK_PL},
    { "split"           , MASK_PL},
    { "sprintf"         , MASK_PL},
    { "sqrt"            , MASK_PL},
    { "srand"           , MASK_PL},
    { "stat"            , MASK_PL},
    { "static"          , MASK_CPP | MASK_JAVA},
    { "string"          , MASK_PAS },
    { "struc"           , MASK_ASM },
    { "struct"          , MASK_CPP },
    { "study"           , MASK_PL},
    { "sub"             , MASK_PL},
    { "substr"          , MASK_PL},
    { "super"           , MASK_JAVA},
    { "switch"          , MASK_CPP | MASK_JAVA},
    { "symlink"         , MASK_PL},
    { "synchronized"    , MASK_JAVA},
    { "syntax"          , MASK_REXX},
    { "syscall"         , MASK_PL},
    { "sysopen"         , MASK_PL},
    { "sysread"         , MASK_PL},
    { "sysseek"         , MASK_PL},
    { "system"          , MASK_PL},
    { "syswrite"        , MASK_PL},
    { "tell"            , MASK_PL},
    { "telldir"         , MASK_PL},
    { "then"            , MASK_REXX | MASK_PAS},
    { "this"            , MASK_CPP | MASK_JAVA},
    { "throw"           , MASK_CPP | MASK_JAVA},
    { "throws"          , MASK_JAVA},
    { "tie"             , MASK_PL},
    { "tied"            , MASK_PL},
    { "time"            , MASK_PL},
    { "times"           , MASK_PL},
    { "to"              , MASK_REXX | MASK_PAS},
    { "tr"              , MASK_PL},
    { "trace"           , MASK_REXX},
    { "transient"       , MASK_JAVA},
    { "true"            , MASK_CPP | MASK_JAVA},
    { "truncate"        , MASK_PL},
    { "try"             , MASK_CPP | MASK_JAVA},
    { "type"            , MASK_PAS },
    { "typedef"         , MASK_CPP },
    { "uc"              , MASK_PL},
    { "ucfirst"         , MASK_PL},
    { "umask"           , MASK_PL},
    { "undef"           , MASK_PL},
    { "union"           , MASK_CPP },
    { "unit"            , MASK_PAS },
    { "unless"          , MASK_PL},
    { "unlink"          , MASK_PL},
    { "unpack"          , MASK_PL},
    { "unshift"         , MASK_PL},
    { "unsigned"        , MASK_CPP },
    { "untie"           , MASK_PL},
    { "until"           , MASK_REXX | MASK_PAS | MASK_PL},
    { "upper"           , MASK_REXX},
    { "use"             , MASK_REXX | MASK_PL},
    { "uses"            , MASK_PAS },
    { "utime"           , MASK_PL},
    { "value"           , MASK_REXX},
    { "values"          , MASK_PL},
    { "var"             , MASK_REXX | MASK_PAS},
    { "vec"             , MASK_PL},
    { "virtual"         , MASK_CPP | MASK_PAS },
    { "void"            , MASK_CPP | MASK_JAVA},
    { "volatile"        , MASK_CPP | MASK_JAVA},
    { "wait"            , MASK_PL},
    { "waitpid"         , MASK_PL},
    { "wantarray"       , MASK_PL},
    { "warn"            , MASK_PL},
    { "when"            , MASK_REXX},
    { "while"           , MASK_REXX | MASK_CPP | MASK_PAS | MASK_JAVA | MASK_PL},
    { "with"            , MASK_REXX | MASK_PAS},
    { "word"            , MASK_ASM },
    { "write"           , MASK_PL},
    { "x"               , MASK_PL},
    { "xor"             , MASK_PAS | MASK_PL},
    { "y"               , MASK_PL},
    {0,0}
};

