/*
** Module   :KEYCOLL.CPP
** Abstract :Keyboard definition collection
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Fri  27/03/1998     Created
**
*/

#include <string.h>

#include <boxcoll.h>
#include <version.h>

int KeyDefCollection::Compare(Ptr p1, Ptr p2)
{
    return __cstrcmp((char*)p1, (char*)p2);
}

void KeyDefCollection::InsKey(char *buf, int namelen)
{
    char *str;

    if(!buf || namelen >= KEY_NAME_LEN)
        return;

    str = buf+namelen;

    while(__issp(*str))
        str++;

    if(!*str)
        return;

    if(*str != ':' && *str != '=')
        return;

    str++;

    int nlen = compile_keydef(str, 0);

    if(nlen <= 0)
        return;

    struct keydef_pair* def = (struct keydef_pair*)
                              new char[sizeof(keydef_pair)+nlen];
    def->prog[nlen] = 0;

    compile_keydef(str, def->prog);

    memcpy(def->key, buf, namelen);
    def->key[namelen] = 0;

    //printf("Compiled definition for %s\n", def->key);

    unsigned long index = Look(def->key);

    if(index < Count() && !Compare(def->key, Get(index)))
    {
        //Replace existing keydef
        Free(Remove(index));
        At(def, index);
    }
    else
    	Add(def);
}

char *KeyDefCollection::GetDef(char *key)
{
    unsigned long index = Look(key);

    if(index < Count() && !Compare(key, Get(index)))
        return ((struct keydef_pair*)Get(index))->prog;
    return 0;
}

void KeyDefCollection::AddAssignment(char *keyname, char *prog)
{
    if(!keyname || !prog)
        return;

    int nlen = strlen(prog);

    struct keydef_pair* def = (struct keydef_pair*)
                              new char[sizeof(keydef_pair)+nlen];

    strncpy(def->key, keyname, KEY_NAME_LEN);
    memcpy(def->prog, prog, nlen);
    def->prog[nlen] = 0;

    unsigned long index = Look(def->key);

    if(index < Count() && !Compare(def->key, Get(index)))
    {
        Free(Remove(index));
        At(def, index);
    }
    else
        Add(def);
}

