/*
** Module   :DISPATCH.CPP
** Abstract :Keyboard events dispatcher
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Thu  26/03/1998     Created
*/

#include <string.h>

#include <boxcoll.h>
#include <keynames.h>
#include <version.h>

#define INCL_DOS
#include <os2.h>

void EditBoxCollection::Dispatcher(KeyInfo& k, int iMode)
{
    lock();
    track_beg();

    if((k.skey & 0x00FF) == kbEnter &&
    	!(k.skey & (shAlt | shCtrl | shShift)))
            k.skey &= ~shIsCtrl;

    char* pre_key  = (iMode) ? keys.GetDef("kbBeforeKey"):0;
    char* post_key = (iMode) ? keys.GetDef("kbAfterKey"):0;

    if(pre_key)
    {
        track_recording(pre_key, 0);
        play_macro(pre_key);
    }

    if(k.skey & shIsCtrl)
    {
        char* prog = keys.GetDef(k.KeyName);

        if(prog)
        {
            track_recording(prog, 0);
            play_macro(prog);
        }
    }
    else
    {
        track_recording(0, (char)k.key);
        usual_key(k);
    }

    if(post_key)
    {
        track_recording(post_key, 0);
        play_macro(post_key);
    }

    track_end();
    unlock();
}

void EditBoxCollection::play_macro(char *macro)
{
    if(!macro)
        return;

    KeyInfo k;

    while(*macro)
    {
        if(*macro == FUNC_ESCAPE)
        {
            macro++;
            switch(unsigned(*macro))
            {
                case FUNC_ABORT            : doAbort            (); break;
                case FUNC_BKSP             : doBksp             (); break;
                case FUNC_CLOSE            : doClose            (); break;
                case FUNC_COPY             : doCopy             (); break;
                case FUNC_COPYRIGHT2       : doCopyright2       (); break;
                case FUNC_CUT              : doCut              (); break;
                case FUNC_DEL              : doDel              (); break;
                case FUNC_DELLINE          : doDelLine          (); break;
                case FUNC_DELTOEOL         : doDelToEOL         (); break;
                case FUNC_DELWORDLEFT      : doDelWordLeft      (); break;
                case FUNC_DELWORDRIGHT     : doDelWordRight     (); break;
                case FUNC_DOWN             : doDown             (); break;
                case FUNC_DOWNMARK         : doDownMark         (); break;
                case FUNC_DUPLICATE_LINE   : doDupLine          (); break;
                case FUNC_END              : doEnd              (); break;
                case FUNC_ENDMARK          : doEndMark          (); break;
                case FUNC_EXIT             : doExit             (); break;
                case FUNC_FILEBEGIN        : doFileBegin        (); break;
                case FUNC_FILEBEGINMARK    : doFileBeginMark    (); break;
                case FUNC_FILEEND          : doFileEnd          (); break;
                case FUNC_FILEENDMARK      : doFileEndMark      (); break;
                case FUNC_FILELIST         : doFileList         (); break;
                case FUNC_FLIPAUTOINDENT   : doFlipAutoindent   (); break;
                case FUNC_FLIPBLOCKMODE    : doFlipBlockMode    (); break;
                case FUNC_FLIPHILITING     : doFlipHiliting     (); break;
                case FUNC_FLIPWORDWRAP     : doFlipWordWrap     (); break;
                case FUNC_FLIPWWMERGE      : doFlipWWMerge      (); break;
                case FUNC_FLIPWWLONG       : doFlipWWLong       (); break;
                case FUNC_HELPSCREEN       : doHelpScreen       (); break;
                case FUNC_HOME             : doHome             (); break;
                case FUNC_HOMEMARK         : doHomeMark         (); break;
                case FUNC_INDENT           : doIndent           (); break;
                case FUNC_INS              : doIns              (); break;
                case FUNC_INSDATE          : doInsDate          (); break;
                case FUNC_INSFILENAME      : doInsFileName      (); break;
                case FUNC_INSFILENAMESHORT : doInsFileNameShort (); break;
                case FUNC_JUMPCOL          : doJumpCol          (); break;
                case FUNC_JUMPLINE         : doJumpLine         (); break;
                case FUNC_LEFT             : doLeft             (); break;
                case FUNC_LEFTMARK         : doLeftMark         (); break;
                case FUNC_LOAD             : doLoad             (); break;
                case FUNC_LOWER            : doLower            (); break;
                case FUNC_MACRORECEND      : doMacroRecEnd      (); break;
                case FUNC_MACRORECSTART    : doMacroRecStart    (); break;
                case FUNC_MATCHBRACKET     : doMatchBracket     (); break;
                case FUNC_MATCHBRACKETMARK : doMatchBracketMark (); break;
                case FUNC_NEW              : doNew              (); break;
                case FUNC_NEXTFILE         : doNextFile         (); break;
                case FUNC_PASTE            : doPaste            (); break;
                case FUNC_PGDN             : doPgDn             (); break;
                case FUNC_PGDNMARK         : doPgDnMark         (); break;
                case FUNC_PGUP             : doPgUp             (); break;
                case FUNC_PGUPMARK         : doPgUpMark         (); break;
                case FUNC_PREVFILE         : doPrevFile         (); break;
                case FUNC_RIGHT            : doRight            (); break;
                case FUNC_RIGHTMARK        : doRightMark        (); break;
                case FUNC_SAVE             : doSave             (); break;
                case FUNC_SAVEALL          : doSaveAll          (); break;
                case FUNC_SAVEAS           : doSaveAs           (); break;
                case FUNC_SEARCH           : doSearch           (); break;
                case FUNC_SEARCHAGAIN      : doSearchAgain      (); break;
                case FUNC_SORT             : doSort             (); break;
                case FUNC_UNDO             : doUndo             (); break;
                case FUNC_UNINDENT         : doUnindent         (); break;
                case FUNC_UP               : doUp               (); break;
                case FUNC_UPMARK           : doUpMark           (); break;
                case FUNC_UPPER            : doUpper            (); break;
                case FUNC_WORDLEFT         : doWordLeft         (); break;
                case FUNC_WORDLEFTMARK     : doWordLeftMark     (); break;
                case FUNC_WORDRIGHT        : doWordRight        (); break;
                case FUNC_WORDRIGHTMARK    : doWordRightMark    (); break;
                case FUNC_FLIPTYPE         : doFlipType         (); break;
                case FUNC_HILITE_ACHOICE   : doHilitingChoice   (); break;
                case FUNC_SET_XLAT         : doSetXlat          (); break;
                case FUNC_LOAD_KEYS        : doLoadProfile      (); break;

                case FUNC_REXX             : doRexx(++macro); return;

                case FUNC_BMK_PUT_0: case FUNC_BMK_PUT_1: case FUNC_BMK_PUT_2:
                case FUNC_BMK_PUT_3: case FUNC_BMK_PUT_4: case FUNC_BMK_PUT_5:
                case FUNC_BMK_PUT_6: case FUNC_BMK_PUT_7: case FUNC_BMK_PUT_8:
                case FUNC_BMK_PUT_9:
                    doSetMark(*macro - FUNC_BMK_PUT_0);
                    break;

                case FUNC_BMK_GET_0: case FUNC_BMK_GET_1: case FUNC_BMK_GET_2:
                case FUNC_BMK_GET_3: case FUNC_BMK_GET_4: case FUNC_BMK_GET_5:
                case FUNC_BMK_GET_6: case FUNC_BMK_GET_7: case FUNC_BMK_GET_8:
                case FUNC_BMK_GET_9:
                    doGotoMark(*macro - FUNC_BMK_GET_0);
                    break;

                case FUNC_JMP_LST_0: case FUNC_JMP_LST_1: case FUNC_JMP_LST_2:
                case FUNC_JMP_LST_3: case FUNC_JMP_LST_4: case FUNC_JMP_LST_5:
                case FUNC_JMP_LST_6: case FUNC_JMP_LST_7: case FUNC_JMP_LST_8:
                case FUNC_JMP_LST_9:
                    doJumpList(*macro - FUNC_JMP_LST_0);
                    break;

            }
            macro++;
        }
        else
        {
            k.key = *macro++;
            usual_key(k);
        }
    }
}

void EditBoxCollection::track_recording(char *macro, char chr)
{
    if(!recording)
        return;
    struct macro_rec *tmp = new macro_rec;
    tmp->macro = macro;
    tmp->chr   = chr;
    tmp->next  = 0;

    if(!head)
        head = tmp;

    if(tail)
        tail->next = tmp;
    tail = tmp;
}

void EditBoxCollection::clear_recording()
{
    struct macro_rec *tmp;

    while(head)
    {
        tmp = head->next;
        delete head;
        head = tmp;
    }
    head = tail = 0;
    recording = 0;
}

char* EditBoxCollection::track_recording_done()
{
    struct macro_rec *tmp;
    int len   = 0;
    char *out = 0;

    for(tmp = head; tmp; tmp = tmp->next)
    {
        if(tmp->macro)
            len += strlen(tmp->macro);
        else
            len++;
    }

    out = new char[len + 1];

    char *ptr = out;

    for(tmp = head; tmp; tmp = tmp->next)
    {
        if(tmp->macro)
        {
            char *str = tmp->macro;

            while(*str)
            {
                if(*str == FUNC_ESCAPE)
                {
                    if(*(str+1) == FUNC_MACRORECEND  ||
                       *(str+1) == FUNC_MACRORECSTART)
                    {
                        str++;
                        str++;
                    }
                    else
                    {
                        *ptr++ = *str++;
                        *ptr++ = *str++;
                    }
                }
                else
                    *ptr++ = *str++;
            }
        }
        else
            *ptr++ = tmp->chr;
    }
    *ptr = 0;

    return out;
}

void EditBoxCollection::start_recording()
{
    recording = 1;
}

