/*
** Module   :CLIPBRD.CPP
** Abstract :Clipboard-related methods of class Buffer
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  05/03/1997     Updated to V0.5
**      Sat  12/04/1997   	Updated to V0.8
**      Wed  12/11/1997     Updated to V0.9, mostly rewritten
**      Tue  12/12/2000     Single-char ops replaced by group operations
**                          to improve performance
*/

#include <stdlib.h>
#include <string.h>

#include <buffer.h>
#include <version.h>

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

Buffer* Buffer::copy()
{
    if(!mark_state)
        return 0;

    int mark_beg_row = min(old_abs_row, abs_row());
    int mark_end_row = max(old_abs_row, abs_row());

    Buffer* clip = new Buffer;
    if(col_block || mark_beg_row == mark_end_row)
    {
        int mark_col_start = min(old_abs_col, abs_col());
        int mark_col_end   = max(old_abs_col, abs_col());

        if(col_block)
        {
            clip->set_column_block(1);
            clip->num_cols = mark_col_end - mark_col_start;
        }

        for(int i = mark_beg_row; i <= mark_end_row; i++)
        {
            PLine ln = new Line(line(i), mark_col_start,
                                mark_col_end - mark_col_start);
            ln->xlat(cp_out);
            clip->add_line(ln);
        }
    }
    else
    {
        for(int i = mark_beg_row; i <= mark_end_row; i++)
        {
            if(i == mark_beg_row)
            {
                int col_start = (mark_beg_row == old_abs_row)
                            	? old_abs_col : abs_col();

                PLine ln = new Line(line(i), col_start, line(i)->len() - col_start);

                ln->xlat(cp_out);
                clip->add_line(ln);
                continue;
            }
            if(i == mark_end_row)
            {
                int col_end = (mark_end_row == old_abs_row)
                              ? old_abs_col : abs_col();

                if(col_end > line(i)->len())
                    col_end = line(i)->len();

                PLine ln = new Line(line(i), 0, col_end);

                ln->xlat(cp_out);
                clip->add_line(ln);
                continue;
            }

            //Default action

            PLine ln = new Line(line(i));

            ln->xlat(cp_out);
            clip->add_line(ln);
        }
    }
    clip->to_pm();
    return clip;
}

Buffer* Buffer::cut(Rect& rect)
{
    if(!mark_state)
        return 0;
    Buffer* clip = copy();
    clear(rect);
    changed = 1;
    return clip;
}

void Buffer::clear(Rect& rect)
{
    if(!mark_state)
        return;

    changed = 1;

    int mark_beg_row = min(old_abs_row, abs_row());
    int mark_end_row = max(old_abs_row, abs_row());

    if(col_block || mark_beg_row == mark_end_row)
    {
        int mark_col_start = min(old_abs_col, abs_col());
        int mark_col_end   = max(old_abs_col, abs_col());

        for(int i = mark_beg_row; i <= mark_end_row; i++)
        {
            track(opRestoreLine,(void *)line(i),(void *)i);
            line(i)->del_char(mark_col_start, mark_col_end - mark_col_start);
        }

        if(abs_col() != mark_col_start)
            goto_col(rect, mark_col_start);
    }
    else
    {
        int col_start;
        int col_end  ;

        /* mark_beg_row */

        col_start = (mark_beg_row == old_abs_row) ? old_abs_col : abs_col();
        col_end   = line(mark_beg_row)->len();

        track(opRestoreLine,(void *)line(mark_beg_row),(void *)mark_beg_row);

        int res = line(mark_beg_row)->del_char(col_start, col_end - col_start);

        /* mark_end_row */

        col_start = 0;
        col_end   = (mark_end_row == old_abs_row) ? old_abs_col : abs_col();

        track(opRestoreLine,(void *)line(mark_end_row),(void *)mark_end_row);

        line(mark_end_row)->del_char(col_start, col_end - col_start);

        /* other lines */

        int i = mark_end_row - (mark_beg_row + 1);

        if(i > 0)
        {
            Buffer *tmp_buf = new Buffer(i);
            remove_items(tmp_buf,(mark_beg_row + 1), i);
            track(opInsBlock,
                  (void *) tmp_buf,
                  (void *) (mark_beg_row + 1));
        }

        goto_line(rect, mark_beg_row);
        goto_col(rect, (mark_beg_row == old_abs_row) ? old_abs_col : abs_col());

        del_char(rect);
    }
    unmark();

    fill_hiliting(mark_beg_row, line(mark_beg_row)->state());
}

void Buffer::paste(Rect& rect, Buffer* clip)
{
    if(!clip)
        return;

    changed = 1;
    int recalc_row = abs_row()-1;

    if(recalc_row < 0)
        recalc_row = 0;

    int i,j;

    clip->from_pm();

    if(clip->col_block || clip->Count() == 1)
    {
        for(i = 0; i < clip->Count(); i++)
        {
            track(opRestoreLine, line(abs_row() + i), (void *)(abs_row() + i));

            PLine ln = new Line(clip->line(i));
            ln->xlat(cp_in);

            line(abs_row() + i)->ins_char(abs_col(), ln);

            if((i < clip->Count() - 1) && (abs_row() + i) == (Count() - 1))
            {
                track(opDelLine,(void *)(Count()));
                Add(new Line);
            }

            delete ln;
        }
    }
    else
    {
        PLine ln;

        for(i = 1; i < clip->Count() - 1; i++)
        {
            track(opDelLine,(void *)(abs_row() + i));
            ln = new Line(clip->line(i));
            ln->xlat(cp_in);

            At(ln, abs_row() + i);
        }

        ln = line(abs_row());
        track(opRestoreLine,(void *)ln,(void *)(abs_row()));

        PLine ln0 = new Line(ln, abs_col(), ln->len() - abs_col());

        ln->del_char(abs_col(), ln->len() - abs_col());

        ins_line(ln0, abs_row()+clip->Count()-1);
        track(opDelLine,(void *)(abs_row()+clip->Count()-1));

        PLine ln1 = new Line(clip->line(0));
        ln1->xlat(cp_in);
        ln->ins_char(abs_col(), ln1);

        delete ln1;

        ln1 = new Line(clip->line(clip->Count() - 1));
        ln1->xlat(cp_in);
        ln0->ins_char(0, ln1);

        delete ln1;

        goto_line(rect, abs_row() + clip->Count()-1);
        goto_col(rect, clip->line(clip->Count()-1)->len());
    }

    fill_hiliting(recalc_row, line(recalc_row)->state());
}

void Buffer::paste_over(Rect&,Buffer*)
{
    //Still unimplemented
    changed = 1;
}

