/*
** Module   :BSEARCH.CPP
** Abstract :Search routine
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Mon  15/03/1998     Created
*/

#include <buffer.h>
#include <_search.h>
#include <version.h>

#define UNDO    1

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

//----------------------------------------------------------------------
// Search routines
//
//----------------------------------------------------------------------

int Buffer::search(Rect& rect, char* flags, char *pattern)
{
    SearchEngine *s = 0;
    char *str = flags;
    int s_row = abs_row();
    int e_row = Count();
    int incr  = 1;
    int replace = 0;
    int ignore_case = 0;
    int i;

    if(!pattern || !pattern[0])
        return 0;

    while(*str)
    {
        switch(__to_upper(*str))
        {
            case 'E':
                if(!s)
                	s = new RXSearch;
                break;

            case 'I':
                if(!s)
                    s = new BMHISearch;

                ignore_case = 1;
                break;
/*
            case 'G':
                s_row = 0;
                e_row = Count();
                break;
*/
            case 'B':
                e_row = 0;

                if(s_row == 0)
                    s_row = abs_row();

                incr  = -1;
                break;
        }
        str++;
    }
    if(!s)
        s = new BMHSearch;
    str = 0;

    s->init(pattern, ignore_case);

    for(i = s_row; i != e_row; i += incr)
    {
        int match_len = 0;
        PLine ln = new Line(line(i), 0, line(i)->len());

        if(!ln || !ln->len())
        {
            delete ln;
            continue;
        }

        ln->xlat(cp_out);

    	s->middle(0);

        if(s->search(ln->str, match_len))
        {
            int jump_offset = 0;

            if(i == abs_row())
            {
                jump_offset = abs_col();
                if(found_len && found_row == i && found_col == jump_offset)
                    jump_offset += found_len;
                else
                    jump_offset += 1;
            }

            //cut off search past the end of srting

            if(jump_offset >= ln->len())
            {
                delete ln;
                continue;
            }

            if(jump_offset)
                s->middle(1);   //Tell search that we're in middle of string

            //char *new_str = new char[ln->len()+1];

            char *new_str = &ln->str[jump_offset];

            //ln->get_print(jump_offset, new_str, ln->len());

            //new_str[ln->len()] = 0;

            str = s->search(new_str, match_len);

            if(!str || (str - new_str + jump_offset) >= ln->len())
            {
                //delete new_str;
                delete ln;
                continue;
            }

            goto_line(rect, i);
            goto_col(rect, str - new_str + jump_offset);
            set_found(i, str - new_str + jump_offset, match_len);

            //delete new_str;
            delete ln;
            return match_len;
        }
        delete ln;
    }
    return 0;
}

int Buffer::replace(Rect&, char *repl)
{
    if(abs_col() != found_col || abs_row() != found_row || !repl)
       return 0;

    int i;
    changed = 1;

    for(i = 0; i < found_len; i++)
    {
        char chr = chr_out(abs_line()->del_char(abs_col()));
    	track(opInsChar, (void *)chr);
    }

    for(i = 0; *repl; i++)
    {
	    track(opDelChar);
        abs_line()->ins_char(chr_in(*repl++), abs_col() + i);
    }

    check_hiliting();

    found_len = i;

    return 1;
}

