/*
** Module   :BRACKET.CPP
** Abstract :Bracket matching routine
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Mon  15/03/1998     Created
*/

#include <buffer.h>
#include <version.h>

#define UNDO    1

#ifndef max
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif


//-----------------------------------------
// Bracket matching v 0.0.1a
//-----------------------------------------

struct brackets_pair
{
    char cLB;
    char cRB;
};

static brackets_pair brackets[]=
{
    {'(',')'},
    {'{','}'},
    {'[',']'},
    {'<','>'}
};

#define BM_FORWARD  0
#define BM_BACKWARD 1
#define BM_NONE     2

void Buffer::match_bracket(Rect& rect)
{
    int i;
    int direction = BM_NONE;
    int pair  = 0;
    int level = 0;
    int an_const = 0;

    char bracket = (char)abs_line()->char_at(abs_col());

    for(i = 0; i < (sizeof(brackets)/sizeof(brackets[0])); i++)
    {
        if(bracket == brackets[i].cLB)
        {
            // Bracket found, direction forward
            direction = BM_FORWARD;
            pair = i;
            break;
        }

        if(bracket == brackets[i].cRB)
        {
            // Bracket found, direction backward
            direction = BM_BACKWARD;
            pair = i;
            break;
        }
    }

    if(abs_col() &&
       abs_line()->char_at(abs_col() - 1) == '\'' &&
       abs_line()->char_at(abs_col() + 1) == '\'')
    {
        an_const = 1;
    }

    if(direction == BM_NONE)
        return;

    if(direction == BM_FORWARD)
    {
        //Direction: forward
        //quickly looking for bracket, then check other parameters
        int _row = abs_row();
        int _col = abs_col()+1;

        while(_row < Count())
        {
            PLine ln = line(_row);

            for(; _col < ln->len(); _col++)
            {
                if(ln->char_at(_col) != brackets[pair].cLB &&
                   ln->char_at(_col) != brackets[pair].cRB)
                {
                    continue;
                }

                if(an_const && (!_col ||
                                ln->char_at(_col - 1) != '\'' ||
                                ln->char_at(_col + 1) != '\''))
                {
                    continue;
                }

                if(!an_const &&
                   ln->char_at(_col - 1) == '\'' &&
                   ln->char_at(_col + 1) == '\'')
                {
                	continue;
                }

                if(ln->char_at(_col) == brackets[pair].cLB)
                {
                    level++;
                    continue;
                }

                if(ln->char_at(_col) == brackets[pair].cRB)
                {
                     if(level)
                     {
                         level--;
                         continue;
                     }

                     if(_row != abs_row())
                         goto_line(rect, _row);
                     goto_col(rect, _col);
                     return;
                }
            }
            _row++;
            _col = 0;
        }
    }
    else
    {
        int _row = abs_row();
        int _col = abs_col()-1;

        while(_row >= 0)
        {
            PLine ln = line(_row);

            for(; _col >= 0; _col--)
            {
                if(ln->char_at(_col) != brackets[pair].cLB &&
                   ln->char_at(_col) != brackets[pair].cRB)
                {
                    continue;
                }

                if(an_const && (!_col ||
                                ln->char_at(_col - 1) != '\'' ||
                                ln->char_at(_col + 1) != '\''))
                {
                    continue;
                }

                if(!an_const &&
                   ln->char_at(_col - 1) == '\'' &&
                   ln->char_at(_col + 1) == '\'')
                {
                    continue;
                }

                if(ln->char_at(_col) == brackets[pair].cRB)
                {
                    level++;
                    continue;
                }

                if(ln->char_at(_col) == brackets[pair].cLB)
                {
                    if(level)
                    {
                        level--;
                        continue;
                    }

                    if(_row != abs_row())
                        goto_line(rect, _row);
                    goto_col(rect, _col);
                    return;
                }
            }
            _row--;
            _col = line(_row) ? line(_row)->len() : 0;
        }
    }
}

