/*
** Module   :BOXCOLL.CPP
** Abstract :Edit box collection
**
** Copyright (C) Sergey I. Yevtushenko
** Copyright (C) Dmitry Froloff
**
** Log: Mon  16/06/1997 	Created
**      Tue  17/04/2001     Added mouse support
*/

#include <string.h>
#include <stdio.h>

#include <fio.h>
#include <stddlg.h>
#include <keynames.h>
#include <version.h>
#include <rx.h>

#define INCL_DOS
#define INCL_MOU
#include <os2.h>

#define MK_CLR(clr)     (app_pal[CL_APPLICATION_START+(clr)])

static void APIENTRY thTimer(ULONG data)
{
    EditBoxCollection* pEdit = (EditBoxCollection*) data;
    int i = 0;

    if(!pEdit)
        return;

    PMObj pm;

    while(!pEdit->isDown())
    {
        DosSleep(100);

        i++;

        if(i == 10)
        {
            pEdit->lock();
            pEdit->SendKey("kbTimer");
            pEdit->draw();
            pEdit->unlock();
            i = 0;
        }
    }
}

static void APIENTRY thMouse(ULONG data)
{
    MOUEVENTINFO Event;
    USHORT MouHandle = 0;
    USHORT ReadType = 1;
    APIRET rc;

    PMObj pm;

    EditBoxCollection* pEdit = (EditBoxCollection*) data;

    rc = MouOpen( 0L, &MouHandle );

    if(rc)
        return;

    rc = MouDrawPtr(MouHandle);

    while(!pEdit->isDown())
    {
        rc = MouReadEventQue(&Event, &ReadType, MouHandle);

        if(Event.fs & iMouseMask)
        {
            pEdit->lock();

            if(pEdit->current())
            {
                pEdit->track_beg();

                if(iSenseShift)
                {
                    if(kiLastKey.skey & shShift)
                        pEdit->current()->mark();
                    else
                        pEdit->current()->unmark();
                }

                pEdit->SetMouse(Event.row, Event.col);
                pEdit->track_end();

                pEdit->draw();
            }
            pEdit->unlock();
        }
    }

    MouClose(MouHandle);
}

static void APIENTRY thPipe(ULONG data)
{
    EditBoxCollection* pEdit = (EditBoxCollection*) data;

    if(!pEdit)
        return;

    PMObj pm;

    while(!pEdit->isDown())
    {
        if(!pEdit->npFED.IsValid())
        {
            DosSleep(200);
            pEdit->npFED.Open(cPipe);
        }
        else
        {
            char* s = 0;

            do
            {
                s = pEdit->npFED.ReadMsg();

//printf("%d - %d - %d\n", s, pEdit->npFED.IsValid(), pEdit->isDown());


	            if(!s || !pEdit->npFED.IsValid() || pEdit->isDown())
                    break;

	            char* p = s;

//printf("[%s]\n", s);

                if(!memicmp(p, "open ", 5))
                {
                    p += 5;

                    while(__issp(*p))
                        p++;

                    if(!*p)
                        break;

                    pEdit->lock();
                    pEdit->doOpenFile(p);
                    pEdit->draw();
                    pEdit->unlock();
                    break;
                }

                if(!memicmp(p, "cursor ", 7))
                {
                    p += 7;

                    while(__issp(*p))
                        p++;

                    if(!*p)
                        break;

                    pEdit->lock();
                    pEdit->set_xy(p);
                    pEdit->draw();
                    pEdit->unlock();
                    break;
                }
                             // kbPipe =
                if(!memicmp(p, "execute ", 8))
                {
                    memcpy(p, "kbPipe =", 8);
                    pEdit->lock();
                    pEdit->CompileKey(p, 6);
                    pEdit->SendKey("kbPipe");
                    pEdit->draw();
                    pEdit->unlock();
                    break;
                }

//printf("no match!\n", s);

                //Future extensions may go here..
            }
            while(0);

            delete s;
        }
    }
}

Initor::Initor()
{
    vio_init();
    InitREXX();
}

EditBoxCollection::EditBoxCollection():Collection(10,2),
                                       init(), keys(), prof_keys(), npFED(cPipe)
{
    cur_box   = 0;
    shutdown  = 0;
    recording = 0;

    head = tail = 0;
    tTID = (TID)-1;
    mTID = (TID)-1;
    pTID = (TID)-1;

    DosCreateMutexSem(0, &hMtx, 0, 0);
    DosCreateThread(&tTID, thTimer, (ULONG)this, 0, 0x80000);
    DosCreateThread(&mTID, thMouse, (ULONG)this, 0, 0x80000);
    DosCreateThread(&pTID, thPipe , (ULONG)this, 0, 0x80000);

    Clipboard = new Buffer;
    Clipboard->add_line(new Line);

    load_profile(0);    //Global profile
    load_profile(1);    //Local profile

    if(!keys.Count())
    {
        shutdown = 1;
    }

    open();
}

void EditBoxCollection::lock()
{
    DosRequestMutexSem(hMtx, (ULONG)-1);
}

void EditBoxCollection::unlock()
{
    DosReleaseMutexSem(hMtx);
}

void EditBoxCollection::CompileKey(char* str, int j)
{
    keys.InsKey(str, j);
}

void EditBoxCollection::Done()
{
    lock();
    RemoveAll();
    vio_shutdown();

//    DosCloseMutexSem(hMtx);
//    DosWaitThread(&tTID, DCWW_WAIT);
//    DosWaitThread(&pTID, DCWW_WAIT);
//    DosWaitThread(&mTID, DCWW_WAIT);

#ifdef PRINT_HEAP_STATS
    void print_heap_stat(void);
    print_heap_stat();
#endif
}

void EditBoxCollection::Free(Ptr p)
{
    delete (EditBox*)p;
}

void EditBoxCollection::SendKey(char *key)
{
    KeyInfo k;

    k.skey = shIsCtrl;
    strcpy(k.KeyName, key);
    Dispatcher(k);
}

void EditBoxCollection::SetMouse(int new_row, int new_col)
{
    current()->put_mouse(*current(), new_row, new_col);
}

EditBox* EditBoxCollection::current()
{
    return GetBox(cur_box);
}

EditBox* EditBoxCollection::next()
{
    cur_box++;
    if(cur_box >= Count())
        cur_box = 0;
    return current();
}

EditBox* EditBoxCollection::prev()
{
    cur_box--;
    if(cur_box < 0)
        cur_box = Count()-1;
    return current();
}

EditBox* EditBoxCollection::select(int new_cur)
{
    if(new_cur < Count())
        cur_box = new_cur;
    return current();
}

EditBox* EditBoxCollection::locate(int num)
{
    for(int i = 0; i < Count(); i++)
    {
        if(GetBox(i)->number() == num)
        {
            select(i);
            break;
        }
    }
    return current();
}

void EditBoxCollection::select(EditBox* new_box)
{
    for(int i = 0; i < Count(); i++)
    {
        if(new_box == GetBox(i))
        {
            select(i);
            break;
        }
    }
}

EditBox* EditBoxCollection::open()
{
    EditBox* new_box = new EditBox(0,0, Rows - 1, Cols);

    if(iUpperStatus)
        new_box->row++;

    Add(new_box);
    return new_box;
}

void EditBoxCollection::close()
{
    EditBox* box = (EditBox *)Remove(cur_box);
    delete box;

    if(!Count())
        open();
}

int EditBoxCollection::opened(char *fname)
{
    char* _cname = get_full_name(fname);

    for(int i = 0; i < Count(); i++)
    {
        if(!__cstrcmp(GetBox(i)->get_name(), _cname))
        {
            delete _cname;
            return i;
        }
    }
    delete _cname;
    return -1;
}

void EditBoxCollection::draw()
{
    if(!current())
        return;

    current()->draw();

    char* str = statusline;
    char* ptr = cName;

    if(!str || !ptr)
        return;

    int fminlen = 0;

    for(;*str; str++)
    {
        if(*str == '%')
        {
            char *out = 0;
            int minlen = 0;
            str++;

            if(!*str)
                break;

            while(__isdd(*str))
            {
                minlen *= 10;
                minlen += *str++ - '0';
            }

            switch(*str)
            {
                case 'n': out = cvt_num(current()->number(), 0);        	break;
                case 'r': out = cvt_num(current()->get_edit_row(), minlen); break;
                case 'c': out = cvt_num(current()->get_edit_col(), minlen); break;
                case 'd': out = cvt_num(current()->get_cur_char(), minlen); break;
                case 'p': out = cvt_num(current()->get_rel_pos() , minlen); break;
                case 'x': out = xcvt_char(current()->get_cur_char());   	break;
                case 'h': out = Parser::NameByKey(current()->get_hiliting()); break;
                case 'l': out = current()->get_cur_cp();                    break;

                case 'a': *ptr++ = (current()->get_auto_indent() ? 'I':' '); break;
                case 'u': *ptr++ = (current()->get_changed() ? '*':' ');     break;
                case 't': *ptr++ = (current()->get_unix() ? 'U':'D');        break;
                case 'm': *ptr++ = (current()->get_column_block() ? 'C':'S');break;

                case 'f': out = current()->get_fmt_name(minlen, '');
                          fminlen = minlen;
                          break;

                case 'w':
                    if(!(current()->ww_get() & WW_STATE))
                        *ptr++ = ' ';
                    else
                        *ptr++ = (current()->ww_get() & WW_MERGE ? 'M':'W');
                    break;

                default:
                    if(*str)
                        *ptr++ = *str;
                    break;
            }

            if(out)
                while(*out)
                    *ptr++ = *out++;
            continue;
        }
        *ptr++ = *str;
    }
    *ptr = 0;

    int sRow = (iUpperStatus) ? (0):(Rows - 1);

    vio_print2(sRow, 0, cName, Cols, MK_CLR(CL_STATUSLINE));

    if(recording)
        vio_print2(sRow, Cols - 1, "R", 1, 0xF0);

    strcpy(cName, "FED-");
    strcat(cName, current()->get_fmt_name(fminlen));
    set_title(cName);
}

int EditBoxCollection::check_save()
{
    if(!current())
        return 0;

    EditBox* cur = current();

    do
    {
        if(current()->get_changed())
        {
            draw();

            int rc = AChoice(5, 5, Yes_No, "Save?");

            switch(rc)
            {
                case -1:
                case  2:
                    select(cur);
                    return -1;
                case  0:

                    if(current()->is_untitled())
                    {
                        rc = FileDialog(5, 5, cName, 2);
                        if(!rc)
                            current()->save_as(cName);
                        else
                            return -1;
                    }
                    if(current()->save())
                    {
                        MessageBox("Error saving file!");
                        return -1;
                    }
            }
        }
        else
            current()->save(); //Indeed just put EA and ignore error

        next();
    }
    while(current() != cur);
    return 0;
}

void EditBoxCollection::search_proc()
{
    if(!current())
        return;

    if(strchr(Flags, 'g') || strchr(Flags, 'G'))    //Global search
        doFileBegin();

    int rc = current()->search(Flags, Search);

    if(!rc)
    {
        if(iVSearch)
            MessageBox("\n No occurences found! \n");
        return;
    }

    if(rc && (strchr(Flags, 'r') || strchr(Flags, 'R')))
    {
        // Replace mode
        if((strchr(Flags, 'n') ||
            strchr(Flags, 'N'))) //Noask
        {
            do
            {
                current()->replace(Replace);
            }
            while(current()->search(Flags, Search));

            if(iVSearch)
                MessageBox("\n Done. \n");
        }
        else //Confirmation
        {
            do
            {
                int rr;
                int cc;

                if(current()->get_cur_row() < (Rows - 7))
                    rr = current()->get_cur_row() + 2;
                else
                    rr = current()->get_cur_row() - 7;

                if(current()->get_cur_col() < (Cols - 12))
                    cc = current()->get_cur_col();
                else
                    cc = current()->get_cur_col() - 12;

                draw();

                rc = AChoice(rr, cc, Yes_No, "Replace?");
                if(rc == 0)
                    current()->replace(Replace);
                if(rc == 2 || rc == -1)
                    break;
            }
            while(current()->search(Flags, Search));

            if(rc != 2 && rc != -1 && iVSearch)
                MessageBox("\n Done. \n");
        }
    }
}

void EditBoxCollection::track_beg()
{
    for(int i = 0; i < Count(); i++)
    {
        GetBox(i)->track_beg();
    }
}

void EditBoxCollection::track_end()
{
    for(int i = 0; i < Count(); i++)
    {
        GetBox(i)->track_end();
    }
}

void EditBoxCollection::track_cancel()
{
    for(int i = 0; i < Count(); i++)
    {
        GetBox(i)->track_cancel();
    }
}

void EditBoxCollection::usual_key(KeyInfo& k)
{
    if(current()->get_mark_state())
        current()->clear(*current());

    if(current()->get_ins_mode())
        current()->ins_char(*current(), k.key);
    else
        current()->replace_char(*current(), k.key);
}

void EditBoxCollection::set_xy(char *ptr)
{
    int cX = 0;
    int cY = 0;

    if(!current())
        return;

    while(*ptr && __isdd(*ptr))
    {
        cX *= 10;
        cX += *ptr - '0';
        ptr++;
    }

    if(*ptr)
        ptr++;

    while(*ptr && __isdd(*ptr))
    {
        cY *= 10;
        cY += *ptr - '0';
        ptr++;
    }

    if(cX > 0)
        current()->goto_line(*current(), cX - 1);
    if(cY > 0)
        current()->goto_col(*current(), cY - 1);
}

