/*
** Module   :BCOMMAND.CPP
** Abstract :Editor Commands
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  25/03/1998     Created
*/

#include <stddlg.h>
#include <string.h>
#include <stdio.h>

#include <boxcoll.h>
#include <fio.h>
#include <dialog.h>
#include <keynames.h>
#include <version.h>

#define INCL_REXXSAA
#ifdef __EMX__
extern "C" {
#include <os2emx.h>
}
#else
#include <rexxsaa.h>
#endif

#define MK_CLR(clr)     (app_pal[CL_APPLICATION_START+(clr)])

extern JumpList JList[];
//---- General

void EditBoxCollection::doSave()
{
    if (current()->is_untitled())
		doSaveAs();
    else
    {
        if(current()->save())
            MessageBox("Error saving file!");
    }
}

void EditBoxCollection::doSaveAs()
{
    int rc = FileDialog(5, 5, cName, 2);

    if (!rc)
    {
        if(current()->save_as(cName))
            MessageBox("Error saving file!");
    }
}

void EditBoxCollection::doLoad()
{
    int rc = FileDialog(2, 2, cName, 0);

	if (!rc)
        doOpenFile(cName);
}

void EditBoxCollection::doOpenFile(char *pName)
{
    int rc = opened(pName);

    if(rc < 0)
    {
        if (!current()->is_untitled() ||
            current()->get_changed())
                select(open());

        current()->load(pName);
        SendKey("kbOpen");
    }
    else
        select(rc);
}

void EditBoxCollection::doNew()
{
	select(open());
    SendKey("kbOpen");
}

void EditBoxCollection::doClose()
{
    SendKey("kbClose");

    if(!current()->check_save())
	{
		close();
		select(0);
	}
}

void EditBoxCollection::doHelpScreen()
{
	Dialog dlg(2, 2, Rows - 4, Cols - 4);
	ListBox *list = new ListBox(1, 1, dlg.rows - 2, dlg.cols - 2);

    dlg.Ins(list);

    char *str;
    char *ptr;

    for(ptr = str = help_text; *str;)
    {
        char chr;

        while(*str && *str != '\n')
            str++;

        chr = *str;
        *str = 0;

        list->add_at_end(ptr);

        *str = chr;

        if(*str)
            str++;

        ptr = str;
    }

    KeyInfo k;

	do
	{
		dlg.draw();
		vio_read_key(&k);
		dlg.do_key(k);
	}
	while (k.skey != (kbEsc | shIsCtrl));
}

void EditBoxCollection::doNextFile()
{
	next();
}

void EditBoxCollection::doPrevFile()
{
	prev();
}

void EditBoxCollection::doSort()
{
    current()->sort();
}

void EditBoxCollection::doSearch()
{
	int rr;
	int rc;

	if (current()->get_cur_row() >= Rows / 2)
		rr = 3;
	else
		rr = Rows / 2;

	rc = SearchReplace(rr,
					   3,
					   Search,
					   Replace,
					   Flags);
	if (!rc)
	{
		search_proc();
	}
}

void EditBoxCollection::doSearchAgain()
{
	search_proc();
}

void EditBoxCollection::doFileList()
{
    Dialog dlg(2,2, Rows - 4 , Cols - 4);
    ListBox *list = new ListBox(1, 1, dlg.rows - 2, dlg.cols - 2);

    dlg.Ins(list);

    int i;

    for(i = 0; i < Count(); i++)
    {
        EditBox* one = GetBox(i);

        cName[0] = one->get_changed() ? '*':' ';
        strcpy(&cName[1], one->get_fmt_name(list->cols - 1));

        list->add_at_end(cName);

        if(one == current())
            list->go_item(i);
    }

    KeyInfo k;
    do
    {
        dlg.draw();
        vio_read_key(&k);

        if((k.skey & 0x00FF) == kbEnter ||
           (k.skey & 0x00FF) == kbGrEnter)
        {
            select(list->first_selected());
            return;
        }
        dlg.do_key(k);
    }
    while(k.skey != (kbEsc | shIsCtrl));
}

void EditBoxCollection::doSaveAll()
{
    EditBox *cur = current();

	do
	{
		current()->save();
		next();
	}
	while (current() != cur);
}

void EditBoxCollection::doJumpLine()
{
	int rr;

	if (current()->get_cur_row() >= Rows / 2)
		rr = 3;
	else
		rr = Rows / 2;

	int place = 0;
	int rc = AskNumber(rr, 3, &place, "Goto Line");

	if (!rc)
	{
		current()->goto_line(*current(), place - 1);
	}
}

void EditBoxCollection::doJumpCol()
{
	int rr;

	if (current()->get_cur_row() >= Rows / 2)
		rr = 3;
	else
		rr = Rows / 2;

	int place = 0;
	int rc = AskNumber(rr, 3, &place, "Goto Column");

	if (!rc)
	{
		current()->goto_col(*current(), place - 1);
	}
}

void EditBoxCollection::doExit()
{
    if(check_save() == -1)
        shutdown = 0;
    else
        shutdown = 1;
}

void EditBoxCollection::doAbort()
{
	shutdown = 1;
}

void EditBoxCollection::doCopyright()
{
    static char * copyright[]=
    {
        "FAST Editor Lite for OS/2 "VERSION,
        "Copyright (C) Sergey I. Yevtushenko, 1997-2000",
        0
    };

    vio_cls(MK_CLR(CL_DEFAULT));
    int i;

    for(i = 0; copyright[i]; i++)
        vio_print(i + 1, 1,copyright[i], Cols, MK_CLR(CL_DEFAULT));

    vio_show();
}

void EditBoxCollection::doCopyright2()
{
    doCopyright();
    KeyInfo k;
    vio_read_key(&k);
}
//--------------------------------------------------------------
//---- Cursor movement

void EditBoxCollection::doLeft()
{
	current()->unmark();
	current()->cursor_left(*current());
}
void EditBoxCollection::doWordLeft()
{
	current()->unmark();
	current()->word_left(*current());
}
void EditBoxCollection::doRight()
{
	current()->unmark();
	current()->cursor_right(*current());
}
void EditBoxCollection::doWordRight()
{
	current()->unmark();
	current()->word_right(*current());
}
void EditBoxCollection::doPgUp()
{
	current()->unmark();
	current()->page_up(*current());
}
void EditBoxCollection::doFileBegin()
{
	current()->unmark();
	current()->text_begin(*current());
}
void EditBoxCollection::doPgDn()
{
	current()->unmark();
	current()->page_down(*current());
}
void EditBoxCollection::doFileEnd()
{
	current()->unmark();
	current()->text_end(*current());
}
void EditBoxCollection::doHome()
{
	current()->unmark();
	current()->line_begin(*current());
}
void EditBoxCollection::doEnd()
{
	current()->unmark();
	current()->line_end(*current());
}
void EditBoxCollection::doUp()
{
	current()->unmark();
	current()->cursor_up(*current());
}
void EditBoxCollection::doDown()
{
	current()->unmark();
	current()->cursor_down(*current());
}
void EditBoxCollection::doMatchBracket()
{
	current()->unmark();
	current()->match_bracket(*current());
}

//---- Block marking
void EditBoxCollection::doLeftMark()
{
	current()->mark();
	current()->cursor_left(*current());
}
void EditBoxCollection::doWordLeftMark()
{
	current()->mark();
	current()->word_left(*current());
}
void EditBoxCollection::doRightMark()
{
	current()->mark();
	current()->cursor_right(*current());
}
void EditBoxCollection::doWordRightMark()
{
	current()->mark();
	current()->word_right(*current());
}
void EditBoxCollection::doPgUpMark()
{
	current()->mark();
	current()->page_up(*current());
}
void EditBoxCollection::doFileBeginMark()
{
	current()->mark();
	current()->text_begin(*current());
}
void EditBoxCollection::doPgDnMark()
{
	current()->mark();
	current()->page_down(*current());
}
void EditBoxCollection::doFileEndMark()
{
	current()->mark();
	current()->text_end(*current());
}
void EditBoxCollection::doHomeMark()
{
	current()->mark();
	current()->line_begin(*current());
}
void EditBoxCollection::doEndMark()
{
	current()->mark();
	current()->line_end(*current());
}
void EditBoxCollection::doUpMark()
{
	current()->mark();
	current()->cursor_up(*current());
}
void EditBoxCollection::doDownMark()
{
	current()->mark();
    current()->cursor_down(*current());
}
void EditBoxCollection::doMatchBracketMark()
{
	current()->mark();
	current()->match_bracket(*current());
}

//---- Editing commands

void EditBoxCollection::doUpper()
{
    current()->toupper(*current());
}
void EditBoxCollection::doLower()
{
    current()->tolower(*current());
}
void EditBoxCollection::doBksp()
{
	current()->back_space(*current());
}
void EditBoxCollection::doDel()
{
	if (current()->get_mark_state())
		current()->clear(*current());
	else
		current()->del_char(*current());
    current()->unmark();
}

void EditBoxCollection::doDelLine()
{
	PLine line = current()->del_line(*current(), current()->abs_row());
	delete line;
}

void EditBoxCollection::doDupLine()
{
    current()->dup_line(*current(), current()->abs_row());
}

void EditBoxCollection::doDelWordLeft()
{
	current()->del_word_left(*current());
}
void EditBoxCollection::doDelWordRight()
{
	current()->del_word_right(*current());
}
void EditBoxCollection::doDelToEOL()
{
	current()->del_to_EOL(*current());
}
void EditBoxCollection::doIndent()
{
	current()->indent();
}
void EditBoxCollection::doUnindent()
{
	current()->unindent();
}

void EditBoxCollection::doCut()
{
	delete Clipboard;

	Clipboard = current()->cut(*current());
}
void EditBoxCollection::doCopy()
{
	delete Clipboard;

	Clipboard = current()->copy();
}
void EditBoxCollection::doPaste()
{
	if (current()->get_mark_state())
	{
		current()->clear(*current());
		current()->unmark();
	}
	current()->paste(*current(), Clipboard);
}

void EditBoxCollection::doUndo()
{
    current()->track_cancel();
    current()->undo(*current());
}

//---- State commands
void EditBoxCollection::doIns()
{
	current()->set_ins_mode(1 - current()->get_ins_mode());
}
void EditBoxCollection::doFlipBlockMode()
{
	current()->set_column_block(1 - current()->get_column_block());
}
void EditBoxCollection::doFlipAutoindent()
{
	current()->set_auto_indent(1 - current()->get_auto_indent());
}
void EditBoxCollection::doFlipHiliting()
{
	current()->flip_hiliting();
}
void EditBoxCollection::doFlipType()
{
    current()->set_unix(1 - current()->get_unix());
}

void EditBoxCollection::doInsDate()
{
    char buff[FED_MAXPATH];

    if(!curr_date_str(buff))
        play_macro(buff);
}

void EditBoxCollection::doInsFileName()
{
    play_macro(current()->get_name());
}

void EditBoxCollection::doInsFileNameShort()
{
    char buff[FED_MAXPATH];
    make_short_name(current()->get_name(), buff);
    play_macro(buff);
}

//---- Macro Recorder commands

void EditBoxCollection::doMacroRecStart()
{
    start_recording();
}

void EditBoxCollection::doMacroRecEnd()
{
    if(!recording)
        return;

    char *macro = track_recording_done();
    clear_recording();
    KeyInfo k;

    MessageBox("Press key to assign recorded macro\n <ESC> - cancel", &k);

    if(k.skey != (kbEsc | shIsCtrl))
        keys.AddAssignment(k.KeyName, macro);
    delete macro;
}

//---- Rexx macro processor

void EditBoxCollection::doRexx(char* prog)
{
    RXSTRING INSTORE[2];
    RXSTRING arg;
    RXSTRING rexxretval;
    SHORT    rexxrc = 0;
    APIRET   rc;

    INSTORE[0].strptr    = (PCH)prog;
    INSTORE[0].strlength = strlen(prog);
    INSTORE[1].strptr    = 0;
    INSTORE[1].strlength = 0;

    arg.strptr    = (PCH)"";
    arg.strlength = 0;
    rexxretval.strptr    = 0;
    rexxretval.strlength = 0;

    rc=RexxStart((LONG)      1,
                (PRXSTRING)  &arg,
                (PSZ)        "FED_RX",
                (PRXSTRING)  INSTORE,
                (PSZ)        "FED",
//                (LONG)       RXSUBROUTINE,
                (LONG)       RXFUNCTION,
                (PRXSYSEXIT) 0,
                (PSHORT)     &rexxrc,
                (PRXSTRING)  &rexxretval);

    DosFreeMem(rexxretval.strptr);
}

void EditBoxCollection::doSetMark(int i)
{
    current()->bmk_place(i);
}

void EditBoxCollection::doGotoMark(int i)
{
    current()->bmk_go(i);
}

void EditBoxCollection::doJumpList(int i)
{
    if(i >= 0 && i <= 9)
        JumpListBox(&JList[i], 0, 0, 0, 0);
}

void EditBoxCollection::doSetXlat()
{
    int rr;

    if (current()->get_cur_row() >= Rows / 2)
        rr = 3;
    else
        rr = Rows / 2;

    int place = 0;
    int rc = AskNumber(rr, 3, &place, "Code page ");

    if (!rc && place > 0)
    {
        char cp[64];
        char *cp_num = cvt_num(place, 3);
        strcpy(cp, "IBM-");
        strcat(cp, cp_num);

        current()->set_xlate(cp);
    }
}

void EditBoxCollection::doHilitingChoice()
{
    char** hl_names = new char* [Parser::Count()+1];

    int i;

    for(i = 0; i < Parser::Count(); i++)
        hl_names[i] = Parser::Name(i, 1);

    hl_names[i] = 0;

    int rc = AChoice(5, 5, hl_names, "Mode");

    if(rc >= 0)
    {
        current()->set_hiliting(Parser::Type(rc));
        current()->fill_hiliting(0, ST_INITIAL);
    }

    delete hl_names;
}

void EditBoxCollection::doLoadProfile()
{
    int sz = 0;
    int i;

    for(i = 0; i < current()->Count(); i++)
    {
        sz += current()->line(i)->len();
        sz += 2; //CRLF
    }
    sz++; //NULL terminator

    char *pByte = new char[sz];

    char *ptr = pByte;

    for(i = 0; i < current()->Count(); i++)
    {
        current()->line(i)->build_print(ptr);
        ptr += current()->line(i)->len();
        *ptr++ = '\r';
        *ptr++ = '\n';
        *ptr   = 0;
    }

    int iSaveStatus = iUpperStatus;

    load_profile(pByte);

    if(iSaveStatus != iUpperStatus)
    {
        int iShift = (iUpperStatus) ? 1:-1;

        for(i = 0; i < Count(); i++)
            GetBox(i)->row += iShift;
    }

    delete pByte;
}

void EditBoxCollection::doFlipWordWrap()
{
    current()->ww_set(current()->ww_get() ^ WW_STATE);
}

void EditBoxCollection::doFlipWWMerge()
{
    current()->ww_set(current()->ww_get() ^ WW_MERGE);
}

void EditBoxCollection::doFlipWWLong()
{
    current()->ww_set(current()->ww_get() ^ WW_LONG);
}

