/*
** Module   :_CTYPE.CPP
** Abstract : NLS support routines
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Sat  03/05/1997   	Updated
*/

#define INCL_DOSNLS
#include <os2.h>

#include <_ctype.h>
#include <version.h>

void __nls_init(void)
{
    COUNTRYCODE Country;
    COUNTRYINFO CtryInfo = {0};
    ULONG ulLen;
    unsigned i;
    APIRET rc;

    for(i = 0; i < 256; i++)
    {
        toupper_cvt_table[i] = (char)i;
        tolower_cvt_table[i] = (char)i;
        collate_cvt_table[i] = (char)i;
    }

    for(i = 'a'; i <= 'z'; i++)
    {
        toupper_cvt_table[i] = (char)(i - 'a' + 'A');
    }

    for(i = 'A'; i <= 'Z'; i++)
    {
        tolower_cvt_table[i] = (char)(i - 'A' + 'a');
    }

    Country.country  = 0;
    Country.codepage = 0;

    rc = DosMapCase(256,
                    &Country,
                    toupper_cvt_table);

    DD_TRACE("DosMapCase",rc);

    if(rc)
        return;

    rc = DosQueryCollate(256,
                         &Country,
                         collate_cvt_table,
                         &ulLen);

    DD_TRACE("DosQueryCollate",rc);

    rc = DosQueryCtryInfo(sizeof(CtryInfo), &Country,
                          &CtryInfo, &ulLen);

    DD_TRACE("DosQueryCtryInfo",rc);

    if(!rc)
    {
        iDateFmt = CtryInfo.fsDateFmt;
      //  cDateSep = CtryInfo.szDateSeparator[0];
    }
    for(i = 128; i < 256; i++)
    {
        if((unsigned char)toupper_cvt_table[i] > (unsigned char)0x7F)
        	tolower_cvt_table[(unsigned char)toupper_cvt_table[i]] = (char)i;
    }
    for(i = 128; i < 256; i++)
    {
        __r_ctype[i] = (tolower_cvt_table[i] != toupper_cvt_table[i]) ?
                        (IS_AL | IS_IS) :
                        (IS_PU);
    }
}

int __nstrcmp(char *s0, char *s1, char *cvt_tbl)
{
    if(!s0 || !s1)
        return (s0) ? 1:-1;

    while(*s0 || *s1)
    {
        if(collate_cvt_table[cvt_tbl[*s0]] == collate_cvt_table[cvt_tbl[*s1]])
        {
            s0++;
            s1++;
            continue;
        }

        if(collate_cvt_table[cvt_tbl[*s0]] > collate_cvt_table[cvt_tbl[*s1]])
            return 1;
        if(collate_cvt_table[cvt_tbl[*s0]] < collate_cvt_table[cvt_tbl[*s1]])
            return -1;
    }
    return 0;
}

int __cstrcmp(char *s0, char *s1)
{
    if(!s0 || !s1)
        return (s0) ? 1:-1;
    while(*s0 || *s1)
    {
        if(__to_lower(*s0) == __to_lower(*s1))
        {
            *s0++;
            *s1++;
            continue;
        }

        if(__to_lower(*s0) > __to_lower(*s1))
            return 1;
        if(__to_lower(*s0) < __to_lower(*s1))
            return -1;
    }
    return 0;
}

int __cnstrcmp(char *s0, char *s1, int n)
{
    if(!s0 || !s1 || n <= 0)
        return (s0) ? 1:-1;

    while(n--)
    {
        if(__to_lower(*s0) == __to_lower(*s1))
        {
            *s0++;
            *s1++;
            continue;
        }

        if(__to_lower(*s0) > __to_lower(*s1))
            return 1;
        if(__to_lower(*s0) < __to_lower(*s1))
            return -1;
    }
    return 0;
}

char* __cstrchr(char* s0, int chr)
{
    if(!s0)
        return 0;

    chr = __to_lower(chr);

    while(*s0)
    {
        if(__to_lower(*s0) == chr)
            return s0;

        s0++;
    }
    return 0;
}

#ifdef __GNUC__
extern "C" void __rtti_user(void);
void __rtti_user(void) {}
extern "C" void __rtti_si(void);
void __rtti_si(void) {}
extern "C" void __rtti_class(void);
void __rtti_class(void) {}
extern "C" void __eh_pc(void);
void __eh_pc(void){}
//extern "C" void terminate(void)
void terminate(void) {}
#endif
