/*
** Module   :VARPOOL.H
** Abstract :
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  29/09/1999 Created
**
*/

#include <collect.h>

#ifndef __VARPOOL_H
#define __VARPOOL_H

class VarPoolItem
{
        char *cName;
        char *cValue;
    public:

        VarPoolItem(char *pName, char *pValue =0);
    	~VarPoolItem();

        void  set(char *pValue);
        char *get()             { return cValue;}
        char *name()            { return cName; }

};

class VarPool: public SortedCollection
{
        virtual void Free(Ptr p)    { delete ((VarPoolItem *)p);}
        virtual int Compare(Ptr p1, Ptr p2);

        VarPoolItem* LocateVar(char *name, int iCreate);

    public:

        VarPool();
        virtual ~VarPool();

        void del(char *name);
        void drop(char *namestart);
        void set(char *name, char *value);
        char* get(char *name);
};

#endif  /*__VARPOOL_H*/

