/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */
#ifndef  __REGEXP_H
#define  __REGEXP_H

#define NSUBEXP  10

#define regexcase(r,st) (r)->regcase=(st)

typedef struct regexp {
	char *startp[NSUBEXP];
    char *endp[NSUBEXP];
    int regcase;
    int regbol_off;
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;

regexp* regcomp(char *exp);
int regexec(regexp *prog, char *string);
void regsub(regexp *prog, char *source, char *dest);
void regerror(char *s);

void regexp_bol_off(regexp *prog);  /* Disable matching of BOL */
void regexp_bol_on(regexp *prog);   /* Enable matching of BOL  */

#endif

