/*
** Module   :LINE.H
** Abstract :Class Line handles one line of editor
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  05/03/1997   	Updated to V0.5
*/

#include <collect.h>
#include <common.h>
#include <parser.h>

#ifndef  __LINE_H
#define  __LINE_H

#define BC_STEP     16

class ByteCache
{
        char* buf;      //Buffer of pairs color/len
        int   len;      //Buffer len
        int   pos;      //Last requested position rounded down to token len
        int   bpos;     //Last position in buffer for 'pos'

        int   enc;      //Current encoding position
        int   last_pos; //Last encoded position

#define q_len(p)    ((buf[p] & 0x0F) + 1)

        void expand_buffer();
        int unwind(int qry);
        int unwind2(int qry)
        {
            if(qry > last_pos || !len)
            	return 0;

            if(qry >= pos && qry < (pos + q_len(bpos)))
                return buf[bpos];

            pos += q_len(bpos);
            bpos++;

            if(qry >= pos && qry < (pos + q_len(bpos)))
                return buf[bpos];

            return unwind(qry);
        }

    public:

        ByteCache():buf(0),len(0)   	{ reset();}
        ~ByteCache()                	{ delete buf;}

        //Direct access (ReadOnly)
        int get_color(int pos)  { return unwind2(pos) >> 4;}
        int get_len  (int pos)  { return (unwind2(pos) & 0x0F) + 1;}

        //Stream encoding (WroteOnly)
        void reset()                     { pos = bpos = enc = last_pos = 0;}
        void encode(int color, int len);
};

class Line;
typedef Line* PLine;

class Line
{
        int buf_len;
        int known_len;
        int hl_state;

        void expand_by(int len);
        void check_size(int sz) { if(sz >= buf_len) expand_by(sz - buf_len); }

    public:
        char *str;
//        ByteCache bc;

        Line();
        Line(char *);
        Line(PLine);
        Line(PLine master, int start, int width);

        ~Line();
        void set(char *str);
        char * get_print(int start, char *buffer, int width);
        int ins_char(int chr, int pos);
        int ins_char(int pos, PLine src);
        int del_char(int pos, int num = 1);
        int len();
        void touch();
        int char_at(int pos);
        int fchar_at(char *tmp, int pos) { return (pos < len()) ? tmp[pos]:0;}
        void build_print(char*);
        void xlat(char *cvt_tbl);

        int state() { return hl_state;}

        void set_hiliting(Parser*, int& initial_state);
};

#endif //__LINE_H

