/*
** Module   :KEYCOLL.H
** Abstract :Key bindings container
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Fri  27/03/1998     Created
*/

#include <collect.h>
#include <vio.h>
#include <common.h>
#include <dict.h>

#ifndef __KEYCOLL_H
#define __KEYCOLL_H

class FunctionDictionary: public Dictionary
{
    public:
        FunctionDictionary();
};

struct keydef_pair
{
    char key[KEY_NAME_LEN];
    char prog[1];
};

int macro_len(char *macro);

class KeyDefCollection:public SortedCollection
{
    	FunctionDictionary Func_DIC;
        int compile_keydef(char *str, char *out);
	public:
        KeyDefCollection():SortedCollection(),Func_DIC() {bDuplicates = 0;}

        virtual int Compare(Ptr p1, Ptr p2);

        void InsKey(char *buf, int namelen);
        void AddAssignment(char *keyname, char *prog);

        char *GetDef(char *key);
};

#endif  /* __KEYCOLL_H */

