/*
** Module   :EDITBOX.H
** Abstract :EditBox control representation class
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Sat  03/05/1997   	Created
*/

#include <buffer.h>

#ifndef  __EDITBOX_H
#define  __EDITBOX_H

//-------------------------------------------------------
// class EditBox

class EditBox: public Rect, public Buffer
{
        struct
        {
            int row;
            int col;
        }
        bookmark[BMK_NUM];

        char *name;
        char *orig_file;
        int num;
        static short used;
    public:

        EditBox(int, int, int, int);
        virtual ~EditBox();

        int load(char* name);
        int save_as(char* name);
        int set_name(char *name);
        int new_file();
        int save();
        int close();
        void draw();
        int search(char* flags, char *patt);
        int replace(char *str);
        int number()                { return num;}
        char *get_name()            { return name;}
        char *get_fmt_name(int, int = ' ');
        int check_save();
        int is_untitled();
        void bmk_place(int i);
        void bmk_go(int i);
        void put_xy();
};

#endif //__EDITBOX_H
