/*
** Module   :BOXCOLL.H
** Abstract :Edit box collection
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Mon  16/06/1997   	Created
**      Thu  26/03/1998   	Interface updated, so all
**                        	improvements will be simpler to implement
*/

#include <editbox.h>
#include <keycoll.h>
#include <pipe.h>

#ifndef  __BOXCOLL_H
#define  __BOXCOLL_H


//-------------------------------------------------------
// class EditBoxCollection

struct macro_rec
{
    char *macro;
    char chr;
    struct macro_rec * next;
};

class Initor
{
    public:
        Initor();
};

class ProfileDictionary: public Dictionary
{
    public:
        ProfileDictionary();
};

class EditBoxCollection:public Collection
{
        EditBox* GetBox(int box)    { return (EditBox*)Get(box); }
        int cur_box;
        int shutdown;
        int recording;
        unsigned long hMtx;
        unsigned long tTID;
        unsigned long mTID;
        unsigned long pTID;

        macro_rec * head;
        macro_rec * tail;

        void track_recording(char *prog, char chr);
        void clear_recording();
        void start_recording();
        char* track_recording_done();

        Initor init;
        KeyDefCollection keys;
        ProfileDictionary prof_keys;

    public:

        NamedPipe npFED;

        EditBoxCollection();
        virtual ~EditBoxCollection()    { Done();}

        virtual void Free(Ptr p);

        void lock();
        void unlock();

        EditBox* current();
        EditBox* next();
        EditBox* prev();
        EditBox* locate(int);
        EditBox* select(int);
        void select(EditBox*);

        EditBox* open();
        int opened(char *fname);
        void close();

        int check_save();

        void draw();
        void search_proc();
        void load_profile(int);
        void load_profile(char *);
        void load_profile_file(char*);
        void play_macro(char *macro);
        void set_xy(char *ptr);
        void track_beg();
        void track_end();
        void track_cancel();

        void usual_key(KeyInfo&);
        void Dispatcher(KeyInfo&, int iMode = 0);
        void CompileKey(char* str, int j);

        int  isDown() { return shutdown;}

        void Done();
        void SendKey(char *key);
        void SetMouse(int row, int col);

//------- exported public methods
// !WARNING!
// Methods listed below assumes at least one edit box available
// for processing, i.e. collection is not empty.

        //---- General

        void doAbort();
        void doClose();
        void doCopyright();
        void doCopyright2();
        void doExit();
        void doFileList();
        void doHelpScreen();
        void doJumpCol();
        void doJumpLine();
        void doLoad();
        void doOpenFile(char *);
        void doNew();
        void doNextFile();
        void doPrevFile();
        void doSave();
        void doSaveAll();
        void doSaveAs();
        void doSearch();
        void doSearchAgain();

        //---- Cursor movement
        void doDown();
        void doEnd();
        void doFileBegin();
        void doFileEnd();
        void doHome();
        void doLeft();
        void doMatchBracket();
        void doPgDn();
        void doPgUp();
        void doRight();
        void doUp();
        void doWordLeft();
        void doWordRight();

        //---- Block marking
        void doDownMark();
        void doEndMark();
        void doFileBeginMark();
        void doFileEndMark();
        void doHomeMark();
        void doLeftMark();
        void doMatchBracketMark();
        void doPgDnMark();
        void doPgUpMark();
        void doRightMark();
        void doUpMark();
        void doWordLeftMark();
        void doWordRightMark();

        //---- Editing commands
        void doBksp();
        void doDel();
        void doDelLine();
        void doDelToEOL();
        void doDelWordLeft();
        void doDelWordRight();
        void doDupLine();
        void doIndent();
        void doLower();
        void doUnindent();
        void doUpper();
        void doSort();

        void doCopy();
        void doCut();
        void doPaste();

        void doUndo();

        //---- State commands
        void doFlipAutoindent();
        void doFlipBlockMode();
        void doFlipHiliting();
        void doHilitingChoice();
        void doFlipType();
        void doIns();
        void doSetXlat();

        //---- Special functions
        void doInsDate();
        void doInsFileName();
        void doInsFileNameShort();

        //---- Macro Recorder commands
        void doMacroRecStart();
        void doMacroRecEnd();

        //---- Rexx macro processor
        void doRexx(char* prog);

        //---- Bookmarks processing
        void doSetMark(int i);
        void doGotoMark(int i);

        //---- Jump lists processing
        void doJumpList(int i);

        //---- 'In place' profile loading
        void doLoadProfile();

        //---- Word wrap

        void doFlipWordWrap();
        void doFlipWWMerge();
        void doFlipWWLong();
};

#endif //__BOXCOLL_H

