/*
** Module   :_SEARCH.H
** Abstract :Search engine implementation
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Wed  12/11/1997   	Adopted from C SNIPPETS
*/

#ifndef  __SEARCH_H
#define  __SEARCH_H

class SearchEngine
{
    protected:
        int patlen;
        int skip[257];
        int skip2;
        char *pat;
        void *expr;

    public:
        SearchEngine()  { pat = 0; expr = 0;}
        ~SearchEngine() { delete pat; delete expr;}

        virtual void init(char *,int) {}
        virtual char* search(char *, int& match_len) { match_len = 0; return 0;}
        virtual void middle(int i)    {}    //Tell parser (not) to match BOL
};

//-----------------------------------------------------------
// Boyer-Moore-Horspool pattern match
//-----------------------------------------------------------

class BMHSearch: public SearchEngine
{
    public:

        virtual void init(char *pattern,int);
        virtual char* search(char *string, int& match_len);
};

//-----------------------------------------------------------
// Boyer-Moore-Horspool case insensitive pattern match
//-----------------------------------------------------------

class BMHISearch: public SearchEngine
{
    public:

        virtual void init(char *pattern,int);
        virtual char* search(char *string, int& match_len);
};

//-----------------------------------------------------------
// Regular expression pattern match
//-----------------------------------------------------------

class RXSearch: public SearchEngine
{

    public:

        virtual void init(char *pattern,int);
        virtual char* search(char *string, int& match_len);
        virtual void middle(int i);
};

#endif //__SEARCH_H

