/*
** Module   :_CTYPE.H
** Abstract :NLS support routines
**
** Copyright (C) Sergey I. Yevtushenko
**
** Log: Sun  04/05/1997   	Updated
*/

#include <common.h>

#ifndef  __CTYPE_H
#define  __CTYPE_H

#define IS_NO     0
#define IS_PU     1
#define IS_SP     2
#define IS_AL     4 /* 'a'-'z', 'A'-'Z', ''-'', ''-'' */
#define IS_DI     8 /* '0'-'9' */
#define IS_XD    16 /* '0'-'9', 'a'-'f', 'A'-'F' */
#define IS_HD    32 /* '0'-'9', 'a'-'f', 'A'-'F', 'x', 'X', 'u','U', 'l', 'L'*/
#define IS_QU    64 /* '\'', '\"' */
#define IS_SE   128 /* ';' */
#define IS_IS   256 /* 'a'-'z', 'A'-'Z', ''-'', ''-'', '#', '_' */
#define IS_IC  (IS_IS | IS_DI) /* 'a'-'z', 'A'-'Z', ''-'', ''-'', '0'-'9', '#', '_' */
#define IS_OP  1024 /* '%', '&', '*', '+', ',', '-', '.', '<', '>', '?', '{', '|', '}', '~' */

#define __isis(c) (__r_ctype[(unsigned char)(c)] & IS_IS)
#define __isic(c) (__r_ctype[(unsigned char)(c)] & IS_IC)
#define __issp(c) (__r_ctype[(unsigned char)(c)] & IS_SP)
#define __ishd(c) (__r_ctype[(unsigned char)(c)] & IS_HD)
#define __isdd(c) (__r_ctype[(unsigned char)(c)] & IS_DI)

inline char __to_lower(char chr)
{
    return tolower_cvt_table[(chr)];
}

inline char __to_upper(char chr)
{
    return toupper_cvt_table[(chr)];
}

void __nls_init(void);
int __cstrcmp(char *, char *);
int __cnstrcmp(char *s0, char *s1, int n);
int __nstrcmp(char *, char *, char *);  /* str1, str2, cvt_tbl */
char* __cstrchr(char* s0, int chr);

#endif
