;; Mail sending commands for Emacs.  

;; Copyright (C) 1992, 1993 Stuart Wilson.

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;; This file contains the modifications to sendmail.el, that are required  
to 

;; make the sendmail E-lisp code work on a PC running OS/2 v2.0
;;
;; It uses C:\TCPIP\BIN\SENDMAIL.EXE from IBM TCP/IP v1.2
;;
;;        Stuart Wilson
;;        stuartw@pec.co.nz
;;        23 July 1992.


;; First of all load the original sendmail.el
(load-library "sendmail")


;; It won't work unless this is set to true
(setq mail-interactive t)

;;
;; Now replace a couple of functions to make it work under OS/2
;;
(defun mail-send ()
  "Send the message in the current buffer."
  (interactive)
  (message "Sending...")
  (if (sendmail-send-it)
      (message "Sending...done"))
  (set-buffer-modified-p nil)
  (delete-auto-save-file-if-necessary))


(defun sendmail-send-it ()
  (let ((errbuf (if mail-interactive
		    (generate-new-buffer "*sendmail-errors*")
		  0))
	(tembuf (generate-new-buffer " sendmail temp"))
	(case-fold-search nil)
	delimline
	(mailbuf (current-buffer)))
    (unwind-protect
	(save-excursion
	  (set-buffer tembuf)
	  (setq buffer-undo-list t)
	  (erase-buffer)
	  (insert-buffer-substring mailbuf)
	  (goto-char (point-max))
	  ;; require one newline at the end.
	  (or (= (preceding-char) ?\n)
	      (insert ?\n))
	  ;; Change header-delimiter to be what sendmail expects.
	  (goto-char (point-min))
	  (re-search-forward
	    (concat "^" (regexp-quote mail-header-separator) "\n"))
	  (replace-match "\n")
	  (backward-char 1)
	  (setq delimline (point-marker))
	  (if mail-aliases
	      (expand-mail-aliases (point-min) delimline))
	  (goto-char (point-min))
	  ;; ignore any blank lines in the header
	  (while (and (re-search-forward "\n\n\n*" delimline t)
		      (< (point) delimline))
	    (replace-match "\n"))
	  (let ((case-fold-search t))
	    ;; Find and handle any FCC fields.
	    (goto-char (point-min))
	    (if (re-search-forward "^FCC:" delimline t)
		(mail-do-fcc delimline))
	    ;; If there is a From and no Sender, put in a Sender.
	    (goto-char (point-min))
	    (and (re-search-forward "^From:"  delimline t)
		 (not (save-excursion
			(goto-char (point-min))
			(re-search-forward "^Sender:" delimline t)))
		 (progn
		   (forward-line 1)
		   (insert "Sender: " (getenv "USER") "@" (getenv  
"HOSTNAME") "\n")))
	    ;; don't send out a blank subject line
	    (goto-char (point-min))
	    (if (re-search-forward "^Subject:[ \t]*\n" delimline t)
		(replace-match ""))
	    (if mail-interactive
		(save-excursion
		  (set-buffer errbuf)
		  (erase-buffer))))

	  ;;
	  ;; Now the changes to make it work under OS/2.
	  ;;     --- stuartw@pec.co.nz

	  (let ((tmp-fname (make-temp-name "smail"))
		(to (mail-extract-to)))
	    (if (string= to "")
		(message "Sending... failed -- No \"To:\" Address")
	      (message (concat "Sending... to " to))
	      (write-region (point-min) (point-max) tmp-fname nil 0)
	      (call-process "c:/tcpip/bin/sendmail.exe"
			    nil errbuf nil
			    "-af" tmp-fname
			    "-f" (concat (getenv "USER") "@" (getenv  
"HOSTNAME"))
			    to)
	      (message "Sending... done")
	      (delete-file tmp-fname))))
      (kill-buffer tembuf)
      (if (bufferp errbuf)
	  (kill-buffer errbuf)))))


;; IBM sendmail for OS/2 requires the To address to be on the command
;; line, which means we have to extract it from the message header.

(defun mail-extract-to ()
   (save-excursion
     (goto-char (point-min))
     (let ((start
	      (if (not (re-search-forward "^To:" (point-max) t))
		  nil
		(skip-chars-forward " \t")
		(point)))
	   (end
	    (progn
	      (end-of-line)
	      (skip-chars-backward " \t\n")
	      (point))))
       (if start
	   (buffer-substring start end)
	 ""))))