/*********************************************************/
/*                                                       */
/* Additional work for the Enhanced E installation       */
/* This script is run as the "PostPlugin" at close       */
/* and adds a "Sound" and "PlugIns" directory as well    */
/* as rewriting the "UnInstal.cmd" to remove it all at   */
/* uninstallation time and to remove entries made to     */
/* the os2.ini file.                                     */
/*                                                       */
/* For those using this file as a template for SFX:      */
/*                                                       */
/* This file is interpreted and may have problems with   */
/* subroutines on some machines so it has to be written  */
/* in a straight line for the most part.                 */
/*                                                       */
/*********************************************************/
parse source . . ThisProgram

crlf              = '0d0a'x
ThisDir           = Left(ThisProgram, lastpos('\', ThisProgram)-1)
UnInstall         = InstDir||'\UnInstal.cmd'

/*********************************************************/
/* Unzip Printer files and delete the zip                */
/*********************************************************/
address cmd 'unzip' InstDir||'\vpt.zip'
Call  SysFileDelete(InstDir||'\vpt.zip')

/*********************************************************/
/* Make the "Sound" directory and move files to it       */
/*********************************************************/
rc                = Directory(InstDir)
rc                = SysFileTree(InstDir||'\sound','List','DO')
if List.0         = 0 then rc = SysMkDir('Sound')

BadSound          = 0
Do index          = 1 to 4
  FileName        = InstDir||'\click'||index||'.wav'
  NewFileName     = InstDir||'\sound\click'||index||'.wav'
  rc              = SysFileTree(NewFileName,'List','FO')
  result          = 0
  if List.0       > 0 then Call SysFileDelete(NewFileName)
  Contents        = CharIn(FileName,1,Chars(FileName))
  rc              = Stream(FileName,'c','close')
  rc              = CharOut(NewFileName,Contents)
  rc              = Stream(NewFileName,'c','close')
  rc              = SysFileTree(NewFileName,'List','FO')
  if List.0       > 0 then Call SysFileDelete(FileName)
  else BadSound   = BadSound + 1
end

/*********************************************************/
/* Make the "ClipText" directory and move files to it    */
/* We won't worry about overwriting because of the odd   */
/* names we've given them but won't delete if not written*/
/*********************************************************/
rc                = Directory(InstDir)
rc                = SysFileTree(InstDir||'\cliptext','List','DO')
if List.0         = 0 then rc = SysMkDir('ClipText')

Do index          = 1 to 3
  FileName        = InstDir||'\_ReadMe'||index||'.txt'
  NewFileName     = InstDir||'\ClipText\_ReadMe'||index||'.txt'
  rc              = SysFileTree(NewFileName,'List','FO')
  if List.0       > 0 then Call SysFileDelete(NewFileName)
  Contents        = CharIn(FileName,1,Chars(FileName))
  rc              = Stream(FileName,'c','close')
  rc              = CharOut(NewFileName,Contents)
  rc              = Stream(NewFileName,'c','close')
  rc              = SysFileTree(NewFileName,'List','FO')
  if List.0       > 0 then Call SysFileDelete(FileName)
end

/*********************************************************/
/* Make the "PlugIns" directory and move files to it     */
/*********************************************************/
rc                = SysFileTree(InstDir||'\plugins','List','DO')
if List.0         = 0 then rc = SysMkDir('Plugins')

PlugIn.0          = 0
PIndex            = 0
rc                = SysFileTree(InstDir||'\plugin.api','aList','FO')
rc                = SysFileTree(InstDir||'\*.plg','List','FO')
if aList.0        > 0 then do
  NewTotal        = List.0 + 1
  List.0          = NewTotal
  List.NewTotal   = aList.1
end
if List.0         > 0 then do
  do index        = 1 to List.0
    BaseName      = FileSpec('N',List.index)
    NewFile       = InstDir||'\plugins\'||BaseName
    rc            = SysFileTree(NewFile,'nList','FO')
    if nList.0    > 0 Then do
      Template    = Left(nList.1, Length(nList.1)-3)||'???'
      TempFile    = SysTempFileName(Template)
      Contents    = CharIn(NewFile,1,Chars(NewFile))
      rc          = Stream(NewFile,'c','close')
      rc          = CharOut(TempFile,Contents)
      rc          = Stream(TempFile,'c','close')
      rc          = SysFileDelete(NewFile)
      PIndex      = PIndex+1
      PlugIn.0    = PIndex
      Plugin.PIndex = FileSpec('N',List.index)||' > '||FileSpec('N',TempFile)
    end
    Contents      = CharIn(List.index,1,Chars(List.index))
    rc            = Stream(List.index,'c','close')
    rc            = CharOut(NewFile,Contents)
    rc            = Stream(NewFile,'C','Close')
    rc            = SysFileDelete(List.index)
  end
end

if PlugIn.0>0 then do
  PlugInList      = 'Plugins backed up:'||crlf
  Do index        = 1 to PlugIn.0
    PlugInList    = PlugInList||Plugin.index||crlf
  end
  if BadSound     > 1 then Plural = 's'
  else Plural     = ''
  if BadSound     > 0 then msg1 = BadSound 'sound file'||Plural||' could not be copied to the sounds directory. Uncopied files always remain in the main directory.'||crlf||crlf
  else msg1       = ''
  msg2            = PlugIn.0||' (out of '||List.0||' total) plugin files were backed up in the "Plugin" directory.'
  msg3            = crlf||crlf||PlugInList
  msg4            = crlf||'These plugins may have been modified by the user and the installer will not overwrite them'
  msg5            = ' for this reason. Please check the plugin directory for the backups and update any that you may'
  msg6            = ' have modified.'||crlf||crlf
  response        = VpMessageBox(window,'Enhanced E Installation',msg1||msg2||msg3||msg4||msg5||msg6)
end

/*********************************************************/
/* Make changes to the "UnInstal.cmd" file               */
/*********************************************************/
UnInstValue       = CharIn(UnInstall,1,Chars(UnInstall))
rc                = Stream(UnInstall,'c','close')

NewInfo1          = "rc = sysini('User', 'EE', 'Delete:')"||crlf
NewInfo2          = "rc = sysini('User', 'EEE', 'Delete:')"||crlf
NewInfo           = NewInfo1||NewInfo2

Start             = Pos('/* Other work    */', UnInstValue)
UnInstValue       = Insert(newInfo,UnInstValue,start+20)
rc                = SysFileDelete(UnInstall)
rc                = CharOut(UnInstall,UnInstValue)
rc                = Stream(UnInstall,'c','close')
rc                = Directory(ThisDir)
rc                = SysFileDelete(InstDir||'\PrePlug.cmd')
rc                = SysFileDelete(InstDir||'\PostPlug.cmd')
