/* EDText.CPP : DSOM-Klasse : EDisServ.DLL V 1.1 */
/* Speicherung der Textzeilen und Zugriff        */
/*                                               */
/* (C) 1995 M.Schwarz, FoPra TU-Muenchen SS1995  */
/* (C) 1996 M.Schwarz, SOMObjects-Programmierung */
/*                     OS/2 Inside 7/96          */

/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.43
 */

#ifndef SOM_Module_edtext_Source
#define SOM_Module_edtext_Source
#endif
#define EDText_Class_Source

#include "EDText.xih"
#include "EDLine.xh"

/* IUICL-Headers (zum Laden von Texten) */
#include <iostream.h>
#include <fstream.h>
#include <string.h>



/* SOM-Functionen */

/*
 * loadtext (OK):
 */

SOM_Scope long  SOMLINK loadtext(EDText *somSelf,  Environment *ev,
                                 string filePath)
{

    EDTextData *somThis = EDTextGetData(somSelf);
    EDLine    *eLine;

    ifstream  infile(filePath);
    long     rc = 0;
    long      lnr = 0;
    char      line[255];

    EDTextMethodDebug("EDText","loadtext");
/**/
    if (somThis->strFilePath) SOMFree(somThis->strFilePath);
    somThis->strFilePath = (string) SOMMalloc(strlen(filePath)+1);
    strcpy(somThis->strFilePath, filePath);

   /* Datei ffnen */
    if (!infile) {
      /* Neue Datei erzeugen */
       ofstream  outfile(filePath);
       if (!outfile)
         return -1;
      /* Text in Datei schreiben */
       outfile << "";
      /* Datei schlieen */
       outfile.close();

       infile.open(filePath);
    } /* endif */

    if (infile) {
      /* Datei Zeile fr Zeile laden */
       while (!infile.eof()) {
          infile.getline(line, 255, '\n');
          if (!infile.fail()) {
            /* Zeile line in Text einfgen */
             lnr++;
             eLine = new EDLine;
             eLine->set(ev, lnr, line, "", 0, 0);
             if (somSelf->addLine(ev, lnr, eLine))
                return -2;
          } /* endif */
       } /* endwhile */
       somThis->nLines = sequenceLength(somThis->seqLNr);
    } else {
      /* Datei nicht gefunden */
       return -1;
    } /* endif */

    if (lnr == 0) {
      /* Neue Datei: eine Zeile eintragen */
       lnr++;
       eLine = new EDLine;
       eLine->set(ev, lnr, "", "", 0, 0);
       if (somSelf->addLine(ev, lnr, eLine))
          return -2;
    } /* endif */

    if (somThis->nLines == 0)
       return -3;

    return (somThis->nLines);
}

/*
 * saveText (OK):
 */

SOM_Scope long  SOMLINK savetext(EDText *somSelf,  Environment *ev,
                                 string filePath)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    EDLine    *eLine;

    long     rc = 0;
    long      lid = 0;
    char      line[255];
    EDTextMethodDebug("EDText","savetext");
/**/
    if (somThis->strFilePath) SOMFree(somThis->strFilePath);
    somThis->strFilePath = (string) SOMMalloc(strlen(filePath)+1);
    strcpy(somThis->strFilePath, filePath);

   /* Datei zum Schreiben ffnen */
    ofstream  outfile(filePath);

   /* Text in Datei schreiben */
    for (long i=0 ;i<sequenceLength(somThis->seqLNr) ;i++ ) {
       lid = sequenceElement(somThis->seqLNr, i);
       somSelf->getLine(ev, lid, &eLine);

       if (i != 0) outfile << "\n";
       outfile << eLine->_get_line(ev);

    } /* endfor */

   /* Datei schlieen */
    outfile.close();

    return(rc);
}

/*
 * getText (OK):
 */

SOM_Scope long  SOMLINK getText(EDText *somSelf,  Environment *ev,
                                _IDL_SEQUENCE_long* sLNr)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    EDTextMethodDebug("EDText","getText");
/**/
    if (somThis->seqLNr._buffer) {
       *sLNr = somThis->seqLNr;
    } else {
       return -1;
    } /* endif */

    return 0;
}

/*
 * addLine (OK):
 */

SOM_Scope long  SOMLINK addLine(EDText *somSelf,  Environment *ev,
                                long lnr, EDLine* ed_line)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    EDTextMethodDebug("EDText","addLine");
/**/
    if (lnr-1 != sequenceLength(somThis->seqLNr))
       return -1;

   /* Zeile i in seqLines einfgen */
    somThis->seqLines._buffer = (EDLine**)
       SOMRealloc(somThis->seqLines._buffer, sizeof(EDLine*)
                  *(sequenceLength(somThis->seqLines)+1));
    sequenceElement(somThis->seqLines, sequenceLength(somThis->seqLines)) = ed_line;
    sequenceLength(somThis->seqLines)++;

    somThis->seqLNr._buffer = (long*) SOMRealloc(somThis->seqLNr._buffer, sizeof (long) * (sequenceLength(somThis->seqLNr)+1) );
    sequenceLength(somThis->seqLNr)++;
    sequenceElement(somThis->seqLNr,
       sequenceLength(somThis->seqLNr)-1) = sequenceLength(somThis->seqLines)-1;
    somThis->nLines++;

    return (0);
}

/*
 * insLine (OK):
 */

/*
 * SOM_Scope long  SOMLINK insLine(EDText *somSelf,  Environment *ev,
 *                                 long prelid, long aftlid, EDLine** ed_line)
 */

/*
 * The prototype for insLine was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK insLine(EDText *somSelf,  Environment *ev,
                                long prelid, EDLine** ed_line)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    long    i, lid;
    EDLine   *eLine;
    EDTextMethodDebug("EDText","insLine");
/**/
   /* Zeile in seqLNr einfgen */
    i = 0;
    if (prelid != -1 /* Anfangszeile -> i=0 */) {
       while ( prelid != sequenceElement(somThis->seqLNr, i)
               && (i < sequenceLength(somThis->seqLNr))) {
         i++;
       } /* endwhile */
       if (prelid != sequenceElement(somThis->seqLNr, i))
          return -2;
       i++;
    }

   /* neue Zeile lid in seqLines erzeugen */
    somThis->seqLines._buffer = (EDLine**) SOMRealloc(somThis->seqLines._buffer, sizeof(EDLine*)*(sequenceLength(somThis->seqLines)+1));
    lid = sequenceLength(somThis->seqLines);
    sequenceLength(somThis->seqLines)++;

   /* Neue EDLine erzeugen und setzen */
    eLine = new EDLine;
    eLine->set(ev, lid, "", "", 0, 0);
    sequenceElement(somThis->seqLines, lid) = eLine;

   /* Zeile i in seqLNr einfgen */
    somThis->seqLNr._buffer = (long*) SOMRealloc(somThis->seqLNr._buffer, sizeof(long)*(sequenceLength(somThis->seqLNr)+1));
    sequenceLength(somThis->seqLNr)++;
    for (int jj = sequenceLength(somThis->seqLNr)-1 ;jj > i; jj-- ) {
       sequenceElement(somThis->seqLNr, jj) = sequenceElement(somThis->seqLNr, jj-1);
    } /* endfor */
    sequenceElement(somThis->seqLNr, i) = lid;
    somThis->nLines++;

    *ed_line = eLine;

    return(lid);
}

/*
 * delLine (OK):
 */

/*
 * SOM_Scope long  SOMLINK delLine(EDText *somSelf,  Environment *ev,
 *                                 long lid, long prelid, long aftlid)
 */

/*
 * The prototype for delLine was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK delLine(EDText *somSelf,  Environment *ev,
                                long lid)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    long    i;
    EDTextMethodDebug("EDText","delLine");

   /* Zeile aus seqLNr lschen */
    i = 0;
    while ( (lid != sequenceElement(somThis->seqLNr, i))
            && (i < sequenceLength(somThis->seqLNr))) {
      i++;
    } /* endwhile */
    if (lid == sequenceElement(somThis->seqLNr, i)) {

      /* Lschen */
       for (int jj=i;jj<sequenceLength(somThis->seqLNr) ;jj++ ) {
          sequenceElement(somThis->seqLNr, jj) = sequenceElement(somThis->seqLNr, jj+1);
       } /* endfor */
       somThis->seqLNr._buffer = (long*) SOMRealloc(somThis->seqLNr._buffer, sizeof(long)*(sequenceLength(somThis->seqLNr)-1));
       sequenceLength(somThis->seqLNr)--;

    } else {
       return -1;  /* ZeilenID nicht vorhanden */
    } /* endif */

    return 0;

}

/*
 * setLine (OK):
 */

SOM_Scope long  SOMLINK setLine(EDText *somSelf,  Environment *ev,
                                long lid, EDLine* ed_line)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    EDLine *tmpline;
    EDTextMethodDebug("EDText","setLine");

    if ((lid >= 0) && (lid < sequenceLength(somThis->seqLines))) {
       tmpline = sequenceElement(somThis->seqLines,lid);
       tmpline->set(ev, lid, ed_line->_get_line(ev), ed_line->_get_lock(ev), ed_line->_get_vnr(ev), ed_line->_get_ltime(ev));
    } else {
       return(-1);
    }
    return(0);
}

/*
 * getLine (OK):
 */

SOM_Scope long  SOMLINK getLine(EDText *somSelf,  Environment *ev,
                                long lid, EDLine** ed_line)
{
    EDTextData *somThis = EDTextGetData(somSelf);
    EDTextMethodDebug("EDText","getLine");

    if ((lid >= 0) && (lid < sequenceLength(somThis->seqLines))) {
       *ed_line = sequenceElement(somThis->seqLines, lid);
    } else {
       return(-1);
    } /* endif */

    return (0);
}



SOM_Scope void SOMLINK somDefaultInit(EDText *somSelf, som3InitCtrl* ctrl)
{
    EDTextData *somThis; /* set in BeginInitializer */
    somInitCtrl globalCtrl;
    somBooleanVector myMask;
    EDTextMethodDebug("EDText","somDefaultInit");
    EDText_BeginInitializer_somDefaultInit;

    EDText_Init_SOMObject_somDefaultInit(somSelf, ctrl);
/*a*/
   /* Zeilenzuordnungsfeld init */
    sequenceLength(somThis->seqLNr) = 0;
    somThis->seqLNr._buffer =
       (long*) SOMMalloc(sizeof (long));
   /* Zeilenablagefeld init */
    sequenceLength(somThis->seqLines) = 0;
    somThis->seqLines._buffer =
       (EDLine**) SOMMalloc(sizeof (EDLine *));
   /* Variablen init */
    somThis->nLines = 0; /* == sequenceLength(somThis->seqLNr) */
    somThis->strFilePath = NULL;
/*e*/
}


SOM_Scope void SOMLINK somDestruct(EDText *somSelf, octet doFree,
                                   som3DestructCtrl* ctrl)
{
    EDTextData *somThis; /* set in BeginDestructor */
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;
    EDTextMethodDebug("EDText","somDestruct");
    EDText_BeginDestructor;

/*a*/
    EDLine *eLine;
    long lid;

   /* Speicher fr die EDLines freigeben */
    for (long i=0 ;i<sequenceLength(somThis->seqLNr) ;i++ ) {
       lid = sequenceElement(somThis->seqLNr, i);
       if ((lid >= 0) && (lid < sequenceLength(somThis->seqLines))) {
          eLine = sequenceElement(somThis->seqLines, lid);
       }
       if (eLine) {
          delete eLine;
       } /* endif */
    } /* endfor */

   /* Speicher der Textablagefelder freigeben */
    if (somThis->seqLNr._buffer)
       SOMFree(somThis->seqLNr._buffer);
    if (somThis->seqLines._buffer)
       SOMFree(somThis->seqLines._buffer);
    if (somThis->strFilePath)
       SOMFree(somThis->strFilePath);
/*e*/
    EDText_EndDestructor;
}


