/* EDServ.C   : DSOM-Klasse : EDisServ.DLL V 1.1 */
/* Editorservice-Klasse                          */
/*                                               */
/* (C) 1995 M.Schwarz, FoPra TU-Muenchen SS1995  */
/* (C) 1996 M.Schwarz, SOMObjects-Programmierung */
/*                     OS/2 Inside 7/96          */

/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.43
 */


#ifndef SOM_Module_edserv_Source
#define SOM_Module_edserv_Source
#endif
#define EDService_Class_Source

#include <time.h>
#include <stdio.h>
#include "edserv.ih"
#include "edline.h"



/*
 * get_edline (OK):
 */

SOM_Scope long  SOMLINK get_edline(EDService *somSelf,  Environment *ev,
                                   long lnr, EDLine** ed_line,
                                   string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc=0;
    EDServiceMethodDebug("EDService","get_edline");

    /* Hole Zeile aus Text */
    rc =_getLine(somSelf, ev, lnr, ed_line);

    return(rc);
}

/*
 * put_edline (OK):
 */


/*
 * SOM_Scope long  SOMLINK put_edline(EDService *somSelf,  Environment *ev,
 *                                    long lnr, EDLine* ed_line,
 *                                    string user)
 */

/*
 * The prototype for put_edline was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK put_edline(EDService *somSelf,  Environment *ev,
                                   long lnr, string line, long vnr,
                                   string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc=0;
    EDLine* tmpline;
    EDServiceMethodDebug("EDService","put_edline");

    if (_getLine(somSelf, ev, lnr, &tmpline))
       return(-1);  /* Zeile nicht gefunden */

    if (_locked(somSelf, ev, lnr, user))
       return(-2);  /* Zeile gesperrt */

    if (__get_vnr(tmpline, ev) > vnr)
       return(-3);  /* Zeile veraltet */

    /* Neue Zeile gltig */
    _set(tmpline, ev, lnr, line, __get_lock(tmpline, ev), vnr, time(NULL));

    /* nderung in Eventliste speichern: */
    _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * (sequenceLength(_events)+1));
    sequenceElement(_events, sequenceLength(_events)) = lnr;
    sequenceLength(_events)++;
    /* EventCounter erhhen: */
    _eventcnt++;

    return(rc);
}

/*
 * ins_edline (OK):
 */

/*
 * SOM_Scope long  SOMLINK ins_edline(EDService *somSelf,  Environment *ev,
 *                                    long prelnr, long aftlnr,
 *                                    EDLine** ed_line, string user)
 */

/*
 * The prototype for ins_edline was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK ins_edline(EDService *somSelf,  Environment *ev,
                                   long prelnr, EDLine** ed_line,
                                   string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc = 0;
    EDLine    *tmpline;
    EDServiceMethodDebug("EDService","ins_edline");

    /* Fge neue Zeile ein, gib EDLine und lid zurck */
    rc =_insLine(somSelf, ev, prelnr, ed_line);
    if (rc >= 0) {
       /* Setze User-Sperre auf neue Zeile */
       _set(*ed_line, ev, __get_lnr(*ed_line, ev), "", user, 0,0);

       /* nderung in Eventliste speichern: */
       _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * (sequenceLength(_events)+2));
       sequenceElement(_events, sequenceLength(_events)) = -2;
       sequenceLength(_events)++;
       sequenceElement(_events, sequenceLength(_events)) = rc;
       sequenceLength(_events)++;
       /* EventCounter um 2 erhhen: */
       _eventcnt+=2;
    } /* endif */

    return(rc);
}

/*
 * del_edline (OK):
 */


/*
 * SOM_Scope long  SOMLINK del_edline(EDService *somSelf,  Environment *ev,
 *                                    long lnr, long prelnr, long aftlnr,
 *                                    long vnr, string user)
 */

/*
 * The prototype for del_edline was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK del_edline(EDService *somSelf,  Environment *ev,
                                   long lnr, long vnr, string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc = 0;
    EDLine* tmpline;
    EDServiceMethodDebug("EDService","del_edline");

    if (_getLine(somSelf, ev, lnr, &tmpline))
       return(-1);  /* Zeile nicht gefunden */

    if (_locked(somSelf, ev, lnr, user))
       return(-2);  /* Zeile gesperrt */

    if (__get_vnr(tmpline, ev) > vnr)
       return(-3);  /* Zeile veraltet */

    /* Lsche Zeile lid */
    rc =_delLine(somSelf, ev, lnr);
    if (rc >= 0) {
       /* nderung in Eventliste speichern: */
       _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * (sequenceLength(_events)+1));
       sequenceElement(_events, sequenceLength(_events)) = -2;
       sequenceLength(_events)++;
       /* EventCounter erhhen: */
       _eventcnt++;
    } /* endif */

    return(rc);
}

/*
 * getlock (OK):
 */


/*
 * SOM_Scope long  SOMLINK getlock(EDService *somSelf,  Environment *ev,
 *                                 long lnr, EDLine* ed_line, string user)
 */

/*
 * The prototype for getlock was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK getlock(EDService *somSelf,  Environment *ev,
                                long lnr, long vnr, string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc=0;
    EDLine* tmpline;
    EDServiceMethodDebug("EDService","getlock");

    if (_getLine(somSelf, ev, lnr, &tmpline))
       return(-1);  /* Zeile nicht gefunden */

    if (_locked(somSelf, ev, lnr, user))
       return(-2);  /* Zeile gesperrt */

    if (__get_vnr(tmpline, ev) > vnr)
       return(-3);  /* Zeile veraltet */

    /* Neue Sperre gltig */
    _set(tmpline, ev, lnr, __get_line(tmpline, ev), user, __get_vnr(tmpline, ev), time(NULL));

    /* nderung in Eventliste speichern: */
    _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * (sequenceLength(_events)+1));
    sequenceElement(_events, sequenceLength(_events)) = lnr;
    sequenceLength(_events)++;
    /* EventCounter erhhen: */
    _eventcnt++;

    return(rc);
}


/*
 * rellock (OK)
 */

/*
 * SOM_Scope long  SOMLINK rellock(EDService somSelf,  Environment *ev,
 *                                 long lnr, string user)
 */

/*
 * The prototype for rellock was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK rellock(EDService *somSelf,  Environment *ev,
                                long lnr, string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc=0;
    EDLine* tmpline;
    EDServiceMethodDebug("EDService","rellock");

    tmpline = EDLineNew();

    if (_getLine(somSelf, ev, lnr, &tmpline))
       return(-1);  /* Zeile nicht gefunden */

    if (_locked(somSelf, ev, lnr, user))
       return(-2);  /* Zeile gesperrt */

    /* Sperre aufheben */
    _set(tmpline, ev, lnr, __get_line(tmpline, ev), "", __get_vnr(tmpline, ev), 0);

    /* nderung in Eventliste speichern: */
    _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * (sequenceLength(_events)+1));
    sequenceElement(_events, sequenceLength(_events)) = lnr;
    sequenceLength(_events)++;
    /* EventCounter erhhen: */
    _eventcnt++;

    return(rc);
}


/*
 * appendline (OK)
 */

/*
 * SOM_Scope long  SOMLINK appendline(EDService somSelf,  Environment *ev,
 *                                    long lnr, long vnr, string user)
 */

/*
 * The prototype for appendline was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK appendline(EDService *somSelf,  Environment *ev,
                                   long lnr, long vnr, string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc=0;
    EDLine* tmpline;
    EDServiceMethodDebug("EDService","appendline");

    if (!(_getLine(somSelf, ev, lnr, &tmpline)))
       return(-4);  /* Zeile schon vorhanden */

//    if (__get_nlines(somSelf, ev) != lnr-1)
//       return(-1);

    tmpline = EDLineNew();

    /* leere neue Zeile erstellen */
    __set_lnr (tmpline, ev, lnr);
    __set_line(tmpline, ev, "");
    __set_lock(tmpline, ev, "");
    __set_vnr (tmpline, ev, vnr);
    __set_ltime(tmpline, ev, 0);

    _addLine(somSelf, ev, lnr, tmpline);

    /* nderung in Eventliste speichern: */
    _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * (sequenceLength(_events)+1));
    sequenceElement(_events, sequenceLength(_events)) = lnr;
    sequenceLength(_events)++;
    /* EventCounter erhhen: */
    _eventcnt++;

    return(rc);
}


/*
 * getinfo ()
 */

/*
 * SOM_Scope long  SOMLINK getinfo(EDService *somSelf,  Environment *ev,
 *                                 long* nlines, string* docname,
 *                                 long* evcnt, string user)
 */

/*
 * The prototype for getinfo was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK getinfo(EDService *somSelf,  Environment *ev,
                                long* nlines, long* evcnt, string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    EDServiceMethodDebug("EDService","getinfo");

    *nlines = __get_nLines(somSelf, ev);
    *evcnt = _eventcnt;

    return(0);
}


/*
 * getevents (OK)
 */

SOM_Scope long  SOMLINK getevents(EDService *somSelf,  Environment *ev,
                                  long* evcnt, _IDL_SEQUENCE_long* events,
                                  string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long i, j = 0;

    EDServiceMethodDebug("EDService","getevents");

    /* Speicher fr Eventsliste anmelden */
    events->_length = _eventcnt - *evcnt+2;
    events->_buffer = (long*) SOMMalloc(sizeof(long) * (events->_length));
    events->_buffer[0] = -3; /* Dummy */
    events->_buffer[1] = -3; /* Dummy */
    for (i=*evcnt; i<_eventcnt ; i++) {
       if (sequenceElement(_events, i) < 0) {
          if (sequenceElement(_events, i) == -1) {
             events->_buffer[0] = -1; /* Neue Userliste */
             j++;
             events->_length--;
          } else if (sequenceElement(_events, i) == -2) {
             events->_buffer[1] = -2; /* Neue Textliste */
             j++;
             events->_length--;
          } /* endif */
       } else {
          events->_buffer[i-*evcnt+2-j] = sequenceElement(_events, i);
       } /* endif */
    } /* endfor */
    *evcnt = _eventcnt;

    return(0);
}


/*
 * joinsession (OK)
 */

SOM_Scope long  SOMLINK joinsession(EDService *somSelf,  Environment *ev,
                                    string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc = 0;
    long i;
    string tmpUser;
    EDServiceMethodDebug("EDService","joinsession");

   // implementation
    tmpUser = (string) SOMMalloc(strlen(user)+1);
    strcpy(tmpUser, user);

   // check if name already in userlist
    if (sequenceLength(_users) > 0) {
      long  countName = 0;
      short loop;
      do {
         loop = 0;
         for (i = 0; i<sequenceLength(_users); i++ ) {
            if (!strcmp(tmpUser, sequenceElement(_users, i))) {
               char ucount[35];
               SOMFree(tmpUser);
               tmpUser = (string) SOMMalloc(strlen(user)+strlen(_ltoa(++countName, ucount, 10))+2);
               sprintf(tmpUser, "%s:%s", user, ucount);
               rc = countName;
               loop = 1;
            } /* endif */
         } /* endfor */
      } while (loop);
    }  /* endif */

   // put new user into userlist
    _users._buffer = (string*) SOMRealloc(_users._buffer, sizeof(string) * (sequenceLength(_users)+1));
    sequenceElement(_users, sequenceLength(_users)) = tmpUser;
    sequenceLength(_users)++;

   // save changes in eventlist
    _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * ++(sequenceLength(_events)));
    sequenceElement(_events, _eventcnt) = -1;
   // rise event counter
    _eventcnt++;

   // rc  < 0 -> error
   // rc == 0 -> registered by userName
   // rc  > 0 -> registered by userName:rc

    return(rc);
}



/*
 * leavesession (OK)
 */

SOM_Scope long  SOMLINK leavesession(EDService *somSelf,  Environment *ev,
                                     string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long  rc=0;
    long  i;
    string item;
    EDServiceMethodDebug("EDService","leavesession");

    /* Implementation */
    /* User in Userliste lschen: */
    for (i=0; i < sequenceLength(_users) ; i++ ) {
       item = sequenceElement(_users, i);
       if (!strcmp(item, user)) {
          if (item) SOMFree(item);
          sequenceLength(_users)--;
          for (i; i < sequenceLength(_users); i++) {
             sequenceElement(_users, i) = sequenceElement(_users, i+1);
          } /* endfor */
          _users._buffer = (string*) SOMRealloc(_users._buffer, sizeof(string) * (sequenceLength(_users)+1));

          /* nderung in Eventliste speichern: */
          _events._buffer = (long*) SOMRealloc(_events._buffer, sizeof(long) * ++(sequenceLength(_events)));
          sequenceElement(_events, _eventcnt) = -1;
          /* EventCounter erhhen: */
          _eventcnt++;

          return(rc);
       } /* endif */
    } /* endfor */

    rc = -1L;   /* User nicht in Liste eingetragen */
    return(rc);
}



/*
 * getusers (OK)
 */

SOM_Scope long  SOMLINK getusers(EDService *somSelf,  Environment *ev,
                                 _IDL_SEQUENCE_string* userlist)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    EDServiceMethodDebug("EDService","getusers");

    *userlist = _users;

    return(0);
}


/*
 * locked (OK)
 */

/*
 * SOM_Scope long  SOMLINK locked(EDService somSelf,  Environment *ev,
 *                                long lnr, string user)
 */

/*
 * The prototype for locked was replaced by the following prototype:
 */
SOM_Scope long  SOMLINK locked(EDService *somSelf,  Environment *ev,
                               long lnr, string user)
{
    EDServiceData *somThis = EDServiceGetData(somSelf);
    long rc=0;
    EDLine* tmpline;
    EDServiceMethodDebug("EDService","locked");

    if (_getLine(somSelf, ev, lnr, &tmpline))
       return(-1);  /* Zeile nicht gefunden */

    if (strlen(__get_lock(tmpline, ev))>0) {
       if (difftime(time(NULL), (time_t) __get_ltime(tmpline, ev)) > 120)
          return(0);   /* Sperrzeit von 2 Minuten abgelaufen! */
       if (strcmp(__get_lock(tmpline, ev), user))
          return(-2);  /* Zeile gesperrt */
    } /* endif */

    return(rc);
}



SOM_Scope void SOMLINK somDefaultInit(EDService *somSelf, som3InitCtrl* ctrl)
{
    EDServiceData *somThis; /* set in BeginInitializer */
    somInitCtrl globalCtrl;
    somBooleanVector myMask;
    EDServiceMethodDebug("EDService","somDefaultInit");
    EDService_BeginInitializer_somDefaultInit;

    EDService_Init_EDText_somDefaultInit(somSelf, ctrl);

    /* Userliste Initialisieren */
    sequenceLength(_users) = 0;
    _users._buffer = (string*) SOMMalloc(sizeof(string));

    /* Eventliste Initialisieren */
    sequenceLength(_events) = 0;
    _events._buffer = (long*) SOMMalloc(sizeof(long));
    _eventcnt = 0;

}


SOM_Scope void SOMLINK somDestruct(EDService *somSelf, octet doFree,
                                   som3DestructCtrl* ctrl)
{
    EDServiceData *somThis; /* set in BeginDestructor */
    somDestructCtrl globalCtrl;
    somBooleanVector myMask;

    long  i;
    string item;

    EDServiceMethodDebug("EDService","somDestruct");
    EDService_BeginDestructor;

    /* Speicher fr Userliste freigeben */
    for (i=0; i < sequenceLength(_users) ; i++ ) {
       item = sequenceElement(_users, i);
       if (item) SOMFree(item);
    }
    SOMFree(_users._buffer);

    /* Speicher fr Eventliste freigeben */
    SOMFree(_events._buffer);

    EDService_EndDestructor;
}


