/* Ported to the EMX-GCC-Copiler 0.8h by Thomas K. Gtz
 * Date: February 1994
 * All changes are marked with my insignia: tkg
 */

/* The third argument in every DlgProc has been changed from USHORT to ULONG 
 * without further comment (tkg)
 */


#define INCL_WINHELP
#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "edit.h"
#include "edlg.h"

/* window procedure for about box */
MRESULT EXPENTRY AboutDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg) {
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
            case DID_CANCEL:
               WinDismissDlg (hwnd, TRUE);
               return 0;
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}


/* The functions
 * 1. VOID FillDirListBox (HWND hwnd, CHAR *pcCurrentPath)
 * 2. VOID FillFileListBox (HWND hwnd)
 * 3. MRESULT EXPENTRY OpenDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
 * 4. MRESULT EXPENTRY SaveasDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
 * have been deleted. The Open- and SaveAs-Dialogs will now
 * be done by the Standard-File-Dialog of PM
 */




/* determine if pathname is a valid file or directory */
/* by Charles Petzold, from Programming the OS/2 Presentation Manager */
SHORT ParseFileName (CHAR *pcOut, CHAR *pcIn)
{
/*
 *   Input:    pcOut -- Pointer to parsed file specification.
 *             pcIn  -- Pointer to raw file specification.
 *                      
 *   Returns:      0 -- pcIn had invalid drive or directory.
 *                 1 -- pcIn was empty or had no filename.
 *                 2 -- pcOut points to drive, full dir, and file name.
 *
 *   Changes current drive and directory per pcIn string.
 */

   CHAR *pcLastSlash, *pcFileOnly;
   ULONG ulDriveMap;
   ULONG ulDriveNum;      /* (tkg) */
   ULONG ulDirLen = 64L;

   strupr (pcIn);

   /* If input string is empty, return 1 */
   if (pcIn[0] == '\0')
      return 1;

   /* Get drive from input string or current drive */
   if (pcIn[1] == ':') {
      /* if (DosSelectDisk (pcIn[0] - '@')) now: (tkg */
      if (DosSetDefaultDisk (pcIn[0] - '@'))
         return 0;

      pcIn += 2;
   }
   /* DosQCurDisk (&usDriveNum, &ulDriveMap); now: (tkg) */
   DosQueryCurrentDisk (&ulDriveNum, &ulDriveMap);

   *pcOut++ = (CHAR)((CHAR) ulDriveNum + '@');
   *pcOut++ = ':';
   *pcOut++ = '\\';

   /* If rest of string is empty, return 1 */
   if (pcIn[0] == '\0')
      return 1;

   /* Search for last backslash.  If none, could be directory. */
   if (NULL == (pcLastSlash = strrchr (pcIn, '\\'))) {
      /* if (!DosChDir (pcIn, 0L)) now: (tkg) */
      if (!DosSetCurrentDir (pcIn))
         return 1;

      /* Otherwise, get current dir & attach input filename */
      /* DosQCurDir (0, pcOut, &usDirLen); now: */
      DosQueryCurrentDir (0, pcOut, &ulDirLen);

      if (strlen (pcIn) > 12)
         return 0;

      if (*(pcOut + strlen (pcOut) - 1) != '\\')
         strcat (pcOut++, "\\");

      strcat (pcOut, pcIn);
      return 2;
   }
   
   /* If the only backslash is at beginning, change to root */
   if (pcIn == pcLastSlash) {
      /* DosChDir ("\\", 0L); now: (tkg) */
      DosSetCurrentDir ("\\");

      if (pcIn[1] == '\0')
         return 1;

      strcpy (pcOut, pcIn + 1);
      return 2;
   }
   
   /* Attempt to change directory -- Get current dir if OK */
   *pcLastSlash = '\0';

   /* if (DosChDir (pcIn, 0L)) now: (tkg) */
   if (DosSetCurrentDir (pcIn))
      return 0;

   /* DosQCurDir (0, pcOut, &usDirLen); now: (tkg) */
   DosQueryCurrentDir (0, pcOut, &ulDirLen);

   /* Append input filename, if any */
   pcFileOnly = pcLastSlash + 1;

   if (*pcFileOnly == '\0')
      return 1;

   if (strlen (pcFileOnly) > 12)
      return 0;

   if (*(pcOut + strlen (pcOut) - 1) != '\\')
      strcat (pcOut++, "\\");

   strcat (pcOut, pcFileOnly);
   return 2;
}


/* window procedure for find (text search) dialog box */
MRESULT EXPENTRY FindDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg) {
      case WM_INITDLG:
        WinSendDlgItemMsg (hwnd, DID_FINDTEXT, EM_SETTEXTLIMIT,
           MPFROM2SHORT (50, 0), NULL);
         WinSetDlgItemText (hwnd, DID_FINDTEXT, szFind);
         WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_FINDTEXT));
         return (MRESULT) TRUE;
         
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
               if (WinQueryDlgItemText (hwnd, DID_FINDTEXT, 60, szFind))
                  WinDismissDlg (hwnd, DID_OK);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            case DID_CANCEL:
               WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}


/* window procedure for replace (text search and replace) dialog box */
MRESULT EXPENTRY ReplaceDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   BOOL FAR *pb;
   
   switch (msg) {
      case WM_INITDLG:
         WinSendDlgItemMsg (hwnd, DID_NEWTEXT, EM_SETTEXTLIMIT,
            MPFROM2SHORT (50, 0), NULL);
         WinSendDlgItemMsg (hwnd, DID_OLDTEXT, EM_SETTEXTLIMIT,
            MPFROM2SHORT (50, 0), NULL);
         WinSetDlgItemText (hwnd, DID_OLDTEXT, szFind);
         WinSetDlgItemText (hwnd, DID_NEWTEXT, szReplace);
         pb = (PVOID) mp2;   /* TRUE if first entry */
         if (*pb) {
            WinEnableWindow (WinWindowFromID (hwnd, DID_DOREPLACE), FALSE);
            WinEnableWindow (WinWindowFromID (hwnd, DID_REPLACEALL), FALSE);
            WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_OLDTEXT));
         }
         else
            WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_NEWTEXT));
         return (MRESULT) TRUE;
         
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
               if (WinQueryDlgItemText (hwnd, DID_OLDTEXT, 60, szFind)) {
                  WinQueryDlgItemText (hwnd, DID_NEWTEXT, 60, szReplace);
                  WinDismissDlg (hwnd, DID_OK);
               }
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            case DID_DOREPLACE:
               if (WinQueryDlgItemText (hwnd, DID_NEWTEXT, 60, szReplace))
                  WinDismissDlg (hwnd, DID_DOREPLACE);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               break;
               
            case DID_REPLACEALL:
               if (WinQueryDlgItemText (hwnd, DID_NEWTEXT, 60, szReplace))
                  WinDismissDlg (hwnd, DID_REPLACEALL);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               break;
               
            case DID_CANCEL:
               WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}


/* window procedure for find (text search) dialog box */
MRESULT EXPENTRY GoLnDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch (msg) {
      case WM_INITDLG:
         WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, DID_LINENBR));
         return (MRESULT) TRUE;
         
      case WM_COMMAND:
         switch (SHORT1FROMMP (mp1)) {
            case DID_OK:
               if (WinQueryDlgItemText (hwnd, DID_LINENBR, 20, szLine))
                  WinDismissDlg (hwnd, DID_OK);
               else
                  WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            case DID_CANCEL:
               WinDismissDlg (hwnd, DID_CANCEL);
               return 0;
               
            default:
               break;
         }
   }
   return WinDefDlgProc (hwnd, msg, mp1, mp2);
}
