/* 
  This is eco.e, version 1.2, the source code of the 
  EPM module eco.ex for compiling Java, C and IPF.
  
  Copyright (c) 1998-1999 Walter Schmidt
*/


compile if EVERSION < '6.03b'
  *** Error: EPM version 6.03b required
compile endif


compile if not defined(SMALL) -- being compiled separately
  const ECO_PRO = 0           -- linkable module
compile else                  
  const ECO_PRO = 1           -- built-in "Pro" version
compile endif


compile if not defined(SMALL) -- being compiled separately
  include 'stdconst.e'
  include 'colors.e'
  define INCLUDING_FILE = 'eco.e'
  tryinclude 'MYCNF.E'
  compile if not defined(SITE_CONFIG)
    const SITE_CONFIG = 'SITECNF.E'
  compile endif
  compile if SITE_CONFIG
    tryinclude SITE_CONFIG
  compile endif
  compile if not defined(NLS_LANGUAGE)
    const NLS_LANGUAGE = 'ENGLISH'
  compile endif
compile endif -- SMALL


define EcoPrimVersion = '1.2'
const
compile if ECO_PRO
  ECO_VERSION = EcoPrimVersion || ' Pro'
compile else
  ECO_VERSION = EcoPrimVersion
compile endif

compile if not defined(ECO_EXTENSIONS)
  const
     ECO_EXTENSIONS = 'C H SQC CPP HPP CXX HXX SQX JAV JAVA IPF' 
     -- keep in sync with CKEYS.E and TAGS.E
compile endif

const
   ECO_MENU_ID   = 21
   ECO_MENU_C_ID = 2101
   ECO_MENU_V_ID = 2118
   ECO_MENU_L_ID = 2102
   ECO_MENU_H_ID = 2103
   ECO_MENU_S_ID = 2104
   ECO_MENU_A_ID = 2105

   ECO_COPYRIGHT_STRING = '(C) Walter Schmidt 1998-1999'
   ECO_MENU__MSG = 'Menus related to Java and C programming'
   ECO_COM__MSG  = 'Execute a compiler in the directory of this file'
   ECO_VIEW__MSG = 'View transcript of compilation'
   ECO_ERR__MSG  = 'Show next error in source file'
   ECO_TSH__MSG  = 'Toggle syntax highlighting of this file'
   
   ECO_NOSOURCE  = 'This is not a real file'
   ECO_NOLOG     = 'There is no transcript'
   ECO_NOERR     = 'No more errors'
   ECO_NOHILIT   = 'ECO supports highlighting for Java, HTML, C, IPF and Makefiles only'

   ECO_APP       = 'ECO'
   ECO_DEFCMD    = 'javac %**F'
   
   ECO_WTITLE    = 'Compiler invocation:'
   ECO_PROMPTTEXT= '( %**F and %**N will expand to the current '||
                   'filename with/without extension. )'

compile if not defined(HELP_PROD_MENUP__MSG)
  const HELP_PROD_MENUP__MSG=    \1'Copyright and version info'
compile endif


definit
   universal app_hini
-- initialize compiler command, if not yet defined:
   if queryprofile(app_hini, ECO_APP, 'COMMAND') = '' then
      call setprofile(app_hini, ECO_APP, 'COMMAND', ECO_DEFCMD)
   endif
-- add menu:   
   'PostMe BuildCompMenu'


compile if ECO_PRO
  defselect -- called at startup time and when switching files
      -- enable the Compile menu if supported language file loaded
      'PostMe EcoEnableCompMenu'
  
  defload -- called when loading files
      -- enable the Compile menu if supported language file loaded
      'PostMe EcoEnableCompMenu'
compile endif


defexit
   universal defaultmenu
   deletemenu defaultmenu,ECO_MENU_ID,0,0
   call maybe_show_menu()


defc BuildCompMenu
   universal  defaultmenu
-- Temporarily delete Help menu so we can put it back later on the end 
-- of the menu bar where it belongs!
   deletemenu defaultmenu, HELP_MENU_ID, 0, 0  -- delete the existing Help menu
                                               -- (we want it to stay at the right)
   BUILDSUBMENU defaultmenu, ECO_MENU_ID, 'Comp~ile', \1ECO_MENU__MSG, 0,0
   BUILDMENUITEM defaultmenu, ECO_MENU_ID, ECO_MENU_C_ID, '~Compile...',
                              'eco_compile'\1ECO_COM__MSG, 0,0
   BUILDMENUITEM defaultmenu, ECO_MENU_ID, ECO_MENU_V_ID, '~View transcript',
                              'eco_view_result'\1ECO_VIEW__MSG, 0,0
   BUILDMENUITEM defaultmenu, ECO_MENU_ID, ECO_MENU_L_ID, '~Locate next error',
                              'eco_next_error'\1ECO_ERR__MSG, 0,0
   BUILDMENUITEM defaultmenu, ECO_MENU_ID, ECO_MENU_H_ID, '~Highlighting',
                              'eco_toggle_hilite'\1ECO_TSH__MSG, 0,0
   BUILDMENUITEM defaultmenu, ECO_MENU_ID, ECO_MENU_S_ID, \0, '', 4, 0
   BUILDMENUITEM defaultmenu, ECO_MENU_ID, ECO_MENU_A_ID, '~About...', 'eco_ver' HELP_PROD_MENUP__MSG,0,0

   call readd_help_menu();   -- Put Help menu back in
   showmenu defaultmenu
compile if ECO_PRO   
   'Postme EcoEnableCompMenu'
compile endif

-- enable the ECO menu only if the current file is an ECO-file, i. e. a 
-- file with one of the extensions defined by ECO_EXTENSIONS. Also enabled:
-- command shells for the support of finding errors, and HTML files.
-- Only defined with built-in ECO, not with linkable module!

compile if ECO_PRO
  DEFC EcoEnableCompMenu =
     ext = FILETYPE()
     eco_enabled = WORDPOS(ext, ECO_EXTENSIONS ||' HTM HTML MAK') | 
        POS("COMMAND_SHELL", ext) | POS("MAKEFILE", UPCASE(.filename))
     eco_comp_enabled = WORDPOS(EXT, ECO_EXTENSIONS) | POS("MAKEFILE", UPCASE(.filename))
     eco_hlit_enabled = WORDPOS(EXT, ECO_EXTENSIONS||' HTM HTML MAK') | 
        POS("MAKEFILE", UPCASE(.filename))
     SetMenuAttribute(ECO_MENU_ID, 16384, eco_enabled)
     if eco_enabled then
        SetMenuAttribute(ECO_MENU_C_ID, 16384, eco_comp_enabled)
        SetMenuAttribute(ECO_MENU_H_ID, 16384, eco_hlit_enabled)
     endif
  RETURN
compile endif

defc eco_compile
   universal eco_id, eco_shellid, eco_first_line, eco_current_line,
             eco_dr, eco_dir, app_hini
   call eco_parse_filename(.filename, eco_dr, eco_dir, stem, ext)
   if (eco_dr = '') or (eco_dir ='') then
      sayerror ECO_NOSOURCE
      return
   endif
   current_cmd = queryprofile(app_hini, ECO_APP, 'COMMAND')
   sbuf = entrybox(ECO_WTITLE, 
                   '/~Run/~Cancel/',
                   current_cmd,254,80,
                   atoi(0) ||            -- default button # 
                   atoi(0) ||            -- help panel ID (0 for no help)
                   gethwnd(APP_HANDLE) ||
                   ECO_PROMPTTEXT||\0) 
   button = asc(leftstr(sbuf,1))
   if button=1 then 
      EOS = pos(\0,sbuf,2)    -- CHR(0) signifies End Of String
      cmd = substr(sbuf,2,EOS-2)
   else
      cmd = '' -- cancelled or closed otherwise
   endif
   if cmd <> '' then
      call setprofile(app_hini, ECO_APP, 'COMMAND', cmd)
      call eco_save()
      call eco_cd()
      display -2
      rc = 0
      activatefile eco_id
      display 2
      if rc<>0 then
         -- activatefile failed -> invalid fileid
         'shell'
         .AUTOSAVE = 0
         getfileid eco_id
         eco_shellid = substr(.filename,16)
      else
         .line = .last
      endif
      command = eco_makecmd(cmd, stem, ext)
      'shell_write' eco_shellid eco_dr 
      'shell_write' eco_shellid "cd" eco_dir
      .line = .last
      eco_first_line = .line
      eco_current_line = .line
      'shell_write' eco_shellid command
   endif


defc eco_View_result
   universal eco_id, eco_current_line, eco_first_line
   getfileid id
   if id = eco_id then
      .line = eco_first_line
   else
      display -2
      rc = 0
      activatefile eco_id
      display 2
      if rc<>0 then
         sayerror ECO_NOLOG
      else
         .line = eco_current_line
      endif
   endif


defc eco_next_error
   universal eco_id, eco_current_line, eco_first_line, eco_dr, eco_dir,
             eco_mark_end                       -- circled region starts
                                                -- in .line at .col, ends at
                                                -- eco_mark_end
   getfileid id
   if id = eco_id then
      if .line = .last then
         current_line = eco_first_line + 1
      else
         current_line = .line -- the current error, not the next one
      endif
   else
      display -2
      rc = 0
      activatefile eco_id
      display 2
      if rc<>0 then
         sayerror ECO_NOLOG
         activatefile id
         return
      endif
      current_line = eco_current_line + 1
   endif

   call directory(eco_dr||eco_dir)
   eco_last_line = .last
   found = 0

   ErrorColEnd = 0
   do while (current_line < eco_last_line)
      getline errorline, current_line
      -- try VisualAge format
      parse value errorline with Filename '(' LineNum ':' ErrorCol ') :' ErrorNr ':' ErrorMsg  
      if (FileName <> '') & isnum(LineNum) & isnum(ErrorCol) & (ErrorMsg <> '') then
         -- Filename & LineNum & ErrorCol & ErrorMsg recognized
         found = 1
         leave
      endif
      -- try Jikes/emacs format
      parse value errorline with Filename ':' LineNum ':' ErrorCol ':' LineNum ':' ErrorColEnd ': ' ErrorMsg  
      if (FileName <> '') & isnum(LineNum) & isnum(ErrorCol) & isnum(ErrorColEnd) & (ErrorMsg <> '') then
         -- Filename & LineNum & ErrorCol & ErrorColEnd & ErrorMsg recognized
         found = 1
         leave
      endif
      -- try GNU/Java format
      if substr(errorline, 2, 1) = ':' then
         col = pos(':', errorline, 3)
         if col then
            Filename = leftstr(errorline, col-1)
            parse value substr(errorline, col+1) with LineNum ':' ErrorMsg
         else
            Filename = '' 
            LineNum = ''
            ErrorMsg = ''
         endif
      else
         parse value errorline with Filename ':' LineNum ':'  ErrorMsg
      endif
      if (FileName <> '') & isnum(LineNum) & (ErrorMsg <> '') then 
         -- FileName & Linenum & ErrorMsg recognized,
         -- now try to find ErrorCol, too:
         if (current_line+2 <= .last) then
            getline errorline, current_line+2
            ErrorCol = pos('^', errorline)
         else
            ErrorCol=0
         endif
         found = 1
         leave
      endif
      --try IPFC format
      parse value errorline with '<' Filename ':' LineNum '>'  ErrorMsg
      if  (FileName <> '') & isnum(LineNum) & (ErrorMsg <> '') then
         -- FileName & Linenum & ErrorMsg recognized;
         -- ErrorCol can, however, not be determined easily.
         ErrorCol = 0
         found = 1
         leave
      endif
      current_line = current_line + 1
   enddo

   if found then
      eco_current_line = current_line 
      FileName = translate(FileName,'\','/')
      'edit' FileName
      .line = LineNum
      sayerror ErrorMsg
      if ErrorCol>0 then
         .col = ErrorCol                        -- position cursor to the 
                                                -- begin of the erroneous
                                                -- token
         getline sourceline, LineNum
         if ErrorColEnd = 0 then
             do i = ErrorCol to length(sourceline)  -- approximate error by 
                c = substr(sourceline, i, 1)    -- a variable at current
                if ( pos(translate(c),          -- position
                      "ABCDEFGHIJKLMNOPQRSTUVWXYZ_1234567890") = 0 ) then
                   leave
                endif
             end 
             if i > ErrorCol then               -- variables with at least
                eco_mark_end = i - 1            -- one character
             else                               -- other token
                eco_mark_end = ErrorCol
             endif
         else
            eco_mark_end = ErrorColEnd
         endif
         'PostMe eco_circleit'
      endif
   else
      activatefile id
      sayerror ECO_NOERR
   endif


defproc eco_makecmd(command, fname, ext)
-- we perform the following substitutions:
-- %**N   ->  filename without extension
-- %**F   ->  filename with extension

    do forever
       posi=pos('%**N', command)
       if posi then
          command=delstr(command, posi, 4)
          command = insertstr(fname, command, (posi-1))
       else
          leave
       endif
    enddo
    do forever
       posi=pos('%**F', command)
       if posi then
          command=delstr(command, posi, 4)
          command = insertstr(fname'.'ext, command, (posi-1))
       else
          leave
       endif
    enddo
return command


defproc eco_parse_filename(qname, var dr, var dir, var stem, var ext)
    n = lastpos('\',qname)
    tmp = substr(qname,n+1)
    p = lastpos('.', tmp)
    if p <= 1   then
       stem = tmp
       ext = ''
    else
       stem = substr(tmp,1,p-1)
       ext = substr(tmp,p+1)
    endif
    tmp = substr(qname,1,n)
    n = pos(':',tmp)
    dr = substr(tmp,1,n)
    dir = substr(tmp,n+1)
    if dir <> '\' then
       dir = strip(dir,'T','\')
    endif
return


defproc eco_cd
   dirpos=lastpos('\',.filename)
   if dirpos>1 then
      call directory(substr(.filename,1,dirpos-1))
   endif
return


defproc eco_save
   if .modify then
      'save'
   endif
   GETFILEID StartFileID
   LOOP
      NEXTFILE
      GETFILEID NextFileID
      IF NextFileID = StartFileID THEN
         LEAVE
      ENDIF
      IF wordpos(FILETYPE(), ECO_EXTENSIONS) THEN
         IF .modify THEN
            'save'
         ENDIF
      ENDIF
   ENDLOOP
   ACTIVATEFILE StartFileID
return


defc eco_toggle_hilite
   color_file=''
   ext=filetype()
   if wordpos(ext, 'JAV JAVA') then
      color_file= 'EPMKWDS.JAV'
   elseif wordpos(ext, 'HTM HTML') then
      color_file= 'EPMKWDS.HTM'
   elseif ext = 'IPF' then
      color_file= 'EPMKWDS.IPF'
   elseif wordpos(ext, ECO_EXTENSIONS) then
      color_file= 'EPMKWDS.C'
   elseif (pos('MAKEFILE', upcase(.filename)) | ext='MAK') then
      color_file='EPMKWDS.MAK'
   else
      beep(440,125)
      sayerror ECO_NOHILIT
      return
   endif
   current_toggle = windowmessage(1,  getpminfo(EPMINFO_EDITFRAME),
                                  5505,          -- EPM_EDIT_KW_QUERYPARSE
                                  0,
                                  0)
   'toggle_parse' (not current_toggle) color_file
return


defc eco_circleit
   universal eco_mark_end
   circleit 1, .line, .col, eco_mark_end, LIGHT_RED
return


defc eco_ver
   call WinMessageBox('About the EPM Compiler Front End',
                      'ECO version '||ECO_VERSION\13||
                      ECO_COPYRIGHT_STRING,
                      MB_OK+MB_INFORMATION+MB_DEFBUTTON1+MB_MOVEABLE)

/* finis */

