
/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 */

#ifndef REGEXP_H
#define REGEXP_H

/* The first byte of the regexp internal "program" is actually this magic   */
/* number; the start node begins in the second byte.			    */

#define MAGIC		   0234

#define NSUBEXP 	   10

struct S_RegExp
{
    char     *startp[NSUBEXP];
    char     *endp[NSUBEXP];
    char      regstart; 	   /* Internal use only. */
    char      reganch;		   /* Internal use only. */
    char     *regmust;		   /* Internal use only. */
    short     regmlen;		   /* Internal use only. */
    char      program[1];	   /* Unwarranted chumminess with compiler. */
};
typedef struct S_RegExp         regexp;


regexp *     regcomp PROTO((char *exp));
short        regexec PROTO((register regexp *prog, register char *string));
void         regsub PROTO((regexp *prog, char *source, char *dest));

#ifndef REGERROR
void         regerror PROTO((char *msg));
#endif

#ifdef DEBUG
void         regdump PROTO((regexp *r));
#endif

#endif	/* REGEXP_H */
