
/*
 *              Author:     Bob Withers     E-Mail: bwit@mo.net
 *              Copyright (c) 1993, All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appears in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * The author makes no representations about the suitability of this
 * software for any purpose.  This software is provided ``as is''
 * without express or implied warranty.
 *
 *      Define      Operating System        Compiler Tested
 *      -------     ----------------        ---------------
 *      MSDOS_16    DOS                     Microsoft VC++ V1.51
 *      NT_32       Win NT                  Microsoft VC++ V2.1
 *      OS2_16      OS/2 V1+                Microsoft C V6.00
 *      OS2_32      OS/2 V2+                IBM C Set++ V2.1
 *      BORLAND     OS/2                    Borland C++ for OS/2 V1.0
 *      BORLAND     DOS, Win NT             Borland C++ V4.5
 */

#ifndef DIRENT_H
#define DIRENT_H

/*  Unix style directory(3C) support for DOS, OS/2, and Win NT          */


struct dirent
{
    long            d_ino;      /* not used in this implementation      */
    long            d_off;      /* not used in this implementation      */
    int             d_isdir;    /* non-standard, 0 = file, 1 = dir      */
    unsigned short  d_reclen;
    char            d_name[1];
};


struct S_Dir
{
    char           *dirname;
    int             max_ent;
    int             tot_ent;
    int             cur_ent;
    struct dirent **entp;
};
typedef struct S_Dir            DIR;


DIR *               opendir(char *filename);
struct dirent *     readdir(DIR *dirp);
long                telldir(DIR *dirp);
void                seekdir(DIR *dirp, long loc);
void                rewinddir(DIR *dirp);
void                closedir(DIR *dirp);

#endif      /* DIRENT_H */
