//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2000 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/(rus/)?license.txt for more information).
//
#ifndef __ColorerClasses__
#define __ColorerClasses__

#include<stdio.h>

#include<sgml/sgml.h>
#include<regexp/cregexp.h>

typedef struct SColorDef *PColorDef;
typedef struct SClNode  *PClNode;
typedef struct SScheme *PScheme;
typedef struct SType *PType;

typedef class  CColorData *PColorData;
typedef struct SParseCache *PParseCache;
typedef class  CColorer *PColorer;

//  Coloring data _array_
//  First element->start = First Line No
//  First element->end = Number of elements in array
typedef struct SLineHL{
  unsigned int color;
  int start,end;
  SLineHL *next, *last;
} *PLineHL;
PLineHL CreateColors(int lnum,int fst);

// open structure!
struct SType{
  char *descr, *name, *sname;
  void *params;
  bool  loaded;
  PSgmlEl block;
  PScheme scheme;
  PRegExp exts;

  PType next;
  SType();
  ~SType();
};

class CColorData
{
  PScheme   slist;
  PType     tlist;
  PSgmlEl   types, sgmlbase;
  FILE      *errfile;
  PColorDef ColorDefs, CurCol;
  bool      loaded;
  char      *filepath, *dbgFileName, *errfname;

  unsigned int _getcolor(char *name);
  unsigned int GetColor(PSgmlEl El, char *tag);
  bool AddScheme(PSgmlEl elem, PScheme scheme);
  bool AddType(PSgmlEl elem, PType type);
  PScheme ReadColorData(PSgmlEl elem, PScheme *scheme, PType *type);
  bool loaddata(char *data, int len);
  bool updatelinks();
public:
  CColorData(char *path, char *ef);
  CColorData(char *data, int len, char *ef);
  ~CColorData();
  bool isok();

  unsigned int GetColor(char *name);
  PType enumtypes(PType next);
  PType seltype(char *fname, char *fstline, int no = 0);
  bool loadtype(PType type);
};

struct SParseCache
{
  int sline, eline;
  unsigned int bkcol;
  PScheme  scheme;
  SMatches matchstart;
  PClNode  ClEnder;
  char    *bkline;
  SParseCache *children,*next,*parent;

  SParseCache();
  ~SParseCache();
  SParseCache *SearchLine(int ln, SParseCache **cache);
};

class CColorer
{
  PType    Type;
  PScheme  Scheme;
  PLineHL  Lines;
  SParseCache Cache;
  PParseCache Parent, Forward;
  SMatches MatchEnd;
  bool     Drawing, Parsing, VRSet;
  bool     brparse;
  int      StLine, LinesNum;
  unsigned int CurBkCol;
  int      gx, gy, gyvis, gyvisto, gyto, len, fst, endline;
  char    *str;
  char*    (*GetLine)(PColorer obj, int no, int*len);
  void     (*VisReady)(PColorer obj);

  int Colorize(PRegExp Ender, unsigned int Back);
  int DrawLine(int len);
  int SearchIDs();
  int SearchRexExp(int no, int slen);
  void inline Fill(int no, int x, int cx, unsigned int col);
  unsigned int inline convert(unsigned int col);
public:
  CColorer();
  ~CColorer();
  bool ClearCache();
  void BreakParse();
  bool SetServices(char*(*gl)(PColorer, int, int*), void (*vr)(PColorer));
  bool SetColoringSrc(PType type);
  PLineHL SetMaxLines(int num);
  bool CompactLines();
  int  QuickParse(int from, int num);
  int  FullParse(int from, int fvis, int visnum, int allnum);
};

#endif