#define COLORSNUM     0x10
#define HRCCOLOR      "color"
#define INCLUDE_LEVEL 0x40
#define BADCOLOR      ((unsigned int)0)
#define DEFCOLOR      ((unsigned int)0xFFFFFFFF)

struct SColorDef
{
  char *def;
  unsigned int val;

  SColorDef *next;
  SColorDef();
  ~SColorDef();
};

struct SIDs
{
  char id[0x40];
  bool symb;
  int  len, color;
};
struct SIDInfo
{
  SIDs *ids;
  int   num;
  int   mcase;
  short cache[256];
  short cachelast[256];
};

enum EClType {  EEMPTY, ELINE, ESCHEME, EINCLUDE };

struct SClNode
{
  EClType  type;
  PRegExp  start, end;
  int      prior;
  PScheme  scheme;
  char    *sname;
  unsigned int colors[COLORSNUM];
  PClNode  next, nextuse;

  SClNode();
  ~SClNode();
};

struct SScheme
{
  char *name;
  PClNode ClNode;

  SIDInfo *caseid[INCLUDE_LEVEL];
  SIDInfo *nocaseid[INCLUDE_LEVEL];
  int  includesnum;

  PScheme next;
  SScheme();
  ~SScheme();
};

bool GetNumber(char *Str,double *Res);

bool DestroyColors(PLineHL line);
bool AddColor(PLineHL line, int lno, int s, int e, int col);
bool ClearLine(PLineHL line, int lno);
bool CompactLines(PLineHL Lines);