//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2000 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/(rus/)?license.txt for more information).
//
#include<ctype.h>
#include<string.h>
#include<colorer/classes.h>
#include<colorer/cintrnl.h>

SParseCache::SParseCache()
{
  children = next = parent = NULL;
};
SParseCache::~SParseCache()
{
  if (children) delete children;
  if (next) delete next;
};
PParseCache SParseCache::SearchLine(int ln,PParseCache *cache)
{
PParseCache r1,r2,tmp=this;
  *cache = NULL;
  while(tmp){
    if (tmp->sline <=ln && tmp->eline >= ln){
      r1 = tmp->children->SearchLine(ln,&r2);
      if (r1){
        *cache = r2;
        return r1;
      };
      *cache = r2; // last child
      return tmp;
    };
    if (tmp->sline <= ln) *cache = tmp;
    tmp = tmp->next;
  };
  return NULL;
};

/////////////////////////////// CColorer //////////////////////////////

CColorer::CColorer()
{
  Lines = NULL;
  LinesNum = 0;
  Cache.sline = 0;
  Cache.eline = 0x7FFFFFF;
  Cache.children = Cache.parent = Cache.next = NULL;
}
CColorer::~CColorer()
{
  DestroyColors(Lines);
}
bool CColorer::ClearCache()
{
  if (Cache.children) delete Cache.children;
  Cache.sline = 0;
  Cache.eline = 0x7FFFFFF;
  Cache.children = Cache.parent = Cache.next = NULL;
  return true;
};
void CColorer::BreakParse()
{
  brparse = true;
};

bool CColorer::SetServices(char*(*gl)(PColorer, int,int*), void (*vr)(PColorer))
{
  GetLine = gl;
  VisReady = vr;
  return true;
}
bool CColorer::SetColoringSrc(PType type)
{
  Type = type;
  Scheme = type->scheme;
  return true;
}
PLineHL CColorer::SetMaxLines(int num)
{
  LinesNum = num;
  if (Lines) DestroyColors(Lines);
  Lines  = CreateColors(num,0);
  return Lines;
}
bool CColorer::CompactLines()
{
  return ::CompactLines(Lines);
};
int CColorer::FullParse(int from, int fvis, int visnum, int allnum)
{
int ret, add, i;
  Drawing = false;
  Parsing = true;
  do{
    Lines[0].start = fvis;
    brparse = false;
    VRSet = 0;
    gx = 0;
    gy = from;
    gyvis = fvis;
    gyvisto = fvis+visnum;
    endline = gyto = from + allnum;

    if (gyvisto > gyto) gyvisto = gyto;

    Cache.scheme = Scheme;
    Parent = Cache.SearchLine(from,&Forward);
    do{
      if (!Forward){
        if (!Parent) return 0;
        delete Parent->children;
        Parent->children = NULL;
      }else{
        delete Forward->next;
        Forward->next = NULL;
      };
      if (Parent != &Cache)
        Parent->ClEnder->end->SetBkTrace(Parent->bkline,&Parent->matchstart);
      Scheme = Parent->scheme;
      if (Parent != &Cache)
        ret = Colorize(Parent->ClEnder->end, Parent->bkcol);
      else
        ret = Colorize(NULL, DEFCOLOR);

      if (ret == 3) break;
      if (Parent != &Cache){
        Parent->eline = gy;
      };
      if (Parent != &Cache && (gy >= gyvis) && (gy < gyto)){
        fst = true;
        gx = MatchEnd.e[0];
        Fill(gy,MatchEnd.s[0],MatchEnd.e[0],Parent->ClEnder->colors[0]);
        add = Parent->matchstart.CurMatch;
        for (i = 1;(i < MatchEnd.CurMatch) && (i < COLORSNUM);i++)
          if (MatchEnd.s[i] != -1 && (Parent->ClEnder->colors[i+add-1] != BADCOLOR))
            Fill(gy,MatchEnd.s[i],MatchEnd.e[i],Parent->ClEnder->colors[i+add-1]);
      };
      Forward = Parent;
      Parent = Parent->parent;
    }while(Parent);
  }while(ret == 3);
  if (!VRSet && VisReady) VisReady(this);
  return endline;
};

int CColorer::QuickParse(int from, int num)
{
int ret;
  Drawing = true;
  Parsing = false;
  do{
    Lines[0].start = from;
    brparse = false;
    gx = 0;
    gy = from;
    gyto = num + from;
    gyvis = from;
    gyvisto = num + from;
    ret = Colorize(NULL, DEFCOLOR);
  }while(ret == 3);
  return gy;
};

unsigned int inline CColorer::convert(unsigned int col)
{
  if (CurBkCol != DEFCOLOR){
    if (col>>0x10 == 0xFFFF) col = (CurBkCol&0xFFFF0000) + (col&0xFFFF);
    if ((col&0xFFFF) == 0xFFFF) col = (CurBkCol&0xFFFF) + (col&0xFFFF0000);
  };
  return col;
};
void inline CColorer::Fill(int no, int x, int cx, unsigned int col)
{
  AddColor(Lines, no, x, cx, convert(col));
};

int CColorer::SearchIDs()
{
int idsnum, i, c, first;
short pos, last;
SIDInfo *idi;

  for (first = 0; first < 2; first++)
  for (c = 0; c < Scheme->includesnum; c++){
    if (first){
      idsnum = Scheme->caseid[c]->num;
      idi = Scheme->caseid[c];
    }else{
      idsnum = Scheme->nocaseid[c]->num;
      idi = Scheme->nocaseid[c];
    };
    if (!idsnum) continue;

    pos = idi->cache[(unsigned char)str[gx]];
    last = idi->cachelast[(unsigned char)str[gx]];
    if (!idi->mcase){
      pos = idi->cache[tolower((unsigned char)str[gx])];      
      last = idi->cachelast[tolower((unsigned char)str[gx])];
    };
    if (pos == -1) continue;
    for (; pos <= last; pos++){
      if (idi->mcase)
        i = strncmp(idi->ids[pos].id, str+gx, idi->ids[pos].len);
      else
        i = strnicmp(idi->ids[pos].id, str+gx, idi->ids[pos].len);
      if (!i && !idi->ids[pos].symb){
        if (gx && (isalnum(str[gx-1]) || str[gx-1] =='_')) break;
        if (isalnum(str[gx + idi->ids[pos].len]) || str[gx + idi->ids[pos].len] =='_') break;
      };
      if(!i){
        Fill(gy, gx, gx + idi->ids[pos].len, idi->ids[pos].color);
        gx += idi->ids[pos].len - 1;
        return false;
      };
    };
  };
/*
    i = (IDsNum-1)/2;
    s = 0;
    e = IDsNum-1;
    while(true){
      j = MyCmp(str+gx,IDs[i].ID,IDs[i].Len,IDs[i].MCase);

      if (!j){
        brother = i+1;
        ok = i;
        while((brother < IDsNum) && !MyCmp(IDs[i].ID,IDs[brother].ID,IDs[i].Len,IDs[i].MCase) ){
          if (!MyCmp(str+gx,IDs[brother].ID,IDs[brother].Len,IDs[brother].MCase))
            ok = brother;
          brother++;
        };
        i = ok;
        if (gx+IDs[i].Len > len) break;
        if (!IDs[i].Symb){
          if (gx && (isalnum(str[gx-1]) || str[gx-1] =='_')) break;
          if (isalnum(str[gx+IDs[i].Len]) || str[gx+IDs[i].Len] =='_') break;
        };
        Fill(gy,gx,gx+IDs[i].Len,IDs[i].IDsCol);
        gx += IDs[i].Len-1;
        return false;
      };
      if (e-s <= 0) break;
      if (j < 0) e = i-1;
      else s = i+1;
      i = s + (e-s)/2;
    };
  };
*/
  return false;
};

int CColorer::SearchRexExp(int no, int slen)
{
PClNode   Stack[INCLUDE_LEVEL];
int       StPtr = 0;
PClNode   Node;
SMatches  Match,Match1;
PScheme   OldScheme;
PParseCache OldCacheF,OldCacheP, ResF, ResP;
int       i, add, mend, ogy;

  Node = Scheme->ClNode;
  while(true){
    if (!Node){
      if (!StPtr) break;
      Node = Stack[--StPtr];
    };
    if (Node->nextuse){
      Stack[StPtr++] = Node->next;
      Node = Node->nextuse;
      continue;
     };

    switch(Node->type){
      case ELINE:
        if (!Node->end){
          if (!Node->start->Parse(str+gx,str,str+slen,&Match)) break;

          for (i = 1;Drawing && (i < COLORSNUM) && (i < Match.CurMatch); i++)
            if (Match.s[i] != -1 && (Node->colors[i-1] != BADCOLOR))
              Fill(gy,Match.s[i], Match.e[i], Node->colors[i-1]);

          //mend = Match.e[0];
          //if(gx < Match.s[0]) DrawLine(Match.s[0] - gx);
          //gx = mend-1;
          gx = Match.e[0]-1;
        }else{
          if (!Node->start->Parse(str+gx,str,str+slen,&Match)) break;
          gx = Match.e[0];
          Node->end->SetBkTrace(str, &Match);
          if (!Node->end->Parse(str+gx,str,str+slen,&Match1)) break;

          if (Drawing){
            Fill(gy,Match.s[0],Match1.e[0],Node->colors[0]);
            for (i = 1;(i < Match.CurMatch) && (i < COLORSNUM);i++)
              if (Match.s[i] != -1 && (Node->colors[i] != BADCOLOR))
                Fill(gy,Match.s[i],Match.e[i],Node->colors[i]);
            add = i;
            for (i = 1;(i < Match1.CurMatch) && (i < COLORSNUM-add+1);i++)
              if (Match1.s[i] != -1 && (Node->colors[i+add-1] != BADCOLOR))
                Fill(gy,Match1.s[i],Match1.e[i],Node->colors[i+add-1]);
          };
          //mend = Match1.e[0];
          //if(gx < Match.s[0]) DrawLine(Match.s[0] - gx);
          //gx = mend-1;
          gx = Match1.e[0]-1;
        };
        return (Node->prior)?-2:2;
      case ESCHEME:
        if (!Node->start->Parse(str+gx,str,str+slen,&Match)) break;
        Node->end->SetBkTrace(str,&Match);

        fst = true;
        gx = Match.e[0];

        if (Parsing){
          ResF = Forward;
          ResP = Parent;
          ogy = gy;
          if (Forward){
            Forward->next = new SParseCache;
            OldCacheF = Forward->next;
            OldCacheP = Parent?Parent:Forward->parent;
            Parent = Forward->next;
            Forward = NULL;
          }else{
            Forward = new SParseCache;
            Parent->children = Forward;
            OldCacheF = Forward;
            OldCacheP = Parent;
            Parent = Forward;
            Forward = NULL;
          };
          OldCacheF->parent=OldCacheP;
          OldCacheF->bkcol = convert(Node->colors[0]);
          OldCacheF->sline=gy+1;
          OldCacheF->scheme = Node->scheme;
          OldCacheF->matchstart=Match;
          OldCacheF->ClEnder=Node;
          OldCacheF->bkline=str;
        };
        if (Drawing){
          CurBkCol = convert(Node->colors[0]);
          Fill(no, Match.s[0], Match.e[0], Node->colors[0]);
          for (i = 1;(i < Match.CurMatch) && (i < COLORSNUM);i++)
            if (Match.s[i] != -1 && (Node->colors[i] != BADCOLOR))
              Fill(no,Match.s[i],Match.e[i],Node->colors[i]);
        };
        add = Match.CurMatch;
        OldScheme = Scheme;
        Scheme = Node->scheme;
        mend = Colorize(Node->end, convert(Node->colors[0]));
        Scheme = OldScheme;
        if (Parsing){
          if (ogy == gy){
            delete OldCacheF;
            if (ResF) ResF->next = NULL;
            else ResP->children = NULL;
            Forward = ResF;
            Parent = ResP;
          }else{
            OldCacheF->eline=gy;
            Forward = OldCacheF;
            Parent = OldCacheP;
          };
        };
        if (mend == 3) return 3;
        if (Drawing){
          Fill(gy,MatchEnd.s[0], MatchEnd.e[0], Node->colors[0]);
          for (i = 1;(i < MatchEnd.CurMatch) && (i < COLORSNUM-add+1);i++)
            if (MatchEnd.s[i] != -1 && (Node->colors[i+add-1] != BADCOLOR))
              Fill(gy,MatchEnd.s[i],MatchEnd.e[i],Node->colors[i+add-1]);
        };
        gx = MatchEnd.e[0];
        return (Node->prior)?-1:1;
    };
    Node = Node->next;
  };
  return 0;
};

int CColorer::DrawLine(int len)
{
int Ret,ox,add=-1;

  if (!Scheme){
    gx = len;
    return 0;
  };
  for (; gx < len; gx++){
    if (!strnicmp(str+gx,"Cail Lomecb",11)){
      Fill(gy,gx,gx+11,0xffff0004);
      gx+=10;
      continue;
    };

    ox = gx;
    Ret = SearchRexExp(gy,this->len);
    if (Ret == 1 || Ret == -1){  // Scheme
      gy--;
      return 1;
    };
    if (Ret == 2 || Ret == -2){  // RegExp
      if (Ret == 2 && MatchEnd.s[0] >= ox && MatchEnd.s[0] <= gx)
        add=gx+1;
      continue;
    };
    if (Ret == 3) return Ret;
    if (Drawing) SearchIDs();
  };
  if(add != -1){
    gx = add;
    gy--;
    return 1;
  };
  return 0;
};

int CColorer::Colorize(PRegExp Ender,unsigned int Back)
{
int Res = 0, Recurse = 0, Ret, col;

  for (; gy < gyto; gy++){
    Drawing = (gy >= gyvis) && (gy < gyvisto);

    CurBkCol = Back;
    str = GetLine(this, gy, &len);
    if (!str) break;

    if (Drawing && !Recurse && !fst) ClearLine(Lines,gy);

    fst = false;
    Recurse = 0;
    MatchEnd.s[0] = MatchEnd.e[0] = len;
    if (Ender) Res = Ender->Parse(str+gx, str, str+len, &MatchEnd);
    if (!Res)
      MatchEnd.s[0] = MatchEnd.e[0] = len;
    col = MatchEnd.s[0];
    if (!Res && Drawing && Ender) col = col|0x8000; // full line
    if (Drawing) AddColor(Lines, gy, gx, col, CurBkCol);

    Ret = DrawLine(MatchEnd.e[0]);
    if (gy==gyvisto && VisReady && !VRSet){
      VRSet=true;
      VisReady(this);
    };
    if (brparse){
      endline = gy;
      gy = gyto;
    };

    if (Ret == 1) Recurse = true;
    if (Ret == 3) return 3;
    if (Recurse) Res = false;
    if (Res) return true;
    if (!Recurse) gx = 0;
  };
  return true;
};
