//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2000 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/(rus/)?license.txt for more information).
//
#include<fcntl.h>
#include<io.h>
#include<sys/timeb.h>
#include<time.h>
#include<ctype.h>
#include<stdio.h>
#include<string.h>

#include<colorer/classes.h>
#include<colorer/cintrnl.h>
#include<colorer/clines.cpp>

#define ERRLOG(pr, s1, s2, s3, s4) (errfname?(pr)?fprintf(errfile,\
        (s1), (s2), (s3), (s4)):1:1)

#define STARTLOG(s) while(errfname){\
      timeb timebuffer; char *timeline;\
      ftime(&timebuffer); timeline = ctime(&(timebuffer.time));\
      errfile = fopen(errfname,"a+");\
      ERRLOG(1,"%s %.19s.%03hu\n", s, timeline, timebuffer.millitm);\
      break; }

#define CLEARLOG() (  errfname? remove(errfname) :0)

#define ENDLOG() while(errfname){\
      timeb timebuffer; char *timeline;\
      ftime(&timebuffer); timeline = ctime(&(timebuffer.time));\
      ERRLOG(1,"--- end  logging  --- %.19s.%03hu\n\n",\
            timeline, timebuffer.millitm, 0);\
      fclose(errfile);\
      break; }


SColorDef::SColorDef()
{
  next = NULL;
  def = NULL;
};
SColorDef::~SColorDef()
{
  if (next) delete next;
  if (def)  delete[] def;
};

SClNode::SClNode()
{
  memset(this, 0, sizeof(SClNode));
};
SClNode::~SClNode()
{
  if (start) delete start;
  if (end) delete end;
  if (next) delete next;
  if (sname) delete[] sname;
};

SScheme::SScheme()
{
  memset(this,0, sizeof(SScheme));
};
SScheme::~SScheme()
{
  if (name) delete[] name;
  delete ClNode;
  if (caseid[0]){
    delete[] caseid[0]->ids;
    delete caseid[0];
  };
  if (nocaseid[0]){
    delete[] nocaseid[0]->ids;
    delete nocaseid[0];
  };
  if (next) delete next;
};

SType::SType()
{
  memset(this, 0, sizeof(SType));
};
SType::~SType()
{
  if (sname) delete[] sname;
  if (name) delete[] name;
  if (descr) delete[] descr;
  if (exts) delete exts;
  if (next) delete next;
};

void sortwords(SIDInfo *idinfo, bool mtchcase)
{
SIDs tmp;
SIDs *ids;
bool ch = true;
int t, i, j;

  if (!idinfo->num) return;
  ids = idinfo->ids;
  for (j = 0; ch && j < idinfo->num - 1; j++){
    ch = false;
    for (i = 0; i < idinfo->num - 1; i++){
      t = stricmp(ids[i].id, ids[i+1].id);
      if (mtchcase) t = strcmp(ids[i].id, ids[i+1].id);
      if (t > 0){
        if (!strnicmp(ids[i].id, ids[i+1].id, ids[i+1].len))
          t = 0;
        if (mtchcase && !strncmp(ids[i].id, ids[i+1].id, ids[i+1].len))
          t = 0;
      };
      if (t < 0){
        if (!strnicmp(ids[i].id, ids[i+1].id, ids[i].len))
          t = 1;
        if (mtchcase && !strncmp(ids[i].id, ids[i+1].id, ids[i].len))
          t = 1;
      };
      if (t > 0){
        tmp = ids[i];
        ids[i] = ids[i+1];
        ids[i+1] = tmp;
        ch = true;
      };
    };
  };
  memset(idinfo->cache, 0xFF, sizeof(idinfo->cache));
  memset(idinfo->cachelast, 0, sizeof(idinfo->cachelast));
  for (j = 0; j < idinfo->num; j++){
    if (mtchcase)
      if(idinfo->cache[(unsigned char)ids[j].id[0]] == -1){
        idinfo->cache[(unsigned char)ids[j].id[0]] = j;
        idinfo->cachelast[(unsigned char)ids[j].id[0]] = j;
      }else
        idinfo->cachelast[(unsigned char)ids[j].id[0]]++;
    if (!mtchcase){
      t = tolower((unsigned char)ids[j].id[0]);
      if(idinfo->cache[t] == -1)
        idinfo->cache[t] = idinfo->cachelast[t] = j;
      else
        idinfo->cachelast[t]++;
    };
  };
};

////////////////////////////////////////////////////////////////////////////

CColorData::CColorData(char *path, char *ef)
{
int sz;
int file;

  filepath = new char[strlen(path)+1];
  strcpy(filepath, path);
  dbgFileName = NULL;
  slist = NULL;
  tlist = NULL;
  sgmlbase = NULL;
  errfname = NULL;
  if (ef){
    sz = strlen(ef);
    errfname = new char[sz+1];
    strcpy(errfname, ef);
  };
  file = open(path,O_BINARY|O_RDONLY);
  if (file == -1 || !(sz = filelength(file))){
    loaded = false;
    return;
  };
  char *data = new char[sz];
  read(file, data, sz);
  close(file);
  loaded = loaddata(data,sz);
  delete[] data;
};
CColorData::CColorData(char *data, int len, char *ef)
{
  filepath = NULL;
  dbgFileName = NULL;
  slist = NULL;
  tlist = NULL;
  sgmlbase = NULL;
  errfname = NULL;
  if (ef){
    int sz = strlen(ef);
    errfname = new char[sz+1];
    strcpy(errfname, ef);
  };

  loaded = loaddata(data, len);
};
CColorData::~CColorData()
{
  if (ColorDefs) delete ColorDefs;
  if (errfname) delete errfname;
  delete[] filepath;
  if (loaded){
    delete slist;
    delete tlist;
    delete sgmlbase;
  };
};

bool CColorData::loaddata(char *data, int len)
{
PScheme tmpsc;
PType   td;

  if(sgmlbase) return false;
  ColorDefs = NULL;
  CurCol = NULL;

  CLEARLOG();
  STARTLOG("--- start logging ---");
  dbgFileName = "colorset.hrc";
  types = sgmlbase = new CSgmlEl;
  sgmlbase->parse(data,len);
  while(types = types->next())
    if (!types || types->gettype() == eBlockedEl && types->name && !stricmp(types->name,"Colorer")) break;

  if (!types){
    delete sgmlbase;
    ERRLOG(1,"main 'Colorer' block not found\n",0,0,0);
    ENDLOG();
    return false;
  };

  CurCol = ColorDefs = new SColorDef;
  slist = new SScheme;
  tlist = new SType;
  tmpsc = slist;
  td = tlist;
  ReadColorData(types->child(), &tmpsc, &td);
  updatelinks();
  ENDLOG();
  return true;
};

bool CColorData::updatelinks()
{
PClNode ClNodeData;
PType   td;
PScheme sd, tmpsc;
int     i;

///////////////////////// scheme <-> type linking /////////////////////////////
  for(td = tlist; td; td = td->next){
    sd = slist;
    td->scheme = NULL;
    if (!td->sname) continue;
    while(sd){
      if (td->sname && sd->name && !stricmp(sd->name, td->sname)){
        td->scheme = sd;
        break;
      };
      sd = sd->next;
    };
    ERRLOG(!td->scheme,"error linking type '%s' with scheme '%s'\n", td->descr, td->sname, 0);
  };
///////////////////////////// scheme linking //////////////////////////////////
  sd = slist;
  while (sd){
    ClNodeData = sd->ClNode;
    int num = 1;
    while (ClNodeData){
      if (ClNodeData->sname && (ClNodeData->type == ESCHEME)){
        tmpsc = slist;
        while (tmpsc){
          if (tmpsc->name && !stricmp(tmpsc->name,ClNodeData->sname)){
            ClNodeData->scheme = tmpsc;
            break;
          };
          tmpsc = tmpsc->next;
        };
        ERRLOG(!tmpsc,"scheme '%s' not found during linking into scheme '%s'\n", ClNodeData->sname, sd->name,0);
        if (!tmpsc){
          delete ClNodeData->start;
          ClNodeData->start = NULL;
        };
      };
      if (ClNodeData->type == EINCLUDE){
        tmpsc = slist;
        while (tmpsc && tmpsc != sd){
          if(ClNodeData->sname && tmpsc->name && !stricmp(tmpsc->name, ClNodeData->sname)){
            for (i = 0; i < tmpsc->includesnum; i++,num++){
              sd->caseid[num] = tmpsc->caseid[i];
              sd->nocaseid[num] = tmpsc->nocaseid[i];
            };
            ClNodeData->nextuse = tmpsc->ClNode;
            break;
          };
          tmpsc = tmpsc->next;
        };
        ERRLOG(!tmpsc || tmpsc == sd,"cannot include scheme '%s' into scheme '%s'\n", ClNodeData->sname, sd->name,0);
      };
      ClNodeData = ClNodeData->next;
    };
    sd->includesnum = num;
    sd = sd->next;
  };
  return true;
};

////////////////////////////////////////////////////////////////////////////////////

PScheme CColorData::ReadColorData(PSgmlEl elem, PScheme *scheme, PType *type)
{
PSgmlEl BaseEl;
int     file;
int     sz,i;
char   *data, *param, *savedname;
char    path[512];

  for (i = 0; elem; elem = elem->next()){
    if (!elem->name) continue;
    if (!stricmp(elem->name,"define")){
      param = elem->GetChrParam("name");
      CurCol->def = new char[strlen(param)+1];
      strcpy(CurCol->def,param);
      CurCol->val = 0;
      CurCol->val = GetColor(elem,"value");
      CurCol->next = new SColorDef;
      CurCol = CurCol->next;
    };
    if (!stricmp(elem->name,"include")){
      if (!(param = elem->GetChrParam("name"))) continue;
      if (!filepath) continue;
      strcpy(path,filepath);
      savedname = dbgFileName;
      dbgFileName = param;
      for (i = strlen(path);i; i--)
        if (path[i]=='\\' || path[i]=='/') break;
      strcpy(path+i+1, param);

      file = open(path,O_BINARY|O_RDONLY);

      ERRLOG(file == -1, "cannot include file '%s'\n", dbgFileName,0,0);

      if (file == -1 || !(sz = filelength(file)))
        continue;
      data = new char[sz];
      read(file, data, sz);
      close(file);

      BaseEl = new CSgmlEl;
      BaseEl->parse(data, sz);
      delete[] data;

      ReadColorData(BaseEl->next(), scheme, type);
      delete BaseEl;
      dbgFileName = savedname;
    };
    if (!stricmp(elem->name,"scheme") && scheme){
      if (!AddScheme(elem, *scheme)) continue;
      (*scheme)->next = new SScheme;
      *scheme = (*scheme)->next;
    };
    if (!stricmp(elem->name,"type") && type){
      if (!AddType(elem, *type)) continue;
      (*type)->next = new SType;
      *type = (*type)->next;
    };
    continue;
  };
  return *scheme;
};

bool CColorData::AddScheme(PSgmlEl elem, PScheme scheme)
{
PSgmlEl tmpEl, KeyWrd;
PClNode next;
PScheme scheck;
char   *Param, *Param1, *Param2;
char    ColName[0x20];
int     Col, Len, Pos;
bool    IsCase;
SIDs   *pIDs;

  Param = elem->GetChrParam("name");
  if (!Param){
    ERRLOG(1,"found scheme without name in '%s'\n",dbgFileName,0,0);
    return false;
  };
  for (scheck = slist; scheck; scheck = scheck->next)
    if (scheck->name && !stricmp(scheck->name, Param)){
      //ERRLOG(1, "duplicate scheme '%s' - load cancelled\n", Param, 0, 0);
      return false;
    };

  Len = strlen(elem->GetChrParam("name"));
  scheme->name = new char[Len+1];
  strcpy(scheme->name,elem->GetChrParam("name"));

  scheme->caseid[0] = new SIDInfo;
  scheme->nocaseid[0] = new SIDInfo;
  scheme->caseid[0]->num = 0;
  scheme->nocaseid[0]->num = 0;

  for(tmpEl = elem->child(); tmpEl; tmpEl = tmpEl->next()){
    if (!tmpEl->name) continue;
    if (!stricmp(tmpEl->name,"keywords"))
    {
      for(KeyWrd = tmpEl->child(); KeyWrd; KeyWrd = KeyWrd->next())
        if(KeyWrd->name && (!stricmp(KeyWrd->name,"word") ||
        !stricmp(KeyWrd->name,"symb")))
        {
          Param =  tmpEl->GetChrParam("matchcase");
          if (Param){
            if (!stricmp(Param,"true")) scheme->caseid[0]->num++;
            else scheme->nocaseid[0]->num++;
          }else
            scheme->caseid[0]->num++;
        };
    };
  };
  scheme->caseid[0]->ids = new SIDs[scheme->caseid[0]->num];
  scheme->caseid[0]->mcase = true;
  scheme->nocaseid[0]->ids = new SIDs[scheme->nocaseid[0]->num];
  scheme->nocaseid[0]->mcase = false;
  scheme->ClNode = new SClNode;
  next = scheme->ClNode;
  scheme->nocaseid[0]->num = scheme->caseid[0]->num = 0;

  for(tmpEl = elem->child(); tmpEl; tmpEl = tmpEl->next()){
    if (!tmpEl->name) continue;

    if (!stricmp(tmpEl->name,"include")){
      if (!(Param = tmpEl->GetChrParam("scheme"))){
        ERRLOG(1,"including scheme without parameter in scheme '%s'\n", dbgFileName, 0, 0);
        continue;
      };
      next->type = EINCLUDE;
      int len = strlen(tmpEl->GetChrParam("scheme"));
      next->sname = new char[len+1];
      strcpy(next->sname, tmpEl->GetChrParam("scheme"));

      next->next = new SClNode;
      next = next->next;
    };
    if (!stricmp(tmpEl->name,"regexp")){
      if (!(Param  = tmpEl->GetChrParam("start"))) continue;
      Param1 = tmpEl->GetChrParam("end");
      Param2 = tmpEl->GetChrParam("prior");
      next->prior = Param2?(!stricmp(Param2,"low")?1:0):0;
      next->type = ELINE;
      next->start = new CRegExp(Param);
      next->start->SetNoMoves(true);
      ERRLOG(!next->start->isok(),"fault compiling regexp '%s' in '%s'\n", Param, dbgFileName,0);
      next->end = NULL;
      if (Param1){
        next->end = new CRegExp(Param1);
        next->end->SetNoMoves(false);
        ERRLOG(!next->end->isok(),"fault compiling regexp '%s' in '%s'\n",Param1,dbgFileName,0);
      };
      if (!next->start) continue;
      for (int i = 0; i < COLORSNUM; i++){
        sprintf(ColName,"color%x",i);
        next->colors[i] = GetColor(tmpEl,ColName);
      };
      if (Param1 && next->colors[0] == BADCOLOR) next->colors[0] = DEFCOLOR;
      next->next = new SClNode;
      next = next->next;
    };
    if (!stricmp(tmpEl->name,"block")){
      if (!(Param = tmpEl->GetChrParam("start"))){
        ERRLOG(true,"'Start' block tag not found in '%s'\n",dbgFileName,0,0);
        continue;
      };
      if (!(Param1 = tmpEl->GetChrParam("end"))){
        ERRLOG(true,"'End' block tag not found in '%s'\n",dbgFileName,0,0);
        continue;
      };
      if (!tmpEl->GetChrParam("scheme")){
        ERRLOG(true,"block without scheme in '%s'\n",dbgFileName,0,0);
        continue;
      };
      Param2 = tmpEl->GetChrParam("prior");
      next->prior = Param2?(!stricmp(Param2,"low")?1:0):0;
      next->type = ESCHEME;
      next->start = new CRegExp(Param);
      next->start->SetNoMoves(true);
      ERRLOG(!next->start->isok(),"fault compiling regexp '%s' in '%s'\n",Param,dbgFileName,0);
      next->end = new CRegExp(Param1);
      next->end->SetNoMoves(false);
      ERRLOG(!next->end->isok(),"fault compiling regexp '%s' in '%s'\n",Param1,dbgFileName,0);

      if (!next->start || !next->end) continue;
      for (int i = 0; i < COLORSNUM; i++){
        sprintf(ColName,"color%x",i);
        next->colors[i] = GetColor(tmpEl,ColName);
      };
      if (next->colors[0] == BADCOLOR) next->colors[0] = DEFCOLOR;
      int len = strlen(tmpEl->GetChrParam("scheme"));
      next->sname = new char[len+1];
      strcpy(next->sname, tmpEl->GetChrParam("scheme"));

      next->next = new SClNode;
      next = next->next;
    };
    if (!stricmp(tmpEl->name,"keywords")){
      Param1 = tmpEl->GetChrParam("matchcase");
      IsCase = Param1?!stricmp(Param1,"true"):true;
      for(KeyWrd = tmpEl->child(); KeyWrd; KeyWrd = KeyWrd->next()){
        int type = 0;
        if (!KeyWrd->name) continue;
        if (!stricmp(KeyWrd->name,"word")) type = 1;
        if (!stricmp(KeyWrd->name,"symb")) type = 2;
        if (!type) continue;

        if (!(Param = KeyWrd->GetChrParam("name")) || !strlen(Param)) continue;
        Col = GetColor(tmpEl, HRCCOLOR);
        if (KeyWrd->GetChrParam("color"))
          Col = GetColor(KeyWrd, HRCCOLOR);
        Len = strlen(Param);
        if (IsCase){
          pIDs = scheme->caseid[0]->ids;
          Pos = scheme->caseid[0]->num;
          scheme->caseid[0]->num++;
        }else{
          pIDs = scheme->nocaseid[0]->ids;
          Pos = scheme->nocaseid[0]->num;
          scheme->nocaseid[0]->num++;
        };
        memmove(pIDs[Pos].id, Param, Len);
        pIDs[Pos].id[Len] = 0;
        pIDs[Pos].len = Len;
        pIDs[Pos].color = Col;
        pIDs[Pos].symb = (type-1) != false;
      };
    };
  };
  sortwords(scheme->caseid[0], true);
  sortwords(scheme->nocaseid[0], false);
  return true;
};

bool CColorData::AddType(PSgmlEl elem, PType type)
{
char *param1, *param2, *param3;

  param1 = elem->GetChrParam("exts");
  param2 = elem->GetChrParam("descr");
  param3 = elem->GetChrParam("name");
  if (!param1 || elem->gettype() != eBlockedEl) return false;
  if (param2){
    int len = strlen(param2);
    type->descr = new char[len+1];
    strcpy(type->descr, param2);
  };
  if (param3){
    int len = strlen(param3);
    type->name = new char[len+1];
    strcpy(type->name, param3);
  };
  type->exts = new CRegExp(param1);
  ERRLOG(!type->exts->isok(),"fault compiling regexp '%s' in type '%s'\n", param1, type->descr, 0);
  type->block  = elem;
  type->loaded = false;
  return true;
};

unsigned int CColorData::_getcolor(char *name)
{
PColorDef ColDef;
bool ok = false;
int col = BADCOLOR;
double res;

  for (ColDef = ColorDefs; ColDef && ColDef->def; ColDef = ColDef->next)
    if (!stricmp(name, ColDef->def)){
      col = ColDef->val;
      ok = true;
      break;
    };
  if (!ok){
    ok = GetNumber(name,&res);
    if(ok) col = (unsigned int)res;
  };
  ERRLOG(name && !ok, "cannot find color define '%s' in %s\n", name, dbgFileName, 0);
  return col;
};
unsigned int CColorData::GetColor(PSgmlEl El, char *tag)
{
  return GetColor(El->GetChrParam(tag));
};
unsigned int CColorData::GetColor(char *name)
{
int    len, col1, col2;
char  *name1, *name2, *tmpstr, *str;
bool   add = false;

  col1 = col2 = BADCOLOR;
  name1 = name2 = NULL;
  str = name2 = name;
  if (!str) return col1;

  while(*name2 != '/' && *name2 != '+' && *name2) name2++;
  if (*name2 == '+') add = true;
  len = name2 - str;
  if (len){
    name1 = new char[len+1];
    strncpy(name1, str, len);
    name1[len] = 0;
    col1 = _getcolor(name1);
    delete[] name1;
    col2 = add?0:col1;
  };
  if (*name2){
    tmpstr = new char[strlen(name2)];
    strcpy(tmpstr, name2+1);
    name2 = tmpstr;
    col2 = _getcolor(name2);
    delete[] name2;
    if (!len) col1 = add?0:col2;
  };
//  ERRLOG(!((col1+col2) >> 16), "warning color %s in %s\n", str, dbgFileName, 0);
  if (add) return col1 + col2;
  else return (col1&0xffff) + (col2&0xffff0000);
};

bool CColorData::isok()
{
  return loaded;
};

PType CColorData::seltype(char *fname, char *fstline, int no)
{
PType current, fnd;
PSgmlEl sbase;
PRegExp rline;
SMatches match;
char *param1, *param2;

  for(current = tlist; current; current = current->next)
    if(current->exts && current->exts->Parse(fname,&match)){
      if (!no) break;
      no--;
    };
  if(!current || !fstline) return current;
  for(sbase = current->block->child(); sbase; sbase = sbase->next())
    if (sbase->name && !stricmp(sbase->name,"switch")){
      param1 = sbase->GetChrParam("match");
      param2 = sbase->GetChrParam("type");
      if (!param1 || !param2) continue;
      rline = new CRegExp(param1);
      if (!rline->isok())
        continue;
      if (!rline->Parse(fstline, &match)) continue;
      for(fnd = tlist; fnd; fnd = fnd->next)
        if(fnd->name && !stricmp(fnd->name, param2)){
          current = fnd;
          break;
        };
      break;
    };
  return current;
};

PType CColorData::enumtypes(PType next)
{
  if (!next) return tlist;
  if (!next->next->next) return NULL;
  return next->next;
};
bool CColorData::loadtype(PType type)
{
PSgmlEl sgmlpar, sgmlload;
PScheme scheme;
char path[512];
char *data, *savedname, *param1;
int  file, sz, i;
bool sloaded = false;

  if (!type) return false;
  if (type->loaded) return true;

  sprintf(path, "--- loading type '%s' ---", type->descr);
  STARTLOG(path);
  scheme = slist;
  while(scheme->next) scheme = scheme->next;

  for(sgmlpar = type->block->child(); sgmlpar; sgmlpar = sgmlpar->next()){
    if (sgmlpar->name && !stricmp(sgmlpar->name,"scheme")){
      param1 = sgmlpar->GetChrParam("value");
      type->sname = new char[strlen(param1)+1];
      strcpy(type->sname, param1);
      sloaded = true;
    };
    if (sgmlpar->name && !stricmp(sgmlpar->name,"load")){
      param1 = sgmlpar->GetChrParam("value");
      if (!param1) continue;
      strcpy(path,filepath);
      savedname = dbgFileName;
      dbgFileName = param1;
      strcpy(path,filepath);
      for (i = strlen(path); i; i--)
        if (path[i]=='\\' || path[i]=='/') break;
      strcpy(path+i+1, param1);

      file = open(path,O_BINARY|O_RDONLY);
      ERRLOG(file == -1, "cannot include file '%s'\n", dbgFileName,0,0);
      if (file == -1 || !(sz = filelength(file)))
        continue;
      data = new char[sz];
      read(file, data, sz);
      close(file);

      sgmlload = new CSgmlEl;
      sgmlload->parse(data, sz);
      delete[] data;
      ReadColorData(sgmlload->next(), &scheme, NULL);
      delete sgmlload;
      dbgFileName = savedname;
    };
  };
  type->loaded = true;
  ERRLOG(!sloaded, "found type block '%s' without scheme tag\n",type->descr,0,0);
  updatelinks();
  ENDLOG();
  return true;
};
