#define RegWorking    "working"
#define RegFileName   "basefile"
#define RegErrLog     "errlog"

#define RcFileName   "colorset.hrc"

enum {  mName, mSetup, mTurnOff, mErrLog,
  mOk, mOk1,
  mCancel, mBasefile, mMsg1 };

typedef struct STypeInfo
{
  unsigned int color, row, col;
  int backparse, brcolor, brtype, maxlinelen;
  bool useht, fullback, separator;
}*PTypeInfo;

typedef struct SFileList *PFileList;
struct SFileList
{
  int        id;
  PType      CurType;
  PTypeInfo  typeinfo;
  PColorer   FullParse;
  PLineHL    FLines;
  PFileList  Next, Prev;
  int        endline;

  PFileList GetFile(int fid);
  PFileList AddFile(int fid);
  bool DeleteFile(int fid);
  SFileList();
  ~SFileList();
};


extern "C"{
  HANDLE WINAPI _export OpenPlugin(int OpenFrom,int Item);
  void   WINAPI _export ExitFAR();
  void   WINAPI _export SetStartupInfo(struct PluginStartupInfo *Info);
  void   WINAPI _export GetPluginInfo(struct PluginInfo *Info);
  int    WINAPI _export Configure(int ItemNumber);
  int    WINAPI _export ProcessEditorInput(INPUT_RECORD *Rec);
  int    WINAPI _export ProcessEditorEvent(int Event,void *Param);
};

void ReloadData();
char *GetMsg(int MsgId);
DWORD WINAPI IdleMon(void *data);
bool loadtypes();
bool freetypes();
PFileList loadfile(PType CurType);
