//
//  Copyright (c) Cail Lomecb (Igor Ruskih) 1999-2000 <ruiv@uic.nnov.ru>
//  You can use, modify, distribute this code or any other part
//  of colorer library in sources or in binaries only according
//  to Colorer License (see /doc/(rus/)?license.txt for more information).
//
#include<stdio.h>
#include<stdlib.h>
#include<windows.h>

#include<sgml/sgml.h>
#include<regexp/cregexp.h>
#include<farplugin/plugin.hpp>
#include<misc/registry.cpp>
#include<colorer/classes.h>

#include"pcolorer.h"

PluginStartupInfo Info;
EditorInfo EditInfo;
PColorData ColorData = NULL;
HKEY hPlugReg;
PFileList CurList, FileList = NULL;
bool rWorking = true, rErrLog = false;
int  EID = -1;

#include"ptypes.cpp"
#include"pconfig.cpp"

char*  PluginMenuStrings;
HANDLE hIdleThr, hIdle;
char   PalettePath[100];
char   HRCPath[512];
bool   ErrorLoad = false, GotMsg = false;
int    maxlinelen, BkCol, oldblock = 0x1000000;
int    curline, curpos;
PLineHL FLines;
STypeInfo defpars;
struct{ char s,e; }brackets[4] = {{'(',')'}, {'[',']'}, {'{','}'}, {'<','>'}, };

//////////////////////////////////////////////////////////////////////////
char *GetLine(PColorer obj, int no, int *len)
{
EditorGetString EditStr;
  EditStr.StringNumber = no;
  EditStr.StringText = NULL;
  if (!Info.EditorControl(ECTL_GETSTRING,&EditStr)) return NULL;
  if (len){
    *len = EditStr.StringLength;
    if (*len > maxlinelen) *len = maxlinelen;
  };
  return EditStr.StringText;
};

void ReloadData()
{
char Key[512];
HKEY hColor;
int  i,j,len;
char *marr[2] = {"colorer", "just wait - i'm reloading..."};

  rWorking  = rGetValue(hPlugReg,RegWorking) != 0;
  rErrLog   = rGetValue(hPlugReg,RegErrLog) != 0;
  if (rWorking) return;

  HANDLE scr = Info.SaveScreen(0,0,-1,-1);
  Info.Message(Info.ModuleNumber, 0, NULL, &marr[0], 2, 0);

  hColor = rOpenKey(HKEY_CURRENT_USER,PalettePath);
  i = rGetValue(hColor,"CurrentPalette", HRCPath, 0x100);
  BkCol = i?HRCPath[0x35]:0xF0;
  RegCloseKey(hColor);

  strcpy(HRCPath, Info.ModuleName);
  for (j = 0, i = strlen(HRCPath); i; i--){
    if (j && (HRCPath[i]=='\\' || HRCPath[i]=='/')) break;
    if (HRCPath[i]=='\\' || HRCPath[i]=='/') j++;
  };

  len = rGetValue(hPlugReg, RegFileName, Key, 512);
  // MD returns 1, and wnt returns 0  :(
  if (len < 2) strcpy(HRCPath + i + 1, RcFileName);
  else strcpy(HRCPath, Key);
  EID = -1;
  freetypes();
  if (FileList) delete FileList;
  delete ColorData;
  ColorData = new CColorData(HRCPath, rErrLog?"c:\\_colorer.log":NULL);
  ErrorLoad = !ColorData->isok();
  loadtypes();
  FileList = new SFileList;

  Info.RestoreScreen(scr);
};

//////////////////////////////////////////////////////////////////////////
void WINAPI SetStartupInfo(struct PluginStartupInfo *Info)
{
int i;
DWORD thrid;
char Key[200];

  memset(&::Info, 0, sizeof(::Info));
  memmove(&::Info, Info, (Info->StructSize > sizeof(::Info))?sizeof(::Info):Info->StructSize);

  sprintf(Key,"%s\\Colorer",::Info.RootKey);
  hPlugReg = rOpenKey(HKEY_CURRENT_USER,Key);
  strcpy(PalettePath,::Info.RootKey);
  for (i = strlen(PalettePath);i; i--)
    if ((PalettePath[i]=='\\' || PalettePath[i]=='/')) break;
  sprintf(PalettePath+i,"\\Colors");

  ReloadData();
  hIdleThr = CreateThread(NULL,0,IdleMon,0,0,&thrid);
};

void WINAPI ExitFAR()
{
  if (FileList) delete FileList;
  delete ColorData;
  TerminateThread(hIdleThr,0);
  CloseHandle(hIdleThr);
  RegCloseKey(hPlugReg);
  FindCloseChangeNotification(hIdle);
};

void WINAPI GetPluginInfo(struct PluginInfo *Info)
{
  memset(Info, 0, sizeof(*Info));
  Info->Flags = PF_EDITOR|PF_DISABLEPANELS;
  Info->StructSize = sizeof(*Info);
  Info->PluginConfigStringsNumber = 1;
  Info->PluginMenuStringsNumber = 1;
  PluginMenuStrings = GetMsg(mName);
  Info->PluginConfigStrings = &PluginMenuStrings;
  Info->PluginMenuStrings = &PluginMenuStrings;
};

HANDLE WINAPI OpenPlugin(int OpenFrom,int Item)
{
  if (OpenFrom == OPEN_EDITOR)
    SyntaxMenu();
  else
    Configure(0);
  return 0;
};

char *GetMsg(int MsgId)
{
  return(Info.GetMsg(Info.ModuleNumber,MsgId));
};

DWORD WINAPI IdleMon(void *data)
{
char Path[300];
int i;
  strcpy(Path, HRCPath);
  for (i = strlen(Path);i; i--)
    if (Path[i]=='\\' || Path[i]=='/') break;
  Path[i]=0;

  hIdle = FindFirstChangeNotification(Path,true,FILE_NOTIFY_CHANGE_LAST_WRITE);
  if (hIdle == INVALID_HANDLE_VALUE) return 0;
  while(true){
    WaitForSingleObject(hIdle,INFINITE);
    FindNextChangeNotification(hIdle);
    if (rWorking) continue;
    GotMsg = true;
    EID = -1;
  };
  FindCloseChangeNotification(hIdle);
  return 0;
};

//////////////////////////////////////////////////////////////////////////
void setpars(PType type)
{
PTypeInfo di;
PSgmlEl par;
int res;
char *str;

  di = new STypeInfo;
  memmove(di, &defpars, sizeof(defpars));
  if (type->params) delete type->params;
  type->params = di;
  di->separator = type->block->GetChrParam("separator")?true:false;
  for(par = type->block->child(); par; par = par->next()){
    if (par->name && !stricmp(par->name,"params")){
      if (par->GetIntParam("backparse", &res))
        di->backparse = res;
      if (par->GetIntParam("maxlinelen", &res))
        di->maxlinelen = res;
      if (!di->maxlinelen) di->maxlinelen = 8000;

      di->fullback = par->GetChrParam("fullback") != NULL;
      di->brcolor = ColorData->GetColor(par->GetChrParam("brcolor"));
      if (!di->brcolor) di->brcolor = defpars.brcolor;
      di->brtype = 0;
      str = par->GetChrParam("brtype");
      if (!str){
        di->brtype = 0xF;
        continue;
      };
      while(*str){
        switch(*str){
          case '(':
            di->brtype |= 0x1; break;
          case '[':
            di->brtype |= 0x2; break;
          case '{':
            di->brtype |= 0x4; break;
          case '<':
            di->brtype |= 0x8; break;
        };
        str++;
      };
    };
    if (par->name && !stricmp(par->name,"colors")){
      if (par->GetChrParam("useht")) di->useht = true;
      di->color = ColorData->GetColor(par->GetChrParam("color"));
      if (!di->color) di->color = defpars.color;
      di->col = ColorData->GetColor(par->GetChrParam("col"));
      if (!di->col) di->col = defpars.col;
      di->row = ColorData->GetColor(par->GetChrParam("row"));
      if (!di->row) di->row = defpars.row;
    };
  };
};

bool loadtypes()
{
PType type;
  if (!ColorData) return false;
  memset(&defpars, 0, sizeof(defpars));
  defpars.backparse = 2000;
  // default type
  for(type = ColorData->enumtypes(NULL); type; type = ColorData->enumtypes(type))
    if (type->name && !stricmp(type->name,"default")){
      setpars(type);
      break;
    };
  if (type) memmove(&defpars, type->params, sizeof(defpars));
  // all types
  for(type = ColorData->enumtypes(NULL); type; type = ColorData->enumtypes(type))
    setpars(type);
  return true;
};
bool freetypes()
{
PType type;
  if (!ColorData) return false;
  for(type = ColorData->enumtypes(NULL); type; type = ColorData->enumtypes(type))
    delete (PTypeInfo)type->params;
  return true;
};

PFileList loadfile(PType CurType)
{
PFileList fl;
  ColorData->loadtype(CurType);
  if (!CurType->loaded)
    setpars(CurType);

  fl = FileList->AddFile(EditInfo.EditorID);
  fl->FullParse = new CColorer();
  fl->FLines = fl->FullParse->SetMaxLines(100);
  fl->FullParse->SetServices(GetLine, 0);
  fl->FullParse->SetColoringSrc(CurType);
  fl->CurType = CurType;
  fl->typeinfo = (PTypeInfo)CurType->params;
  maxlinelen = fl->typeinfo->maxlinelen;
  return fl;
};
unsigned int inline convert(unsigned int col, unsigned int bk)
{
  if (col>>0x10 == 0xFFFF) col = (bk<<12 & 0xFFFF0000) + (col&0xFFFF);
  if ((col&0xFFFF) == 0xFFFF) col = (bk&0xF) + (col&0xFFFF0000);
  return (col>>12 & 0xF0) + (col & 0xF);
};

int WINAPI ProcessEditorEvent(int Event,void *Param)
{
EditorColor EditColor;
EditorConvertPos ecp;
char       *FileName, *line;
PType       CurType;
PLineHL     Lines,l1;
int         i, j, fr, ctc, len;
  // disable work
  if (rWorking) return 0;
  // close file
  if (Event == EE_CLOSE){
    CurList = FileList->GetFile(*(int *)Param);
    EID = -1;
    if (!CurList) return 0;
    FileList->DeleteFile(*(int *)Param);
    return 0;
  };
  // ignores
  if (Event != EE_REDRAW) return 0;
  if ((int)Param){
    Info.EditorControl(ECTL_REDRAW,0);
    return 0;
  };
  // reloading
  if (GotMsg){
    ReloadData();
    GotMsg = false;
    EID = -1;
  };
  if (ErrorLoad) return 0;

  // search
  Info.EditorControl(ECTL_GETINFO,&EditInfo);
  curline = EditInfo.CurLine;
  curpos = EditInfo.CurPos;

  FileName = EditInfo.FileName;
  if (EID != EditInfo.EditorID)
    if (!(CurList = FileList->GetFile(EditInfo.EditorID))){
      CurType = ColorData->seltype(FileName,GetLine(0, 0, 0));
      if (CurType) CurList = loadfile(CurType);
    };
  if (!CurList || !CurList->CurType) return 0;
  CurType = CurList->CurType;
  EID = EditInfo.EditorID;
  Lines = CurList->FLines;

  // optimizing and coloring
  fr = (EditInfo.TopScreenLine > CurList->endline)?CurList->endline:EditInfo.TopScreenLine;
  CurList->endline = EditInfo.TopScreenLine;
  if (EditInfo.BlockType == BTYPE_NONE && fr > oldblock)
    fr = CurList->endline = oldblock;
  if (EditInfo.BlockType != BTYPE_NONE) oldblock = EditInfo.BlockStartLine;
  else oldblock = 0x1000000;
  if (EditInfo.TopScreenLine - fr > CurList->typeinfo->backparse)
    fr = EditInfo.TopScreenLine - CurList->typeinfo->backparse;
  CurList->FullParse->FullParse(fr, EditInfo.TopScreenLine, EditInfo.WindowSizeY,
     EditInfo.TopScreenLine - fr + EditInfo.WindowSizeY);

  // correct for tabs
  ecp.StringNumber = -1;
  ecp.SrcPos = EditInfo.CurPos;
  Info.EditorControl(ECTL_REALTOTAB,&ecp);
  // set colors
  ctc = convert(CurList->typeinfo->color, BkCol);
  if (!ctc) ctc = BkCol;
  for(i = 0; i < EditInfo.WindowSizeY; i++){
    l1 = Lines[i+1].next;
    // clear
    EditColor.StringNumber = i+Lines[0].start;
    EditColor.StartPos = -1;
    EditColor.Color = 0;
    Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
    // fill bg
    if (ctc != BkCol){
      EditColor.StartPos = 0; //EditInfo.LeftPos;
      EditColor.EndPos = EditInfo.LeftPos+EditInfo.WindowSizeX-1;
      EditColor.Color = ctc;
      Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
    };
    // draw current cursor's row
    if (EditInfo.TopScreenLine+i == EditInfo.CurLine && CurList->typeinfo->row){
      EditColor.StartPos = EditInfo.LeftPos;
      EditColor.EndPos = EditInfo.LeftPos+EditInfo.WindowSizeX-1;
      EditColor.Color = convert(CurList->typeinfo->row, ctc);
      Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
      while(l1){
        if (CurList->typeinfo->useht)
          l1->color = (l1->color&0xFFFF) + (CurList->typeinfo->row&0xFFFF0000);
        if (l1->color == 0xFFFFFFFF)
          l1->color = CurList->typeinfo->row;
        l1 = l1->next;
      };
      l1 = Lines[i+1].next;
    };
    // each line
    if (EditInfo.TopScreenLine+i != EditInfo.CurLine || !CurList->typeinfo->row || CurList->typeinfo->useht)
      while(l1){
        EditColor.Color = convert(l1->color, ctc);
        EditColor.StartPos = l1->start;
        EditColor.EndPos = (l1->end&0x7fff)-1;
        // l1->end can have 15th bit on!
        if (l1->end&0x8000 && CurList->typeinfo->fullback && ((l1->color>>0x16)!=0xFFFF))
          EditColor.EndPos = EditInfo.LeftPos+EditInfo.WindowSizeX-1;
        Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
        l1 = l1->next;
      };
    // vertical column
    if (CurList->typeinfo->col){
      if (EditInfo.TopScreenLine+i == EditInfo.CurLine && CurList->typeinfo->row)
        continue;
      ecp.StringNumber = EditColor.StringNumber;
      ecp.SrcPos = ecp.DestPos;
      Info.EditorControl(ECTL_TABTOREAL,&ecp);
      EditColor.StartPos = ecp.DestPos;
      EditColor.EndPos = ecp.DestPos;
      EditColor.Color = convert(CurList->typeinfo->col, ctc);
      Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
      ecp.DestPos = ecp.SrcPos;
    };
  };

  // brackets
  int brlev = 0, brtype, brno = 4;

  line = GetLine(0, curline, &len);
  while(true){
    if (len > curpos){
      brtype = 0;
      for(brno = 0; brno < 4 && line[curpos] != brackets[brno].s; brno++);
      if (brno < 4) break;
      brtype = 1;
      for(brno = 0; brno < 4 && line[curpos] != brackets[brno].e; brno++);
      if (brno < 4) break;
    };
    curpos--;
    if (len > curpos){
      brtype = 0;
      for(brno = 0; brno < 4 && line[curpos] != brackets[brno].s; brno++);
      if (brno < 4) break;
      brtype = 1;
      for(brno = 0; brno < 4 && line[curpos] != brackets[brno].e; brno++);
      if (brno < 4) break;
    };
    break;
  };
  if (brno < 4 && CurList->typeinfo->brcolor && (CurList->typeinfo->brtype&1<<brno))
  if (brtype == 0){
    // forward
    EditColor.Color = convert(CurList->typeinfo->brcolor, ctc);
    EditColor.StringNumber = curline;
    EditColor.StartPos = curpos;
    EditColor.EndPos = curpos;
    Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
    brlev = 1;
    for(j = curline; brlev && j < curline+EditInfo.WindowSizeY; j++){
      line = GetLine(0, j, &len);
      if (!line) break;
      i = (j==curline)?curpos+1:0;
      for(; i < len; i++){
        if (line[i] == brackets[brno].e) brlev--;
        if (line[i] == brackets[brno].s) brlev++;
        if (!brlev){
          EditColor.StringNumber = j;
          EditColor.StartPos = i;
          EditColor.EndPos = i;
          Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
          break;
        };
      };
    };
  }else{
    // backward
    EditColor.Color = convert(CurList->typeinfo->brcolor, ctc);
    EditColor.StringNumber = curline;
    EditColor.StartPos = curpos;
    EditColor.EndPos = curpos;
    Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
    brlev = 1;
    for(j = curline; brlev && j > EditInfo.TopScreenLine-1; j--){
      line = GetLine(0, j, &len);
      if (!line) break;
      i = (j==curline)?curpos-1:len-1;
      for(; i >= 0; i--){
        if (line[i] == brackets[brno].e) brlev++;
        if (line[i] == brackets[brno].s) brlev--;
        if (!brlev){
          EditColor.StringNumber = j;
          EditColor.StartPos = i;
          EditColor.EndPos = i;
          Info.EditorControl(ECTL_ADDCOLOR,&EditColor);
          break;
        };
      };
    };
  };
  return true;
};
