
#include <defs.h>
#include <colorer/classes.h>
#include <regexp/cregexp.h>
#include <sgml/sgml.h>

#include "colorerc.h"

typedef struct STypeInfo
{
  unsigned int color, row, col;
  int          backparse, brcolor, brtype, maxlinelen;
  bool         useht, fullback, separator;
} *PTypeInfo;

typedef struct SFileList *PFileList;

struct SFileList
{
  int        id;
  PType      CurType;
  PTypeInfo  typeinfo;
  PColorer   FullParse;
  PLineHL    FLines;
  PFileList  Next, Prev;
  int        endline;

  PFileList GetFile(int fid);
  PFileList AddFile(int fid);
  bool DeleteFile(int fid);
  SFileList();
  ~SFileList();
};
