#include <string.h>
#include <io.h>
#include <fcntl.h>

#include "connect.h"
#include "colorer.h"

PColorData ColorData = NULL;
PFileList FileList = NULL, CurList = NULL;
STypeInfo defpars;
bool ErrorLoad = false;
int maxlinelen, BkCol, oldblock = 0x1000000;
PPluginStartupInfo  Info;
EditorInfo  EditInfo;
int EID = -1;
int curline, curpos, curEditor;
char HRCPath[260];

const tb = 4;

struct
{
  char s, e;
} brackets[ tb ] =
{
  { '(', ')' },
  { '[', ']' },
  { '{', '}' },
  { '<', '>' }
//  { '"', '"' },
//  { 27,  27  }
};

#include "ptypes.cpp"
#include "log.cpp"

void setpars( PType type )
{
  PTypeInfo di;
  PSgmlEl par;
  int res;
  char *str;

  di = new STypeInfo;
  memmove( di, &defpars, sizeof( defpars ) );
  if ( type->params )
    delete type->params;
  type->params = di;
  di->separator = type->block->GetChrParam( "separator" ) ? true : false;
  for ( par = type->block->child(); par; par = par->next() )
  {
    if ( par->name && !stricmp( par->name, "params" ) )
    {
      if ( par->GetIntParam( "backparse", &res ) )
        di->backparse = res;
      if ( par->GetIntParam( "maxlinelen", &res ) )
        di->maxlinelen = res;
      if ( !di->maxlinelen )
        di->maxlinelen = 8000;

      di->fullback = par->GetChrParam( "fullback" ) != NULL;
      di->brcolor = ColorData->GetColor( par->GetChrParam( "brcolor" ) );
      if ( !di->brcolor )
        di->brcolor = defpars.brcolor;
      di->brtype = 0;
      str = par->GetChrParam( "brtype" );
      if ( !str )
      {
        di->brtype = 0xF;
        continue;
      }
      while ( *str )
      {
        switch ( *str )
        {
          case '(':
            di->brtype |= 0x1; break;
          case '[':
            di->brtype |= 0x2; break;
          case '{':
            di->brtype |= 0x4; break;
          case '<':
            di->brtype |= 0x8; break;
//          case '"':
//            di->brtype |= 0x10; break;
//          case 27:
//            di->brtype |= 0x20; break;
        }
        str++;
      }
    }
    if ( par->name && !stricmp( par->name, "colors" ) )
    {
      if ( par->GetChrParam( "useht" ) )
        di->useht = true;
      di->color = ColorData->GetColor( par->GetChrParam( "color" ) );
      if ( !di->color )
        di->color = defpars.color;
      di->col = ColorData->GetColor( par->GetChrParam( "col" ) );
      if ( !di->col )
        di->col = defpars.col;
      di->row = ColorData->GetColor( par->GetChrParam( "row" ) );
      if ( !di->row )
        di->row = defpars.row;
    }
  }
}

bool loadtypes()
{
  PType type;

  if ( !ColorData )
    return false;

  memset( &defpars, 0, sizeof( defpars ) );

  defpars.backparse = 2000;

  for ( type = ColorData->enumtypes( NULL ); type; type = ColorData->enumtypes( type ) )
    if ( type->name && !stricmp( type->name, "default" ) )
    {
      setpars( type );
      break;
    }
  if ( type ) memmove( &defpars, type->params, sizeof( defpars ) );

  for ( type = ColorData->enumtypes( NULL ); type; type = ColorData->enumtypes( type ) )
    setpars( type );

  return true;
}

bool freetypes()
{
  PType type;

  if ( !ColorData )
    return false;
  for ( type = ColorData->enumtypes( NULL ); type; type = ColorData->enumtypes( type ) )
    delete ( PTypeInfo )type->params;

  return true;
}

void ReloadData()
{
  int i;

  freetypes();

  delete FileList;
  delete ColorData;

  strcpy( HRCPath, Info->ModuleName );
  for ( i = strlen( HRCPath ); i; i-- )
  {
//    if ( j && ( HRCPath[i] == '\\' || HRCPath[i] == '/' ) )
//      break;
//    if ( HRCPath[i] == '\\' || HRCPath [i] == '/' )
//      j++;
    if ( HRCPath[i] == '\\' || HRCPath[i] == '/' )
      break;
  }

  strcpy( HRCPath + i + 1, "colorset.hrc" );

  ColorData = new CColorData( HRCPath, NULL );
  ErrorLoad = !ColorData->isok();

  loadtypes();
  FileList = new SFileList;
}

char *GetLine( PColorer obj, int no, int *len )
{
  EditorGetString EditStr;

  EditStr.StringNumber = no;
  EditStr.StringText = NULL;

  if ( !Info->EditorControl( curEditor, ECTL_GETSTRING, &EditStr ) )
    return NULL;

  if ( len )
  {
    *len = EditStr.StringLength;
    if ( *len > maxlinelen )
      *len = maxlinelen;
  }

  return EditStr.StringText;
}

PFileList loadfile( PType CurType )
{
  PFileList fl;
  char buf[200];

  ColorData->loadtype( CurType );

  if ( !CurType->loaded )
    setpars( CurType );

//  sprintf( buf, "Adding list %p\n", EditInfo.EditorID );

//  writelog( buf );

  fl = FileList->AddFile( EditInfo.EditorID );
  fl->FullParse = new CColorer();
  fl->FLines = fl->FullParse->SetMaxLines( 100 );
  fl->FullParse->SetServices( GetLine, 0 );
  fl->FullParse->SetColoringSrc( CurType );
  fl->CurType = CurType;
  fl->typeinfo = ( PTypeInfo )CurType->params;
  maxlinelen = fl->typeinfo->maxlinelen;

  return fl;
}

unsigned int inline convert( unsigned int col, unsigned int bk )
{
  if ( col >> 0x10 == 0xFFFF )
    col = ( bk << 12 & 0xFFFF0000 ) + ( col & 0xFFFF );
  if ( ( col & 0xFFFF ) == 0xFFFF )
    col = ( bk & 0xF ) + ( col & 0xFFFF0000 );
  return ( col >> 12 & 0xF0 ) + ( col & 0xF );
}

APIRET APIENTRY OpenPlugin( int iOpenFrom, int iItem, int iHandle )
{
  return 0;
}

APIRET APIENTRY ClosePlugin( int iHandle )
{
  return 0;
}

APIRET APIENTRY ExitCONNECT()
{
  freetypes();

  delete FileList;
  delete ColorData;

//  closelog();

  return 0;
}

APIRET APIENTRY SetStartupInfo(PPluginStartupInfo ppsi)
{
  Info = ppsi;

//  openlog( "j:\\connect\\colorer\\src\\cnlib\\colorer.log" );

  ReloadData();

  return 0;
}

APIRET APIENTRY ProcessEditorEvent( int hEditor, int iEvent, void * pParam )
{
  EditorColor EditColor;
//  EditorConvertPos ecp;
  char *FileName, *line;
  PType CurType;
  PLineHL     Lines, l1;
  int i, j, fr, ctc, len, scrpos;

  curEditor = hEditor;

  // close file
  if ( iEvent == EE_CLOSE )
  {
    CurList = FileList->GetFile( ( int )pParam );
    EID = -1;
    if ( !CurList )
      return 0;
    FileList->DeleteFile( ( int )pParam );
    return 0;
  }

  if ( iEvent == EE_READ )
    return 0;

  if ( ErrorLoad ) return 0;

  // search
  Info->EditorControl( hEditor, ECTL_GETINFO, &EditInfo );
  curline = EditInfo.CurLine;
  curpos = EditInfo.CurPos;

  FileName = EditInfo.FileName;
  if ( EID != EditInfo.EditorID )
  {
    if ( !( CurList = FileList->GetFile( EditInfo.EditorID ) ) )
    {
      CurType = ColorData->seltype( FileName, GetLine( 0, 0, 0 ) );
      if ( CurType )
        CurList = loadfile( CurType );
    }
  }

  if ( !CurList || !CurList->CurType )
    return 0;
  CurType = CurList->CurType;
  EID = EditInfo.EditorID;
  Lines = CurList->FLines;

  // optimizing and coloring
  fr = ( EditInfo.TopScreenLine > CurList->endline ) ? CurList->endline : EditInfo.TopScreenLine;
  CurList->endline = EditInfo.TopScreenLine;
//  if ( EditInfo.BlockType == BTYPE_NONE && fr > oldblock )
//    fr = CurList->endline = oldblock;
//  if ( EditInfo.BlockType != BTYPE_NONE )
//    oldblock = EditInfo.BlockStartLine;
//  else
    oldblock = 0x1000000;
  if ( EditInfo.TopScreenLine - fr > CurList->typeinfo->backparse )
    fr = EditInfo.TopScreenLine - CurList->typeinfo->backparse;
  CurList->FullParse->FullParse( fr, EditInfo.TopScreenLine,
    EditInfo.WindowSizeY, EditInfo.TopScreenLine - fr + EditInfo.WindowSizeY);

  // correct for tabs
//  ecp.StringNumber = -1;
//  ecp.SrcPos = EditInfo.CurPos;
//  Info.EditorControl( ECTL_REALTOTAB,&ecp );

  scrpos = EditInfo.CurPos;

  // set colors
  ctc = convert( CurList->typeinfo->color, BkCol );
  if ( !ctc )
    ctc = BkCol;

  for( i = 0; i < EditInfo.WindowSizeY; i++ )
  {
    l1 = Lines[ i + 1 ].next;
    // clear
    EditColor.StringNumber = i + Lines[ 0 ].start;
    EditColor.StartPos = -1;
    EditColor.Color = 0;
    Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
    // fill bg
    if ( ctc != BkCol )
    {
      EditColor.StartPos = 0; //EditInfo.LeftPos;
      EditColor.EndPos = EditInfo.LeftPos + EditInfo.WindowSizeX - 1;
      EditColor.Color = ctc;
      Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
    };

    // each line
    if ( EditInfo.TopScreenLine + i != EditInfo.CurLine || !CurList->typeinfo->row || CurList->typeinfo->useht )
      while( l1 )
      {
        EditColor.Color = convert( l1->color, ctc );
        EditColor.StartPos = l1->start;
        EditColor.EndPos = ( l1->end & 0x7fff ) - 1;
        // l1->end can have 15th bit on!
        if ( l1->end & 0x8000 && CurList->typeinfo->fullback && ( ( l1->color >> 0x16 ) != 0xFFFF ) )
          EditColor.EndPos = EditInfo.LeftPos + EditInfo.WindowSizeX - 1;
        Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
        l1 = l1->next;
      }
  }

  // brackets
  int brlev = 0, brtype, brno = tb;

  line = GetLine( 0, curline, &len );
  while ( true )
  {
    if ( len > curpos )
    {
      brtype = 0;
      for ( brno = 0; brno < tb && line[ curpos ] != brackets[ brno ].s; brno++ );
      if ( brno < tb )
        break;
      brtype = 1;
      for ( brno = 0; brno < tb && line[ curpos ] != brackets[ brno ].e; brno++ );
      if ( brno < tb )
        break;
    }
    curpos--;
    if ( len > curpos )
    {
      brtype = 0;
      for ( brno = 0; brno < tb && line[ curpos ] != brackets[ brno ].s; brno++ );
      if ( brno < tb ) break;
      brtype = 1;
      for ( brno = 0; brno < tb && line[ curpos ] != brackets[ brno ].e; brno++ );
      if ( brno < tb ) break;
    }
    break;
  }
  if ( brno < tb && CurList->typeinfo->brcolor && ( CurList->typeinfo->brtype & 1 << brno ) )
  if ( brtype == 0 )
  {
    // forward
    EditColor.Color = convert( CurList->typeinfo->brcolor, ctc );
    EditColor.StringNumber = curline;
    EditColor.StartPos = curpos;
    EditColor.EndPos = curpos;
    Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
    brlev = 1;
    for ( j = curline; brlev && j < curline + EditInfo.WindowSizeY; j++ )
    {
      line = GetLine( 0, j, &len );
      if ( !line )
        break;
      i = ( j == curline ) ? curpos + 1 : 0;
      for( ; i < len; i++ )
      {
        if ( line[ i ] == brackets[ brno ].e )
          brlev--;
        if ( line[ i ] == brackets[ brno ].s )
          brlev++;
        if ( !brlev )
        {
          EditColor.StringNumber = j;
          EditColor.StartPos = i;
          EditColor.EndPos = i;
          Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
          break;
        }
      }
    }
  }
  else
  {
    // backward
    EditColor.Color = convert( CurList->typeinfo->brcolor, ctc );
    EditColor.StringNumber = curline;
    EditColor.StartPos = curpos;
    EditColor.EndPos = curpos;
    Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
    brlev = 1;
    for ( j = curline; brlev && j > EditInfo.TopScreenLine - 1; j-- )
    {
      line = GetLine( 0, j, &len );
      if ( !line )
        break;
      i = ( j == curline ) ? curpos - 1 : len - 1;
      for ( ; i >= 0; i-- )
      {
        if ( line[ i ] == brackets[ brno ].e )
          brlev++;
        if ( line[ i ] == brackets[ brno ].s )
          brlev--;
        if ( !brlev )
        {
          EditColor.StringNumber = j;
          EditColor.StartPos = i;
          EditColor.EndPos = i;
          Info->EditorControl( hEditor, ECTL_ADDCOLOR, &EditColor );
          break;
        }
      }
    }
  }

  return true;
}
