;;; CLASS BROWSER FOR C++
;;; $Id: br-stat.el,v 3.1 1995/02/17 18:19:36 mmann Exp $
;;;
;;; **********************************************************************
;;; Copyright (C) 1993, 1994 Gerd Moellmann. All rights reserved.
;;; Altenbergstr. 6, D-40235 Duesseldorf, Germany
;;; 100025.3303@COMPUSERVE.COM
;;; Suggestions, comments and requests for improvements are welcome.
;;; **********************************************************************
;;;
;;; This version works with both Emacs version 18 and 19, and I want
;;; to keep it that way. It requires the CL-19 Common Lisp compatibility
;;; package for Emacs 18 and 19.
;;;
;;; This contains code that displays statistics for a class tree.
;;; 

;; This file may be made part of the Emacs distribution at the option
;; of the FSF.

;; This code is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; this code, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(require 'cl-19 "cl")
(require 'backquote)
(require 'br-struc)
(require 'br-macro)

;;;
;;; Provide the following statistics in a buffer:
;;;
;;; (1) Number of classes
;;; (2) Number of classes with multiple base classes
;;; (3) Number of member functions, variables etc.
;;;
;;; Must be called with current buffer = tree buffer because it
;;; accesses buffer-local variables.
;;;
;;; ###autoload

(defun tree-statistics ()
  (interactive)
  (let ((tree-file (buffer-file-name)))
    (with-output-to-temp-buffer "*Tree Statistics*"
      (multiple-value-bind (classes member-functions member-variables
				    static-functions static-variables)
	  (tree-stats)
	(set-buffer standard-output)
	(erase-buffer)
	(insert "STATISTICS FOR TREE " (or tree-file "unknown") ":\n\n")
	(tree-stat-print "Number of classes:" classes)
	(tree-stat-print "Number of member funtions:" member-functions)
	(tree-stat-print "Number of member variables:" member-variables)
	(tree-stat-print "Number of static functions:" static-functions)
	(tree-stat-print "Number of static variables:" static-variables)))))

;;;
;;; Print TITLE, indent to column 40 and print integer value VALUE.
;;; 

(defun tree-stat-print (title value)
  (insert title)
  (indent-to 40)
  (insert (format "%d\n" value)))

;;;
;;; Return multiple values describing statistics of a tree.
;;; 

(defun* tree-stats (&aux (classes 0)
			 (member-functions 0)
			 (member-variables 0)
			 (static-functions 0)
			 (static-variables 0))
  (dotrees (tree @tree-obarray)
    (incf classes)
    (incf member-functions (length (tree-member-functions tree)))
    (incf member-variables (length (tree-member-variables tree)))
    (incf static-functions (length (tree-static-functions tree)))
    (incf static-variables (length (tree-static-variables tree))))
  (values classes member-functions member-variables
	  static-functions static-variables))

(provide 'br-stat)

;;; end of `br-stat.el'.
    