/* HTML to ASCII (852) converter */

'@echo off'
parse arg input output maradek

if input = '' | output = '' | maradek <> '' then
        do
                say 'HTML to ASCII (852) converter'
                exit
        end

'del 'output' >NUL 2>>&1'

accented_table  = "֢遚"
htmltag.1       = "&aacute;"  /*  */
htmltag.2       = "&Aacute;"  /*  */
htmltag.3       = "&eacute;"  /*  */
htmltag.4       = "&Eacute;"  /*  */
htmltag.5       = "&iacute;"  /*  */
htmltag.6       = "&Iacute;"  /*  */
htmltag.7       = "&oacute;"  /*  */
htmltag.8       = "&Oacute;"  /*  */
htmltag.9       = "&ouml;"    /*  */
htmltag.10      = "&Ouml;"    /*  */
htmltag.11      = "&ocirc;"   /*  */
htmltag.12      = "&Ocirc;"   /*  */
htmltag.13      = "&uacute;"  /*  */
htmltag.14      = "&Uacute;"  /*  */
htmltag.15      = "&uuml;"    /*  */
htmltag.16      = "&Uuml;"    /*  */
htmltag.17      = "&ucirc;"   /*  */
htmltag.18      = "&Ucirc;"   /*  */

do while lines(input)
        line = linein(input)
        do tag_num = 1 to 18
                tag = htmltag.tag_num
                do until tag_pos = 0
                        tag_pos = pos(tag,line)
                        if tag_pos <> 0 then
                                do
                                        acc_char = substr(accented_table, tag_num, 1)
                                        if tag_pos = 1 then
                                                head = ''
                                        else
                                                head = left(line, tag_pos-1)
                                        if tag_pos = length(line) - length(tag) + 1 then
                                                tail = ''
                                        else
                                                tail = substr(line, tag_pos+length(tag))
                                        line = head || acc_char || tail
                                end
                end
        end
        rc = lineout(output, line)
end

rc = lineout(input)
rc = lineout(output)

exit
