//
// $Header: i:/ifs/RCS/32BITS/IFS-OS2/fsd32/fs32_init.c,v 1.4 1998/02/08 17:44:31 STEINER Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996, 1997  Matthieu WILLM (willm@ibm.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>


#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/DevHlp32.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>
#include <os2/vfsapi.h>
#include <os2/ifsdbg.h>
#include <os2/bounds.h>


/***********************************************************************************/
/*** Device helper entry point                                                   ***/
/***********************************************************************************/

PTR16 DevHelp2;
void *TKSSBase;


int                swap_in_progress;

int drive_options[26] = {0, };

#ifdef VFATOS2_VER
int vfat_drives[26] = {0,};   // set to 1 if drive has to be handled by VFAT
#endif

/***********************************************************************************/
/*** Some external data ...                                                      ***/
/***********************************************************************************/


extern unsigned long event;                // To be moved somewhere in a .h file


int Read_Write = 0;                        // 0 read only - 1 read write
int auto_fsck  = 1;                        // 1 force e2fsck - 0 do not force e2fsck

char Use_Extended_Interface = 1;   // 1 use strategy 2 I/O if available - 0 use FSH_DOVOLIO I/O
char Case_Retensive         = 0;   // 1 case retensive (like HPFS) - 0 case sensitive
char Errors_Panic           = 0;
char write_through_support  = 0;
char fs_strict_checking     = 0;


/***********************************************************************************/
/*** OS/2 Infosegs pointers                                                      ***/
/***********************************************************************************/

struct InfoSegGDT *pSysInfoSeg = 0;     // OS/2 global infoseg
struct InfoSegLDT *pLocInfoSeg = 0;     // OS/2 local  infoseg

/***********************************************************************************/
/*** Time zone so that time stamps shown in OS/2 are the same as in Linux        ***/
/***********************************************************************************/

long timezone                  = 0;     // Time zone (second shift from UTC)

char msg[]="\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n";
char msg1[]="\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n";
extern char banner[];


struct DevHelp32 DevHelp32 = {DEVHELP32_MAGIC, DEVHELP32_VERSION,};

/*
 * struct fs32_init_parms {
 *     PTR16 pMiniFSD;
 *     PTR16 DevHelp;
 *     PTR16 cmdline;
 * };
 */
// int APIENTRY fs32_init(struct fs32_init_parms *parms, void *mwdd32_TKSSBase, void *DevHlp32, int DevHlp32_length) {
int FS32INIT fs32_init(struct fs32_init_parms *parms) {
    char           *szParm;
    int             rc;
    char *tz;
    char *pTmp1;
    int i;
    int Quiet = 0;
    struct minifsd_to_fsd_data *pMiniFSD;
    unsigned long stdout;
    unsigned long written;
    unsigned long PgCount;
    char code32_lock[12];
    char dgroup_lock[12];
    char const32_ro_lock[12];


    /*
     * parms is already thunked in mwdd32$, so unlike other fs32_* entry points,
     * parms = __StackToFlat(parms); is unnecessary here.
     */

    /*
     * Saves 16:16 DevHelp entry point (for use by fsh32_* routines)
     */
    DevHelp2 = parms->DevHelp;


    /*
     * Initializes the logging facility
     */
    BufPtr    = 0;
    BufOpen   = 0;
    memset(BufMsg, 0, BUFMSGSIZ);


    //
    // Retrieves the global and the local infoseg
    //
    if ((rc = DevHlp32_GetInfoSegs(&pSysInfoSeg, &pLocInfoSeg)) == NO_ERROR) {

    //
    // Command line parsing
    //
    if (parms->cmdline.seg) {
        if ((rc = DevHlp32_VirtToLin(parms->cmdline, __StackToFlat(&szParm))) == NO_ERROR) {


        strupr(szParm);
        for (pTmp1 = strpbrk(szParm, "-/"); pTmp1; pTmp1 = strpbrk(pTmp1, "-/")) {
		  pTmp1 ++;
                  //
                  // Maximum disk cache size.
                  //
                  if (strncmp(pTmp1, "CACHE:", sizeof("CACHE:") - 1) == 0) {
                      cache_size = strtoul(pTmp1 + sizeof("CACHE:") - 1, __StackToFlat(&pTmp1), 0);
                      cache_size = ((cache_size * 1024L + 61440L - 1L) / 61440L) * 61440L;
                      if (cache_size < 245760L) {
                          cache_size = 245760L; // 4 * (65536 - 4096)
                      }
                      continue;
                  }

                  //
                  // Quiet initialization.
                  //
                  if (strncmp(pTmp1, "Q", sizeof("Q") - 1) == 0) {
                      Quiet = 1;
                      continue;
                  }

                  //
                  // Strategy 2 I/O
                  //
                  if (strncmp(pTmp1, "NO_STRAT2", sizeof("NO_STRAT2") - 1) == 0) {
                      Use_Extended_Interface = 0;
                      continue;
                  }

                  //
                  // Case sensitivity
                  //
                  if (strncmp(pTmp1, "CASE_RETENSIVE", sizeof("CASE_RETENSIVE") - 1) == 0) {
                      Case_Retensive = 1;
                      continue;
                  }


                  //
                  // Read/Write access enabled
                  //
                  if (strncmp(pTmp1, "RW", sizeof("RW") - 1) == 0) {
                      Read_Write = 1;
                      continue;
                  }

                  //
                  // Disable automatic e2fsck when Linux mounts an ext2fs partition "touched"
                  // by OS/2.
                  //
                  if (strncmp(pTmp1, "NO_AUTO_FSCK", sizeof("NO_AUTO_FSCK") - 1) == 0) {
                      auto_fsck = 0;
                      continue;
                  }

                  //
                  // OPEN_FLAGS_WRITETHROUGH and OPEN_FLAGS_NOCACHE support
                  //
                  if (strncmp(pTmp1, "WRITE_THROUGH", sizeof("WRITE_THROUGH") - 1) == 0) {
                      write_through_support = 1;
                      continue;
                  }

                  //
                  // ext2fs behaviour on error (panic/continue)
                  //
                  if (strncmp(pTmp1, "ERRORS=", sizeof("ERRORS=") - 1) == 0) {
                      if (strncmp(pTmp1 + sizeof("ERRORS=") - 1, "CONTINUE", sizeof("CONTINUE") - 1) == 0) {
                          Errors_Panic = 0;
                      }
                      if (strncmp(pTmp1 + sizeof("ERRORS=") - 1, "PANIC", sizeof("PANIC") - 1) == 0) {
                          Errors_Panic = 1;
                      }
                      continue;
                  }

                  //
                  // ext2fs behaviour on error (panic/continue)
                  //
                  if (strncmp(pTmp1, "OUTPUT=", sizeof("OUTPUT=") - 1) == 0) {
                      if (strncmp(pTmp1 + sizeof("OUTPUT=") - 1, "COM1", sizeof("COM1") - 1) == 0) {
                          debug_com    = 1;
                          debug_port   = OUTPUT_COM1;
                      }
                      if (strncmp(pTmp1 + sizeof("OUTPUT=") - 1, "COM2", sizeof("COM2") - 1) == 0) {
                          debug_com    = 1;
                          debug_port   = OUTPUT_COM2;
                      }
                      continue;
                  }

                  //
                  // IFS entry points to trace
                  //
                  check_trace(pTmp1);

                  //
                  // Time zone               
                  //
                  if (strncmp(pTmp1, "TZ:", sizeof("TZ:") - 1) == 0) {
 		      timezone = strtol(pTmp1 + sizeof("TZ:") - 1, __StackToFlat(&pTmp1), 0);
                      if ((timezone < -1440) || (timezone > 1440)) {
                          timezone  = 0;         // Invalid time zone : default to UTC
                      } else {
                          timezone *= -60;        // Converts in seconds from UTC
                      }
                      printk("\t Timezone = %d",timezone);
                      continue;
                  }

                  //
                  // Force strategy 2 I/O (if available) on removable media.
                  //
                  if (strncmp(pTmp1, "FORCE_STRAT2:", sizeof("FORCE_STRAT2:") - 1) == 0) {
                      int d;
                      d = strtol(pTmp1 + sizeof("FORCE_STRAT2:") - 1, __StackToFlat(&pTmp1), 0);
                      if ((d >= 0) && (d <= 26)) {
                          printk("Forcing strategy 2 I/O on drive %d", d);
                          drive_options[d] = 1;
                      }
                      continue;
                  }

#ifdef VFATOS2_VER
                  //
                  // get list of drives to handle by VFAT
                  //
                  if (strncmp(pTmp1, "VFAT:", sizeof("VFAT:") - 1) == 0) {

                      char ch;

                      pTmp1 += sizeof("VFAT:") -1;
                      while (pTmp1 && *pTmp1 && *pTmp1 != ' ') {
                         ch = *pTmp1;
                         if (ch >= 'a' && ch <= 'z'){
                           vfat_drives[ch-'a'] = 1;
                           if (*(pTmp1+1) == '+') {
                             vfat_drives[ch-'a'] = 2;  /* force VFAT */
                             pTmp1++;
                           }
                         }
                         else if (ch >= 'A' && ch <= 'Z') {
                          vfat_drives[ch-'A'] = 1;
                           if (*(pTmp1+1) == '+') {
                             vfat_drives[ch-'A'] = 2;  /* force VFAT */
                             pTmp1++;
                           }
                         }
                         else if (ch == '*'){
                            int k;
                            for (k = 0; k < 26 ; k++)
                              if (vfat_drives[k]==0) vfat_drives[k] = 1;
                         }
                         else
                            break;
                         
                         pTmp1++;
                      } /* endwhile */

/* disable floppy support */
vfat_drives[0] = vfat_drives[1] = 0;

                      continue;
                  }
#endif

                  //
                  // Unknown command line option
                  //
//                  DosWrite(1, "EXT2-OS2 : Unknown option ", sizeof("EXT2-OS2 : Unknown option ") - 1, &lg);
//                  DosWrite(1, pTmp1, strlen(pTmp1), &lg);
//                  DosWrite(1, "\r\n", sizeof("\r\n") - 1, &lg);
//              }
        }
        }   //DevHlp32_VirtToLin
    }




            rc = NO_ERROR;


    } // DevHlp32_GetInfoSegs

    /*
     * Locks EXT2_FIXED_CODE into physical memory
     */
    rc = DevHlp32_VMLock(
		         VMDHL_LONG, 
		         (void *)code32_start, 
			 (unsigned long)code32_end - (unsigned long)code32_start,
                         (void *)-1,
                         __StackToFlat(code32_lock),
		         __StackToFlat(&PgCount)
                        );
    if (rc == NO_ERROR) {
        /*
         * Locks DGROUP into physical memory
         */
        rc = DevHlp32_VMLock(
	    	             VMDHL_LONG | VMDHL_WRITE, 
		             (void *)&dgroup_start, 
			     (unsigned long)(&dgroup_end) - (unsigned long)(&dgroup_start),
                             (void *)-1,
                             __StackToFlat(dgroup_lock),
		             __StackToFlat(&PgCount)
                            );
	if (rc == NO_ERROR) {
            /*
             * Locks CONST32_RO into physical memory
             */
            rc = DevHlp32_VMLock(
	    	                 VMDHL_LONG,  
		                 (void *)&const32_ro_start, 
			         (unsigned long)(&const32_ro_end) - (unsigned long)(&const32_ro_start),
                                 (void *)-1,
                                 __StackToFlat(const32_ro_lock),
		                 __StackToFlat(&PgCount)
                                );
	    if (rc == NO_ERROR) {
                /*
                 * Locks CODE16 into physical memory
                 */
                rc = fsh32_forcenoswap(code16_seg);
            }
        }
    }


    name_cache_init(0, 0);                 // Directory entry cache initialization
    inode_init(0, 0);                      // I-node table initialization
    reqlist_init(2);                       // Strategy 2 request list table initialization
    file_table_init(0, 0);                 // File table initialization
    buffer_init();                         // Disk cache initialization

    /*
     * If booted from ext2-os2 MINIFSD.FSD, we must inherit files, inodes and superblocks.
     */
    if (parms->pMiniFSD.seg) {
        printk("\tstruct inode            : %d", sizeof(struct inode));
        printk("\tstruct super_block      : %d", sizeof(struct super_block));
        printk("\tstruct file             : %d", sizeof(struct file));
        printk("\tstruct ext2_inode       : %d", sizeof(struct ext2_inode));
        printk("\tstruct ext2_super_block : %d", sizeof(struct ext2_super_block));
        printk("\tstruct minifsd_data     : %d", sizeof(struct minifsd_to_fsd_data));
        printk("\tstruct ext2_sb_info     : %d", sizeof(struct ext2_sb_info));


        if ((rc = DevHlp32_VirtToLin(parms->pMiniFSD, __StackToFlat(&pMiniFSD))) == NO_ERROR) {
            if ((rc = DevHlp32_VirtToLin(*(PTR16 *)pMiniFSD, __StackToFlat(&pMiniFSD))) == NO_ERROR) {
                if (pMiniFSD->mfsdata_magic == MINIFSD_DATA_MAGIC) {
                    /*
                     * inherits inodes from the mini FSD
                     */
                    inherit_minifsd_inodes(pMiniFSD);
                    printk("inherit_minifsd_inodes");

                    /*
                     * inherits files from the mini FSD
                     */
                    inherit_minifsd_files(pMiniFSD);
                    printk("inherit_minifsd_files");

                    /*
                     * inherits superblocks (mounted volumes ) from the mini FSD
                     */
                    inherit_minifsd_supers(pMiniFSD);
                    printk("inherit_minifsd_supers");
                } else {
                    printk("pMiniFSD: bad magic");
                }
            }
        }
    }

    if (!Quiet) {
        DevHlp32_SaveMessage(msg, strlen(msg) + 1);
        DevHlp32_SaveMessage(banner, strlen(banner)+1);
        DevHlp32_SaveMessage(msg1, strlen(msg1) + 1);
    }

    return rc;
}
