/*****************************************************************************
* SAMPLE (C) D. FRIEAUFF, 1991                                               *
******************************************************************************/

#define  INCL_PM
#define  INCL_DOS
#include <os2.h>
#include <malloc.h>
#include <b8lib3.h>

#include <string.h>
#include <stdio.h>

#include "rc.h"
#include "sample.h"

/**********************
* External references *
***********************/
extern BOOL    bTPbooted;      /* flags whether transputer (TP) is booted */
extern BOOL    bImage;         /* flags whether an image has been generated */
extern HAB     hab;            /* anchor block handle */
extern WIN     w;              /* window */
extern PARAMS  params;         /* iteration parameters */

/********************************************
* Global variables with external references *
*********************************************/
HFILE        hfB008;                 /* device driver handle */
BOOL         bTimerActive = FALSE;   /* timer active */
BOOL         bMove = FALSE;          /* mouse operation */
BOOL         bColor;                 /* use color (1) or greyscale (0) */
PBYTE        pRxBuffer;              /* transputer data */
PBITMAPINFO2 pbmi2;                  /* pointer to bitmapinfo */

/*******************************************
* Global variables w/o external references *
********************************************/
static HBITMAP hbmMem = 0;                /* handle of bitmap in the memory PS */
static POINTL  ptlStart, ptlDrag, ptlPos; /* mouse zoom positions */
static HPS     hpsM;                      /* cached PS during zoom operations */

/*********************************
* Local function predeclarations *
**********************************/
static BOOL WndCreate(HWND);
static VOID WndPaint(HWND);
static VOID WndButton1Down(HWND, MPARAM);
static VOID WndMouseMove(MPARAM);
static VOID WndButton1Up(HWND, MPARAM);
static VOID WndDestroy(void);
static BOOL WndTimer(HWND);

/**********
* WndProc *
***********/
MRESULT EXPENTRY WndProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
USHORT usRet;

switch (msg) {
  case WM_CREATE:
    usRet = WndCreate(hwnd);
    return(usRet ? M_TRUE : M_FALSE);

  case WM_SIZE:
    w.sizel.cx = (LONG)SHORT1FROMMP(mp2);
    w.sizel.cy = (LONG)SHORT2FROMMP(mp2);
    return(M_FALSE);

  case WM_PAINT:
    WndPaint(hwnd);
    return((MRESULT)0L);

  case WM_COMMAND:
    Command(hwnd, mp1);
    return((MRESULT)0L);

  case WM_BUTTON1DOWN:
    if (bTimerActive || !bTPbooted)
       return ((MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2));
    WndButton1Down(hwnd, mp1);
    break;

  case WM_MOUSEMOVE:
    if (bMove) WndMouseMove(mp1);
    return((MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2));

  case WM_BUTTON1UP:
    if (bMove) WndButton1Up(hwnd, mp1);
    return((MRESULT)1L);

  case WM_TIMER:
    if (SHORT1FROMMP(mp1) != ID_TPTIMER) break;
    WndTimer(hwnd);
    return(M_FALSE);

  case WMU_ENDTIMER:
    if (!bTimerActive) return(M_FALSE);
    WinStopTimer(hab, hwnd, ID_TPTIMER);
    bTimerActive = FALSE;
    bImage = TRUE;
    return(M_FALSE);

  case WM_CLOSE:
    WndDestroy();
    WinPostMsg(hwnd, WM_QUIT, 0L, 0L);
    return((MRESULT)0L);
  }
return ((MRESULT)WinDefWindowProc(hwnd, msg, mp1, mp2));
}

/************
* WndCreate *
*************/
BOOL WndCreate(HWND hwnd)
{
SIZEL             sizel = { 0, 0 };    /* use same page size as device */
BITMAPINFOHEADER2 bmp;                 /* data to create bitmap */
HPS               hps;                 /* cached PS, used to query device capabilities */
HDC               hdc;                 /* screen device context, used to query device capabilities */
LONG              lcColors;            /* number of different colors the screen can display */
LONG              cPlanes, cBitCount;  /* device caps */

/* open transputer device driver */
if (B8Open(&hfB008)) return(ErrorMsg(hwnd, IDS_B8OPEN));

/* create receive buffer for transputer data */
pRxBuffer = malloc(TP_BUFFER_SIZE);
if (!pRxBuffer) return(ErrorMsg(hwnd, IDS_ALLOCMEM));

/* create memory DC */
CreateMemDC (&w.hdcMem);
if (w.hdcMem == 0L) return(ErrorMsg(hwnd, IDS_OPENDC));

/* create memory PS */
sizel.cx = sizel.cy = 0L;
w.hpsMem = GpiCreatePS(hab, w.hdcMem, &sizel, PU_PELS | GPIT_MICRO | GPIA_ASSOC);
if (w.hpsMem == 0L) return(ErrorMsg(hwnd, IDS_CREATEPS));

/* create bitmap and set it into the memory PS */
hps = WinGetPS(hwnd);
hdc = GpiQueryDevice(hps);
DevQueryCaps(hdc, CAPS_COLOR_BITCOUNT, 1L, &cBitCount);
DevQueryCaps(hdc, CAPS_COLOR_PLANES, 1L, &cPlanes);
WinReleasePS(hps);
bmp.cbFix = 16;
bmp.cx = VS_MAX_X;
bmp.cy = VS_MAX_Y;
bmp.cBitCount = (USHORT)cBitCount;
bmp.cPlanes = (USHORT)cPlanes;
hbmMem = GpiCreateBitmap(w.hpsMem, &bmp, 0L, NULL, NULL);
if (hbmMem == 0L) return(ErrorMsg(hwnd, IDS_CREATEBITMAP));
GpiSetBitmap(w.hpsMem, hbmMem);

/* allocate memory for bitmapinfo and color table for GpiSetBitmapBits during WM_TIMER processing */
lcColors = 1 << bmp.cBitCount;
pbmi2 = malloc(sizeof(BITMAPINFO2) + lcColors * sizeof(RGB2));
if (!pbmi2) return(ErrorMsg (hwnd, IDS_ALLOCMEM));

/* setup bitmapinfo */
pbmi2->cbFix = 16;
pbmi2->cPlanes = 1;
pbmi2->cBitCount = 8;

/* set iteration parameters to default */
SetParamDefaults();

return(FALSE);
}

/***********
* WndPaint *
************/
VOID WndPaint(HWND hwnd)
{
POINTL aptl[4];
HPS    hps = WinBeginPaint(hwnd,0, (PRECTL)aptl);

/* if transputer not booted or no image computed yet, clear screen */
if (!bTPbooted || !bImage) {
   WinQueryWindowRect(w.hwndClient, (PRECTL)aptl);
   WinFillRect(hps, (PRECTL)aptl, CLR_BLACK);
   WinEndPaint(hps);
   return; }

/* set source and target rectangle */
WinQueryWindowRect(w.hwndClient, (PRECTL)aptl);    /* target */
aptl[2].x = 0;           aptl[2].y = 0;             /* source */
aptl[3].x = params.lcx;  aptl[3].y = params.lcy;

/* copy from memory PS to screen; zoom if necessary */
GpiBitBlt(hps, w.hpsMem, 4L, aptl, ROP_SRCCOPY, BBO_AND);
WinEndPaint(hps);
}

/*******************
* SetParamDefaults *
********************/
VOID SetParamDefaults(void)
{
params.lcx       = 0L;
params.lcy       = 0L;
params.RealStart = DEF_REALSTART;
params.RealEnd   = DEF_REALEND;
params.ImagStart = DEF_IMAGSTART;
params.ImagEnd   = DEF_IMAGEND;
params.RealConst = DEF_REALCONST;
params.ImagConst = DEF_IMAGCONST;
bColor           = DEF_COLOR;
}

/*****************
* WndButton1Down *
******************/
VOID WndButton1Down(HWND hwnd, MPARAM mp1)
{
bMove = TRUE;
GETPOINTERPOS((&ptlStart), mp1);
WinSetCapture(HWND_DESKTOP, hwnd);
ptlDrag = ptlPos = ptlStart;
hpsM = WinGetPS(w.hwndClient);
GpiSetColor(hpsM, CLR_YELLOW);
GpiSetMix(hpsM, FM_XOR);
}

/***************
* WndMouseMove *
****************/
VOID WndMouseMove(MPARAM mp1)
{
GETPOINTERPOS((&ptlPos), mp1);
if ((ptlDrag.x == ptlPos.x) && (ptlDrag.y == ptlPos.y)) return;
GpiMove(hpsM, &ptlStart);
GpiBox(hpsM, DRO_OUTLINE, &ptlDrag, 0L, 0L);
ptlDrag = ptlPos;
GpiMove(hpsM, &ptlStart);
GpiBox(hpsM, DRO_OUTLINE, &ptlDrag, 0L, 0L);
}

/***************
* WndButton1Up *
****************/
VOID WndButton1Up(HWND hwnd, MPARAM mp1)
{
RECTL  rclZoom, rectl;
LONG   lcx, lcy;
FLOAT  fcxImage, fcyImage;
FLOAT  fcxFactor, fcyFactor;

WinReleasePS(hpsM);

/* compute new parameters from zoom window */
WinSetCapture(HWND_DESKTOP, 0);
GETPOINTERPOS((&ptlDrag), mp1);
rclZoom.xLeft = ptlStart.x; rclZoom.yBottom = ptlStart.y;
rclZoom.xRight = ptlDrag.x; rclZoom.yTop = ptlDrag.y;
lcx = rclZoom.xRight - rclZoom.xLeft;
lcy = rclZoom.yTop - rclZoom.yBottom;
if (lcy < 0) lcy = -lcy;
if (lcx < 0) lcx = -lcx;
if ((lcx < 8) || (lcy < 8)) {
   bMove = FALSE;
   return; }
WinQueryWindowRect(w.hwndClient, &rectl);
params.lcx = rectl.xRight - rectl.xLeft;
params.lcy = rectl.yTop - rectl.yBottom;
fcxImage = params.RealEnd - params.RealStart;
fcyImage = params.ImagEnd - params.ImagStart;
fcxFactor = fcxImage / (FLOAT)params.lcx;
fcyFactor = fcyImage / (FLOAT)params.lcy;
params.RealStart += fcxFactor * (FLOAT)rclZoom.xLeft;
params.RealEnd = params.RealStart + fcxFactor * (FLOAT)lcx;
params.ImagStart += fcyFactor * (FLOAT)rclZoom.yTop;
params.ImagEnd = params.ImagStart + fcyFactor * (FLOAT)lcy;
bMove = FALSE;

/* start iteration */
CmdStart(hwnd);
}

/*************
* WndDestroy *
**************/
VOID WndDestroy(void)
{
free(pRxBuffer);
free(pbmi2);
DosClose (hfB008);
GpiSetBitmap(w.hpsMem, 0);     /* free PS from bitmap */
GpiDeleteBitmap(hbmMem);
GpiDestroyPS(w.hpsMem);
DevCloseDC(w.hdcMem);
}

/***********
* WndTimer *
************/
BOOL WndTimer(HWND hwnd)
{
HPS    hps;
USHORT i, usLength, usMsg, usRet, cPixels, y;
ULONG  ulBytesTransf;
BOOL   bReady;
POINTL aptl[3];

/* try to read the packet length. Return, if no packet available */
if (usRet = B8GetInt(hfB008, &usLength, &bReady))
   return (ErrorMsg(hwnd, IDS_B8GETINT));
if (!bReady) return(FALSE);

/* get PS for drawing */
hps = WinGetPS(w.hwndClient);

/* read packet from transputer */
if (usRet = B8Read(hfB008, pRxBuffer, SRV_TIMEOUT, usLength, &ulBytesTransf)) {
   WinReleasePS(hps);
   return (ErrorMsg(hwnd, IDS_B8READ)); }

/* parse transputer packet, decode header and execute */
i = 0;
while (i < usLength) {
  usMsg = *(PUSHORT)&(pRxBuffer[i]);
  i += 4;   /* points now to data */
  switch (usMsg) {
    case HCMD_PIXEL:
      cPixels = *(PUSHORT)(pRxBuffer + i - 2) - 2;
      y = *(PUSHORT)(pRxBuffer + i);
      pbmi2->cx = params.lcx;
      pbmi2->cy = params.lcy;
      if (GpiSetBitmapBits(w.hpsMem, y, 1, &pRxBuffer[i+2], pbmi2) != 1) {
         WinReleasePS(hps);
         return(ErrorMsg(hwnd, IDS_GPISETBMPBITS)); }
      aptl[0].x = 0;                aptl[0].y = y;  /* target lower left corner */
      aptl[1].x = params.lcx;       aptl[1].y = y+1;/* target upper right corner */
      aptl[2].x = 0;                aptl[2].y = y;  /* source lower left corner */
      GpiBitBlt(hps, w.hpsMem, 3L, aptl, ROP_SRCCOPY, BBO_IGNORE);
      i += cPixels + 2;
      break;
    case HCMD_ENDTIMER:
      WinPostMsg(w.hwnd, WMU_ENDTIMER, (MPARAM)0, (MPARAM)0);
      break;
    default:
      WinPostMsg(w.hwnd, WMU_ENDTIMER, (MPARAM)0, (MPARAM)0);
      WinReleasePS(hps);
      return(ErrorMsg (hwnd, IDS_INVMSG));
    }
  }
WinReleasePS(hps);
return(FALSE);
}
