-------------------------- HOST COMMUNICATION --------------------------
-- commands to host
VAL FLUSH.BUFFER             IS 0(INT16):    -- command to buffer process
VAL HCMD.ACK                 IS 1(INT16):
VAL HCMD.NAK                 IS 2(INT16):
VAL HCMD.ENDTIMER            IS 3(INT16):
VAL HCMD.PIXEL               IS 4(INT16):
VAL HCMD.TESTDATA            IS 5(INT16):

-- to.host communication protocol
PROTOCOL HOST.BUFFER.IO IS INT16; INT16::[]BYTE:

-- host buffer constants
VAL MAX.DATA.FROM.HOST IS   4096: -- length of a data block in bytes, must be >= longest data block to host
VAL MAX.DATA.TO.HOST   IS  10010: -- length of a data block in bytes, must be >= longest data block to host
VAL MAX.HOST.MESSAGES  IS      2: -- buffer size in number of messages
VAL MAX.HOST.BUFSIZ    IS  (MAX.HOST.MESSAGES * (MAX.DATA.TO.HOST + 4)):

-------------------------- ITERATION --------------------------
VAL ITERATION.CONST     IS      4.0(REAL64):

----------------------------- TEST ----------------------------
VAL INT MAX.TEST.BLOCK.LENGTH IS 10000:
