#ifndef INCL_B8LIB
#define INCL_B8LIB

/* device driver commands */
#define B8_IO              0x90L    /* category for DosDevIOCtl */
#define B8_CMD_RESET       0L
#define B8_CMD_ANALYSE     1L
#define B8_CMD_GET_E_FLAG  2L
#define B8_CMD_GET_R_FLAG  3L
#define B8_CMD_GET_W_FLAG  4L
#define B8_CMD_READ        5L
#define B8_CMD_WRITE       6L
#define B8_CMD_DMA_READ    7L
#define B8_CMD_DMA_WRITE   8L
#define B8_CMD_PEEK        9L
#define B8_CMD_GETINT16   10L
#define B8_CMD_GET8BYTES  11L

/* DevIOCtl return values */
#define B8_RET_FLAG_SET    0xFF01
#define B8_RET_DEV_N_RDY   0xFF02
#define B8_RET_TIMEOUT     0xFF03

/* Transfer slice length */
#define B8_SLICE_LENGTH      0xFFFE  /* in bytes */
#define B8_PEEK_SLICE_LENGTH 0xF000  /* in bytes */

/* Threshold for DMA transfers: if a data block with a length of less than
   B8_DMA_THRESHOLD has to be transferred via B8DMARead or B8DMAWrite,
   the DMA will not be used because of its large initialization overhead */
#define B8_DMA_THRESHOLD   256L

/* error codes */
#define B8_ERRORS             0x3000
#define ERROR_B8_NO_OPEN      B8_ERRORS + 1  /* can't open device driver */
#define ERROR_B8_NO_CLOSE     B8_ERRORS + 2  /* can't close device driver */
#define ERROR_B8_RD_N_RDY     B8_ERRORS + 3  /* device not ready error */
#define ERROR_B8_RD_T_OUT     B8_ERRORS + 4  /* timeout error */
#define ERROR_B8_RD_ERR       B8_ERRORS + 5  /* general error */
#define ERROR_B8_WR_N_RDY     B8_ERRORS + 6  /* device not ready error */
#define ERROR_B8_WR_T_OUT     B8_ERRORS + 7  /* timeout error */
#define ERROR_B8_WR_ERR       B8_ERRORS + 8  /* general error */
#define ERROR_B8_NO_RESET     B8_ERRORS + 9  /* can't reset device driver */
#define ERROR_B8_NO_ANALYSE   B8_ERRORS + 10 /* can't analyse device driver */
#define ERROR_B8_GET_E_FLAG   B8_ERRORS + 11 /* can't read error flag */
#define ERROR_B8_GET_R_FLAG   B8_ERRORS + 12 /* can't read ready-read flag */
#define ERROR_B8_GET_W_FLAG   B8_ERRORS + 13 /* can't read ready-write flag */
#define ERROR_B8_BOOT_FHANDLE B8_ERRORS + 14 /* invalid bootfile handle */
#define ERROR_B8_BOOT_NULL    B8_ERRORS + 15 /* invalid bootfile size (==0) */
#define ERROR_B8_BOOT_NOMEM   B8_ERRORS + 16 /* not enough memory */
#define ERROR_B8_BOOT_FILE    B8_ERRORS + 17 /* error reading bootfile */
#define ERROR_B8_BOOT_RESET   B8_ERRORS + 18 /* cant reset board */
#define ERROR_B8_BOOT_NOBOARD B8_ERRORS + 19 /* board not present or defunct */
#define ERROR_B8_BOOT_TRANSM  B8_ERRORS + 20 /* transmission error during boot */
#define ERROR_B8_PK_N_RDY     B8_ERRORS + 21 /* device not ready error */
#define ERROR_B8_PK_T_OUT     B8_ERRORS + 22 /* timeout error */
#define ERROR_B8_PK_ERR       B8_ERRORS + 23 /* general error */
#define ERROR_B8_GET_INT      B8_ERRORS + 24 /* second byte not available */
#define ERROR_B8_GET_8BYTES   B8_ERRORS + 25 /* a byte not available */

/* IOCTL read/write parameter buffer structure */
typedef struct
  {
  USHORT usTimeout;     /* timeout value */
  USHORT usLength;      /* input: not used, output: # bytes really transmitted */
  } RW_PARAMS;

/* IOCTL peek parameter buffer structure */
typedef struct
  {
  USHORT usTimeout;     /* timeout value */
  USHORT usLength;      /* input: not used, output: # lwords really peeked */
  } PK_PARAMS;

/**********************************
*  FUNCTION FORWARD DECLARATIONS  *
**********************************/
USHORT EXPENTRY B8Open (PHFILE);
USHORT EXPENTRY B8Close (HFILE);
USHORT EXPENTRY B8Read (HFILE, PBYTE, USHORT, ULONG, PULONG);
USHORT EXPENTRY B8DMARead (HFILE, PBYTE, USHORT, ULONG, PULONG);
USHORT EXPENTRY B8Write (HFILE, PBYTE, USHORT, ULONG, PULONG);
USHORT EXPENTRY B8DMAWrite (HFILE, PBYTE, USHORT, ULONG, PULONG);
USHORT EXPENTRY B8Reset (HFILE);
USHORT EXPENTRY B8Analyse (HFILE);
USHORT EXPENTRY B8TestError (HFILE, PBOOL);
USHORT EXPENTRY B8TestRead (HFILE, PBOOL);
USHORT EXPENTRY B8TestWrite (HFILE, PBOOL);
USHORT EXPENTRY B8BootFile (HFILE, HFILE, BOOL);
USHORT EXPENTRY B8DMABootFile (HFILE, HFILE, BOOL);
USHORT EXPENTRY B8Peek (HFILE, PBYTE, USHORT, ULONG, PULONG);
USHORT EXPENTRY B8GetInt (HFILE, PUSHORT, PBOOL);
USHORT EXPENTRY B8Get8Bytes (HFILE, PBYTE, PBOOL);

#endif /* INCL_B8LIB */
