/* inst_os2.cmd
 *
 * installation script for iODBC (OS/2)
 * creates WPS objects for the iODBC driver manager and documents and
 * create a new INI file for the iODBC driver manager, if necessary
 *
 * (c) 1997 by Dirk Ohme
 */

/*---| includes |------------------------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs
say "************************************"
say "* inst_os2 - (c) 1997 by Dirk Ohme *"
say "************************************"
say

/*---| set viewer and system editor |----------------------------------------*/
editor = SysSearchPath("PATH", "e.exe")
viewer = SysSearchPath("PATH", "view.exe")

/*---| set source directory |------------------------------------------------*/
sourceDir = translate( directory()||"\" )
idx = pos( "IODBC", sourceDir )
if 0 < idx
then do
  sourceDir = left( sourceDir, idx+5 )
end
call directory(sourceDir)

/*---| intro |---------------------------------------------------------------*/
say "Starting install of iODBC for OS/2 software,"
say "working directory = '"sourceDir"'"

/*---| bind icons to files |-------------------------------------------------*/
say "  binding icons to files"
call SysSetIcon "doc\iodbc.inf", "doc\iodbc.ico"

/*---| create workplace shell objects |--------------------------------------*/
say "  creation of WPS folder 'iODBC'"
if SysCreateObject("WPFolder", "iODBC",   "<WP_DESKTOP>",,
                   "OBJECTID=<WP_iODBC>", "update")
then do
  say "   * folder created"
  if SysCreateObject("WPProgram", "Driver Manager", "<WP_iODBC>",,
                     "EXENAME="sourceDir"\lib\iodbcmgr.exe",,
                     "update")
  then do
    say "   * iODBC driver manager"
  end
  if SysCreateObject("WPProgram", "iODBC (Doc)", "<WP_iODBC>",,
                     "EXENAME="viewer";PARAMETERS="sourceDir"\doc\iODBC.inf",,
                     "update")
  then do
    say "   * iODBC.inf"
  end
  if SysCreateObject("WPProgram", "JDBC (Doc)", "<WP_iODBC>",,
                     "EXENAME="viewer";PARAMETERS="sourceDir"\java\doc\JdbcOdbc.inf",,
                     "update")
  then do
    say "   * JdbcOdbc.inf"
  end
  if SysCreateObject("WPProgram", "CLI.txt",     "<WP_iODBC>",,
                     "EXENAME="editor";PARAMETERS="sourceDir"\CLI.txt",,
                     "update")
  then do
    say "   * CLI.txt"
  end
  if SysCreateObject("WPProgram", "iODBC.txt",   "<WP_iODBC>",,
                     "EXENAME="editor";PARAMETERS="sourceDir"\iODBC.txt",,
                     "update")
  then do
    say "   * iODBC.txt"
  end
  if SysCreateObject("WPProgram", "README.txt",  "<WP_iODBC>",,
                     "EXENAME="editor";PARAMETERS="sourceDir"\README.txt",,
                     "update")
  then do
    say "   * README.txt"
  end
end

/*---| check CONFIG.SYS for update |-----------------------------------------*/
configSys = SysSearchPath( "PATH", "cmd.exe" )
configSys = left( configSys, pos("\", configSys) )"config.sys"
configBak = left( configSys, lastpos(".", configSys) )"bak"
configNew = left( configSys, lastpos(".", configSys) )"new"

say "  checking '"configSys"' for installation"
configDiff = 0
if 0 == SysFileDelete(configNew) then say "    old '"configNew"' deleted"
do while lines( configSys )
  zeile = linein( configSys )

  /*---| checking LIBPATH entry |--------------------------------------------*/
  if 1 == pos("LIBPATH=", translate(zeile))
  then do
    /*---| path not set? |---------------------------------------------------*/
    if 0 >= pos(translate(sourceDir), translate(zeile))
    then do
      /*---| string ends on ';'? |-------------------------------------------*/
      if ";" <> right(zeile, 1) then zeile=zeile";"
      /*---| add path |------------------------------------------------------*/
      zeile=zeile""sourceDir"LIB;"
      configDiff = 1
    end
  end

  /*---| checking CLASSPATH entry (Java) |-----------------------------------*/
  if 1 == pos("SET CLASSPATH=", translate(zeile))
  then do
    /*---| path not set? |---------------------------------------------------*/
    if 0 >= pos(translate(sourceDir), translate(zeile))
    then do
      /*---| string ends on ';'? |-------------------------------------------*/
      if ";" <> right(zeile, 1) then zeile=zeile";"
      /*---| add path |------------------------------------------------------*/
      zeile=zeile""sourceDir"JAVA\class\iODBC.zip;"
      configDiff = 1
    end
  end

  /*---| write out line |----------------------------------------------------*/
  if lineout( configNew, zeile )
  then do
    say "error writing '"configNew"'!!!"
    exit 1
  end

end

if lineout( configNew )
then do
  say "error closing '"configNew"'!!!"
  exit 1
end

if ERROR == stream( configSys, "C", "CLOSE" )
then do
  say "error closing '"configSys"'!!!"
  exit 1
end

if 0 <> configDiff
then do
  say "  file '"configSys"' needs an update - shall I update (y/N)?"
  if "Y" <> left(translate(linein()), 1)
  then do
    say "    file '"configSys"' remains unchanged"
    say "    file '"configNew"' contains the updated version"
    exit 0
  end

  if 0 == SysFileDelete(configBak) then say "    old '"configBak"' deleted"
  '@ren 'configSys' config.bak > nul'
  '@ren 'configNew' config.sys > nul'
  say "    file '"configSys"' has been updated"
  say "    file '"configBak"' contains old version"

end

if 0 == SysFileDelete(configNew) then nop

/*---| determine name of iODBC.INI file |------------------------------------*/
defaultDriver = ""
iniFile = sourceDir"LIB\iODBC.ini"
say "  starting creation of new INI file '"iniFile"'"

/*---| checking for iODBC.INI file |-----------------------------------------*/
if 0 == SysFileTree(iniFile, "chkFile", "F")
then do
  if 1 == chkFile.0
  then do
    say "    INI file '"iniFile"' already exists!"
    iniFile = ""
  end
end

if 0 < length(iniFile)
then do
  /*---| check CONFIG.SYS for library path |---------------------------------*/
  libPath = ""
  configSys = SysSearchPath( "PATH", "cmd.exe" )
  configSys = left( configSys, pos("\", configSys) )"config.sys"
  say "    checking '"configSys"' for library paths"
  do while lines( configSys )

    zeile = linein( configSys )

    /*---| checking LIBPATH entry |------------------------------------------*/
    if 1 == pos("LIBPATH=", translate(zeile))
      then libPath = substr( zeile, 9 );

  end

  if ERROR == stream( configSys, "C", "CLOSE" )
  then do
    say "  error closing '"configSys"'!!!"
    say "abort!"
    exit 1
  end

  /*---| parsing library path |----------------------------------------------*/
  idx = pos( ";", libPath )
  do while 0 < idx

    /*---| get next directory |----------------------------------------------*/
    currDir = left( libPath, idx-1 )
    if "\" <> right(currDir, 1)
    then do
      currDir = currDir"\"
    end

    /*---| check for DB2/2 |-------------------------------------------------*/
    drvFile = "db2cli.dll"
    if 0 == SysFileTree(currDir""drvFile, "chkFile", "F")
    then do
      if 1 == chkFile.0
      then do
        /*---| write out result |--------------------------------------------*/
        say "      + DB2/2 CLI found in '"currDir"'"
        rc=lineout( iniFile, "[DB2]" )
        rc=lineout( iniFile, "       comment = IBM DB2/2 driver" );
        rc=lineout( iniFile, "       trace = off" );
        rc=lineout( iniFile, "       tracefile = stderr" );
        rc=lineout( iniFile, "       driver = "currDir""drvFile );
        rc=lineout( iniFile, "       dsn = odbc" );
        defaultDriver = currDir""drvFile
      end
    end

    /*---| Solid V 2.1 |-----------------------------------------------------*/
    drvFile = "sclio32.dll"
    if 0 == SysFileTree(currDir""drvFile, "chkFile", "F")
    then do
      if 1 == chkFile.0
      then do
        /*---| write out result |--------------------------------------------*/
        say "      + Solid Server CLI found in '"currDir"'"
        rc=lineout( iniFile, "[SOLID]" )
        rc=lineout( iniFile, "       comment = Solid Database driver" );
        rc=lineout( iniFile, "       trace = off" );
        rc=lineout( iniFile, "       tracefile = stderr" );
        rc=lineout( iniFile, "       driver = "currDir""drvFile );
        rc=lineout( iniFile, "       dsn = odbc" );
        defaultDriver = currDir""drvFile
      end
    end

    /*---| next entry |------------------------------------------------------*/
    libPath = substr( libPath, idx+1 )
    idx = pos( ";", libPath )

  end

  /*---| parsing iODBC library directory |-----------------------------------*/
  currDir = sourceDir"LIB\"
  say "    checking '"currDir"' for drivers"

  /*---| ... check for mSQL 1.x |--------------------------------------------*/
  drvFile = "libmsql.dll"
  if 0 == SysFileTree(currDir""drvFile, "chkFile", "F")
  then do
    if 1 == chkFile.0
    then do
      /*---| write out result |----------------------------------------------*/
      say "      + Mini SQL 1.x driver found in '"currDir"'"
      rc=lineout( iniFile, "[mSQL]" )
      rc=lineout( iniFile, "       comment = Mini SQL 1.x driver" );
      rc=lineout( iniFile, "       trace = off" );
      rc=lineout( iniFile, "       tracefile = stderr" );
      rc=lineout( iniFile, "       driver = "currDir""drvFile );
      rc=lineout( iniFile, "       dsn = odbc" );
      defaultDriver = currDir""drvFile
    end
  end

  /*---| ... check for mSQL 2.0 |--------------------------------------------*/
  drvFile = "libmsql2.dll"
  if 0 == SysFileTree(currDir""drvFile, "chkFile", "F")
  then do
    if 1 == chkFile.0
    then do
      /*---| write out result |----------------------------------------------*/
      say "      + Mini SQL 2.0 driver found in '"currDir"'"
      rc=lineout( iniFile, "[mSQL2]" )
      rc=lineout( iniFile, "       comment = Mini SQL 2.0 driver" );
      rc=lineout( iniFile, "       trace = off" );
      rc=lineout( iniFile, "       tracefile = stderr" );
      rc=lineout( iniFile, "       driver = "currDir""drvFile );
      rc=lineout( iniFile, "       dsn = odbc" );
      defaultDriver = currDir""drvFile
    end
  end

  /*---| ... check for Oracle database |-------------------------------------*/
  drvFile = "libora.dll"
  if 0 == SysFileTree(currDir""drvFile, "chkFile", "F")
  then do
    if 1 == chkFile.0
    then do
      /*---| write out result |----------------------------------------------*/
      say "      + Oracle database driver found in '"currDir"'"
      rc=lineout( iniFile, "[ORACLE]" )
      rc=lineout( iniFile, "       comment = Oracle database driver" );
      rc=lineout( iniFile, "       trace = off" );
      rc=lineout( iniFile, "       tracefile = stderr" );
      rc=lineout( iniFile, "       driver = "currDir""drvFile );
      rc=lineout( iniFile, "       dsn = odbc" );
      defaultDriver = currDir""drvFile
    end
  end

  /*---| setting default entry |---------------------------------------------*/
  if 0 < length(defaultDriver)
  then do
    say "    setting default entry"
    rc=lineout( iniFile, "[default]" )
    rc=lineout( iniFile, "       comment = default entry" );
    rc=lineout( iniFile, "       trace = off" );
    rc=lineout( iniFile, "       tracefile = stderr" );
    rc=lineout( iniFile, "       driver = "defaultDriver );
    rc=lineout( iniFile, "       dsn = odbc" );
    say "    setting test entry"
    rc=lineout( iniFile, "[test]" )
    rc=lineout( iniFile, "       comment = default entry for testing purpose" );
    rc=lineout( iniFile, "       trace = off" );
    rc=lineout( iniFile, "       tracefile = stderr" );
    rc=lineout( iniFile, "       driver = "defaultDriver );
    rc=lineout( iniFile, "       dsn = test" );
  end

  /*---| close INI file |----------------------------------------------------*/
  if lineout( iniFile )
  then do
    say "  error closing '"iniFile"'!!!"
    say "abort!"
    exit 1
  end
end

/*---| display latest notes |------------------------------------------------*/
say
say "*** press any key to read the latest news ***"
'@pause & type inst_os2.txt | more'

/*---| done |----------------------------------------------------------------*/
say "done."

/*===========================================================================*/
