/*------------------------------------------------------------------------------
 * autoconf.cmd
 *
 * OS/2 REXX command file - auto-detects the environment and configures the
 * makefiles for iODBC, the ODBC drivers and the JDBC-ODBC bridge
 *
 * (c) 1997 by Dirk Ohme
 *------------------------------------------------------------------------------
 */

/*---| initialization |-------------------------------------------------------*/
call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

sourceDir = translate( directory()||"\" )
idx = pos( "\IODBC", sourceDir )
if 0 < idx then sourceDir = left( sourceDir, idx+5 )
call directory(sourceDir)

/*---| intro |----------------------------------------------------------------*/
say "******************************************"
say "* autoconf (OS/2), (c) 1997 by Dirk Ohme *"
say "******************************************"
say
say " - source directory = '"sourceDir"'"

'echo # Config.mk - automatical creation by autoconf       >  Config.mk'
'echo #                                                    >> Config.mk'
'echo # (c) 1997 by Dirk Ohme - all rights reserved        >> Config.mk'
'echo.                                                     >> Config.mk'
'echo #----------------------------------------            >> Config.mk'
'echo # Operating System                                   >> Config.mk'
'echo #----------------------------------------            >> Config.mk'
'echo OS=OS2                                               >> Config.mk'
'echo.                                                     >> Config.mk'

call compiler
call makefiles
call jdk
call odbc
call odbc_msql
call odbc_mysql
call odbc_ora

say "done."
return 0

/*---| detection of compiler and |evelopment environment |--------------------*/
compiler: PROCEDURE
'echo #----------------------------------------            >> Config.mk'
'echo # Compiler, Development Environment                  >> Config.mk'
'echo #----------------------------------------            >> Config.mk'

'icc /v 2>&1 | find "VisualAge" > nul'
if rc = 0 then do
  say "  - IBM Visual Age C++ compiler detected"
  'echo VACPP=Y                                            >> Config.mk'
  'echo MAKE=nmake /nologo                                 >> Config.mk'
  'echo STATIC=Y                                           >> Config.mk'
  'echo # DYNAMIC=Y                                        >> Config.mk'
  'echo.                                                   >> Config.mk'
  return
end

'icc /v 2>&1 | find "IBM" > nul'
if rc = 0 then do
  say "  - IBM C/C++ Set/2 compiler detected"
  'echo IBMC=Y                                             >> Config.mk'
  'echo MAKE=nmake /nologo                                 >> Config.mk'
  'echo STATIC=Y                                           >> Config.mk'
  'echo # DYNAMIC=Y                                        >> Config.mk'
  'echo.                                                   >> Config.mk'
  return
end

'bcc /v 2>&1 | find "Borland" > nul'
if rc = 0 then do
  say "  - Borland C++ compiler detected"
  'echo BCPP=Y                                             >> Config.mk'
  'echo MAKE=make                                          >> Config.mk'
  'echo STATIC=Y                                           >> Config.mk'
  'echo # DYNAMIC=Y                                        >> Config.mk'
  'echo.                                                   >> Config.mk'
  return
end

say "  - can't detect compiler and development environment!"
return

/*---| preparation of Makefile's |--------------------------------------------*/
makefiles: PROCEDURE
call SysFileTree "Makefile.OS2", file, "FOS"
do i=1 to file.0
  dir = file.i
  idx = lastpos( "\", file.i )
  if 0 < idx then dir = left( file.i, idx-1 )
  'copy 'file.i' 'dir'\Makefile >nul 2>&1'
end
say "     + Makefiles are generated"
return

/*---| detection of Java Development Kit |------------------------------------*/
jdk: PROCEDURE
'echo #----------------------------------------            >> Config.mk'
'echo # Java Development Kit                               >> Config.mk'
'echo #----------------------------------------            >> Config.mk'

'echo # No JDK available ...                               >  JAVA\Makefile'
'echo.                                                     >> JAVA\Makefile'
'echo all:                                                 >> JAVA\Makefile'
'echo clean:                                               >> JAVA\Makefile'
'echo delete:                                              >> JAVA\Makefile'
'echo delete_all:                                          >> JAVA\Makefile'

JDK_CLASSPATH = value("CLASSPATH",,"OS2ENVIRONMENT")

if 0 = length(JDK_CLASSPATH) then do
  say " - no Java Development Kit (JDK) available"
  'echo # not available                                    >> Config.mk'
  'echo.                                                   >> Config.mk'
  return
end

'java -version 2>&1 | find /i "JAVA" > nul'
if rc <> 0 then do
  say " - no Java Development Kit (JDK) available"
  'echo # not available                                    >> Config.mk'
  'echo.                                                   >> Config.mk'
  return
end

JDK_VER  = "JDK_unknown"
JDK_PATH = translate( SysSearchPath("PATH", "java.exe") )
idx      = pos( "\BIN", JDK_PATH )
if 0 < idx then JDK_PATH = left( JDK_PATH, idx-1 )

'java -version 2>&1 | find "1.0.1" > nul'
if rc = 0 then JDK_VER="JDK_1.0.1"

'java -version 2>&1 | find "1.0.2" > nul'
if rc = 0 then JDK_VER="JDK_1.0.2"

'java -version 2>&1 | find "1.1" > nul'
if rc = 0 then JDK_VER="JDK_1.1"

say "  - Java Development Kit ("JDK_VER") detected"
say "    path: "JDK_PATH
'echo JAVA='JDK_VER'                                       >> Config.mk'
'echo JDK_PATH='JDK_PATH'                                  >> Config.mk'
'echo.                                                     >> Config.mk'

'copy JAVA\Makefile.OS2 JAVA\Makefile >nul 2>&1'
say "     + JAVA\Makefile generated"

return

/*---| detection of ODBC driver manager |-------------------------------------*/
odbc: PROCEDURE
'echo #----------------------------------------            >> Config.mk'
'echo # ODBC driver manager, environment                   >> Config.mk'
'echo #----------------------------------------            >> Config.mk'

'echo iODBC=Y                                              >> Config.mk'
'echo ODBC=iODBC                                           >> Config.mk'
'echo ODBC_ENV=IODBC_INI                                   >> Config.mk'
'echo ODBC_FILE=ODBC                                       >> Config.mk'
'echo ODBC_INI=iodbc.ini                                   >> Config.mk'
'echo ODBC_INCL='sourceDir'\INCLUDE                        >> Config.mk'
'echo ODBC_LIBS='sourceDir'\ODBC.LIB                       >> Config.mk'
'echo.                                                     >> Config.mk'

say "  - Instrinic ODBC driver manager"

'echo # automatic created by autoconf                      >  DRIVER\Makefile'
'echo.                                                     >> DRIVER\Makefile'
'echo include ..\Config.mk                                 >> DRIVER\Makefile'
'echo include ..\Version.mk                                >> DRIVER\Makefile'
'echo.                                                     >> DRIVER\Makefile'
'echo #---[ ODBC driver setup tool ]---                    >> DRIVER\Makefile'
'echo all ::                                               >> DRIVER\Makefile'
'echo         cd DRV_MGR                                   >> DRIVER\Makefile'
'echo         @$(MAKE) all                                 >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo clean ::                                             >> DRIVER\Makefile'
'echo         cd DRV_MGR                                   >> DRIVER\Makefile'
'echo         @$(MAKE) clean                               >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo delete ::                                            >> DRIVER\Makefile'
'echo         cd DRV_MGR                                   >> DRIVER\Makefile'
'echo         @$(MAKE) delete                              >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo delete_all ::                                        >> DRIVER\Makefile'
'echo         cd DRV_MGR                                   >> DRIVER\Makefile'
'echo         @$(MAKE) delete_all                          >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo.                                                     >> DRIVER\Makefile'

say "     + ODBC driver setup tool"

return

/*---| detection of ODBC driver for mSQL 1.x, 2.x |---------------------------*/
odbc_msql: PROCEDURE
'echo #---[ ODBC driver for mSQL 1.x, 2.x ]---             >> DRIVER\Makefile'
'echo all ::                                               >> DRIVER\Makefile'
'echo         cd mSQL                                      >> DRIVER\Makefile'
'echo         @$(MAKE) clean                               >> DRIVER\Makefile'
'echo         @$(MAKE) all mSQL=Y                          >> DRIVER\Makefile'
'echo         @$(MAKE) clean                               >> DRIVER\Makefile'
'echo         @$(MAKE) all mSQL2=Y                         >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo clean ::                                             >> DRIVER\Makefile'
'echo         cd mSQL                                      >> DRIVER\Makefile'
'echo         @$(MAKE) clean                               >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo delete ::                                            >> DRIVER\Makefile'
'echo         cd mSQL                                      >> DRIVER\Makefile'
'echo         @$(MAKE) delete                              >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo delete_all ::                                        >> DRIVER\Makefile'
'echo         cd mSQL                                      >> DRIVER\Makefile'
'echo         @$(MAKE) delete_all                          >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo.                                                     >> DRIVER\Makefile'

say "     + ODBC driver for mSQL 1.x, 2.x"

return

/*---| detection of ODBC driver for mySQL 3.x.x |-----------------------------*/
odbc_mysql: PROCEDURE
return

/*---| detection of ODBC driver for Personal Oracle 7.x |---------------------*/
odbc_ora: PROCEDURE

ORA_CONFIG = value("CONFIG",,"OS2ENVIRONMENT")
ORA_HOME   = ""
ORA_INCL   = ""
ORA_LIBS   = ""
if 0 = length(ORA_CONFIG) then return

do while lines(ORA_CONFIG)
  zeile = linein( ORA_CONFIG )
  if 1 == pos("ORACLE_HOME=", translate(zeile)) then do
    ORA_HOME = substr( zeile, 13 )
    leave
  end
end

if ERROR == stream( ORA_CONFIG, "C", "CLOSE" ) then return

call SysFileTree ORA_HOME"\*.LIB", file, "FOS"
do i=1 to file.0
  dir = file.i
  idx = lastpos( "\", file.i )
  if 0 < idx then dir = left( file.i, idx-1 )
  ORA_INCL = dir
  ORA_LIBS = file.i
end

'echo #---[ ODBC driver for Personal Oracle 7.x ]---       >> DRIVER\Makefile'
'echo all ::                                               >> DRIVER\Makefile'
'echo         cd ORACLE                                    >> DRIVER\Makefile'
'echo         @$(MAKE) all ORA_INCL='ORA_INCL' ORA_LIBS='ORA_LIBS' >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo clean ::                                             >> DRIVER\Makefile'
'echo         cd ORACLE                                    >> DRIVER\Makefile'
'echo         @$(MAKE) clean                               >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo delete ::                                            >> DRIVER\Makefile'
'echo         cd ORACLE                                    >> DRIVER\Makefile'
'echo         @$(MAKE) delete                              >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo delete_all ::                                        >> DRIVER\Makefile'
'echo         cd ORACLE                                    >> DRIVER\Makefile'
'echo         @$(MAKE) delete_all                          >> DRIVER\Makefile'
'echo         cd ..                                        >> DRIVER\Makefile'
'echo.                                                     >> DRIVER\Makefile'

say "     + ODBC driver for Personal Oracle 7.x"

return

/*===| end of file |==========================================================*/
